    ; extra MACRO files need to go here
    include "myMacros.inc"

    .assume adl=1                       ; ez80 ADL memory mode
    .org $40000                         ; load code here

    jp start_here                       ; jump to start of code

    .align 64                           ; MOS header
    .db "MOS",0,1     

start_here:
            
    push af                             ; store all the registers
    push bc
    push de
    push ix
    push iy

; ------------------
; This is our actual code

; prepare the screen

    SET_MODE 8                          ; mode 8 is 640x480 pixels, 64 colours
	CLS

	ld d,10
ylp:
	ld e,10 ; D.E=y.x
xlp:
	ld a,d
	ld (ply),a
	ld c,8
bhlp:
	ld b,8
	ld a,e
	ld (plx),a
	push de
bwlp:
; Sending a VDU byte stream
	push bc
    ld hl, VDUdata                      ; address of string to use
    ld bc, endVDUdata - VDUdata         ; length of string
    rst.lil $18                         ; Call the MOS API to send data to VDP 
	pop bc
	call incx
	djnz bwlp
	call incy
	pop de
	dec c
	jr nz,bhlp
;inc color
	ld a,(col)
	inc a
	ld (col),a
	ld a,e
	add a,9
	ld e,a
	cp 82 ;10+8*9
	jr nz,xlp

	ld a,d
	add a,9
	ld d,a
	cp 82 ;10+8*9
	jr nz,ylp

;get key
    ld a, $08                           ; code to send to MOS
    rst.lil $08                         ; get IX pointer to System Variables

WAIT_HERE:                              ; loop here until we hit ESC key
    ld a, (ix + $05)                    ; get ASCII code of key pressed
    cp 27                               ; check if 27 (ascii code for ESC)   
    jp z, EXIT_HERE                     ; if pressed, jump to exit

    jr WAIT_HERE

; ------------------
; This is where we exit the program
EXIT_HERE:

    CLS 
    pop iy                              ; Pop all registers back from the stack
    pop ix
    pop de
    pop bc
    pop af
    ld hl,0                             ; Load the MOS API return code (0) for no errors.
    ret                                 ; Return to MOS
; ------------------
incx:
	ld a,(plx)
	inc a
	ld (plx),a
	ret
incy:
	ld a,(ply)
	inc a
	ld (ply),a
	ret

; ------------------
; This is the data we send to VDP

VDUdata:
    .db 23, 0, 192, 0                   ; set to non-scaled graphics

    ; FOR A SINGLE PIXEL PLOT
    .db 18, 0; GCOL mode, colour
col: .db 0
    .db 25, 69                          ; PLOT: mode (69 is a point in current colour),
plx:    .dw 0                          ; X
ply:    .dw 0                          ; Y

endVDUdata:

; ------------------
; colour data

bright_red:     equ     9
green:          equ     2
bright_yellow:  equ     11
bright_magenta: equ     13
blue:           equ     4
white:          equ     7
black:          equ     0
bright_white:   equ     15
