
        module hiscore
check
        ld hl,table.last:ld a,table_cnt
.ch1    push af:push hl
                ld bc,HISCORE.score-HISCORE:add hl,bc
                ld de,score_sprite.score_0-1
                ld b,4
.ch2                    ld a,(de):cp (hl):jp c,.ch3 ; bigger in table
                        jp nz,.next ; player has more
                        inc de:inc hl
                dec b:jp nz,.ch2
.ch3    pop hl:pop af
        ld b,(hl):inc b:jp nz,.found
        ;player has less than last score in the table
.ch0
        call show
        jp $start_addr

.next   pop hl:ld e,l:ld d,h:ld bc,-entry_size:add hl,bc:push hl
        ld a,(de):inc a:jp z,.nx2
.nx1    ld a,(hl):inc hl:ld (de),a:inc de
        inc c:jp nz,.nx1
.nx2    pop hl,af
        dec a:jp nz,.ch1

        ; fill new entry with '.'
.found  push hl:ld bc,$202e
.fn1                    ld (hl),c:inc hl:dec b:jp nz,.fn1
                inc hl:inc hl
                ; move new score to table entry
                ld de,score_sprite.score_0-1:ld b,4:ld c,a
.fn2                    ld a,(de):inc de:ld (hl),a:inc hl
                dec b:jp nz,.fn2

                push bc:call just_show:pop bc
        ;find screen address in `sh_lines' table
                ld hl,sh_lines+SH_LINE.screen:ld de,SH_LINE:ld a,c:ld b,20
.fn3                   dec a:jp m,input_name:add hl,de:jp .fn3

input_name
                ld e,(hl):inc hl:ld d,(hl):ex de,hl:inc hl
                ld a,c:rrca:jp c,.in1
                ld de,-1-HISCORE:add hl,de
.in1    pop de
        ld a,c:add a,a:add a,c:add a,13:ld c,a
.loop
        ld a,$80:ld (crt_ctrl),a
        ld a,b:ld (crt_ctrl-1),a
        ld a,c:ld (crt_ctrl-1),a
        call $f803
        cp 8:jp z,.bs
        cp $7f:jp z,.bs
        cp 13:jp z,.end
        cp 32:jp c,.loop
        push af
        ld a,b:cp 52:jp c,.loop1:pop af:jp .loop
.loop1  pop af:ld (hl),a:inc hl:ld (de),a:inc de
        inc b:jp .loop
.bs     ld a,b:cp 20:jp z,.loop
        ld a,'.':dec hl:ld (hl),a:dec de:ld (de),a
        dec b:jp .loop
.end
        call $f81b:or a:jp p,.end
        ld hl,crt_ctrl:ld (hl),$80
        dec l:ld (hl),0:ld (hl),0
        call wait
        jp $start_addr


just_show
        call clr_screens
        ld a,$40:ld (crt_ctrl),a

        ld a,0:ld (scroll_y),a

        ld hl,line_table:ld de,table:ld bc,entry_size
        ld a,4

        call init_sh_lines

        ld bc,$804:call xy_to_addr
        ld de,sprite
        call draw_sprite

        ld hl,crt_ctrl:ld (hl),0
        dec hl:ld (hl),$4d:ld (hl),scr_lines-1:ld (hl),$77:ld (hl),$53
        inc hl:ld (hl),$27

        ld a,0:push af
        ld hl,(frame_adress):ex de,hl
        ld hl,(frame_len):ld b,h:ld c,l
        ld hl,scr_length-2-(69+5)*7:push hl
        call set_dma

        ld hl,(frame_end):ld (hl),0
        ld hl,(frame_adress):ex de,hl
        ;ld hl,scr_length-1:add hl,de:call wrap_hl
        pop hl:add hl,de:call wrap_hl
        ld (hl),$f3:ld (frame_end),hl

        ld a,(crt_ctrl)
loop    ld a,(crt_ctrl):and $20:jp z,loop


        pop af:inc a:ret z:push af
        cp 20:push af:call c,draw_sh_lines:pop af
        push af:call nc,move_sh_lines:pop af
.hi1    cp 25:jp c,color_up
        pop af
        ret

show    call just_show
wait    xor a:push af
        ld a,(crt_ctrl)
.loop   ld a,(crt_ctrl):and $20:jp z,.loop
        pop af:dec a:ret z:push af
        call $f81b:or a:jp m,.loop
        pop af:ret

        struct SH_LINE
upper_f1        defw 0
screen          defw 0
lower_f1        defw 0
string          defw 0
        ends

sh_lines
        dup 8
        SH_LINE
        edup

draw_sh_lines
        ld a,4:ld hl,sh_lines
.dl1    push af
                call move_f1_fw
                ld e,(hl):inc hl:ld d,(hl):dec hl:push de
                inc de:inc de:call ld_hl_de
                call move_f1_bk
                pop de
                ld c,(hl):inc hl:ld b,(hl):dec hl
                dup 2:ld a,(bc):inc bc:ld (de),a:inc de:edup
                ld (hl),c:inc hl:ld (hl),b:inc hl

                call move_f1_bk
                ld e,(hl):inc hl:ld d,(hl):dec hl:push de
                dec de:dec de:call ld_hl_de
                call move_f1_fw
                pop de
                ld c,(hl):inc hl:ld b,(hl):dec hl
                dup 2:ld a,(bc):dec bc:ld (de),a:dec de:edup
                ld (hl),c:inc hl:ld (hl),b:inc hl
        pop af
        dec a:jp nz,.dl1
        ret

move_sh_lines
        cp 26:ret nc
        ld a,4:ld hl,sh_lines
.dl1    push af
                call move_f1_fw
                inc hl:inc hl
                call move_f1_bk
                inc hl:inc hl
                call move_f1_bk
                inc hl:inc hl
                call move_f1_fw
                inc hl:inc hl
        pop af
        dec a:jp nz,.dl1
        ret

move_f1_fw
        ld e,(hl):inc hl:ld d,(hl):dec hl
        xor a:ld (de),a:inc de:inc de
        ld a,$f1:ld (de),a
ld_hl_de
        ld (hl),e:inc hl:ld (hl),d:inc hl
        ret

move_f1_bk
        ld e,(hl):inc hl:ld d,(hl):dec hl
        xor a:ld (de),a:dec de:dec de
        ld a,$f1:ld (de),a
        jp ld_hl_de

init_sh_lines
        ld a,4
        ld hl,(frame_adress):ld de,$4e*12+8:add hl,de
        ex de,hl:ld hl,sh_lines
.il1    push af
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;upper_f1 +8
        ld bc,72:ex de,hl:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;screen +8+64
        ld bc,108:ex de,hl:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;lower_f1 +8+64
        inc hl:inc hl

        ld bc,42:ex de,hl:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;upper_f1 +8+64
        ld bc,9:ex de,hl:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;screen +8
        ld bc,47:ex de,hl:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:inc hl       ;lower_f1 +8
        ld bc,38:ex de,hl:add hl,bc:ex de,hl
        inc hl:inc hl

        pop af:dec a:jp nz,.il1
        ld a,4:ld de,table
        ld hl,sh_lines+SH_LINE.string
.il2
        ld (hl),e:inc hl:ld (hl),d:ld bc,SH_LINE-1:add hl,bc
        ex de,hl:ld bc,entry_size*2-1:add hl,bc:ex de,hl
        ld (hl),e:inc hl:ld (hl),d:ld bc,SH_LINE-1:add hl,bc
        inc de
        dec a:jp nz,.il2
        ret

scroll_s        equ $22

scroll_d        defb 0
scroll_y        defb 0
scroll_vy       defw $100
sprite_line     defw sprite
s_len           defw scr_length-1

color_up
        .2 rrca:and 7:push af
        ld bc,$0804:call xy_to_addr
        ld de,title_colors
        pop af:ld c,a:ld b,tcolors_cnt
.cu1    ld a,(de):inc de
        add a,c:sub 7:jp p,.cu2:xor a
.cu2    push hl
              ld hl,colors_grade
              add a,l:ld l,a:ld a,(hl)
        pop hl:ld (hl),a
        ld a,$4e:add a,l:ld l,a:call c,wrap_inc_hl
        dec b:jp nz,.cu1
        jp loop

        struct HISCORE
name    text 32,{" ."}
        defs 2,32
score   text 4,{"0000"}
        ends

        display HISCORE
table   HISCORE {{"FLYING TO KILL"},{"8275"}}
.next   HISCORE {{"A GAME OF 2024"},{"8257"}}
        HISCORE {{"OR RATHER A TECHDEMO"},{"8255"}}
        HISCORE {{"INTENDED TO SHOW"},{"8253"}}
        HISCORE {{"UNREVEALED FEATURES"},{"8224"}}
        HISCORE {{"OF THE 8275 CHIP"},{"8080"}}
        HISCORE {{"ALL SCROLLINGS HERE"},{"2024"}}
        HISCORE {{"ARE DONE BY HARDWARE"},{"1986"}}
.last   defb $ff
entry_size      equ table.next-table
table_size      equ table.last-table
table_cnt       equ table_size/entry_size

color_table
        defb color_white,color_white,color_yellow,color_yellow
        defb color_cyan,color_cyan,color_green,color_green


line_table
        defs table_cnt*2

title_colors   defb 6,7,7,5,4,4
tcolors_cnt    equ $-title_colors
;curr_colors    defs curr_colors

        align 8
colors_grade
        defb color_black,color_blue,color_red,color_magenta
        defb color_green,color_cyan,color_yellow,color_white

sprite
        defb color_black
        defh 00 04 C314 CE00 17 C900 C414 C300 06 11 00 00 03 07 11 C900 17 CA00 fd

        defb color_black
        defh 00 00 17 00 06 11 00 00 14 14 10 00 00 04 14 10 14 00 14 17 14 14 C800 17 00 06 11
        defh 00 04 14 10 C300 06 11 C300 04 14 14 00 00 14 17 14 14 00 00 04 14 10 14 00 00 fd

        defb color_black
        defh 00 00 17 00 06 01 00 16 01 00 07 10 00 17 00 02 17 00 00 17 CA00 17 00 06 11 00 00
        defh 06 11 C300 06 11 00 00 04 13 00 02 15 00 00 17 C400 17 00 02 17 00 00 fd

        defb color_black
        defh 00 00 17 03 03 15 00 17 14 14 16 11 00 07 14 14 10 00 00 17 CA00 17 14 16 01 00 00
        defh 06 11 C300 06 11 00 00 06 11 00 00 17 00 00 17 C400 07 14 14 10 00 00 fd

        defb color_black
        defh 00 00 17 00 00 17 00 17 C500 14 00 00 17 00 00 17 CA00 17 C500 06 11 C300 06 11 00
        defh 00 06 11 00 00 17 00 00 17 C400 14 00 00 17 00 00 fd

        defb color_black
        defh 00 04 17 14 14 13 00 02 15 14 12 01 00 17 05 14 13 00 00 07 14 12 01 C600 14 17 14
        defh C300 14 16 15 14 00 14 16 15 14 00 00 07 14 16 01 00 00 07 14 12 01 00 17 05 14 13 00
        defb color_white

        defb $FF

        endmodule
