        module sound



seq1

        defb 1:defw $100
        defb 1:defw $200
        defb 1:defw $300
        defb 1:defw $400
        defb 1:defw $500
        defb 1:defw $500
        defb 1:defw $100
        defb 1:defw $600
        defb 1:defw $80
        defb 1:defw $700
        defb 1:defw $40
        defb 3,0

seq2    ;heli_fall
fq      defl $1000
        dup 100
        defb 1:defw fq
fq      defl fq+$100
        edup
        defb 3,0

seq5    ;rocket_fall
fq      defl $1000
        dup 10
        defb 1:defw fq
        defb 1:defw fq+$10
        defb 1:defw fq+$20
        defb 1:defw fq+$30
fq      defl fq+$800
        edup
        defb 3,0

seq3    ;tank
        defb 1:defw $e000
        defb 3,3
        defb 4:defw seq3

seq4    ;heli
        defb 1:defw $4000
        defb 1:defw $7000
        defb 1:defw $40
        defb 3
        defb 4:defw seq4

seq6    ;laser
fq      defl $800
        defb 1:defw $300
        defb 1:defw $800
        dup 8
        defb 1:defw fq
fq      defl fq*5/4
        edup
        defb 3,0

seq7    ;boom
fq      defl $6000
        dup 8
        defb 1:defw fq
fq      defl fq+fq/32
        edup
        dup 4
        defb 1:defw fq
        defb 2,3
fq      defl fq+fq/32
        edup
        dup 4
        defb 1:defw fq
        defb 1:defw fq*3/2
        defb 3
fq      defl fq+$800
        edup
        defb 0


        ifdef APOGEE

pit_a           equ $ec00
pit_b           equ $ec01
pit_c           equ $ec02
pit_ctrl        equ $ec03



seq_a   defw 0
seq_b   defw 0
seq_c   defw 0

start_a
        ld (seq_a),hl:ret
start_b
        ld (seq_b),hl:ret
start_c
        ld (seq_c),hl:ret


play    ; hl = sequence, de = pit port => hl = next data in sequence
        ld a,h:or l:ret z
        ld a,(hl):inc hl
        or a:jp z,.stop         ; 0 - nothing to play
        dec a:jp z,.play        ; 1 - load frequency
        dec a:ret z             ; 2 - don't change
        dec a:jp z,.mute        ; 3 - mute channel
        dec a:jp z,.load        ; 4 - load address
.play   ld a,(hl):inc hl:ld (de),a
        ld a,(hl):inc hl:ld (de),a
        ret

.mute   ld a,e:rrca:rrca:or $3e:ld (pit_ctrl),a
        ret

.load   ld a,(hl):inc hl:ld h,(hl):ld l,a
        jp play

.stop   ld hl,0:ret

play_all
        ld hl,(seq_a):ld de,pit_a
        call play:ld (seq_a),hl
        ld hl,(seq_b):inc de
        call play:ld (seq_b),hl
        ld hl,(seq_c):inc de
        call play:ld (seq_c),hl
        ret


        macro MUTE sq,cd
        ld hl,0:ld (sq),hl
        ld hl,pit_ctrl:ld (hl),cd
        ret
        endm

mute_a  MUTE seq_a,$3e
mute_b  MUTE seq_b,$7e
mute_c  MUTE seq_c,$be

mute_all
        ld hl,0:ld (seq_a),hl:ld (seq_b),hl:ld (seq_c),hl
        ld hl,pit_ctrl:ld (hl),$3e:ld (hl),$7e:ld (hl),$be
        ret


        endif

        ifdef RK86
play_all
mute_all
start_a
start_b
start_c
mute_b
mute_c
        ret
        endif
        endmod
