wrap_inc_hl
        inc h
wrap_hl
        ld a,h:and $1f:cp high scr_length:ret c
        ld a,h:sub high scr_length:ld h,a
        and $10:ret z:ld a,2*high scr_length:add a,h:ld h,a
        ret

wrap_dec_hl
        dec h
        ld a,h:and $10:ret z
        ld a,h:add a,high scr_length:ld h,a
        ret

xy_to_addr
        ld h,high row_table:ld a,c:add a,a:ld l,a
        ld e,(hl):inc l:ld d,(hl)
        ld hl,(frame_adress):add hl,de
        ld e,b:ld d,0:add hl,de
        jp wrap_hl

                ; scroll screen up and down relative to current position
set_vscroll     ; a = signed scroll amount -64 < a < 64
        ld hl,(frame_adress):ex de,hl
        add a,a:ld l,a:ld h,high row_table
        ld a,(hl):inc l:ld h,(hl):ld l,a
        add hl,de:call wrap_hl:ld (frame_adress),hl
        ld de,scr_start+scr_length-1:ld a,h:and $20:or d:ld d,a
        ld a,e:sub l:ld l,a
        ld a,d:sbc a,h:ld h,a
        ld (frame_len),hl
        ret

; wait for vblank and setup dma controller
; de = channel 2 start, bc = channel 2 lenght, hl = channel 3 length
set_dma
        ld a,h:or $40:ld h,a:push hl
        ld a,b:or $40:ld b,a
        ld a,(crt_ctrl)
.wait_vb
        ld a,(crt_ctrl):and a,$20:jp z,.wait_vb

        ld hl,dma_ctrl:ld (hl),$80      ; +8
        ld l,4:ld (hl),e:ld (hl),d      ; +4 ch2 addr
        inc l:ld (hl),c:ld (hl),b      ; +5 ch2 len
        inc l:ld (hl),0:ld a,d:and $f0:ld (hl),a       ; +6 ch3 addr
        inc l:pop bc:ld (hl),c:ld (hl),b ; +7 ch3 len
        inc l:ld (hl),$a4
        ret

fill_mem
        ld  (hl),a:inc hl
        dec c:jp  nz,fill_mem
        dec b:jp  nz,fill_mem
        ret

clr_screens
        ld a,$40:ld (crt_ctrl),a
        ld hl,scr_start:ld (frame_adress),hl
        ld hl,scr_length-1:ld (frame_len),hl
        ld hl,scr_start+scr_length-1:ld (frame_end),hl
        xor a:ld (frame_mask),a
        ld  hl,scr_start:ld  bc,scr_lines*78+256:push bc
        call fill_mem
        ld  hl,scr_start+$2000:pop bc
        call fill_mem
        ld a,$27:ld (crt_ctrl),a
        ret



get_rnd
        ld hl,(rnda):inc hl:ld a,h:or $f8:ld h,a:ld (rnda),hl
        ld a,(rndv):rlca:add a,(hl):ld (rndv),a
        ret

rnda    defw $f800
rndv    defb $a5

;====================================
; Slow sprites
;------------------------------------
; de = source, hl = addr on screen, c = y-coordinate
draw_sprite
.ds0    ld b,$4e
.ds1    ld a,(de):inc de:cp $c0:jp c,.ds2
                inc a:ret z             ; $ff - end of sprite
                inc a:jp nz,.ds5        ; $fe - default color
                        push de
                                ld de,default_colors
                                ld a,e:add a,c:ld e,a
                                ld a,(de)
                        pop de
.ds2            ld (hl),a
.ds3            inc l:call z,wrap_inc_hl
        dec b:jp .ds1

.ds5            inc a:jp nz,.ds4        ; $fd - new line
                        inc c
                        ld a,l:add a,b:ld l,a:call c,wrap_inc_hl
                        jp .ds0
.ds4            inc a:jp z,.ds3         ; $fc - skip character


.rle    sub $c4:push bc
        ld c,a:ld a,b:sub c:push af:ld a,(de):inc de:ld b,a
.rl4    ld (hl),b:inc l:call z,wrap_inc_hl:dec c:jp nz,.rl4
        pop af:pop bc:ld b,a:jp .ds1
;----------------------------------------
; Draw sprite hiding left offscreen part
; de = source, hl = addr on screen, bc = xy-coordinate
drawL_sprite
        ld a,b:sub 9:ld (.ds4+1),a
.ds0    ld b,a
.ds1    ld a,(de):inc de:cp $f0:jp c,.ds2
                inc a:ret z             ; $ff - end of sprite
                inc a:jp nz,.ds5        ; $fe - default color
                        push de
                                ld de,default_colors
                                ld a,e:add a,c:ld e,a
                                ld a,(de)
                        pop de
.ds2            inc b:jp m,.ds3:ld (hl),a
.ds3            inc l:call z,wrap_inc_hl
        jp .ds1

.ds5            inc a:jp nz,.ds6        ; $fd - new line
                        inc c
                        ld a,$4e:sub b
.ds4                    ld b,0:add a,b
                        add a,l:ld l,a:call c,wrap_inc_hl
                        jp .ds1
.ds6            inc l:call z,wrap_inc_hl         ; $fc - skip character
        inc b:jp .ds1

;-----------------------------------------
; Draw sprite hiding right offscreen part
; de = source, hl = addr on screen, bc = xy-coordinate
drawR_sprite
        ld a,b:add a,56:ld (.ds4+1),a
.ds0    ld b,a
.ds1    ld a,(de):inc de:cp $f0:jp c,.ds2
                inc a:ret z             ; $ff - end of sprite
                inc a:jp nz,.ds5        ; $fe - default color
                        push de
                                ld de,default_colors
                                ld a,e:add a,c:ld e,a
                                ld a,(de)
                        pop de
.ds2            inc b:jp m,.ds3:ld (hl),a
.ds3            inc l:call z,wrap_inc_hl
        jp .ds1

.ds5            inc a:jp nz,.ds6        ; $fd - new line
                        inc c
                        ld a,$4e:sub b
.ds4                    ld b,0:add a,b
                        add a,l:ld l,a:call c,wrap_inc_hl
                        jp .ds1
.ds6            inc l:call z,wrap_inc_hl         ; $fc - skip character
        inc b:jp .ds1

;---------------
save_sprite
        ld a,h:and $20:or d:ld d,a
        ex de,hl:ld (hl),e:inc hl:ld (hl),d:inc hl:ex de,hl
.ss0
        ld b,$4e
.ss1            ld a,(de):or a:jp p,.ss2
                inc a:ret z             ; $ff - end of sprite
                inc a                   ; $fe - default color
                inc a:jp nz,.ss4        ; $fd - new line
                        ld a,l:add a,b:ld l,a:call c,wrap_inc_hl
                        inc de:jp .ss0
.ss2            ld a,(hl):ld (de),a
.ss3            inc de
                inc l:call z,wrap_inc_hl
        dec b:jp .ss1

.ss4            inc a:jp z,.ss3         ; $fc - skip character
                jp .ss2

;--------------------
; de = save_buffer
        ifused restore_sprite
restore_sprite
        ld a,(frame_mask):or d:ld d,a
        ld a,(de):ld l,a:inc de
        ld a,(de):or a:ret z:ld h,a
        xor a:ld (de),a:inc de
        jp draw_sprite
        endif

is_sprite_colided ;de = save_buffer, bc = bytes to find -> c=1 - byte found, a=byte
        ld a,(frame_mask):or d:ld d,a
        inc de:ld a,(de):or a:ret z:inc de
.isc1           ld a,(de):inc de
;                cp $fc:jp z,.isc1
;                cp $fd:jp z,.isc1
                cp b:jp c,.isc1
                cp c:ret c
                inc a:jp nz,.isc1
        or a:ret

        ifused put_sprite
put_sprite      ; bc = xy, hl = sprite data, de = save buffer
        push hl,de:call xy_to_addr
                pop de:push hl,bc:call save_sprite
        pop bc,hl,de
        ld a,b:cp 8:jp c,drawL_sprite
        cp 56:jp nc,drawR_sprite
        jp draw_sprite
        endif

;=============================================
; Fast sprites
;---------------------------------------------
; bc = xy, hl = sprite data, de = save buffer
fput_sprite
        push hl,de:call xy_to_addr
                pop de:push hl,bc:call fsave_sprite
        pop bc,hl,de
        ld a,b:cp 8:jp c,drawL_sprite
        cp 56:jp nc,drawR_sprite
        jp fdraw_sprite

;---------------------------------------
; hl = addr on screen, de = save buffer
fsave_sprite
        ld a,h:and $20:or d:ld d,a
        ex de,hl:ld (hl),e:inc hl:ld (hl),d:inc hl:ex de,hl
.compiled+1
        jp save_sprite.ss0

;----------------------------------
fdraw_sprite
        ld b,high default_colors:ld a,low default_colors:add a,c:ld c,a
.compiled+1
        jp draw_sprite

;-----------------------------------
; de = save_buffer
frestore_sprite
        ld a,(frame_mask):or d:ld d,a
        ld a,(de):ld l,a:inc de
        ld a,(de):or a:ret z:ld h,a
        xor a:ld (de),a:inc de
.compiled       equ $+1
        jp draw_sprite

;-----------------------------------
        macro CompileSprite
        ld c,$4e
.loop   ld a,(hl):inc hl:cp $fc:jp c,.char
        inc a:jp z,.exit
        inc a:jp z,.cdc ;default color
        inc a:jp z,.nl  ;new line

        ld b,low .skip_size:push hl:ld hl,.skip
        jp .do

.nl     ld b,low .new_line_size-2:push hl:ld hl,.new_line
        ld a,(hl):ld (de),a:inc hl:inc de
        ld a,c:ld (de),a:inc hl:inc de
        ld c,$4f:jp .do

.cdc    ld b,low .def_color_size:push hl:ld hl,.def_color
        jp .do

.char   ld b,low .move_to_size:push hl:ld hl,.move_to
.do     ld a,(hl):ld (de),a:inc de:inc hl:dec b:jp nz,.do
        pop hl:dec c:jp .loop

.exit   ld a,$c9:ld (de),a:inc de:ret

.new_line
        ld a,$4e:inc de:add a,l:ld l,a:call c,wrap_inc_hl
.new_line_size  equ $-.new_line

        endm

;----------------------------------------------------
; hl - sprite, de - addr to compile => de - new addr
compile_draw_sprite
        CompileSprite
.move_to
        ld a,(de):ld (hl),a:inc de:inc l:call z,wrap_inc_hl
.move_to_size   equ $-.move_to

.def_color
        ld a,(bc):inc c:ld (hl),a:inc de:inc l:call z,wrap_inc_hl
.def_color_size equ $-.def_color

.skip
        inc de:inc l:call z,wrap_inc_hl
.skip_size      equ $-.skip

;----------------------------------------------------
; hl - sprite, de - addr to compile => de - new addr
compile_save_sprite
        CompileSprite
.move_to
        ld a,(hl):ld (de),a
.skip
        inc de:inc l:call z,wrap_inc_hl
.move_to_size   equ $-.move_to
.skip_size      equ $-.skip
.def_color
        ld a,(hl):ld (de),a:inc de:inc l:call z,wrap_inc_hl
.def_color_size equ $-.def_color

;----------------------------------------------------
; hl - sprite, de - addr to compile => de - new addr
compile_restore_sprite
        CompileSprite
.move_to
        ld a,(de):ld (hl),a
.skip
        inc de:inc l:call z,wrap_inc_hl
.move_to_size   equ $-.move_to
.skip_size      equ $-.skip
.def_color
        ld a,(de):ld (hl),a:inc de:inc l:call z,wrap_inc_hl
.def_color_size equ $-.def_color

;-----------------
        macro SetDraw draw?
        ld hl,(draw?):ld (fdraw_sprite.compiled),hl
        endm

        macro SetDrawSave draw?, save?
        ld hl,(draw?):ld (fdraw_sprite.compiled),hl
        ld hl,(save?):ld (fsave_sprite.compiled),hl
        endm

        macro SetRestore restore?
        ld hl,(restore?):ld (frestore_sprite.compiled),hl
        endm
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^


shift_sprite_right   ; de - source sprite
                    ; hl - destination
                    ; bc - sprite size
        push bc
            ld b,0
.ssl0
            ld a,(de):cp $0d:jp z,.ssl2
            or a:jp m,.ssl2
                and 1:rlca:ld c,a
                ld a,(de):and $10:rrca:rrca:or c:or b
                ld (hl),a
                ld a,(de):and 2:rrca:ld b,a
                ld a,(de):and 4:rlca:rlca:or b:ld b,a
.ssl3       inc hl:inc de
            ex (sp),hl:dec hl:ld a,h:or l:ex (sp),hl
        jp nz,.ssl0
        pop bc
        ret
.ssl2       ld (hl),a:ld b,0:jp .ssl3

        IFDEF RK86
color_black     equ $80
color_blue      equ $88
color_red       equ $81
color_magenta   equ $89
color_cyan      equ $8c
color_green     equ $84
color_yellow    equ $85
color_white     equ $8d
        ENDIF

        IFDEF APOGEE
color_black     equ $8d
color_blue      equ $89
color_red       equ $8c
color_magenta   equ $88
color_cyan      equ $81
color_green     equ $85
color_yellow    equ $84
color_white     equ $80
        ENDIF
