        struct BOOM
x       defb    0       ; x - coordinate
cnt     defb    0       ; counter for animation
spriteN defb    0       ; current number of sprites to animate
sprite  defw    0       ; sprite graphics
y       defb    0       ; y - coordinate
addr    defw    0       ; address on screen
        ends

        macro BoomInit
                ld de,sprite:ld hl,sprite2:ld bc,length:jp shift_sprite_right
        endm

        macro BoomPrepare
           ; hl - pointer to BOOM structure, bc - xy coordinates
                ; => a - number of animation frames
        ld a,b:add a,a:ld (hl),a:inc l     ; x
        ld (hl),anim_delay:inc l           ; cnt
        ld (hl),cnt:inc l                  ; sptiteN
        ld (hl),low sprite:inc l                  ; sprite low
        ld (hl),high sprite:inc l                 ; sprite high
        .2 dec c
        push hl:call xy_to_addr:ex de,hl:pop hl
        ld (hl),c:inc l                         ; y
        ld (hl),e:inc l:ld (hl),d:inc l         ; addr
        ld a,(cnt+1)*anim_delay
        ret
        endm

        macro BoomDraw
            ; hl - BOOM struct => cf=1 - no more animation frames
        dec (hl):inc l:dec (hl):jp z,.db2
        ld a,(hl):cp anim_delay-2:ccf:ret nc
        inc l:inc l:ld e,(hl):inc l:ld d,(hl):jp .db4
.db2            ld (hl),anim_delay         ; cnt
                inc l:dec (hl):jp z,.db1              ;spriteN
                inc l:ld e,(hl):inc l:ld d,(hl) ; sprite.h
                ld bc,size:ex de,hl:add hl,bc:ex de,hl
                ld (hl),d:dec l:ld (hl),e ;sprite.l
                inc l
.db4    inc l:ld c,(hl)                         ; y
        inc l:ld b,(hl)                         ; addr.l
        inc l:ld a,(hl):xor $20:ld (hl),a       ; addr.h
        .7 dec l:ld l,(hl)
        ld h,a:ld a,l:ld l,b:or a:rra:ld b,a:ld a,h:and $20:jp z,.db3
                ld a,e:add a,low length:ld e,a
                ld a,d:adc a,high length:ld d,a
.db3    jp drawL_sprite

.db1    ld (hl),1:scf:ret
        endm

        module boom
init    BoomInit

anim_delay equ 6 ; measured in frames

prepare BoomPrepare

draw    jp $+4:BoomDraw

sprite
    defb color_white:   defh "00 00 00 00 00 00 fe fd"
    defb color_white:   defh "00 04 17 11 00 00 fe fd"
    defb color_white:   defh "00 00 03 00 00 00 fe fd"
    defb color_white:   defh "00 00 00 00 00 00 fe ff"
.next
    defb color_white:   defh "00 04 14 14 10 00 fe fd"
    defb color_white:   defh "00 17 17 17 01 00 fe fd"
    defb color_white:   defh "02 17 17 17 00 00 fe fd"
    defb color_white:   defh "00 00 03 00 00 00 fe ff"

    defb color_yellow:  defh "04 16 17 17 15 fe fc fd"
    defb color_white:   defh "17 17 16 17 17 00 fe fd"
    defb color_white:   defh "02 17 17 16 11 00 fe fd"
    defb color_yellow:  defh "00 01 07 03 00 00 fe ff"

    defb color_yellow:  defh "04 16 17 13 15 00 fe fd"
    defb color_yellow:  defh "17 17 05 17 16 00 fe fd"
    defb color_yellow:  defh "07 13 12 15 11 00 fe fd"
    defb color_yellow:  defh "02 01 17 02 01 00 fe ff"

    defb color_yellow:  defh "14 17 03 17 15 00 fe fd"
    defb color_yellow:  defh "13 17 10 10 16 00 fe fd"
    defb color_yellow:  defh "03 03 06 15 13 00 fe fd"
    defb color_yellow:  defh "02 01 16 02 01 00 fe ff"

    defb color_red:     defh "10 13 02 03 15 00 fe fd"
    defb color_yellow:  defh "03 10 00 10 06 00 fe fd"
    defb color_yellow:  defh "01 03 04 14 12 00 fe fd"
    defb color_red:     defh "02 01 04 02 01 00 fe ff"

    defb color_red:     defh "10 01 01 04 06 00 fe fd"
    defb color_magenta: defh "01 00 00 00 04 00 fe fd"
    defb color_magenta: defh "01 11 00 04 00 00 fe fd"
    defb color_red:     defh "02 01 05 00 01 00 fe ff"

    defb color_red:     defh "10 01 00 02 06 00 fe fd"
    defb color_red:     defh "01 00 00 00 00 00 fe fd"
    defb color_red:     defh "00 01 00 00 00 00 fe fd"
    defb color_red:     defh "02 01 04 00 01 00 fe ff"

    defb color_blue:    defh "10 00 00 00 02 00 fe fd"
    defb color_blue:    defh "00 00 00 00 00 00 fe fd"
    defb color_blue:    defh "00 01 00 00 00 00 fe fd"
    defb color_blue:    defh "00 00 00 00 00 00 fe ff"

        defh "00 00 00 00 00 00 00 fe fd"
        defh "00 00 00 00 00 00 00 fe fd"
        defh "00 00 00 00 00 00 00 fe fd"
        defh "00 00 00 00 00 00 00 fe ff"

sprite2 defs length

size    equ sprite.next-sprite
length  equ sprite2-sprite
cnt     equ length/size

        endmodule

        module boom2

init    BoomInit

anim_delay equ 4 ; measured in frames

prepare BoomPrepare

draw    BoomDraw

sprite
        defb color_white:   defh "00 00 14 10 00 00 fe fd"
        defb color_white:   defh "00 02 17 13 00 00 fe fd"
        defb color_white:   defh "00 00 00 00 00 00 fe ff"
.next
        defb color_white:   defh "00 15 17 15 10 00 fe fd"
        defb color_white:   defh "00 03 17 13 00 00 fe fd"
        defb color_white:   defh "00 00 00 00 00 00 fe ff"

        defb color_yellow:  defh "04 02 01 01 00 00 fe fd"
        defb color_white:   defh "07 15 14 14 13 00 fe fd"
        defb color_yellow:  defh "00 00 01 00 00 00 fe ff"

        defb color_yellow:  defh "10 02 00 00 03 10 fe fd"
        defb color_yellow:  defh "16 10 14 00 14 10 fe fd"
        defb color_yellow:  defh "02 03 13 01 02 00 fe ff"

        defb color_yellow:  defh "10 02 00 00 02 10 fe fd"
        defb color_yellow:  defh "05 00 00 00 04 10 fe fd"
        defb color_yellow:  defh "00 02 02 00 00 00 fe ff"

        defb color_red:     defh "12 00 00 00 01 10 fe fd"
        defb color_yellow:  defh "04 00 00 04 00 00 fe fd"
        defb color_red:     defh "00 02 00 00 00 00 fe ff"

        defb color_red:     defh "01 00 00 00 00 01 fe fd"
        defb color_magenta: defh "10 00 00 00 00 00 fe fd"
        defb color_red:     defh "00 00 00 02 00 00 fe ff"

        defb color_red:     defh "00 00 00 00 00 01 fe fd"
        defb color_red:     defh "10 00 00 00 00 00 fe fd"
        defb color_red:     defh "00 00 00 00 01 00 fe ff"

        defb color_blue:     defh "00 00 00 00 00 00 fe fd"
        defb color_blue:     defh "00 00 00 00 00 00 fe fd"
        defb color_blue:     defh "01 00 00 00 00 00 fe ff"

        defh "00 00 00 00 00 00 00 00 fd"
        defh "00 00 00 00 00 00 00 00 fd"
        defh "00 00 00 00 00 00 00 00 ff"

sprite2 defs length

size    equ sprite.next-sprite
length  equ sprite2-sprite
cnt     equ length/size

        endmodule

        module boom3

init    BoomInit

anim_delay equ 4 ; measured in frames

prepare BoomPrepare

draw    BoomDraw

sprite
        defb color_white:   defh "00 14 00 fe fd"
        defb color_white:   defh "00 03 00 fe ff"
.next
        defb color_yellow:  defh "00 16 01 fe fd"
        defb color_white:   defh "02 13 11 fe ff"

        defb color_yellow:  defh "04 15 10 fe fd"
        defb color_yellow:  defh "02 17 01 fe ff"

        defb color_yellow:  defh "16 03 10 fe fd"
        defb color_yellow:  defh "02 14 03 fe ff"

        defb color_yellow:  defh "01 01 01 fe fd"
        defb color_yellow:  defh "05 02 12 fe ff"

        defb color_red:     defh "11 00 01 fe fd"
        defb color_red:     defh "10 10 04 fe ff"

        defb color_red:     defh "10 00 02 fe fd"
        defb color_red:     defh "04 00 10 fe ff"

        defb color_blue:    defh "10 00 00 fe fd"
        defb color_blue:    defh "00 00 10 fe ff"

        defb color_blue:    defh "01 00 00 fe fd"
        defb color_blue:    defh "00 00 04 fe ff"

        defh "00 00 00 00 00 fd"
        defh "00 00 00 00 00 ff"

sprite2 defs length

size    equ sprite.next-sprite
length  equ sprite2-sprite
cnt     equ length/size

        endmodule
