scr_lines   equ 38
scr_length  equ $b00
scr_start   equ $4000

        IFDEF RK86
crt_ctrl    equ $c001
dma_ctrl    equ $e008
kbd_port    equ $8000
        ENDIF
        IFDEF APOGEE
crt_ctrl    equ $ef01
dma_ctrl    equ $f008
kbd_port    equ $ed00
        ENDIF

        org $start_addr

        call compile_sprites

        call make_row_table

        call boom.init:call boom2.init:call boom3.init

        ld a,'0':ld hl,score_sprite.score_0
        ld (hl),a:dec hl:ld (hl),a
        ld hl,score_sprite.tank_0
        ld (hl),a:dec hl:ld (hl),a
        ld hl,score_sprite.heli_0
        ld (hl),a:dec hl:ld (hl),a
        ld hl,score_sprite.lives_0
        ld (hl),'2':dec hl:ld (hl),a

        call title.show

game_start
        call make_sprite_save
        ld a,1:ld (old_hgt_l),a:ld (old_hgt_u),a
        ld (target_l),a:ld (target_u),a

        xor a:ld (objs.tank.state),a:ld (objs.heli.state),a
        ld (objs.tank.msl_state),a:ld (objs.rocket.state),a
        ld (ship.laser_state),a
        ld l,a:ld h,a:ld (save_buffer.cursor),hl:ld (save_buffer.cursor+$2000),hl

        ld a,128:ld (start_roll_cnt),a


        call clr_screens

        ld a,$f3
        ld (scr_start+scr_length-1),a
        ld (scr_start+$2000+scr_length-1),a

        ld hl,crt_ctrl:ld (hl),0
        dec hl:ld (hl),$4d:ld (hl),scr_lines-1:ld (hl),$37:ld (hl),$73
        inc hl:ld (hl),$27

        ;jp game_over
mainloop
        call sound.play_all
        ld hl,(frame_adress):ex de,hl
        ld hl,(frame_len):ld b,h:ld c,l
        ld hl,scr_length-1
        call set_dma

        ld a,d:xor $20:ld h,a:ld l,e:ld (frame_adress),hl
        and $20:ld (frame_mask),a:jp z,.skip


                inc l:call z,wrap_inc_hl
                ld (frame_adress),hl

                ld hl,(frame_end):ld (hl),0
                ld a,h:xor $20:ld h,a:ld (hl),0

                ld hl,scr_length-1:add hl,de:call wrap_hl
                ld (hl),$f3:ld a,h:xor $20:ld h,a
                ld (hl),$f3:ld (frame_end),hl

                ld hl,(frame_len)
                ld a,h:or l
                dec hl:jp nz,.skip2
                        ld hl,scr_length-1
.skip2  ld (frame_len),hl

.skip   call restore_sprites

        ld hl,(frame_adress):ld de,$4e*4+6
        add hl,de:call wrap_hl
        push hl:call erase:pop hl

        ld de,64:add hl,de:call wrap_hl
        call draw
        ld hl,start_roll_cnt:dec (hl):jp p,mainloop
        ld (hl),0
        call draw_score
        call draw_sprites
        call game_events:jp c,ship_death

        macro KbdInp k_row
                ld a,k_row:ld (kbd_port),a:ld a,(kbd_port+1)
        endm

.wait   KbdInp $fb:rrca
        rrca:jp nc,launch_rocket
        rrca:jp nc,shoot_laser
        KbdInp $fd
        rlca:jp nc,fly_down
        rlca:jp nc,fly_right
        rlca:jp nc,fly_up
        rlca:jp nc,fly_left
        KbdInp $fc
        rrca:rrca:jp nc,.wait

        rrca:jp c,mainloop

        call $f82d
        jp $f86c

start_roll_cnt  defb 0

fly_left
        ld a,(ship.x):cp 10:jp c,mainloop
        dec a:ld (ship.x),a
        jp mainloop
fly_right
        ld a,(ship.x):cp 60:jp nc,mainloop
        inc a:ld (ship.x),a
        jp mainloop
fly_up
        ld a,(ship.y):cp 5:jp c,mainloop
        dec a:ld (ship.y),a
        jp mainloop
fly_down
        ld a,(ship.y):cp 27:jp nc,mainloop
        inc a:ld (ship.y),a
        jp mainloop


launch_rocket
        ld a,(objs.rocket.state):or a:jp nz,mainloop
        ld a,$ff:ld (objs.rocket.state),a
        ld a,(ship.x): add a,rocket_init_x:ld (objs.rocket.x),a
        ld a,(ship.y): add a,rocket_init_y:ld (objs.rocket.y),a

        ld hl,sound.seq5:call sound.start_a

        jp mainloop

shoot_laser
        ld a,(ship.laser_state):or a:jp nz,mainloop
        ld a,7+laser_idle:ld (ship.laser_state),a

        ld hl,sound.seq6:call sound.start_a

        jp mainloop

        include "utils.asm"

frame_adress    defw scr_start
frame_len       defw scr_length-1
frame_end       defw scr_start+scr_length-1
frame_mask      defb 0


old_hgt_u       defb 1
old_hgt_l       defb 1

target_u        defb 1
target_l        defb 1

upper   equ 15
lower   equ 7
middle  equ 23

        ; drawing the sky
        ; target_u holds random height
        ; each iteration current height is changed towards target
draw
        ;push hl:call draw_star:pop hl
        ld de,$0017
        ld a,(old_hgt_u):ld b,a
        ld a,(target_u):cp b:jp nz,du_old

        ; get here when target height reached
        ; randomly choose new height
du_new  push hl:call get_rnd
        rlca:rlca:and upper:inc a
        ld (target_u),a
        pop hl:jp draw
du_old
        sbc a,a:ccf:adc a,b:ld c,a
        ld (old_hgt_u),a

draw_upper
        ld (hl),e
        ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0
        ld a,e
        dec b:jp p,.du3:and $6
.du3    dec b:jp p,.du1:and $7
.du1    dec c:jp p,.du2:and $11
.du2    dec c:jp p,.du4:and $13
.du4    ld e,a:inc d:or a
        jp nz,draw_upper

        ;skip middle part of playfield
        ld a,middle+1:sub d:add a,a
        ex de,hl
        ld l,a:ld h,high row_table
        ld a,(hl):inc l:ld h,(hl):ld l,a
        add hl,de:call wrap_hl
        ld de,middle*256

        ld a,(old_hgt_l):ld b,a:ld c,a
        ld a,(target_l):dec a:ld (target_l),a
        jp nz,draw_lower
                push hl
                call get_rnd
                rlca:rlca:and lower:inc a:ld c,a
                ld (target_l),a:ld (old_hgt_l),a
                pop hl

        ; and draw ground
        ; a random height is choosen
        ; then a random number of lines of that height is drawn
draw_lower
        ld (hl),e
        ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.du0    ld a,e
        dec b:jp p,.dl3:or $11
.dl3    dec b:jp p,.dl1:or $10
.dl1    dec c:jp p,.dl4:or $6
.dl4    dec c:jp p,.dl2:or $4
.dl2    ld e,a::cp $17:jp z,.dl5
        inc d:ld a,d:cp 28:jp nz,draw_lower
        ret
.dl6    ld (hl),e
        ld a,l:add a,$4e:ld l,a:call c,wrap_inc_hl
.dl5    inc d:ld a,d:cp 31:jp nz,.dl6
        ret


draw_star
        call get_rnd
        ;and 127:
        cp 16:ret nc
        add a,upper:ld c,a
        ld b,64+6
        call xy_to_addr
        ld (hl),$cc
        ret


        ; sizes of playfield zones
        ; total playfield height is 32 characters
sky_width       equ     9
scape_width     equ     4
ground_width    equ     3
middle_width    equ     32-sky_width-ground_width-scape_width


erase
        ld de,$4d
        ld bc,default_colors+4
        jp .ent
.loop           ld (hl),d:inc l:call z,wrap_inc_hl
                ld a,(bc):ld (hl),a
                ld a,l:add a,e:ld l,a:call c,wrap_inc_hl
                inc c
.ent            ld a,(bc):inc a:jp nz,.loop
        ret


        struct SAVE
cursor          defb 0 ; x
                defb 0 ; y
ship            defw 0
                defs ship_sprite_size
rocket          defw 0
                defs rocket_sprite_size
laser           defw 0 ; custom save procedure saves 2 bytes
                defb 0 ; at start
                defw 0
                defb 0 ; at end of laser beam
tank            defw 0
                defs tank_sprite_size
tank_msl        defw 0
                defs tank_msl_sprite_size
heli            defw 0
                defs heli_sprite_size
heli_blt        defw 0
                defs heli_blt_sprite_size
        ends

        ; in fact there are 2 save buffers this and at +$2000
        ; they hold backgrounds under sprites for each frame buffer
        ; if frame_adress>=$6000 save buffers are switched automatically
save_buffer SAVE = $4c00


draw_sprites
        call draw_enemy_sprites
        call draw_ship
        call draw_laser
        ret

draw_enemy_sprites
        ld hl,objs.rocket.state:call draw_rocket
        ld hl,objs.tank.state:call draw_tank
        ld hl,objs.tank.msl_state:call draw_tank_msl
        ld hl,objs.heli.blt_state:call draw_heli_blt
        ld hl,objs.heli.state:call draw_heli
        ret

game_events
        ld de,save_buffer.ship
        ld bc,$1b7f
        call is_sprite_colided:ret c

        ld hl,objs.heli.state:call heli_events
        ld hl,objs.tank.state:call tank_events
        or a:ret

add_score_cnt ; de - addr in score sprite => adds 1 to dead enemy counter
        ld a,(de):inc a:ld (de),a:cp $3a:ret c
        ex de,hl:ld (hl),'0':dec hl:inc (hl):ex de,hl
        ret

add_score
        ld hl,score_sprite.score_0:add a,(hl):ld (hl),a:cp $3a:ret c
        sub 10:ld (hl),a:dec hl:inc (hl)
        ret


restore_sprites
        ld de,save_buffer.cursor:ld a,(frame_mask)
        xor $20:or d:ld d,a
        ld hl,crt_ctrl:ld (hl),$80:dec l
        ld a,(de):ld (hl),a:inc de
        ld a,(de):ld (hl),a

        call restore_laser
        SetRestore ship_restore
        ld de,save_buffer.ship:call frestore_sprite
        call restore_enemy_sprites
        ret

restore_enemy_sprites
        SetRestore heli_restore:ld de,save_buffer.heli:call frestore_sprite
        SetRestore heli_brestore:ld de,save_buffer.heli_blt:call frestore_sprite
        SetRestore tank_mrestore:ld de,save_buffer.tank_msl:call frestore_sprite
        SetRestore tank_restore:ld de,save_buffer.tank:call frestore_sprite
        SetRestore rocket_restore:ld de,save_buffer.rocket:call frestore_sprite
        ret

;=================================
; Ship
ship_init_x  equ 20
ship_init_y  equ 1+4

        struct SHIP
y           defb ship_init_y ; don't change order
x           defb ship_init_x ; can be loaded as a pair
laser_state defb 0
        ends
ship    SHIP


draw_ship ; hardware cursor is used to immitate ship's laser cannon
        ld de,save_buffer.cursor
        ld a,(frame_mask):or d:ld d,a
        ld a,(ship.x):ld b,a:add a,laser_init_x:ld (de),a:inc de
        ld a,(ship.y):ld c,a:add a,laser_init_y:ld (de),a

        SetDrawSave ship_draw,ship_save
        ld de,save_buffer.ship
        ld hl,ship_sprite
        jp fput_sprite

ship_sprite
        defb $fc,color_magenta,"\\",$fe,$fd
        defb color_magenta,">]==-",$fe,$fd
        defb $fc,color_magenta,"/",$fe,$ff
ship_sprite_size    equ $-ship_sprite



ship_death
        and $ef:sub $0b:jp nz,.sd1
        ld (objs.tank.msl_state),a
.sd1
        ld hl,(frame_adress):ld a,h:xor $20:ld h,a:ld (frame_adress),hl
        and $20:ld (frame_mask),a
        ld hl,0:ld (save_buffer.cursor),hl:ld (save_buffer.cursor or $2000),hl
        ld hl,crt_ctrl:ld (hl),$80:dec l:.2 ld (hl),0
        call restore_laser
        SetRestore ship_restore:ld de,save_buffer.ship:call frestore_sprite
        ld hl,(ship.y):ld b,h:ld c,l:inc c:inc c
        ld hl,objs.ship_Boom:call boom.prepare
        call sound.mute_all
        ld hl,sound.seq7
        call sound.start_a:call sound.start_b:call sound.start_c
.death_loop
        push af:cp 51:jp c,.dl2
        and 3:ld de,$4e:cp 2:jp c,.dl1:ld de,$b00-$4e
.dl1
        ld hl,(frame_end):ld a,h:and $df:ld h,a
        ld a,(frame_mask):or h:ld h,a
        ld (hl),0
        add hl,de:call wrap_hl
        ld (hl),$f3:ld (frame_end),hl
.dl2
        call sound.play_all
        ld a,(crt_ctrl)
.wait_vb
        ld a,(crt_ctrl):and a,$20:jp z,.wait_vb
        call restore_enemy_sprites
        ld hl,objs.ship_Boom:call boom.draw
        call draw_enemy_sprites
        pop af
        dec a:jp nz,.death_loop
        ld hl,score_sprite.lives_0:ld a,(hl):dec a:cp '0':jp c,game_over
        ld (hl),a
        jp game_start

        include gameover.asm
        include hiscore.asm
;=============================
; Ship's Rocket
rocket_init_x   equ 1 ;relative to ship
rocket_init_y   equ 2 ;relative to ship
rocket_max_x    equ 64
rocket_min_x    equ 52 ;min x for rocket to explode
rocket_max_y    equ 33

        struct ROCKET
x       defb 0
y       defb 0
state   defb 0 ;0 = no rocket; $ff = flying; 1-127 = exploging
cnt     defb 0 ;some counter
        ends

draw_rocket     ; hl = addr.rocket.state
        ld a,(hl):or a:ret z
        jp p,rocket_boom

        ld l,OBJECTS.rocket.x:ld b,(hl)
        inc l:ld c,(hl) ;.rocket.y
        ld l,OBJECTS.rocket.cnt:dec (hl):jp p,.dr1
                ld a,c:cp rocket_max_y/2:ld a,0:jp nc,.dr2
                ld a,b:cpl:rrca:rrca:rrca:and 7
.dr2            ld (hl),a       ;rocket.cnt
                inc c:ld a,c:cp b:ccf:sbc a,0:ld c,a
                cp rocket_max_y:ld l,OBJECTS.rocket.y:ld (hl),a:jp c,.dr1
                ld l,OBJECTS.rocket_Boom:call boom3.prepare
                ld l,OBJECTS.rocket.state:ld (hl),a
.dr1
        inc b:ld a,b:cp rocket_max_x:ccf:sbc a,0
        ld l,OBJECTS.rocket.x:ld (hl),a
        SetDrawSave rocket_draw, rocket_save
        ld hl,rocket_sprite
        ld de,save_buffer.rocket
        jp fput_sprite


rocket_boom
        dec a:ld (hl),a         ; rocket.state
        ld l,OBJECTS.rocket_Boom
        jp boom3.draw



rocket_sprite
        defb color_green,$0e,$1c,$fe,$ff
rocket_sprite_size  equ $-rocket_sprite


tank_max_x      equ 64
tank_y          equ 31
tank_ld_delay   equ 10
tank_msl_delay  equ 3

        struct TANK
state       defb 0 ; 0 - no tank, 1 - tank appeared, 2 - tank loading, >$80 - exploding
x           defb 0
cnt         defb 0
ld_cnt      defb 0
ld_addr     defw 0 ; tank current loading sprite address
msl_y       defb 0
msl_x       defb 0
msl_state   defb 0
score       defw 0
        ends

draw_tank ; hl = addr.tank.state
        ld a,(hl):or a:ret z:jp m,.boom
        dec a: jp z,.appeared
        dec a: jp z,.loading
.appeared
        ld l,OBJECTS.tank.x
        dec (hl):dec (hl):jp m,.away

        ld a,(hl):add a,8:rra:ld b,a
        ld a,(ship.y):ld c,a:ld a,(ship.x):sub c:sub b
        ld c,tank_y:add a,c:add a,6:jp nz,.go_on

        ld l,OBJECTS.tank.msl_state:ld a,(hl):or a:jp nz,.go_on

.start_ld
        ld l,OBJECTS.tank.ld_addr:ld (hl),low tank_ld_sprite
        inc l:ld (hl),high tank_ld_sprite
        ld l,OBJECTS.tank.cnt:ld (hl),tank_ld_delay
        ld l,OBJECTS.tank.ld_cnt:ld (hl),tank_ld_sprite_cnt
        ld l,OBJECTS.tank.state:ld (hl),2
.loading
        ld l,OBJECTS.tank.cnt:dec (hl):jp nz,.ld1
                ld (hl),tank_ld_delay
                inc l:dec (hl):jp z,.start_shoot ; tank.ld_cnt
                        inc l:ld a,low tank_ld_sprite_size
                        add a,(hl):ld (hl),a:inc l; tank.ld_addr
                        ld a,high tank_ld_sprite_size:adc a,(hl):ld (hl),a
.ld1    ld l,OBJECTS.tank.x:ld a,(hl):dec a:jp m,.away
        ld (hl),a:add a,8:rra:ld b,a:ld c,tank_y
        ld l,OBJECTS.tank.ld_addr:ld e,(hl):inc l:ld d,(hl)
        SetDrawSave tank_ld_draw,tank_save
        ex de,hl:ld de,save_buffer.tank
        jp fput_sprite

.go_on  SetDrawSave tank_draw,tank_save
        ld hl,tank_sprite
        ld de,save_buffer.tank
        jp fput_sprite

.start_shoot
        ld l,OBJECTS.tank.state:ld (hl),1
        ld l,OBJECTS.tank.msl_state:ld (hl),1
        ld l,OBJECTS.tank.x:ld a,(hl):add a,12:rra
        ld l,OBJECTS.tank.msl_x:ld (hl),a
        dec l:ld (hl),tank_y-2
        jp .appeared

.boom   inc (hl):jp z,.score
        ld l,OBJECTS.tank_Boom
        jp boom2.draw
.score
        ;ld l,OBJECTS.tank_Boom.x:ld b,(hl)
        ld c,tank_y-1
        ld l,OBJECTS.tank.score:ld e,(hl):inc l:ld d,(hl)
        ld l,OBJECTS.tank_Boom.addr:ld a,(hl):inc l:ld h,(hl):ld l,a
        jp draw_digits

.away   xor a:ld l,OBJECTS.tank.state:ld (hl),a
        call sound.mute_b
        ret

draw_tank_msl ; hl = TANK msl_struct.state
        ld a,(hl):or a:ret z
        ld l,OBJECTS.tank.msl_y:ld c,(hl):inc l:ld b,(hl)
        ld l,OBJECTS.tank.cnt:dec (hl):jp nz,.dtm1
                ld (hl),tank_msl_delay
                dec c:ld a,c:ld l,OBJECTS.tank.msl_y:ld (hl),a:cp 4:jp nc,.dtm2
                        ld l,OBJECTS.tank.msl_state:ld (hl),0:ret
.dtm2           ld a,(ship.x):add a,3
                cp b:jp z,.dtm3:dec b:jp c,.dtm3:.2 inc b
.dtm3           ld a,b:inc l:ld (hl),a ;.tank.msl_x
.dtm1   SetDrawSave tank_mdraw,tank_msave
        ld de,save_buffer.tank_msl
        ld hl,tank_msl_sprite
        jp fput_sprite

tank_events  ; hl = TANK struct.state
        ld a,(hl):or a:jp nz,.ds4
                ld a,(rndv):and $f:ret nz ;:jp nz,.ds4
                ; start tank
                ld (hl),1 ; .tank.state
                ld l,OBJECTS.tank.x:ld (hl),tank_max_x*2
                ld l,OBJECTS.tank.state:ld a,(hl)
                ld hl,sound.seq3:jp sound.start_b

.ds4    dec a:ret m
        ld de,save_buffer.tank:ld bc,$0e0f ; chars of rocket sprite
        call is_sprite_colided:ret nc
                ld l,OBJECTS.tank.x:ld a,(hl):add a,8:rra:ld b,a:ld c,tank_y+1
                ld l,OBJECTS.tank_Boom:call boom2.prepare
                cpl:ld l,OBJECTS.tank.state
                ld b,(hl):ld (hl),a; tank exploding
                ld l,OBJECTS.rocket.state:ld (hl),0

        ld de,score_sprite.tank_0:call add_score_cnt
        ld a,3:ld de,thr_hun:dec b:jp z,.sc1
                ld a,1:ld de,hundred
.sc1    ld l,OBJECTS.tank.score:ld (hl),e:inc l:ld (hl),d
        call add_score
        ld hl,sound.seq7:jp sound.start_b



heli_min_y      equ     6
heli_max_y      equ     24
heli_max_x      equ     66
heli_boom_y     equ     31
heli_x_offset   equ     8

        struct HELI
y               defb 64 ; y*8
x               defb 0  ; (x-heli_x_offset)*2
vy              defb 1
state           defb 0 ; 0 - no heli, 1 - flying, 2 - falling, 3 - exploding
cnt             defb 0
blt_state       defb 0
blt_y           defb 0
blt_x           defb 0
score           defw 0
        ends

draw_heli ; hl = addr.heli.state
        ld a,(hl):or a: ret z
        dec a:jp nz,heli_fall

        ld l,OBJECTS.heli.x:dec (hl):jp z,heli_away

        ld a,(hl):add a,heli_x_offset:rra:ld b,a
        ld de,heli_sprite1:rra:jp c,.dh0
                ld de,heli_sprite2
.dh0    ld l,OBJECTS.heli.vy:ld a,(hl)
        ld l,OBJECTS.heli.y:add a,(hl):ld (hl),a
        ld l,OBJECTS.heli.vy:and $f8:.3 rrca:ld c,a
        cp heli_min_y:jp nc,.dh1
                ld (hl),1:jp .dh2
.dh1    cp heli_max_y:jp c,.dh2
                ld (hl),$ff
.dh2    SetDrawSave heli_draw, heli_save
        ex de,hl:ld de,save_buffer.heli
        jp fput_sprite

heli_away
        ld l,OBJECTS.heli.state:ld (hl),0
        call sound.mute_c
        ret

heli_fall
        dec a:jp nz,heli_boom
        ld l,OBJECTS.heli.y:inc (hl):ld a,(hl)
        ld b,a:and $f8:.3 rrca:ld c,a
        cp heli_boom_y:jp c,.hf1
                ld l,OBJECTS.heli.x:ld a,(hl):add a,heli_x_offset:rra:ld b,a:inc c
                ld l,OBJECTS.heli_Boom
                call boom2.prepare:ld l,OBJECTS.heli.cnt:ld (hl),a
                ld l,OBJECTS.heli.state:ld (hl),3
                ld l,OBJECTS.heli.y:ld b,(hl)
                push hl:ld hl,sound.seq7:call sound.start_c:pop hl


.hf1    ld a,b:and $1c:rrca:ld e,a:ld d,0
        ld l,OBJECTS.heli.x:ld a,(hl):add a,heli_x_offset:rra:ld b,a
        SetDrawSave heli_draw, heli_save
        ld hl,heli_sprites:add hl,de
        ld a,(hl):inc l:ld h,(hl):ld l,a
        ld de,save_buffer.heli
        jp fput_sprite

heli_boom
        ld l,OBJECTS.heli.cnt:dec (hl)
        ld l,OBJECTS.heli_Boom:jp nz,boom2.draw
        ld l,OBJECTS.heli.state:ld (hl),0
        ld a,(rndv):and 63:add a,heli_min_y*8
        ld l,OBJECTS.heli.y:ld (hl),a
        ld l,OBJECTS.heli_Boom.x:ld b,(hl)
        ld l,OBJECTS.heli_Boom.y:ld c,(hl)
        ld l,OBJECTS.heli.score:ld e,(hl):inc l:ld d,(hl)
        ld l,OBJECTS.heli_Boom.addr:ld a,(hl):inc l: ld h,(hl):ld l,a
        jp draw_digits

        ret

heli_blt_min_x  equ 5
draw_heli_blt ; hl = obj.heli.blt_.state
        ld a,(hl):or a:ret z
        ld l,OBJECTS.heli.blt_y:ld c,(hl)
        inc l:ld a,(hl) ; .heli.blt_x
        sub 1:cp heli_blt_min_x:jp c,.away
        ld (hl),a:ld b,a ; .heli.blt_x
        SetDrawSave heli_bdraw, heli_bsave
        ld de,save_buffer.heli_blt
        ld hl,heli_blt_sprite
        jp fput_sprite

.away   ld l,OBJECTS.heli.blt_state:ld (hl),0:ret

heli_events     ; hl = HELI struct
        ld a,(hl):or a:jp nz,.ds2
                ; launch helicopter
                ld a,(rndv):and $3f:ret nz
                ld (hl),1 ;heli.state
                ld l,OBJECTS.heli.x:ld (hl),heli_max_x*2
                ld hl,sound.seq4:call sound.start_c
                ret

.ds2    dec a:ret nz ; = 1-flying
        ld l,OBJECTS.heli.blt_state:ld a,(hl):or a:jp nz,.ds21
                ; heli shoots
                ld l,OBJECTS.heli.x
                ld a,(hl):cp $20:jp c,.ds21
                add a,heli_x_offset:rra:ld b,a
                dec l:ld a,(hl):and $f8:.3 rrca

                ld l,OBJECTS.heli.blt_y:ld (hl),a
                inc l:ld (hl),b ; heli.blt_y

                ld l,OBJECTS.heli.blt_state:ld (hl),1

.ds21   ld a,(ship.laser_state):cp 6+laser_idle:ret nz
        ; check heli death
        ld l,OBJECTS.heli.y:ld a,(hl):and $f8:.3 rrca:ld b,a
        ld a,(ship.y):add a,laser_init_y
        ld c,a:sub b:ret c
        cp 2:ret nc

        ld a,(ship.x):add a,laser_init_x:ld b,a
        inc l:ld a,(hl)         ;heli.x
        cp b:ret c

        ld l,(OBJECTS.heli.state):ld (hl),2
        ld de,score_sprite.heli_0:call add_score_cnt

        ld l,OBJECTS.heli.x:ld a,(hl):sub heli_x_offset
        cp 64:ld a,2:ld de,two_hun:jp nc,.ds23
                ld a,3:ld de,thr_hun
.ds23   ld l,OBJECTS.heli.score:ld (hl),e:inc l:ld (hl),d
        call add_score
        ld hl,sound.seq2:jp sound.start_c



;==============================================
laser_idle      equ $10
laser_init_x    equ 6 ;relative to ship
laser_init_y    equ 1 ;relative to ship

restore_laser
        ld de,save_buffer.laser
        ld a,(frame_mask):or d:ld d,a
        call .rl1
.rl1    ld a,(de):ld l,a:inc de
        ld a,(de):or a:ret z:ld h,a
        xor a:ld (de),a:inc de
        ld a,(de):inc de:ld (hl),a
        ret

        ; laser beam is just a underline attribute of 8275
draw_laser
        ld a,(ship.laser_state):or a:ret z
        sub laser_idle:ld bc,0:jp m,.dl2
                add a,low laser_colors:ld l,a
                ld h,high laser_colors:ld c,(hl)
                ld b,color_black
.dl1    ld h,high row_table
        ld a,(ship.y):add a,laser_init_y:add a,a:ld l,a
        ld e,(hl):inc l:ld d,(hl)
        ld hl,(frame_adress):add hl,de
        ld de,save_buffer.laser:ld a,h:and $20:or d:ld d,a
        push hl
                ld a,(ship.x):add a,laser_init_x:add a,l:ld l,a
                ld a,0:adc a,h:ld h,a:call wrap_hl
                ex de,hl:ld (hl),e:inc hl
                ld (hl),d:inc hl:ex de,hl
                ld a,(hl):ld (de),a:inc de
                ld (hl),c
        pop hl:push de
                ld de,64+7:add hl,de:call wrap_hl
        pop de
        ex de,hl:ld (hl),e:inc hl
        ld (hl),d:inc hl:ex de,hl
        ld a,(hl):ld (de),a:inc de
        ld (hl),b
.dl2
        ld hl,ship.laser_state:dec (hl)
        ret

        ;when laser_state >=0 laser is drawn
        ;if laser_state<0 and >laser_idle laser isn't drawn but can't be fired


        align 8
laser_colors
        defb color_black+$20,color_blue+$20,color_red+$20
        defb color_magenta+$20,color_green+$20,color_cyan+$20
        defb color_yellow+$20,color_white+$20
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

;row_table - values 0..39 multiplied by $4e for fast finding row address
;-----------------------------------------------------------------------
rows_in_table   equ 64
make_row_table
        ld hl,row_table
        ld de,$0
        ld bc,$4e
        ld a,rows_in_table
.loop           ld (hl),e:inc l:ld (hl),d:inc l
                ex de,hl:add hl,bc:ex de,hl
                dec a:jp nz,.loop
        ld de,$0
        ld bc,-$4e
        ld l,$ff
        ld a,rows_in_table
.loop2          ex de,hl:add hl,bc:ex de,hl
                ld (hl),d:dec l:ld (hl),e:dec l
                dec a:jp nz,.loop2
        ret
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

;---------------
make_sprite_save
        ld hl,save_buffer.ship
        ld de,ship_sprite
        ld bc,ship_sprite_size
        call .do

        ld hl,save_buffer.tank
        ld de,tank_sprite
        ld bc,tank_sprite_size
        call .do

        ld hl,save_buffer.heli
        ld de,heli_sprite1
        ld bc,heli_sprite_size
        call .do

        ld hl,save_buffer.heli_blt
        ld de,heli_blt_sprite
        ld bc,heli_blt_sprite_size
        call .do

        ld hl,save_buffer.rocket
        ld de,rocket_sprite
        ld bc,rocket_sprite_size
        call .do

        ld hl,save_buffer.tank_msl
        ld de,tank_msl_sprite
        ld bc,tank_msl_sprite_size
        call .do

        ret

.do
        dup 2
                ld (hl),0:ld a,h:xor $20:ld h,a
                ld (hl),0:ld a,h:xor $20:ld h,a:inc hl
        edup
.l1             ld a,(de):ld (hl),a
                ld a,h:xor $20:ld h,a
                ld a,(de):ld (hl),a
                ld a,h:xor $20:ld h,a
                inc de:inc hl
                dec bc:ld a,b:or c
                jp nz,.l1
        ret
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

;-------------------------------------------
compile_sprites
        ld hl,compiled_sprites

        ld de,ship_sprite
        ld (ship_draw),hl:call .dr
        ld (ship_save),hl:call .sv
        ld (ship_restore),hl:call .rs

        ld de,rocket_sprite
        ld (rocket_draw),hl:call .dr
        ld (rocket_save),hl:call .sv
        ld (rocket_restore),hl:call .rs

        ld de,tank_sprite
        ld (tank_draw),hl:call .dr
        ld (tank_save),hl:call .sv
        ld (tank_restore),hl:call .rs

        ld de,tank_ld_sprite
        ld (tank_ld_draw),hl:call .dr

        ld de,tank_msl_sprite
        ld (tank_mdraw),hl:call .dr
        ld (tank_msave),hl:call .sv
        ld (tank_mrestore),hl:call .rs

        ld de,heli_sprite1
        ld (heli_draw),hl:call .dr
        ld (heli_save),hl:call .sv
        ld (heli_restore),hl:call .rs

        ld de,heli_blt_sprite
        ld (heli_bdraw),hl:call .dr
        ld (heli_bsave),hl:call .sv
        ld (heli_brestore),hl:call .rs

        ld de,score_sprite.score:ld (score_draw.score+1),hl:call .dr
        ld de,score_sprite.tank:ld (score_draw.tank+1),hl:call .dr
        ld de,score_sprite.heli:ld (score_draw.heli+1),hl:call .dr
        ld de,score_sprite.lives:ld (score_draw.lives+1),hl:call .dr

        ld de,hundred:ld (digits_draw+1),hl:call .dr
        ret

.dr     ex de,hl:push hl:call compile_draw_sprite:pop hl:ex de,hl:ret
.sv     ex de,hl:push hl:call compile_save_sprite:pop hl:ex de,hl:ret
.rs     ex de,hl:push hl:call compile_restore_sprite:pop hl:ex de,hl:ret

ship_draw       defw 0
ship_save       defw 0
ship_restore    defw 0

rocket_draw     defw 0
rocket_save     defw 0
rocket_restore  defw 0

tank_draw       defw 0
tank_save       defw 0
tank_restore    defw 0
tank_ld_draw    defw 0

tank_mdraw      defw 0
tank_msave      defw 0
tank_mrestore   defw 0

heli_draw       defw 0
heli_save       defw 0
heli_restore    defw 0

heli_bdraw       defw 0
heli_bsave       defw 0
heli_brestore    defw 0

;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

score_xy equ $822

draw_score
        ld bc,score_xy:call xy_to_addr:ld (score_addr),hl
        ld de,score_sprite.score:call score_draw.score
        ld a,3:add a,l:ld l,a:call c,wrap_inc_hl
        ld de,score_sprite.tank:call score_draw.tank
        ld a,4:add a,l:ld l,a:call c,wrap_inc_hl
        ld de,score_sprite.heli:call score_draw.heli
        ld a,3:add a,l:ld l,a:call c,wrap_inc_hl
        ld de,score_sprite.lives:jp score_draw.lives


score_addr
        defw 0

score_draw
.score  jp 0
.tank   jp 0
.heli   jp 0
.lives  jp 0

score_sprite
.score          defb $17,color_white,"SCORE = 0"
.score_0        defb "000",color_yellow,$ff
.score_size     equ $-.score
.tank           defb $17,color_green,"TANK = 0"
.tank_0         defb "0",color_yellow,$ff
.tank_size      equ $-.tank
.heli           defb $17,color_cyan,"HELI = 0"
.heli_0         defb "0",color_yellow,$ff
.heli_size      equ $-.heli
.lives          defb $17,color_magenta,"LIVES = 0"
.lives_0        defb "3",color_yellow,$ff
.lives_size     equ $-.lives


        include "boom.asm"
        include "enemies.asm"
        include "title.asm"
        include "digits.asm"
        include "sound.asm"

        align 64
default_colors  defb 0,0,0,0
                dup sky_width:defb color_cyan:edup
                dup middle_width:defb color_white:edup
                dup scape_width:defb color_red:edup
                dup ground_width:defb color_yellow:edup
                defb $ff
        align 256
row_table       defs rows_in_table*4

        struct  OBJECTS
tank    TANK
heli    HELI
rocket  ROCKET
rocket_Boom     BOOM
heli_Boom       BOOM
ship_Boom       BOOM
tank_Boom       BOOM
        ends
        assert OBJECTS <256

        align 256
objs    OBJECTS


compiled_sprites        equ $
