game_over
        module game_over
        call sound.mute_all
        call clr_screens

        ld hl,sprite:ld (sprite_line),hl
        ld hl,scroll_s*$100:ld (scroll_d),hl
        ld hl,$ff00:ld (scroll_vy),hl
        ld hl,scr_length-1:ld (s_len),hl
        ld a,0:ld (scroll_o),a
        ld a,$ff:push af

loop    ld a,(scroll_o):ld l,a
        ld a,(scroll_y):ld (scroll_o),a:sub l
        call set_vscroll

        ld hl,(frame_adress):ex de,hl
        ld hl,(frame_len):ld b,h:ld c,l
        ld hl,(s_len)
        call set_dma

        ld hl,(frame_end):ld (hl),0
        ld hl,(frame_adress):ex de,hl
        ld hl,(s_len):add hl,de:call wrap_hl
        ld (hl),$f3:ld (frame_end),hl

        call roll_down:jp nc,loop
        pop af:inc a:push af
        cp $40:jp c,fall
        cp $40:push af:call z,wait:pop af:jp z,loop
        cp $41:call z,correction
        cp $52:jp c,roll_up
        cp $70::jp c,go_away
        call clr_screens:ld bc,$200:call wait.w1
        pop af:jp hiscore.check

wait    ld bc,$2000
.w1     call $f81b:or a:ret p
        dec c:jp nz,.w1
        dec b:jp nz,.w1
        ret

correction
        ld hl,scroll_y:inc (hl):ret

scroll_s        equ $22

scroll_o        defb -16
scroll_d        defb 0
scroll_y        defb 0
scroll_vy       defw $100
sprite_line     defw sprite
s_len           defw scr_length-1

roll_up
        ld bc,$3813:call xy_to_addr
        ld (hl),$f1:ld a,l:add a,20:ld l,a:call c,wrap_inc_hl
        ld (hl),$f1
        ld hl,(s_len):ld de,-$4e:add hl,de:ld (s_len),hl
        ;ld hl,scroll_y:inc (hl):jp loop

        ;call $f803
erase
        ld hl,scroll_y:inc (hl)
        ld bc,$1703:call xy_to_addr
        ld bc,33
.e1     ld (hl),b:inc l:call z,wrap_inc_hl
        dec c:jp nz,.e1
        ld a,(hl):ld (flag),a
        jp loop

flag    defs 1

go_away ld a,(flag):cp $f1:jp nz,erase
        ld bc,$3802:call xy_to_addr
        ld (hl),0:ld a,l:add a,20:ld l,a:call c,wrap_inc_hl:ld (hl),0
        ld hl,(s_len):ld de,$4e:add hl,de:ld (s_len),hl
        xor a:ld (flag),a
        jp loop

roll_down
        ld hl,(sprite_line):ld a,(hl):cp $c0:scf:ret z
        push hl:ld bc,$1704:call xy_to_addr:pop de
        call draw_sprite
.rl2    ex de,hl:ld (sprite_line),hl
        ld hl,scroll_y:dec (hl):ld a,(hl)
        sub scroll_s-17:rrca:rrca:ld c,a:rrca:add a,c:and 7:inc a:ld c,a
.ri6    dec c:ret z
.ri7            ld a,(crt_ctrl):and $20:jp z,.ri7
        jp .ri6

accel   equ -$30

fall    ld hl,(scroll_vy)
.f0     ld bc,accel:add hl,bc
        ld (scroll_vy),hl:ex de,hl
        ld hl,(scroll_d):add hl,de
        ld (scroll_d),hl
        ld a,h:cp 3:jp p,loop
        ld hl,$300:ld (scroll_d),hl:ex de,hl
        xor a:sub l:ld l,a:ld a,0:sbc a,h
        or a:rra
        ld h,a:ld a,l:rra:ld l,a
        ld a,h:or a:rra:ld d,a:ld a,l:rra:ld e,a:add hl,de
        ld (scroll_vy),hl:jp loop

sprite
        defb color_cyan,$E0,$17,$ff

        defb color_cyan,$17,$15,color_red,$02,$C3,$03,color_cyan,$04,$16,$14,color_red,$03
        defb color_cyan,$14,$15,color_red,$c6,$03,$00,$03,$01,$00,$02,$03,$03,color_cyan,$17,$ff

        defb color_cyan,$17,color_red,$03,$17,$14,$14,$16,$13,$01,$00,$00,$03,$17
        defb $03,$00,$00,$06,$17,$15,$C4,$14,$00,$17,$11,$02,$07,$17,$14,color_cyan,$17,$ff

        defb color_cyan,$17,color_yellow,$17,$17,$00,$00,$06,$17,$11,$00,$02,$C3,$17
        defb $01,$00,$06,$17,$11,$C5,$00,$17,$13,$07,$17,$15,color_cyan,$07,$17,$ff

        defb color_cyan,$17,color_yellow,$17,$17,$00,$00,$06,$17,$11,$02,$07,$17,$14
        defb $17,$13,$01,$06,$17,$13,$C3,$03,$00,$00,$17,$15,$14,$16,$13,$03,color_cyan,$17,$ff

        defb color_cyan,$17,color_white,$17,$17,$00,$00,$06,$17,$11,$06,$17,$c3,$00
        defb $17,$11,$06,$17,$11,$C5,$00,$17,$11,$00,$00,$06,$17,color_cyan,$17,$ff

        defb color_cyan,$17,color_white,$17,$17,$00,$00,$06,$17,$11,$06,$17,$C3,$00
        defb $17,$11,$06,$17,$11,$C5,$00,$17,$11,$00,$00,$06,$17,color_cyan,$17,$ff

        defb color_cyan,$17,$01,color_white,$16,$C3,$17,$10,$00,$06,$17
        defb $C3,$00,$17,$11,$04,$C6,$17,$00,$C5,$17,$00,color_cyan,$17,$ff

        defb color_cyan,$17,$17,$C6,$00,$17,$C6,$00,$06,$11,$C6,$00,$17,$C6,$00,$14,$17,$ff

        defb color_cyan,$17,$17,$00,color_white,$C4,$03,$01,$02,$03,$C3,$00
        defb $03,$01,$02,$03,$01,$00,$00,$03,$03,$00,$C6,$03,color_cyan,$17,$ff

        defb color_cyan,$17,$10,color_white,$03,$15,$14,$16,$17,$11,$06,$17,$C3,$00
        defb $17,$11,$06,$17,$11,$00,$00,$17,$17,$00,$17,$15,$C4,$14,color_cyan,$17,$ff

        defb color_cyan,$17,color_white,$17,$17,$00,$00,$06,$17,$11,$06,$C5,$17
        defb $11,$06,$17,$11,$06,$00,$17,$17,$00,$17,$11,$C3,$00,color_cyan,$07,$17,$ff

        defb color_cyan,$17,color_yellow,$C2,$17,$00,$06,$17,$17,$11,$06
        defb $17,$C3,$00,$17,$11,$06,$C6,$17,$00,$C5,$17,color_cyan,$17,$17,$ff

        defb color_cyan,$17,color_yellow,$C2,$17,$C5,0,$06,$17,$C3,$00
        defb $17,$11,$06,$C6,$17,$00,$17,$11,$C3,$00,color_cyan,$C2,$17,$ff

        defb color_cyan,$17,$01,color_red,$16,$13,$C5,$00,$16,$17,$00,$17,$15
        defb $00,$06,$17,$15,$10,$14,$C2,$17,$00,$17,$11,$C3,$00,color_cyan,$04,$17,$ff

        defb color_cyan,$17,$17,$01,color_red,$C4,$14,$10,$C2,$00,$C3,$14
        defb $C2,$00,$04,$14,$10,$C2,$00,$C2,$14,0,$C6,$14,color_cyan,$17,$ff

        defb color_cyan,$C3,$17,$13,$C5,$03,$07,$C5,$03,$13,$C3,$03,$07,$CB,$03,$17,$ff

        defb $C0


; .end    equ $
; .length equ .end-sprite
; .size   equ sprite.next - sprite
; .cnt    equ .length / .size

        endmodule

