        module  title

show    ld a,$40:ld (crt_ctrl),a
        ld hl,scr_start:ld  bc,length+$140
        xor a:call fill_mem
        ld hl,length:ld (curr_len),hl
        call preload

        ld hl,crt_ctrl:ld (hl),$80:dec l:.2 ld (hl),0     ; take away the cursor
        inc l:ld (hl),0
        dec l:ld (hl),$4d:ld (hl),scr_lines-1:ld (hl),$07:ld (hl),$33  ; non-blank attributes
        inc l:ld (hl),$27

        ld de,scr_start:ld bc,length:ld h,b:ld l,c
        call set_dma

        ld hl,scr_start+77-65:ld (curr_f1),hl   ; scrolling by using $f1 character

        ld c,96
.sh0
                ld hl,(curr_len):ex de,hl:ld hl,dma_ctrl-1
                ld (hl),e:ld a,d:or $40:ld (hl),a
                ld a,c:cp 32:jp c,.sh8
                        ld hl,(curr_f1):ld (hl),0:inc hl:ld (hl),$f1:ld (curr_f1),hl
.sh8            ld a,(crt_ctrl)
.sh01           ld a,(crt_ctrl):and a,$20:jp z,.sh01
                ld hl,rows:ld a,97:sub c:ld b,a:cp $21:jp c,.sh1:ld b,$20
.sh1                    ld a,b:cp c:jp nc,.sh5
                        ld e,(hl):inc hl:ld d,(hl):dec hl
                        ld a,(de):inc de:or a:call m,.sh2
                        ld (hl),e:inc hl:ld (hl),d:inc hl

                        ld e,(hl):inc hl:ld d,(hl):dec hl
                        call m,.sh3
                        ld (de),a:inc de
                        ld (hl),e:inc hl:ld (hl),d:inc hl
.sh6            dec b:jp nz,.sh1
        dec c:jp nz,.sh0
        ld bc,0
.sh9
        push bc:ld a,(crt_ctrl)
.sh7            ld a,(crt_ctrl):and $20:jp z,.sh7
                call $f81b:cp $1b:jp z,$f800
        pop bc
        or a:ret p
        dec c:jp nz,.sh9
        call hiscore.show:or a:ret nz
        jp show

.sh2    ld a,(de)
.sh3    inc de:ret

.sh5    .2 inc hl:ld e,(hl):inc hl:ld d,(hl):inc hl
        ld a,(de):or a:jp m,.sh6
        ld a,color_white:ld (de),a
        push hl:ld hl,(curr_len):inc hl:ld (curr_len),hl:pop hl
        jp .sh6

scr_addr        equ scr_start + $4 * 78 + $9
curr_len        defw length
curr_f1         defw scr_start+77-64


preload ; fill screen with attributes only and calc start address for each screen line
        ld hl,rows:push hl
        ld hl,scr_addr:ld bc,bin:ld d,$20
.pl1            ld e,64
                ex de,hl:ex (sp),hl
                ld (hl),c:inc hl:ld (hl),b:inc hl
                ld (hl),e:inc hl:ld (hl),d:inc hl
                ex (sp),hl:ex de,hl
.pl2            ld a,(bc):inc bc:or a:jp p,.pl3
                        and 7:add a,low attrs:push hl
                                ld h,high attrs:ld l,a:ld a,(hl)
                        pop hl:inc e
                        ld (hl),a
.pl3            inc hl:dec e:jp nz,.pl2
                ld a,l:add a,15:ld l,a:ld a,0:adc a,h:ld h,a
        dec d:jp nz,.pl1
        pop hl
        ret

        align 8
attrs   defb color_black,color_blue,color_red,color_magenta
        defb color_green,color_cyan,color_yellow,color_white

rows    defs 128 ; two words for every visible screen line
                 ; first one for address in binary, second one for address on screen

bin     incbin "title.bin"
length  equ $-bin+32*14+78*5+1
        endmodule
