;cp/M+ amstrad cpc and cp/m vector06c
kl_time_please equ &bd0d
BDOS equ 5

AMSTRADCPC equ 0
VECTOR06 equ 1

;LEN equ (7000/4*14)
LEN equ (3000/4*14)
;LEN equ (1000/4*14)
;LEN equ (100/4*14)

MUL10kTAB	equ 0B00h
BUF	equ MUL10kTAB+300h+100h-2

	ORG 0100h

Init:
if AMSTRADCPC
  ld hl,(1)   ;setup firmware services: timer, ...
  ld de,&57
  add hl,de
  ld (firm_jump+1),hl
endif

Restart:
	LD	sp,100h
	LD DE,0
	LD BC,10000
	XOR a
	LD  l,a
GenMulTab:
	LD  h,MUL10kTAB>>8
	LD  (HL),e
	INC h
	LD  (HL),d
	INC h
	LD  (HL),a
	EX DE,HL
	ADD HL,BC
	EX DE,HL
	ADC A,0
	INC l
	JP NZ,GenMulTab

if AMSTRADCPC
	call firm_jump
    dw kl_time_please
    ld (time),hl
    ex de,hl
    ld (time+2),hl
endif
if VECTOR06
    ld hl,0
    ld (time),hl    ;because the prog for the Vector can restart
    ld (time+2),hl
    ld hl,($39)  ;start timer
    ld de,irqe
    ld a,(hl)
    ld (de),a
    di
    ld (hl),$c3   ;the JP instruction
    inc hl
    inc de
    ld a,(hl)
    ld (hl),low(irqp)
    ld (de),a
    inc hl
    inc de
    ld a,(hl)
    ld (hl),high(irqp)
    ld (de),a
    inc hl
    inc de
    inc de
    ex de,hl
    ld (hl),e
    inc hl
    ld (hl),d
    ei
endif

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	LD HL,BUF+(LEN*2)-1
	LD DE,2000
	LD  a,BUF>>8-1
L1:
	LD  (HL),d
	DEC HL
	LD  (HL),e
	DEC HL
	CP h
	JP NZ,L1
	LD HL,0     ; c = 0;
	LD (_C),HL
	LD HL,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH HL
	EX DE,HL		; i = k;
	LD HL,0     ; d = 0;
	LD (Set_D+1),HL
	LD (Set_D2+1),HL
	EX DE,HL
	DEC HL
	ADD HL,HL
	LD  b,h
	LD  c,l
	db 21h		;ld hl,imm
L3:
	DEC BC      ;0bh
	DEC BC
	PUSH BC
	PUSH BC
	LD HL,BUF
	ADD HL,BC
	LD (Set_RI+1),HL
	LD  e,(HL)
	INC l
	LD  l,(HL)     ; r[i]
	
	LD  h,2+(MUL10kTAB>>8)
	LD  b,(HL)
	DEC h
	LD  c,(HL)
	DEC h
	LD  a,(HL)
	LD  l,e
	LD  e,(HL)
	INC h
	ADD A,(HL)
	LD  d,a
	INC h
	LD  a,(HL)
	ADC A,c
	LD  c,a
	JP NC,AfterMUL10k
	INC b
AfterMUL10k:
	
; d += (uint32_t)(r[i]) * 10000UL;
Set_D:	
	LD HL,0
	ADD HL,DE
	EX DE,HL
Set_D2:
	LD HL,0
	JP NC,$+4
	INC HL
	ADD HL,BC
	POP BC	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	LD (Dhi+1),HL
	EX DE,HL
	LD (Dlow+1),HL
	EX DE,HL
	LD  a,c
	CPL
	LD  e,a
	ADD A,l
	LD  a,b
	CPL
	LD  d,a
	ADC A,h
	JP NC,DIV32_
	EX DE,HL
	INC BC
	LD HL,(Set_RI+1)
	LD (Set_RI2+1),HL
	LD HL,0
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	EX DE,HL
	LD (SetHiDiv+1),HL
	LD HL,(Dlow+1)
	EX DE,HL
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
Set_RI2:
	LD (0),HL

; r[i] = res.rem; d = res.quot;
	POP BC
	XOR a
	OR c
	JP NZ,$+7
	OR b
	JP Z,L4	; if (--i == 0) break;
	PUSH BC
	ADD HL,DE
SetHiDiv:
	LD BC,0
	JP NC,$+4
	INC BC
	EX DE,HL
	LD HL,(Dlow+1)
	LD  a,l
 sub e
 LD  e,a
	LD  a,h
 sbc a,d
 LD  d,a
	LD HL,(Dhi+1)
	LD  a,l
 sbc a,c
 LD  l,a
	LD  a,h
 sbc a,b
	RRA
 LD (Set_D2+2),a
	LD  a,l
 RRA
 LD (Set_D2+1),a
	LD  a,d
 RRA
 LD (Set_D+2),a
	LD  a,e
 RRA
 LD (Set_D+1),a
	POP BC
	JP L3		; }

DIV32_:
	INC BC
	XOR a
	OR b
	JP NZ,FastDiv
	OR c
	LD a,(Dlow+2)
	JP M,SlowDiv
	LD  b,c
 LD  c,h
	LD  h,l
 LD  l,a
	LD  d,e
 LD  e,c

	ADD HL,HL
 ADD HL,DE
 JP NC,A1_
	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A2_
S2_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A3_
S3_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A4_
S4_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A5_
S5_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A6_
S6_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A7_
S7_:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A8_
S8_:	ADC A,a
 ADD HL,DE
 JP NC,A9_
S9_: INC a
	JP DIV_2

A1_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S2_
A2_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S3_
A3_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S4_
A4_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S5_
A5_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S6_
A6_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S7_
A7_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S8_
A8_: ADC A,a
A9_: ADD HL,BC

DIV_2:
	LD (SetD+1),a
	LD a,(Dlow+1)
	LD  l,a
	ADD HL,HL
 ADD HL,DE
 JP NC,A10_
	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A11_
S11_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A12_
S12_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A13_
S13_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A14_
S14_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A15_
S15_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A16_
S16_: ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A17_
S17_: ADC A,a

	ADD HL,DE
 JP NC,A18_
S18_: INC a
	LD  l,h
 LD  h,c
	LD  e,a
	JP SetD

A10_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S11_
A11_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S12_
A12_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S13_
A13_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S14_
A14_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S15_
A15_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S16_
A16_: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S17_
A17_: ADC A,a
A18_: ADD HL,BC
	LD  l,h
 LD  h,c
	LD  e,a
	JP SetD

SlowDiv:
	ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVA0
	ADC A,a
 JP C,DIVS0_1
 ADD HL,HL
 ADD HL,DE
 JP NC,DIVA1
DIVS1:	ADC A,a
 JP C,DIVS1_1
DIVS1_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA2
DIVS2:	ADC A,a
 JP C,DIVS2_1
DIVS2_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA3
DIVS3:	ADC A,a
 JP C,DIVS3_1
DIVS3_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA4
DIVS4:	ADC A,a
 JP C,DIVS4_1
DIVS4_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA5
DIVS5:	ADC A,a
 JP C,DIVS5_1
DIVS5_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA6
DIVS6:	ADC A,a
 JP C,DIVS6_1
DIVS6_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA7
DIVS7:	ADC A,a
 JP DIV7_2

DIVS0_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA1
 ADC A,a
 JP NC,DIVS1_0
DIVS1_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA2
 ADC A,a
 JP NC,DIVS2_0
DIVS2_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA3
 ADC A,a
 JP NC,DIVS3_0
DIVS3_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA4
 ADC A,a
 JP NC,DIVS4_0
DIVS4_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA5
 ADC A,a
 JP NC,DIVS5_0
DIVS5_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA6
 ADC A,a
 JP NC,DIVS6_0
DIVS6_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA7
 ADC A,a
 JP DIV7_2

DIVA0: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS1
DIVA1: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS2
DIVA2: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS3
DIVA3: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS4
DIVA4: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS5
DIVA5: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS6
DIVA6: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS7
DIVA7: ADC A,a
 ADD HL,BC
DIV7_2:
	LD (SetD+1),a
	LD a,(Dlow+1)
	ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVA8
	ADC A,a
 JP C,DIVS8_1
 ADD HL,HL
 ADD HL,DE
 JP NC,DIVA9
DIVS9:	ADC A,a
 JP C,DIVS9_1
DIVS9_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA10
DIVS10:	ADC A,a
 JP C,DIVS10_1
DIVS10_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA11
DIVS11:	ADC A,a
 JP C,DIVS11_1
DIVS11_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA12
DIVS12:	ADC A,a
 JP C,DIVS12_1
DIVS12_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA13
DIVS13:	ADC A,a
 JP C,DIVS13_1
DIVS13_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA14
DIVS14:	ADC A,a
 JP C,DIVS14_1
DIVS14_0: ADD HL,HL
 ADD HL,DE
 JP NC,DIVA15
DIVS15:	ADC A,a
 LD  e,a
 JP SetD

DIVS8_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA9
 ADC A,a
 JP NC,DIVS9_0
DIVS9_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA10
 ADC A,a
 JP NC,DIVS10_0
DIVS10_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA11
 ADC A,a
 JP NC,DIVS11_0
DIVS11_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA12
 ADC A,a
 JP NC,DIVS12_0
DIVS12_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA13
 ADC A,a
 JP NC,DIVS13_0
DIVS13_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA14
 ADC A,a
 JP NC,DIVS14_0
DIVS14_1: ADD HL,HL
 INC l
 ADD HL,DE
 JP NC,DIVA15
 ADC A,a
 LD  e,a
 JP SetD	

DIVA8: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS9
DIVA9: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS10
DIVA10: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS11
DIVA11: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS12
DIVA12: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS13
DIVA13: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS14
DIVA14: ADD HL,HL
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVS15
DIVA15: ADC A,a
 ADD HL,BC
 LD  e,a
 JP SetD

FastDiv:
	JP P,FastDiv_
	EX DE,HL
	LD HL,(Dlow+1)
	EX DE,HL
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	JP Set_RI

FastDiv_:
	LD a,(Dlow+2)
	ADD HL,HL
 ADD HL,DE
 JP NC,A1
	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A2
S2:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A3
S3:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A4
S4:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A5
S5:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A6
S6:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A7
S7:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A8
S8:	ADC A,a
	LD (SetD+1),a
 LD a,(Dlow+2)
 ADD A,l
 LD  l,a
 JP NC,$+4
 INC h
	ADD HL,DE
 JP NC,A9
S9:
	LD a,(SetD+1)
	INC a
	LD (SetD+1),a
	JP DIV_

A1: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S2
A2: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S3 
A3: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S4
A4: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S5
A5: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S6
A6: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S7
A7: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S8
A8: ADC A,a
	LD (SetD+1),a
	LD a,(Dlow+2)
 ADD A,l
 LD  l,a
 JP NC,A9
 INC h
 JP Z,S9
A9: ADD HL,BC

DIV_:
	LD a,(Dlow+1)
	LD (A17__+1),a
	ADD HL,HL
 ADD HL,DE
 JP NC,A10
	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A11
S11:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A12
S12:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A13
S13:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A14
S14:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A15
S15:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A16
S16:	ADC A,a
 ADD HL,HL
 ADD HL,DE
 JP NC,A17
S17:	ADC A,a

	LD (S17__+1),a
 LD a,(Dlow+1)
 ADD A,l
 LD  l,a
 JP NC,$+4
 INC h
	ADD HL,DE
S17__:
	LD  e,0
	JP NC,A18
S18: INC e
	JP SetD

A10: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S11
A11: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S12
A12: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S13
A13: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S14
A14: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S15
A15: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S16
A16: ADC A,a
 ADD HL,HL
 ADD HL,BC
 JP C,S17
A17: ADC A,a
A17__:
	LD DE,0
 ADD HL,DE
	LD  e,a
	JP C,S18
A18: ADD HL,BC
SetD:
	LD  d,0
Set_RI:
	LD (0),HL

; r[i] = res.rem; d = res.quot;
	POP BC
	XOR a
	OR c
	JP NZ,QR17
	OR b
	JP Z,L4_	; if (--i == 0) break;

;q*(i-1)=(d-r-q)/2
QR17:
	ADD HL,DE
	JP NC,Dlow
	EX DE,HL
	LD HL,(Dlow+1)
	LD  a,l
	sub e
 LD  e,a
	LD  a,h
 sbc a,d
 LD  d,a
	LD HL,(Dhi+1)
	DEC HL
	JP NC,$+4
	DEC HL
	XOR a
 OR h
 RRA
 LD (Set_D2+2),a
	LD  a,l
 RRA
 LD (Set_D2+1),a
	LD  a,d
 RRA
 LD (Set_D+2),a
	LD  a,e
 RRA
 LD (Set_D+1),a
	JP L3		; }
	
;QR16:
Dlow:
	LD DE,0
	LD  a,e
	sub l
 LD  e,a
	LD  a,d
 sbc a,h
 LD  d,a
Dhi:
	LD HL,0
	JP NC,$+4
	DEC HL
	XOR a
 OR h
 RRA
 LD (Set_D2+2),a
	LD  a,l
 RRA
 LD (Set_D2+1),a
	LD  a,d
 RRA
 LD (Set_D+2),a
	LD  a,e
 RRA
 LD (Set_D+1),a
	JP L3		; }


L4:
	LD HL,(SetHiDiv+1)
	LD BC,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	JP L4_2
L4_:
	LD  a,10000>>8-1
	CP d
	LD HL,0
	JP NC,L4_1
	LD BC,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	db 0FEh    ;cmp
L4_1:
	EX DE,HL
L4_2:
	PUSH HL
	LD HL,(_C)     ; printf("%.4d", c + (uint16_t)(res.quot));
	ADD HL,DE
	CALL PR0000
	POP HL
	LD (_C),HL     ; c = res.rem;
	POP HL
	LD BC,-14
	ADD HL,BC
	LD  a,h
	OR l
	JP NZ,L2

	di
	LD  a,32
	call PrintChar
if AMSTRADCPC
	        call firm_jump
    dw kl_time_please
     ld bc,(time)
     xor a
     sbc hl,bc
     ex de,hl
     ld bc,(time+2)
     sbc hl,bc
     ld bc,300
endif
if VECTOR06
    ld hl,($39)  ;stop timer
    ld de,irqe
    di
    ld a,(de)
    ld (hl),a
    inc de
    inc hl
    ld a,(de)
    ld (hl),a
    inc hl
    inc de
    ld a,(de)
    ld (hl),a
    ei
         ld hl,(time)
         ex de,hl
         ld hl,(time+2)
     ld bc,50
endif
     call div32x16r
	PUSH HL
	EX DE,HL
	call PR00000
		LD  e,'.'
        ld c,2
        call BDOS
    pop hl
if AMSTRADCPC
        ld bc,100   ;10000/300 = 100/3
        call mul16
        ld hl,0
        ld bc,3
        call div32x16r
        ld a,l
        cp 2
        jp c,$+3
        inc de
endif
if VECTOR06
	        ld bc,200    ;10000/50 = 200
        call mul16
endif
             ex de,hl
	call PR0000
	rst 0

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
DIVNR32:
		PUSH DE
		LD  a,e
		LD (DIVNR32_1+1),a
		XOR a
 sub c
 LD  e,a
		sbc a,b
 sub e
 LD  d,a
		POP AF
		call DIVNR24
		PUSH AF
DIVNR32_1:
		LD  a,0
		call DIVNR24
		POP DE
		LD  e,a
		ret

DIVNR24:
		ADD HL,HL
 JP C,DIVNR241p
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_1
 JP DIVNR24p_1
DIVNR241p:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_1
DIVNR24p_1:
		ADD HL,HL
 JP C,DIVNR241p_1
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_2
 JP DIVNR24p_2
DIVNR241p_1:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_2
DIVNR24p_2:
		ADD HL,HL
 JP C,DIVNR241p_2
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_3
 JP DIVNR24p_3
DIVNR241p_2:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_3
DIVNR24p_3:
		ADD HL,HL
 JP C,DIVNR241p_3
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_4
 JP DIVNR24p_4
DIVNR241p_3:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_4
DIVNR24p_4:
		ADD HL,HL
 JP C,DIVNR241p_4
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_5
 JP DIVNR24p_5
DIVNR241p_4:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_5
DIVNR24p_5:
		ADD HL,HL
 JP C,DIVNR241p_5
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_6
 JP DIVNR24p_6
DIVNR241p_5:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_6
DIVNR24p_6:
		ADD HL,HL
 JP C,DIVNR241p_6
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24m_7
 JP DIVNR24p_7
DIVNR241p_6:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24m_7
DIVNR24p_7:
		ADD HL,HL
 JP C,DIVNR241p_7
 SCF
 ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP NC,DIVNR24mExit
DIVNR24pExit: ADC A,a
 ret
DIVNR241p_7:
		ADC A,a
 JP NC,$+4
 INC l
 ADD HL,DE
 JP C,DIVNR24mExit
DIVNR24pExit_: SCF
 ADC A,a
 ret

DIVNR24m:
		ADD HL,HL
 JP NC,DIVNR241m
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_1
 JP DIVNR24m_1
DIVNR241m:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_1
DIVNR24m_1:
		ADD HL,HL
 JP NC,DIVNR241m_1
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_2
 JP DIVNR24m_2
DIVNR241m_1:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_2
DIVNR24m_2:
		ADD HL,HL
 JP NC,DIVNR241m_2
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_3
 JP DIVNR24m_3
DIVNR241m_2:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_3
DIVNR24m_3:
		ADD HL,HL
 JP NC,DIVNR241m_3
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_4
 JP DIVNR24m_4
DIVNR241m_3:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_4
DIVNR24m_4:
		ADD HL,HL
 JP NC,DIVNR241m_4
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_5
 JP DIVNR24m_5
DIVNR241m_4:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_5
DIVNR24m_5:
		ADD HL,HL
 JP NC,DIVNR241m_5
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_6
 JP DIVNR24m_6
DIVNR241m_5:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_6
DIVNR24m_6:
		ADD HL,HL
 JP NC,DIVNR241m_6
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24p_7
 JP DIVNR24m_7
DIVNR241m_6:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24p_7
DIVNR24m_7:
		ADD HL,HL
 JP NC,DIVNR241m_7
 ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP C,DIVNR24pExit
 ADD A,a
 ADD HL,BC
 ret
DIVNR241m_7:
		ADD A,a
 JP NC,$+4
 INC l
 ADD HL,BC
 JP NC,DIVNR24pExit_
DIVNR24mExit: ADD A,a
 ADD HL,BC
 ret
		
PR00000:
	LD DE,-10000
	LD BC,10000
	CALL PR0
PR0000:	LD DE,-1000
	LD BC,1000
	CALL PR0
	LD DE,-100
	LD BC,100
	CALL PR0
PR00:	
	LD DE,-10
	LD BC,10
	CALL PR0
	LD  A,L
PRD:
PRC:
    add a,48
	JP PrintChar
PR0:	LD  A,0FFh
	INC A
	ADD HL,DE
	JP C,$-2
	ADD HL,BC
	    add a,48
PrintChar:
    push bc
    push de
    push hl
    ld e,a
    ld c,2
    call BDOS
    pop hl
    pop de
    pop bc
    ret

if AMSTRADCPC
firm_jump
  jp 0
endif

_C			dw 0
time dw 0,0

if VECTOR06
irqp
    push hl
    push af
    ld hl,time
    inc (hl)
    jp nz,irqf
    inc hl
    inc (hl)
    jp nz,irqf
    inc hl
    inc (hl)
irqf
    pop af
    pop hl
irqe
    nop
    nop
    nop
    jp 0
endif

include "8080-mul16.s"

div32x16r proc  ;00de = hlde/bc, hl = hlde%bc
     local t,t0,t1,t2,t3,l1,l2
     call t
     ld bc,0
     ret
t
     DEC   BC
     LD    A, B
     CPL
     LD    B, A
     LD    A, C
     CPL
     LD    C, A
     call t0
t0   call t1
t1   call t2
t2   call t3
t3   ex de,hl
     add hl,hl
     ex de,hl
     jp c,l1

     ADD   HL, HL
l2   jp c,t4

     LD    A,L
     ADD   A,C
     LD    A,H
     ADC   A,B
     Jp    NC,t5
t4
     ADD   HL,BC
     inc e
t5   RET
l1   add hl,hl
     inc l
     jp l2
     endp

	END
