program RC;

{$A+,B-,D-,E-,F-,G-,I+,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 4096,0,0}

uses Dos, SysProc;

const
  Line   = '------------------------------------------------------------------------------';
  Bold   = '==============================================================================';
  Banner = 'RC version 1.3    Copyright (c) 1994,95 Avatars     Written by Lord Basarabian'#10#13 +
	   '=== <<< Now you can easy translate any text files >>> =========== 25.02.95 ===';
  Usage  = '		Usage: RC [/option] INFILE.EXT [OUTFILE.EXT]';
  Option = '				<option>'#10#13 +
	   '	t: Specify file with table	msx: MSX oriented mode';
  Credit = ' Use RC free, but don''t forget: this software distributed on AS IS principle,'#10#13 +
	   '	 and no any kind of warranty for it provided by author';

const
  Markers: array [0..3] of Char = ('|', '/', '-', '\');
  TempName = '$#%RC%#$.TMP';

  TabName: PathStr = 'RC.TAB';
  InName: PathStr = '';
  OutName: PathStr = '';

  MsxMode: Boolean = False;

  hmInformation = 0;
  hmParam = 1;
  hmTable = 2;
  hmSource = 3;
  hmDiskWrite = 4;

var
  Table: array [Char] of Char;

procedure HaltMsg(const Error: Byte);
begin
  case Error of
    hmInformation:
      begin
	WriteLn(Usage);
	WriteLn(Line);
	WriteLn(Option);
	WriteLn(Bold);
	WriteLn(Credit);
      end;
    hmParam: WriteLn('Invalid parameters');
    hmTable: WriteLn('Table file not found');
    hmSource: WriteLn('Source file not found');
    hmDiskWrite: WriteLn('Disk write protected');
  end;
  Halt($FF);
end;

procedure AnalizeParams;
var
  I, FileCnt: Byte;
  S: String;
begin
  FileCnt := 0;
  for I := 1 to ParamCount do
  begin
    S := ParamStr(I);
    if Pos('/', S) = 0 then
    begin
      Inc(FileCnt);
      if FileCnt = 1 then InName := S else OutName := S;
    end else
    begin
      if UpStr(Copy(S, 1, 3)) = '/T:' then TabName := Copy(S, 4, 255);
      if UpStr(Copy(S, 1, 4)) = '/MSX' then MsxMode := True;
    end;
  end;
  case FileCnt of
    0: HaltMsg(hmInformation);
    1: OutName := InName;
  end;
end;

procedure ReadTable;
var
  F: Text;
  S: String;
  C1, C2: Char;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  FName: String;
begin
  FSplit(ParamStr(0), Dir, Name, Ext);
  if Dir[Length(Dir)] = '\' then Dec(Dir[0]);
  FName := FSearch(TabName, Dir);
  if FName = '' then FName := TabName;
  Assign(F, FName);
  {$I-}
  Reset(F);
  if IoResult <> 0 then HaltMsg(hmTable);
  while not Eof(F) do
  begin
    ReadLn(F, S); C1 := S[1]; C2 := S[2];
    if not (C1 in [#13,#32,#9]) then Table[C1] := C2;
  end;
  Close(F);
  {$I+}
end;

procedure Recode;
var
  InFile, OutFile: Text;
  S: String;
  I, Phase: Byte;
begin
  Phase := 0; Write('Processing  ');
  {$I-}
  Assign(InFile, InName); Reset(InFile);
  if IoResult <> 0 then HaltMsg(hmSource);
  Assign(OutFile, TempName); Rewrite(OutFile);
  if IoResult <> 0 then HaltMsg(hmDiskWrite);
  while not Eof(InFile) do
  begin
    Write(#8 + Markers[(Phase shr 2) mod 4]); Inc(Phase);
    ReadLn(InFile, S);
    for I := 1 to Length(S) do S[I] := Table[S[I]];
    if MsxMode then
    begin
      for I := 1 to Length(S) do if S[I] = #27 then Delete(S, I, 2);
      for I := 1 to Length(S) do if S[I] = #01 then
      begin
	Delete(S,I,1);
	case S[I] of
	  'W': S[I]:='';
	  'X': S[I]:='';
	  'Y': S[I]:='';
	  'V': S[I]:='';
	  'T': S[I]:='';
	  'S': S[I]:='';
	  'U': S[I]:='';
	  'Z': S[I]:='';
	  'Q': S[I]:='';
	  '[': S[I]:='';
	  'R': S[I]:='';
	end;
      end;
    end;
    WriteLn(OutFile, S);
  end;
  Close(InFile);
  Close(OutFile);
  DeleteFile(OutName);
  Rename(OutFile, OutName);
  {$I+}
  WriteLn(#8#8'. All done');
end;

var
  C: Char;

begin
  for C := #0 to #255 do Table[C] := C;
  WriteLn(Banner);
  AnalizeParams;
  ReadTable;
  Recode;
end.