unit SysProc;

{$O+}

interface

uses Dos;

var
  ValCode: Integer;
  VgaPresent: Boolean;
  StartupMode: Byte;

function UpStr(S: String): String;
function Exist(S: String): Boolean;
procedure DeleteFile(S: String);
function FUnExpand(FileName: PathStr): PathStr;
function CutFileName(S: String): String;
procedure PrintStr(S: String);
procedure HaltMessage(S: String);

implementation

function UpStr(S: String): String;
var
  I: Byte;
begin
  for I := 1 to Length(S) do
    if S[I] in ['a'..'z'] then Byte(S[I]) := Byte(S[I]) - 32;
  UpStr := S;
end;

function Exist(S: String): Boolean;
var
  F: File;
begin
  Exist := False;
  Assign(F, S);
  {$I-}
  Reset(F, 1);
  if IoResult = 0 then
  begin
    Close(F);
    Exist := True;
  end;
  {$I+}
end;

procedure DeleteFile(S: String);
var
  F: File;
begin
  Assign(F, S);
  {$I-}
  Reset(F, 1);
  if IoResult = 0 then
  begin
    Close(F);
    Erase(F);
  end;
  {$I+}
end;

function FUnExpand(FileName: PathStr): PathStr;
var
  D, CurDir: DirStr;
  N: NameStr;
  E: ExtStr;
begin
  FileName := FExpand(FileName);
  FSplit(FileName, D, N, E);
  GetDir(0, CurDir);
  if CurDir[Length(CurDir)] <> '\' then CurDir := CurDir + '\';
  if CurDir = D then FUnExpand := N + E;
end;

function CutFileName(S: String): String;
begin
  if Pos('.', S) <> 0 then CutFileName := Copy(S, 1, Pos('.', S) - 1)
  else CutFileName := S;
end;

function Check4Vga: Boolean; assembler;
asm
	XOR	BX,BX
	MOV	AX,1A00H
	INT	10H
	XOR	AX,AX		{ Default is not present }
	CMP	BL,7
	JB	@@1
	CMP	BL,0CH
	JA	@@1
	MOV	AX,1		{ VGA present }
@@1:
end;

function GetMode: Byte; assembler;
asm
	MOV	AH,0FH
	INT	10H
end;

procedure PrintStr(S: String); assembler;
asm
	PUSH	DS
	LDS	SI,S
	CLD
	LODSB
	XOR	AH,AH
	XCHG	AX,CX
	MOV	AH,40H
	MOV	BX,1
	MOV	DX,SI
	INT	21H
	POP	DS
end;

procedure HaltMessage(S: String);
begin
  if GetMode <> StartupMode then
  asm
	XOR	AH,AH
	MOV	AL,StartupMode
	INT	10H
  end;
  PrintStr(S);
  Halt($FF);
end;

begin
  StartupMode := GetMode;
  VgaPresent := Check4Vga;
end.