#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

;#define LEN (8192/4*14)
;#define LEN (3000/4*14)
;#define LEN (1000/4*14)
;#define LEN (100/4*14)

MUL10kTAB	.equ 0A00h
BUF	.equ MUL10kTAB+300h+100h-2

colorsE0	.equ 01010101b
colorsC0	.equ 00110011b
colorsA0	.equ 00001111b
colors80	.equ 11111111b

IntCount	.equ 40h
IntCountHi	.equ IntCount+1
Ccount		.equ IntCountHi+1
cursor		.equ Ccount+1
_C			.equ cursor+2


	ORG 0100h

Init:
	di
	xra a
	out	10h
	mvi	a,0C3h
	sta	0
	sta 38h
	lxi	h,Restart
	shld	1
	lxi h,Int
	shld 39h

Restart:
	di
	lxi	sp,100h
	call cls
	ei
	hlt
	mvi l, colorsE0
	call colorset
	lxi h,078FFh-7
	shld cursor
	mvi a,120
	sta SetLeft+1
	mvi a,0E0h
	sta SetPlane+1
	lxi d,0
	lxi b,10000
	xra a
	mov l,a
GenMulTab:
	mvi h,MUL10kTAB>>8
	mov m,e
	inr h
	mov m,d
	inr h
	mov m,a
	xchg
	dad b
	xchg
	aci 0
	inr l
	jnz GenMulTab

	ei
	hlt
	xra a
	sta IntCountLo+1
	lxi h,0
	shld IntCount

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH H
	dcx h
	dad h
	mov b,h
	mov c,l
				; i = k;
	LXI H,0     ; d = 0;
	mov d,h
	mov e,l
	jmp L3_
L3__:
	xra a\ ora h
L3___:
	rar\ mov h,a
	mov a,l\ rar\ mov l,a
	mov a,d\ rar\ mov d,a
	mov a,e\ rar\ mov e,a
L3:
;	dcx b
;	dcx b
L3_:
	push b
	push b
	push h
	push d
	lxi h,BUF
	dad b
	SHLD Set_RI+1
	mov e,m
	inr l
	mov l,m     ; r[i]
	
	mvi h,2+(MUL10kTAB>>8)
	mov b,m
	dcr h
	mov c,m
	dcr h
	mov a,m
	;BCA
	mov l,e
	;BCDE=BCA0+0(HL)(HL)E
	mov e,m
	inr h
	add m
	mov d,a
	inr h
	mov a,m
	adc c
	mov c,a
	jnc AfterMUL10k
	inr b
AfterMUL10k:

; d += (uint32_t)(r[i]) * 10000UL;
	pop h
	dad d
	shld Dlow+1
	pop h
	JNC $+4
	inx h
	dad b
	shld Dhi+1
	pop b	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	mov a,c
	cma
	mov e,a
	add l
	mov a,b
	cma
	mov d,a
	adc h
	inx b
	jnc DIV32_
	xchg
	lhld Set_RI+1
	shld Set_RI2+1
	lxi h,0
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	XCHG
	shld SetHiDiv+1
	lhld Dlow+1
	XCHG
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
Set_RI2:
	shld 0

; r[i] = res.rem; d = res.quot;
	POP B
	dcx b
	dcx b
	mvi a,0FFh
	cmp b
	JZ L4	; if (--i == 0) break;
	
	dad d
SetHiDiv:
	lxi d,0
	jnc $+4
	inx d
	lda Dlow+1\ sub l\ mov l,a
	lda Dlow+2\ sbb h\ mov h,a
	lda Dhi+1\ sbb e\ mov e,a
	lda Dhi+2\ sbb d
	xchg
	jmp L3___		; }

DIV32_:
	xra a
	ora b
	jnz FastDiv
	ora c
	lda Dlow+2
	jm SlowDiv
	mov b,c\ mov c,h
	mov h,l\ mov l,a
	mov d,e\ mov e,c

	dad h\ dad d\ jnc A1_
	adc a\ dad h\ dad d\ jnc A2_
S2_:	adc a\ dad h\ dad d\ jnc A3_
S3_:	adc a\ dad h\ dad d\ jnc A4_
S4_:	adc a\ dad h\ dad d\ jnc A5_
S5_:	adc a\ dad h\ dad d\ jnc A6_
S6_:	adc a\ dad h\ dad d\ jnc A7_
S7_:	adc a\ dad h\ dad d\ jnc A8_
S8_:	adc a\ dad d\ jnc A9_
S9_: inr a
	jmp DIV_2

A1_: adc a\ dad h\ dad b\ jc S2_
A2_: adc a\ dad h\ dad b\ jc S3_
A3_: adc a\ dad h\ dad b\ jc S4_
A4_: adc a\ dad h\ dad b\ jc S5_
A5_: adc a\ dad h\ dad b\ jc S6_
A6_: adc a\ dad h\ dad b\ jc S7_
A7_: adc a\ dad h\ dad b\ jc S8_
A8_: adc a
A9_: dad b

DIV_2:
	sta SetD+1
	lda Dlow+1
	mov l,a
	dad h\ dad d\ jnc A10_
	adc a\ dad h\ dad d\ jnc A11_
S11_: adc a\ dad h\ dad d\ jnc A12_
S12_: adc a\ dad h\ dad d\ jnc A13_
S13_: adc a\ dad h\ dad d\ jnc A14_
S14_: adc a\ dad h\ dad d\ jnc A15_
S15_: adc a\ dad h\ dad d\ jnc A16_
S16_: adc a\ dad h\ dad d\ jnc A17_
S17_: adc a\
	dad d\ jnc A18_
S18_: inr a
	mov l,h\ mov h,c
	mov e,a
	jmp SetD

A10_: adc a\ dad h\ dad b\ jc S11_
A11_: adc a\ dad h\ dad b\ jc S12_
A12_: adc a\ dad h\ dad b\ jc S13_
A13_: adc a\ dad h\ dad b\ jc S14_
A14_: adc a\ dad h\ dad b\ jc S15_
A15_: adc a\ dad h\ dad b\ jc S16_
A16_: adc a\ dad h\ dad b\ jc S17_
A17_: adc a
A18_: dad b
	mov l,h\ mov h,c
	mov e,a
	jmp SetD

SlowDiv:
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA0
	adc a\ jc DIVS0_1\ dad h\ dad d\ jnc DIVA1
DIVS1:	adc a\ jc DIVS1_1
DIVS1_0: dad h\ dad d\ jnc DIVA2
DIVS2:	adc a\ jc DIVS2_1
DIVS2_0: dad h\ dad d\ jnc DIVA3
DIVS3:	adc a\ jc DIVS3_1
DIVS3_0: dad h\ dad d\ jnc DIVA4
DIVS4:	adc a\ jc DIVS4_1
DIVS4_0: dad h\ dad d\ jnc DIVA5
DIVS5:	adc a\ jc DIVS5_1
DIVS5_0: dad h\ dad d\ jnc DIVA6
DIVS6:	adc a\ jc DIVS6_1
DIVS6_0: dad h\ dad d\ jnc DIVA7
DIVS7:	adc a\ jmp DIV7_2

DIVS0_1: dad h\ inr l\ dad d\ jnc DIVA1\ adc a\ jnc DIVS1_0
DIVS1_1: dad h\ inr l\ dad d\ jnc DIVA2\ adc a\ jnc DIVS2_0
DIVS2_1: dad h\ inr l\ dad d\ jnc DIVA3\ adc a\ jnc DIVS3_0
DIVS3_1: dad h\ inr l\ dad d\ jnc DIVA4\ adc a\ jnc DIVS4_0
DIVS4_1: dad h\ inr l\ dad d\ jnc DIVA5\ adc a\ jnc DIVS5_0
DIVS5_1: dad h\ inr l\ dad d\ jnc DIVA6\ adc a\ jnc DIVS6_0
DIVS6_1: dad h\ inr l\ dad d\ jnc DIVA7\ adc a\ jmp DIV7_2

DIVA0: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS1
DIVA1: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS2
DIVA2: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS3
DIVA3: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS4
DIVA4: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS5
DIVA5: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS6
DIVA6: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS7
DIVA7: adc a\ dad b
DIV7_2:
	sta SetD+1
	lda Dlow+1
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA8
	adc a\ jc DIVS8_1\ dad h\ dad d\ jnc DIVA9
DIVS9:	adc a\ jc DIVS9_1
DIVS9_0: dad h\ dad d\ jnc DIVA10
DIVS10:	adc a\ jc DIVS10_1
DIVS10_0: dad h\ dad d\ jnc DIVA11
DIVS11:	adc a\ jc DIVS11_1
DIVS11_0: dad h\ dad d\ jnc DIVA12
DIVS12:	adc a\ jc DIVS12_1
DIVS12_0: dad h\ dad d\ jnc DIVA13
DIVS13:	adc a\ jc DIVS13_1
DIVS13_0: dad h\ dad d\ jnc DIVA14
DIVS14:	adc a\ jc DIVS14_1
DIVS14_0: dad h\ dad d\ jnc DIVA15
DIVS15:	adc a\ mov e,a\ jmp SetD

DIVS8_1: dad h\ inr l\ dad d\ jnc DIVA9\ adc a\ jnc DIVS9_0
DIVS9_1: dad h\ inr l\ dad d\ jnc DIVA10\ adc a\ jnc DIVS10_0
DIVS10_1: dad h\ inr l\ dad d\ jnc DIVA11\ adc a\ jnc DIVS11_0
DIVS11_1: dad h\ inr l\ dad d\ jnc DIVA12\ adc a\ jnc DIVS12_0
DIVS12_1: dad h\ inr l\ dad d\ jnc DIVA13\ adc a\ jnc DIVS13_0
DIVS13_1: dad h\ inr l\ dad d\ jnc DIVA14\ adc a\ jnc DIVS14_0
DIVS14_1: dad h\ inr l\ dad d\ jnc DIVA15\ adc a\ mov e,a\ jmp SetD	

DIVA8: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS9
DIVA9: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS10
DIVA10: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS11
DIVA11: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS12
DIVA12: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS13
DIVA13: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS14
DIVA14: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS15
DIVA15: adc a\ dad b\ mov e,a\ jmp SetD

FastDiv:
	jp FastDiv_
	xchg
	lhld Dlow+1
	xchg
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
	jmp Set_RI

FastDiv_:
	lda Dlow+2
	dad h\ dad d\ jnc A1
	adc a\ dad h\ dad d\ jnc A2
S2:	adc a\ dad h\ dad d\ jnc A3
S3:	adc a\ dad h\ dad d\ jnc A4
S4:	adc a\ dad h\ dad d\ jnc A5
S5:	adc a\ dad h\ dad d\ jnc A6
S6:	adc a\ dad h\ dad d\ jnc A7
S7:	adc a\ dad h\ dad d\ jnc A8
S8:	adc a
	sta SetD+1\ lda Dlow+2\ add l\ mov l,a\ jnc $+4\ inr h
	dad d\ jnc A9
S9:
	lda SetD+1
	inr a
	sta SetD+1
	jmp DIV_

A1: adc a\ dad h\ dad b\ jc S2
A2: adc a\ dad h\ dad b\ jc S3 
A3: adc a\ dad h\ dad b\ jc S4
A4: adc a\ dad h\ dad b\ jc S5
A5: adc a\ dad h\ dad b\ jc S6
A6: adc a\ dad h\ dad b\ jc S7
A7: adc a\ dad h\ dad b\ jc S8
A8: adc a
	sta SetD+1
	lda Dlow+2\ add l\ mov l,a\ jnc A9\ inr h\ jz S9
A9: dad b

DIV_:
	lda Dlow+1
	dad h\ dad d\ jnc A10
	adc a\ dad h\ dad d\ jnc A11
S11:	adc a\ dad h\ dad d\ jnc A12
S12:	adc a\ dad h\ dad d\ jnc A13
S13:	adc a\ dad h\ dad d\ jnc A14
S14:	adc a\ dad h\ dad d\ jnc A15
S15:	adc a\ dad h\ dad d\ jnc A16
S16:	adc a\ dad h\ dad d\ jnc A17
S17:	adc a\
	sta S17__+1\ lda Dlow+1\ add l\ mov l,a\ jnc $+4\ inr h
	dad d
S17__:
	mvi e,0
	jnc A18
S18: inr e
	jmp SetD

A10: adc a\ dad h\ dad b\ jc S11
A11: adc a\ dad h\ dad b\ jc S12
A12: adc a\ dad h\ dad b\ jc S13
A13: adc a\ dad h\ dad b\ jc S14
A14: adc a\ dad h\ dad b\ jc S15
A15: adc a\ dad h\ dad b\ jc S16
A16: adc a\ dad h\ dad b\ jc S17
A17: adc a
	xchg\ lhld Dlow+1\ mvi h,0
	dad d
	mov e,a
	jc S18
A18: dad b
SetD:
	mvi d,0
Set_RI:
	shld 0

; r[i] = res.rem; d = res.quot;
	POP B
	dcx b
	dcr c
	jnz QR17
	xra a
	ora b
	JZ L4_	; if (--i == 0) break;
;q*(i-1)=(d-r-q)/2
QR17:
	dad d
Dlow:
	lxi d,0
	mov a,e
	jnc QR16
	sub l\ mov e,a
	mov a,d\ sbb h\ mov d,a
	lhld Dhi+1
	dcx h
	jnc L3__
	dcx h
	jmp L3__		; }

QR16:
	sub l\ mov e,a
	mov a,d\ sbb h\ mov d,a
Dhi:
	lxi h,0
	jnc L3__
	dcx h
	jmp L3__		; }


L4:
	lhld SetHiDiv+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	jmp L4_2
L4_:
	mvi a,(10000>>8)-1
	cmp d
	lxi h,0
	jnc L4_1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	.db 0FEh
L4_1:
	xchg
L4_2:
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	mov a,h
	ora l
	jnz L2

	di
	mvi a,11
	call PrintChar
	mvi a,12
	call PrintChar
	mvi a,13
	call PrintChar

	lhld IntCountLo+1
	lda IntCount
	mov h,a
	xchg
	lhld IntCountHi
	mvi h,0

	lxi b,50
	call DIV320
	push h
	xchg
	call PR00000
	mvi a,10
	call PrintChar
	pop h
	dad h
	call PR00
	
	lda SetPlane+1
	mvi l,colorsE0
	cpi 0E0h
	jz SetColors1
	mvi l,colorsC0
	cpi 0C0h
	jz SetColors1
	mvi l,colorsA0
	cpi 0A0h
	jz SetColors1
	mvi l,colors80
SetColors1:
	shld SetColors+1

GetKeyLoop:
		ei
		hlt
		mvi	a, 8Ah
		out	0
		mvi	a, 11111011b
		out	3
		in	2
		rrc
		rrc
		jc Chk2
		mvi l,colorsE0
		shld SetColors+1
Chk2:
		rrc
		jc Chk3
		mvi l,colorsC0
		shld SetColors+1
Chk3:
		rrc
		jc Chk4
		mvi l,colorsA0
		shld SetColors+1
Chk4:
		rrc
		jc SetColors
		mvi l,colors80
		shld SetColors+1
SetColors:
		lxi h,colors80
		call colorset
		jmp GetKeyLoop

	JMP $


DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
DIVNR32:
		push d
		mov a,e
		sta DIVNR32_1+1
		xra a\ sub c\ mov e,a
		sbb b\ sub e\ mov d,a
		pop psw
		call DIVNR24
		push psw
DIVNR32_1:
		mvi a,0
		call DIVNR24
		pop d
		mov e,a
		ret

DIVNR24:
		dad h\ jc DIVNR241p\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_1\ jmp DIVNR24p_1
DIVNR241p:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_1
DIVNR24p_1:
		dad h\ jc DIVNR241p_1\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_2\ jmp DIVNR24p_2
DIVNR241p_1:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_2
DIVNR24p_2:
		dad h\ jc DIVNR241p_2\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_3\ jmp DIVNR24p_3
DIVNR241p_2:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_3
DIVNR24p_3:
		dad h\ jc DIVNR241p_3\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_4\ jmp DIVNR24p_4
DIVNR241p_3:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_4
DIVNR24p_4:
		dad h\ jc DIVNR241p_4\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_5\ jmp DIVNR24p_5
DIVNR241p_4:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_5
DIVNR24p_5:
		dad h\ jc DIVNR241p_5\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_6\ jmp DIVNR24p_6
DIVNR241p_5:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_6
DIVNR24p_6:
		dad h\ jc DIVNR241p_6\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24m_7\ jmp DIVNR24p_7
DIVNR241p_6:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24m_7
DIVNR24p_7:
		dad h\ jc DIVNR241p_7\ stc\ adc a\ jnc $+4\ inr l\ dad d\ jnc DIVNR24mExit
DIVNR24pExit: adc a\ ret
DIVNR241p_7:
		adc a\ jnc $+4\ inr l\ dad d\ jc DIVNR24mExit
DIVNR24pExit_: stc\ adc a\ ret

DIVNR24m:
		dad h\ jnc DIVNR241m\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_1\ jmp DIVNR24m_1
DIVNR241m:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_1
DIVNR24m_1:
		dad h\ jnc DIVNR241m_1\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_2\ jmp DIVNR24m_2
DIVNR241m_1:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_2
DIVNR24m_2:
		dad h\ jnc DIVNR241m_2\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_3\ jmp DIVNR24m_3
DIVNR241m_2:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_3
DIVNR24m_3:
		dad h\ jnc DIVNR241m_3\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_4\ jmp DIVNR24m_4
DIVNR241m_3:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_4
DIVNR24m_4:
		dad h\ jnc DIVNR241m_4\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_5\ jmp DIVNR24m_5
DIVNR241m_4:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_5
DIVNR24m_5:
		dad h\ jnc DIVNR241m_5\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_6\ jmp DIVNR24m_6
DIVNR241m_5:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_6
DIVNR24m_6:
		dad h\ jnc DIVNR241m_6\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24p_7\ jmp DIVNR24m_7
DIVNR241m_6:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24p_7
DIVNR24m_7:
		dad h\ jnc DIVNR241m_7\ add a\ jnc $+4\ inr l\ dad b\ jc DIVNR24pExit\ add a\ dad b\ ret
DIVNR241m_7:
		add a\ jnc $+4\ inr l\ dad b\ jnc DIVNR24pExit_
DIVNR24mExit: add a\ dad b\ ret
		

PR00000:
	LXI D,-10000
	lxi b,10000
	CALL PR0
PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:
PRC:
	JMP PrintChar
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
PrintChar:
		push psw
		push h
        lxi h, cursor
        mov e,m
        inx h
        mov d,m
putcharv:
		add a\ add a
        lxi h, fontsrc
		add l\ mov l,a
		adc h\ sub l\ mov h,a

		mov a,m
		add d\ jnc NotNextLine
SetLeft:
		mvi d,120
		mvi a,-6\ add e\ mov e,a
		jc NotNextLine
		xra a
		sta SetLeft+1
		push h
		push b
		lxi h,0EEFFh
		mvi e,colorsC0
		lda SetPlane+1
		cpi 0E0h
		mvi a,0C0h
		jz SetColors2
		lxi h,0BFFFh
		mvi e,colorsA0
		lda SetPlane+1
		cpi 0C0h
		mvi a,0A0h
		jz SetColors2
		lxi h,09FFFh
		mvi e,colors80
		mvi a,080h
SetColors2:
		sta SetPlane+1
		dcr a
		push d
		call cls_
		pop h
		hlt
		call colorset
		ei
		pop b
		pop h
		lxi d,000FFh-7
NotNextLine:
		push d
		mov a,m
		add d\ mov d,a
		xchg\ shld cursor\ xchg
		pop d
		mov a,m\ inx h
		push psw
		
		mvi a,111b
		ana d
		mov b,a
		xra d
		rrc\ rrc\ rrc
SetPlane:
		adi 0E0h
		mov d,a

		mvi a,MaskTable&255
		add b
		mov c,a
		aci MaskTable>>8
		sub c
		mov b,a
		ldax b
		pop b
		dcr b
		mov c,a

PutSym:		
		push h
		mov h,m
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d
		mvi a,-4\ add e\ mov e,a
		pop h
		inx h
		mov a,c\ rrc\ mov c,a\ jnc $+4\ inr d
		dcr b
		jnz PutSym
		pop h
		pop psw
        ret

MaskTable:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b		

Int:
		push psw
IntCountLo:
		mvi a,0
		inr a
		sta IntCountLo+1
		jnz IntExit2
		push h
		lxi h,IntCount
		inr m
		jnz IntExit
		inx h
		inr m
IntExit:
		pop h
IntExit2:
		pop psw
		ei
		ret

cls:
	lxi	h,0FFFFh
	mvi a,07Fh
cls_:
	mvi e,0
ClrScr:
	mov	m,e
	dcx	h
	cmp	h
	jnz	ClrScr
	ret


colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:
	mov	a, c
	out	2
	mov a,l
	rrc
	mov l,a
	sbb a
	out	0Ch
	xthl
	xthl
	mov a,a
	mov a,a
	mov a,a
	out	0Ch
	mvi a,8
	cmp c
	jnz colorset2
	mvi a,255
	sub l
	jnz colorset2
	mov l,a
colorset2:
	dcr c
	jp	colorset1
	mvi a,255
	out	3
	ret

fontsrc:
	.db 4
	.db 11111000b
	.db 10001000b
	.db 11111000b

	.db 2
	.db 11111000b
	.db 0
	.db 0

	.db 3
	.db 11101000b
	.db 10111000b
	.db 0

	.db 3
	.db 10101000b
	.db 11111000b
	.db 0

	.db 4
	.db 00111000b
	.db 00100000b
	.db 11111000b

	.db 3
	.db 10111000b
	.db 11101000b
	.db 0

	.db 4
	.db 11111000b
	.db 10101000b
	.db 11101000b

	.db 3
	.db 00001000b
	.db 11111000b
	.db 0

	.db 4
	.db 11111000b
	.db 10101000b
	.db 11111000b

	.db 4
	.db 10111000b
	.db 10101000b
	.db 11111000b

	.db 2
	.db 10000000b
	.db 0
	.db 0
	
;11
	.db 4
	.db 0
	.db 0
	.db 0

;12
	.db 4
	.db 00001000b
	.db 11111000b
	.db 00001000b

;13
	.db 4
	.db 01010000b
	.db 01010000b
	.db 01010000b


		
	END
