#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

;#define LEN (8928/4*14)
;#define LEN (3000/4*14)
;#define LEN (1000/4*14)
;#define LEN (100/4*14)

MUL10kTAB	.equ 0700h
BUF	.equ MUL10kTAB+300h+100h-2

IntCount	.equ 40h
IntCountHi	.equ IntCount+1
cursor		.equ IntCountHi+1
_C			.equ cursor+2


	ORG 0100h

Init:
	di
	mvi	a,0C3h
	sta	0
	sta 38h
	lxi	h,Restart
	shld	1
	lxi h,Int
	shld 39h

Restart:
	di
	lxi	sp,100h
	lxi	h,0A000h
	mvi a,33h
	out 0Dh
	out 0Eh
	xra	a
ClrScr:
	mov	m,a
	inx	h
	cmp	h
	jnz	ClrScr
	out 0Eh
	ei
	hlt
	lxi	h, colorsA0+15
	call colorset

	lxi h,00FFh-7
	shld cursor
	mvi a,0A0h
	sta SetPlane+1

	lxi d,0
	lxi b,10000
	xra a
	mov l,a
GenMulTab:
	mvi h,MUL10kTAB>>8
	mov m,e
	inr h
	mov m,d
	inr h
	mov m,a
	xchg
	dad b
	xchg
	aci 0
	inr l
	jnz GenMulTab

	ei
	hlt
	xra a
	sta IntCountLo+1
	lxi h,0
	shld IntCount

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH H
	dcx h
	dad h
	mov b,h
	mov c,l
				; i = k;
	LXI H,0     ; d = 0;
	mov d,h
	mov e,l
	jmp L3_
L3:
	arhl
	mov a,d\ rar\ mov d,a
	mov a,e\ rar\ mov e,a
L3_:
	push b
	push b
	push h
	push d
	mvi a,BUF>>8
	add b
	mov h,a
	mov l,c
	SHLD Set_RI+1
	mov e,m
	inr l
	mov l,m     ; r[i]
	
	mvi h,2+(MUL10kTAB>>8)
	mov b,m
	dcr h
	mov c,m
	dcr h
	mov a,m
	mov l,e
	mov e,m
	inr h
	add m
	mov d,a
	inr h
	mov a,m
	adc c
	mov c,a
	jnc AfterMUL10k
	inr b
AfterMUL10k:
	
; d += (uint32_t)(r[i]) * 10000UL;
	pop h
	dad d
	shld Dlow+1
	xchg
	pop h
	JNC $+4
	inx h
	dad b
	shld Dhi+1
	pop b	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	inx b
	mov a,l
	sub c
	mov a,h
	sbb b
	jnc DIVfull
	xra a\ ora b
	jm DIV32_1
	mov a,d
	add a\ xchg\ rdel\ xchg\ dsub\ jc A1_
S1_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A2_
S2_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A3_
S3_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A4_
S4_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A5_
S5_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A6_
S6_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A7_
S7_: stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A8_
S8_: stc\ adc a
	jmp DivLo_
	
A1_: add a\ xchg\ rdel\ xchg\ dad b\ jc S2_
A2_: add a\ xchg\ rdel\ xchg\ dad b\ jc S3_
A3_: add a\ xchg\ rdel\ xchg\ dad b\ jc S4_
A4_: add a\ xchg\ rdel\ xchg\ dad b\ jc S5_
A5_: add a\ xchg\ rdel\ xchg\ dad b\ jc S6_
A6_: add a\ xchg\ rdel\ xchg\ dad b\ jc S7_
A7_: add a\ xchg\ rdel\ xchg\ dad b\ jc S8_
A8_: add a\ dad b

DivLo_:
	mov d,a
	mov a,e
	add a\ xchg\ rdel\ xchg\ dsub\ jc A9_
S9_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A10_
S10_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A11_
S11_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A12_
S12_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A13_
S13_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A14_
S14_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A15_
S15_:	stc\ adc a\ xchg\ rdel\ xchg\ dsub\ jc A16_
S16_:	stc\ adc a
	jmp Set_RI_
	
A9_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S10_
A10_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S11_
A11_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S12_
A12_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S13_
A13_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S14_
A14_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S15_
A15_:	add a\ xchg\ rdel\ xchg\ dad b\ jc S16_
A16_:	add a\ dad b
Set_RI_:
	mov e,a
Set_RI:
	shld 0
	
; r[i] = res.rem; d = res.quot;
	POP B
	dcx b
	dcr c
	jz L4_

;q*(i-1)=(d-r-q)/2
QR1617:
	dad d
Dlow:
	lxi d,0
	mov a,e
	jc QR17
	sub l\ mov e,a
	mov a,d\ sbb h\ mov d,a
Dhi:
	lxi h,0
	jnc L3
	dcx h
	jmp L3		; }

QR17:
	sub l\ mov e,a
	mov a,d\ sbb h\ mov d,a
	lhld Dhi+1
	dcx h
	jnc L3
	dcx h
	jmp L3		; }

DIV32_1:
	call DIV320
	jmp Set_RI

DIVfull:
	xchg
	lhld Set_RI+1
	shld Set_RI2+1
	lxi h,0
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)

	XCHG
	shld SetHiDiv+1
	lhld Dlow+1
	XCHG
	CALL DIV320		; DE = HLDE/(BC), HL = HLDE%(BC)
Set_RI2:
	shld 0

; r[i] = res.rem; d = res.quot;
	POP B
	dcx b
	jx5 L4		; if (--i == 0) break;
	dcx b
	dad d
SetHiDiv:
	lxi d,0
	jnc $+4
	inx d
	lda Dlow+1\ sub l\ mov l,a
	lda Dlow+2\ sbb h\ mov h,a
	lda Dhi+1\ sbb e\ mov e,a
	lda Dhi+2\ sbb d
	xchg
	rar\ mov h,a
	mov a,l\ rar\ mov l,a
	mov a,d\ rar\ mov d,a
	mov a,e\ rar\ mov e,a
	jmp L3_		; }

L4:
	lhld SetHiDiv+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	jmp L4_2
	
L4_:
	xra a
	ora b
	; if (--i == 0) break;
	jnz QR1617
	mvi a,(10000>>8)-1
	cmp d
	lxi h,0
	jnc L4_1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	.db 0FEh
L4_1:
	xchg
L4_2:
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	mov a,h
	ora l
	jnz L2

	di
	mvi a,11
	call PrintChar
	mvi a,12
	call PrintChar
	mvi a,13
	call PrintChar

	lhld IntCountLo+1
	lda IntCount
	mov h,a
	xchg
	lhld IntCountHi
	mvi h,0

	lxi b,50
	call DIV320
	push h
	xchg
	call PR00000
	mvi a,10
	call PrintChar
	pop h
	dad h
	call PR00
	
	lda SetPlane+1
	lxi h,colorsE0+15
	cpi 0E0h
	jz SetColors1
	lxi h,colorsC0+15
	cpi 0C0h
	jz SetColors1
	lxi h,colorsA0+15
SetColors1:
	shld SetColors+1

GetKeyLoop:
		ei
		hlt
		mvi	a, 8Ah
		out	0
		mvi	a, 11111011b
		out	3
		in	2
		rrc
		rrc
		jc Chk2
		lxi h,colorsA0+15
		shld SetColors+1
Chk2:
		rrc
		jc Chk3
		lxi h,colorsC0+15
		shld SetColors+1
Chk3:
		rrc
		jc SetColors
		lxi h,colorsE0+15
		shld SetColors+1
SetColors:
		lxi h,colorsE0+15
		call colorset
		jmp GetKeyLoop

	JMP $


DIV320:; DE = HLDE/BC, HL = HLDE%BC
DIVNR32:
		mov a,d
		call DIVNR24
		mov d,a
		mov a,e
		call DIVNR24
		mov e,a
		ret

DIVNR24:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p\ dsub\ jc DIVNR24m_1\ stc\ jmp DIVNR24p_1
DIVNR241p:
		dsub\ jnc DIVNR24m_1

DIVNR24p_1:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_1\ dsub\ jc DIVNR24m_2\ stc\ jmp DIVNR24p_2
DIVNR241p_1:
		dsub\ jnc DIVNR24m_2

DIVNR24p_2:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_2\ dsub\ jc DIVNR24m_3\ stc\ jmp DIVNR24p_3
DIVNR241p_2:
		dsub\ jnc DIVNR24m_3

DIVNR24p_3:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_3\ dsub\ jc DIVNR24m_4\ stc\ jmp DIVNR24p_4
DIVNR241p_3:
		dsub\ jnc DIVNR24m_4

DIVNR24p_4:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_4\ dsub\ jc DIVNR24m_5\ stc\ jmp DIVNR24p_5
DIVNR241p_4:
		dsub\ jnc DIVNR24m_5

DIVNR24p_5:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_5\ dsub\ jc DIVNR24m_6\ stc\ jmp DIVNR24p_6
DIVNR241p_5:
		dsub\ jnc DIVNR24m_6

DIVNR24p_6:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_6\ dsub\ jc DIVNR24m_7\ stc\ jmp DIVNR24p_7
DIVNR241p_6:
		dsub\ jnc DIVNR24m_7

DIVNR24p_7:
		ral\ xchg\ rdel\ xchg\ jc DIVNR241p_7\ dsub\ jc DIVNR24mExit
DIVNR24pExitC:
		stc\ ral\ ret
DIVNR241p_7:
		dsub\ jnc DIVNR24mExit
DIVNR24pExit:
		ral\ ret


DIVNR24m:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m\ dad b\ jc DIVNR24p_1\ jmp DIVNR24m_1
DIVNR241m:
		dad b\ jnc DIVNR24p_1
DIVNR24m_1:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_1\ dad b\ jc DIVNR24p_2\ jmp DIVNR24m_2
DIVNR241m_1:
		dad b\ jnc DIVNR24p_2

DIVNR24m_2:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_2\ dad b\ jc DIVNR24p_3\ jmp DIVNR24m_3
DIVNR241m_2:
		dad b\ jnc DIVNR24p_3

DIVNR24m_3:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_3\ dad b\ jc DIVNR24p_4\ jmp DIVNR24m_4
DIVNR241m_3:
		dad b\ jnc DIVNR24p_4

DIVNR24m_4:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_4\ dad b\ jc DIVNR24p_5\ jmp DIVNR24m_5
DIVNR241m_4:
		dad b\ jnc DIVNR24p_5

DIVNR24m_5:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_5\ dad b\ jc DIVNR24p_6\ jmp DIVNR24m_6
DIVNR241m_5:
		dad b\ jnc DIVNR24p_6

DIVNR24m_6:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_6\ dad b\ jc DIVNR24p_7\ jmp DIVNR24m_7
DIVNR241m_6:
		dad b\ jnc DIVNR24p_7

DIVNR24m_7:
		add a\ xchg\ rdel\ xchg\ jnc DIVNR241m_7\ dad b\ jc DIVNR24pExit
		ral\ dad b\ ret
DIVNR241m_7:
		dad b\ jnc DIVNR24pExitC
DIVNR24mExit:
		add a\ dad b\ ret


PR00000:
	LXI D,-10000
	lxi b,10000
	CALL PR0
PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:
PRC:
	JMP PrintChar
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
PrintChar:
		push psw
		push h
        ;    A
        lxi h, cursor
        mov e,m			;e=y
        inx h
        mov d,m			;d=x
		
		; e=y
        ; d=x
        ; a= 
putcharv:
		add a\ add a
        lxi h, fontsrc
		add l\ mov l,a
		adc h\ sub l\ mov h,a

		mov a,m				;
		add d\ jnc NotNextLine
		mvi d,0
		mvi a,-6\ add e\ mov e,a
		jc NotNextLine
		push h
		push b
		hlt
		lda SetPlane+1
		lxi h,colorsC0+15
		cpi 0A0h
		mvi a,0C0h
		jz SetColors2
		lxi h,colorsE0+15
		mvi a,0E0h
SetColors2:
		sta SetPlane+1
		call colorset
		ei
		pop b
		pop h
		mvi e,0FFh-7
NotNextLine:
		push d
		mov a,m
		add d\ mov d,a
		xchg\ shld cursor\ xchg
		pop d
		mov a,m\ inx h
		push psw					;
		
		mvi a,111b
		ana d
		mov b,a
		xra d
		rrc\ rrc\ rrc
SetPlane:
		ori 0A0h
		mov d,a						;DE=

		mvi a,MaskTable&255
		add b
		mov c,a
		aci MaskTable>>8
		sub c
		mov b,a
		ldax b
		pop b						;B=
		dcr b
		mov c,a						;C=

		mvi a,33h
		out 0Eh
PutSym:		
		push h
		mov h,m
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d\ inr e
		dad h\ jnc $+6\ ldax d\ ora c\ stax d
		mvi a,-4\ add e\ mov e,a
		pop h
		inx h
		mov a,c\ rrc\ mov c,a\ jnc $+4\ inr d
		dcr b
		jnz PutSym
		pop h
		xra a
		out 0Eh
		pop psw
        ret

MaskTable:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b		

Int:
		push psw
IntCountLo:
		mvi a,0
		inr a
		sta IntCountLo+1
		jnz IntExit2
		push h
		lxi h,IntCount
		inr m
		jnz IntExit
		inx h
		inr m
IntExit:
		pop h
IntExit2:
		pop psw
		ei
		ret


colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	dcx	h
	dcr	c
	jp	colorset1
	cma
	out	3
	ret

fontsrc:

	.db 4
	.db 11111000b
	.db 10001000b
	.db 11111000b

	.db 2
	.db 11111000b
	.db 0
	.db 0

	.db 3
	.db 11101000b
	.db 10111000b
	.db 0

	.db 3
	.db 10101000b
	.db 11111000b
	.db 0

	.db 4
	.db 00111000b
	.db 00100000b
	.db 11111000b

	.db 3
	.db 10111000b
	.db 11101000b
	.db 0

	.db 4
	.db 11111000b
	.db 10101000b
	.db 11101000b

	.db 3
	.db 00001000b
	.db 11111000b
	.db 0

	.db 4
	.db 11111000b
	.db 10101000b
	.db 11111000b

	.db 4
	.db 10111000b
	.db 10101000b
	.db 11111000b

	.db 2
	.db 10000000b
	.db 0
	.db 0
	
;11
	.db 4
	.db 0
	.db 0
	.db 0

;12
	.db 4
	.db 00001000b
	.db 11111000b
	.db 00001000b

;13
	.db 4
	.db 01010000b
	.db 01010000b
	.db 01010000b


W	.equ 173
colorsE0:
		.db 0,W,0,W,0,W,0,W,0,W,0,W,0,W,0,W
colorsC0:
		.db 0,0,W,W,0,0,W,W,0,0,W,W,0,0,W,W
colorsA0:
		.db 0,0,0,0,W,W,W,W,0,0,0,0,W,W,W,W

	END
