.include "tasm.inc"

; This code is ZX Spectrum specific
;	ORG	$C000		; Use uncontended memory
;	ORG	$7000		;
;	ORG 100h

	call $c010
	
	ld bc,-1
	xor a
	ld d,a
	ld e,a
	ld hl,MULTAB
	call GenSQRtab
	inc h
	inc h
	call GenSQRtab
	

;	LD	HL,$5800
	ld	l,0h
LP0
	ld	h,$90
	ld	de,0
LP1:
;	DEC	HL
	LD	B,7
LP2:	PUSH	BC
	PUSH	HL
	ld	b,l
	ld 	hl,171
	add	hl,de
;	LD	A,L
;	ADD	A,A
;	ADD	A,A
;	ADD	A,A
;	ADD	A,B
;	DEC	A
;	LD	C,A
;	LD	A,H
;	RRCA
;	RRCA
;	RRCA
;	RRCA
;	RR	L
;	RRCA
;	RR	L
;	LD	A,L
;	AND	$F8
;	LD	L,A
;	LD	A,H
;	AND	7
;	OR	L
;	LD	B,A

;	ld a,h
;	sbc a,$bf
;	add a,a
;	add a,a
;	add a,a
;	add a,b
;	ld c,a
	push	hl
	CALL	TRACE
	pop	de
	POP	HL

;	RR	(HL)
	ld a,(hl)\ rla\ ld (hl),a
	
	POP	BC

;	DJNZ	LP2
	dec b\ jp p,LP2

	LD	A,H
;	CP	$40
	cp	$C0
	inc	h
	jp	C,LP1
	inc	l
;	ld	a,255-192
	jp	nz,LP0
;	POP	HL
;	EXX
;	RET
	jp $

GenSQRtab:
	push de
	push af
	rra
	push af
	ld a,d\ rra\ ld d,a
	ld a,e\ rra\ ld e,a
	pop af
	rra
	ld a,d\ rra
	inc h
	ld (hl),a
	dec h
	ld a,e\ rra
	ld (hl),a
	pop af
	pop de
	inc bc
	inc bc
	ex de,hl
	add hl,bc
	ex de,hl
	adc a,0
	inc l
	jp nz,GenSQRtab
	ret
	

SCENE:
GROUND:	DEFW	BALL1,GROUNDI,GROUNDL,GC
BALL1:	DEFW	BALL2,SPHEREI,SPHEREL,B1C,$3F33,$3E71	; r=0.6, r*r=0.36
BALL2:	DEFW	0,SPHEREI,SPHEREL,B2C,$3D9A,$3B48	; r=0.2, r*r=0.04
POS:	DEFB	3		; 3 positions
GROUNDC:DEFW	$BE33,$3F00,$0000	; -0.3, 0.5, 0
BALL1C:	DEFW	$BF33,$BE33,$4180	; -0.6, -0.3, 3
BALL2C:	DEFW	$3F33,$BF33,$4100	; 0.6, -0.6, 2
LIGHT:	DEFW	0,$C000,0
	INCLUDE	"trace.asm"

;	LD	IX,SCENE
	push hl\ ld hl,SCENE\ ld (RegIX),hl\ pop hl
	
	CALL	SCENEI
	RET	NC
	INCLUDE "scene.asm"
	INCLUDE "ground.asm"
	INCLUDE "sphere.asm"
	INCLUDE	"hitray.asm"

; floating point constants
MINF:	EQU	$0000		; Positive epsilon, 2^-64 			5.421e-20
MAXF:	EQU	$7FFF		; Maximal floating point number 2^64-2^55	1.841e+19
ONEF:	EQU	$4000		; One						1.000e+00
ROOT2F:	EQU	$406A		; Square root of 2				1.414e+00
F7F:	EQU	$46FC		; $7F i.e. 127					1.270e+02

; Subroutines
	INCLUDE "fdivmul.asm"
	INCLUDE "faddsub.asm"
;	INCLUDE "../faddsub-fast.asm"
	INCLUDE "fsquare.asm"
	INCLUDE "mul8bit.asm"
	INCLUDE "fint8.asm"
	INCLUDE	"dot.asm"
; Lookup tables
;	INCLUDE "../addtab.asm"
;	INCLUDE "../subtab.asm"
	INCLUDE	"divtab.asm"
	INCLUDE "squaretab.asm"
	INCLUDE	"multab.asm"
; Variables
	INCLUDE	"variables.asm"

	END
	