//=================
// Модуль LCD162
//===================

module lcd162(
 input	clk,
 input	rst,
 output	rs_out,
 output	rw_out,
 output	en_out,

 output [4:0] pos,
 input [7:0] chr,

 output [7:0] dat_out
 );
 
assign en_out = clkr|e; 
assign rw_out = 0;
assign rs_out = rs;
assign dat_out = dat_out_reg;
 
assign pos = pos_reg;
 
 reg e = 1;
 reg rs;   
 reg  [15:0] counter = 0; 
 reg [5:0] current,next = 63; 
 reg clkr = 0; 
 reg [1:0] cnt = 0; 
 reg [4:0] pos_reg;
 reg [7:0] dat; 
 reg [7:0] dat_out_reg;
 
//-------------------------------------------
always @(posedge clk) begin 
    counter=counter+1; 
    if(counter==16'h000f) clkr = ~clkr; 
	 else if (counter==16'h0018) begin
		if (current < 32) dat_out_reg <= chr;
		else dat_out_reg <= dat;
	 end
end 


//-------------------------------------------
always @(posedge clkr or posedge rst) 
begin 
  if (rst) begin
	 next <= 63;
	 cnt <= 0;
  end
  else begin
   current = next; 
   case(current) 

    59:   begin  rs<=0; dat<=8'h38; next<=60; end 
    60:   begin  rs<=0; dat<=8'h0c; next<=61; end 
    61:   begin  rs<=0; dat<=8'h6; next<=62; end 
    62:   begin  rs<=0; dat<=8'h1; next<=0; end 

	 55:	begin  rs<=0; dat<=8'h80; next<=0; end
	 
    0,1,2,3,4,5,6,7,8,9,10,11,12,13,14:   begin  rs<=1; next<=next+1; end 
    15:   begin  rs<=1; next<=56; end 
//    0,1,2,3,4,5,6,7:   begin  rs<=1; dat<=chr; next<=next+1; end 
//    8,9,10,11,12,13,14:   begin  rs<=1; dat<=chr; next<=next+1; end 
//    15:   begin  rs<=1; dat<=chr; next<=56; end 

	 56:	begin  rs<=0; dat<=8'hc0; next<=16; end

//    16,17,18,19,20,21,22,23:   begin  rs<=1; dat<=chr; next<=next+1; end 
//    24,25,26,27,28,29,30:   begin  rs<=1; dat<=chr; next<=next+1; end 
//    31:   begin  rs<=1; dat<=chr; next<=next+1; end 
    16,17,18,19,20,21,22,23,24,25,26,27,28,29,30:   begin  rs<=1; next<=next+1; end 
    31:   begin  rs<=1; next<=next+1; end 
    
	 54:	next<=63;
		
	 63:   begin 
					rs<=0;  dat<=8'h02;                    //
              if(cnt!=2'h2)  
                  begin e<=0; next<=59; cnt<=cnt+1; end  
              else  
                  begin e<=0; next<=55; end    
           end 

	 default:   begin e<=1; next<=next+1; end

   endcase
	pos_reg = next[4:0];
  end
	
end 

endmodule  
