//
// Для Вектор-06Ц
//
// Подключение Мышки к "ВУ" через "контроллер" (USB-mous - "ПУ")
// порт ВВ D4h : запись - управление, чтение - данные.
//
//

module scaner_vu(
	input				clk50,		// clk 50MHz
	
	input	wire	[7:0]	vu_shavv_n,		// шина адреса ввода-вывода
	input	wire	[7:0]	vu_shap,		// шина адреса памяти
	inout	wire	[7:0]	vu_shd,		// шина данных
	
	input				vu_zpvv_n,	// ~ЗПВВ
	input				vu_chtvv_n,	// ~ЧТВВ
	input				vu_stek,		// СТЕК
	input				vu_ras_n,	// ~RAS
	input				vu_cas_n,	// ~CAS
	input				vu_zpzu_n,	// ~ЗПЗУ
	input				vu_chtzu_n,	// ~ЧТЗУ
	input				vu_vvods_n,	// ~ВВОД СИСТ клавиша "ВВОД"
	input				vu_sbros_n,	// ~СБРОС
	input				vu_strob,	// СТРОБ СОСТ.
	input				vu_6MGh,		// доп вход 6МГц
	
	input				vu_blk_n,		// ~вход БЛК
	output			vu_blk_n_out,

	output			rd_pzu_n,	// 0-RD_пзу  1-шина данных
//-------
	output	lcd162_rs,
	output	lcd162_rw,
	output	lcd162_e,
	output	[7:0]	lcd162_data,
//-------
	input		[3:0]	keys,			// кнопки на плате Альтера	0-reset,дев-ON   1-дев-OFF   2-     3-
	output	[3:0]	leds,			// светодиоды на плате Альтера
//-------

	output		[5:0]	sh_upr_mous,		// шина управления контроллером мыши
	input	wire	[7:0]	sh_rd_mous		// шина данных контроллера мыши

);

//----------------------------
assign rd_pzu_n = (rd_D4) ? 1'b0 : 1'b1;	// шина данных на вход, при чтении порта D4 - выход
assign vu_blk_n_out = 1'b1;		// ~БЛК всегда "1"

//----------------------------
reg [5:0]	countReset = 15;	// длительность Сброса при включении питания
wire			InternalReset;

always @(posedge clk50)	if (countReset > 0) countReset <= countReset - 1;

assign InternalReset = (countReset > 0);	// внутренний сигнал RESET - при включении питания
wire Reset = InternalReset | ~keys[0];		// совмещение сброса при включении, кнопки "Ресет"
//----------------------------



// ======== PLL ==============
reg [9:0] clkCnt;	// регистр-счетчик - делитель яастоты

always @(posedge clk1) clkCnt <= clkCnt + 1; // счетчик от 1 МГц

wire clk001 = clkCnt[9];	// 1 KHz
wire clk008 = clkCnt[6];	// 8 KHz
//wire clk062 = clkCnt[3];	// 62 KHz

//=======================================================
//=======================================================
wire clkScan;					// сигнал частоты сканирования
assign clkScan = clk200;	// привязка к конкретной частоте
//=======================================================
//=======================================================

pll_bus	pll_bus(
	.inclk0(clk50),	//  50MHz
	.c0(clk24),			//  24MHz
	.c1(clk1),			//   1MHz
	.c2(clk100),		// 100MHz
	.c3(clk200)			// 200MHz
);

//=== входные буферы шин ========================================

reg [7:0] buf_shav [1:0];		// буфер шины адреса ввода-вывода
reg [7:0] buf_shap [1:0];		// буфер шины адреса памяти
reg [7:0] buf_shd [1:0];		// буфер шины данных
reg [11:0] buf_shsu [1:0];		// буфер шины сигналов управления

always @(posedge clkScan) begin
	buf_shav[1] <= buf_shav[0];	// выход буфера шины адреса ввода-вывода
	buf_shav[0] <= ~vu_shavv_n;	// начало буфера шины адреса ввода-вывода

	buf_shap[1] <= buf_shap[0];	// выход буфера шины адреса памяти
	buf_shap[0] <= vu_shap;		// начало буфера шины адреса памяти

	buf_shd[1] <= buf_shd[0];	// выход буфера шины данных
	buf_shd[0] <= vu_shd;		// начало буфера шины данных

	buf_shsu[1] <= buf_shsu[0];	// выход буфера шины сигналов управления
	buf_shsu[0] <= {vu_zpvv_n, vu_chtvv_n, vu_sbros_n, vu_vvods_n, vu_6MGh, vu_ras_n, vu_cas_n, vu_zpzu_n, vu_chtzu_n, vu_stek, vu_strob, vu_blk_n};		// начало буфера шины сигналов управления
end

wire [7:0] shavv_buf;
assign shavv_buf = buf_shav[1];

wire [7:0] shap_buf;
assign shap_buf = buf_shap[1];

wire [7:0] shd_buf;
assign shd_buf = buf_shd[1];

wire [11:0] shsu_buf;
assign shsu_buf = buf_shsu[1];

//----------------------------- фронт и спад сигналов шины цправления
wire [11:0] shsu_pos;		// матрица буфера шины сигналов управления - фронт сигналов
wire [11:0] shsu_neg;		// матрица буфера шины сигналов управления - спад сигналов

assign shsu_pos = ~buf_shsu[1] & buf_shsu[0];	// матрица буфера - идёт фронт сигналов
assign shsu_neg = ~buf_shsu[0] & buf_shsu[1];	// матрица буфера - идёт спад сигналов

wire RdVV_n;
wire WrVV_pos;
wire WrVV_neg;
wire RdVV_neg;
assign RdVV_n = shsu_buf[10];		// ~ЧТВВ
assign WrVV_pos = shsu_pos[11];	// pos 0>1 ЗПВВ
assign WrVV_neg = shsu_neg[11];	// neg 1>0 ЗПВВ
assign RdVV_neg = shsu_neg[10];	// neg 1>0 ЧТВВ


//======= LEDs =====================
assign leds[0] = ~Reset;
assign leds[1] = keys[1];
assign leds[2] = keys[0];	// reset
assign leds[3] = keys[3];


// ======== LCD162 ===========================================================
reg [7:0] lcd_scr [0:31];
wire [4:0] lcd_pos;

lcd162	lcd162(
	.clk(clk50),
	.rst(Reset),
	.rs_out(lcd162_rs),
	.rw_out(lcd162_rw),
	.en_out(lcd162_e),
	
	.pos(lcd_pos),
	.chr(lcd_scr[lcd_pos]),

	.dat_out(lcd162_data)
);
//======================================================================================== 
wire [7:0] HexKod [15:0];
assign HexKod[0] = "0"; 
assign HexKod[1] = "1"; 
assign HexKod[2] = "2"; 
assign HexKod[3] = "3";
assign HexKod[4] = "4"; 
assign HexKod[5] = "5"; 
assign HexKod[6] = "6"; 
assign HexKod[7] = "7";
assign HexKod[8] = "8"; 
assign HexKod[9] = "9"; 
assign HexKod[10] = "A"; 
assign HexKod[11] = "B";
assign HexKod[12] = "C"; 
assign HexKod[13] = "D"; 
assign HexKod[14] = "E"; 
assign HexKod[15] = "F";

//=================================
always @(posedge clk001) begin
	if (Reset) begin
		lcd_scr[0] <= " "; lcd_scr[1] <= " "; lcd_scr[2] <= " "; lcd_scr[3] <= " "; 
		lcd_scr[4] <= " "; lcd_scr[5] <= " "; lcd_scr[6] <= " "; lcd_scr[7] <= " ";
		lcd_scr[8] <= " "; lcd_scr[9] <= " "; lcd_scr[10] <= " "; lcd_scr[11] <= " ";
		lcd_scr[12] <= " "; lcd_scr[13] <= " "; lcd_scr[14] <= " "; lcd_scr[15] <= " ";
		lcd_scr[16] <= " "; lcd_scr[17] <= " "; lcd_scr[18] <= " "; lcd_scr[19] <= " ";
		lcd_scr[20] <= " "; lcd_scr[21] <= " "; lcd_scr[22] <= " "; lcd_scr[23] <= " ";
		lcd_scr[24] <= " "; lcd_scr[25] <= " "; lcd_scr[26] <= " "; lcd_scr[27] <= "S";
		lcd_scr[28] <= "t"; lcd_scr[29] <= "a"; lcd_scr[30] <= "r"; lcd_scr[31] <= "t";
	end
	else begin
					lcd_scr[0] <= HexKod[d_upr[7:4]];
					lcd_scr[1] <= HexKod[d_upr[3:0]];
					lcd_scr[2] <= " ";
					lcd_scr[3] <= HexKod[rx_Data_buf[7:4]];
					lcd_scr[4] <= HexKod[rx_Data_buf[3:0]];
					lcd_scr[5] <= " ";
					lcd_scr[6] <= HexKod[debug_flag[3:0]];
					lcd_scr[7] <= HexKod[debug2_flag[3:0]];
					lcd_scr[8] <= " ";
					lcd_scr [9] <= " ";
					lcd_scr[10] <= " ";
					lcd_scr[11] <= " ";
					lcd_scr[12] <= " ";
					lcd_scr[13] <= " ";
					lcd_scr[14] <= " ";
					lcd_scr[15] <= HexKod[keys[3:0]];

					lcd_scr[16] <= "x";
					lcd_scr[17] <= "=";
					lcd_scr[18] <= HexKod[deb_x[7:4]];
					lcd_scr[19] <= HexKod[deb_x[3:0]];
					lcd_scr[20] <= " ";
					lcd_scr[21] <= "y";
					lcd_scr[22] <= "=";
					lcd_scr[23] <= HexKod[deb_y[7:4]];
					lcd_scr[24] <= HexKod[deb_y[3:0]];
					lcd_scr[25] <= " ";
					lcd_scr[26] <= " ";
					lcd_scr[27] <= " ";
					lcd_scr[28] <= "k";
					lcd_scr[29] <= "=";
					lcd_scr[30] <= HexKod[deb_k[7:4]];
					lcd_scr[31] <= HexKod[deb_k[3:0]];
	end
end

//============================





//===========================================================
//== для порта мыши =========================================
wire mous_on;
assign mous_on = (d_upr[5]) ? 1 : 0 ; // контроллер мыши: 1-off, 0-on
reg mous_strob_flag;
wire mous_strob;
assign mous_strob = (mous_strob_flag) ? 1 : 0 ; // строб запроса данных у контроллера 1->0 

wire on_D4;
assign on_D4 = (shavv_buf == 8'hD4) ? 1 : 0 ; // выбор адреса D4 (порт мыши) 1-выбор

wire wr_D4_pos;
wire wr_D4_neg;
wire rd_D4;
wire rd_D4_neg;
assign wr_D4_pos = on_D4 ? WrVV_pos : 0 ;  // pos фронт ~ЗПВВ
assign wr_D4_neg = on_D4 ? WrVV_neg : 0 ;  // neg спад ~ЗПВВ
assign rd_D4 =     on_D4 ?  ~RdVV_n : 0 ;	// 1 - ЧТВВ D4
assign rd_D4_neg = on_D4 ? RdVV_neg : 0 ;  // neg спад ЧТВВ D4



//=== Приём байта из порта D4  =========
reg [3:0] debug_flag = 0;
reg [3:0] debug2_flag = 0;

reg [7:0] d_upr;	// байт управления принятый с шины "ВУ"
wire wr_ports_neg, wr_ports_pos;
assign wr_ports_neg = wr_D4_neg;	// 1->0 для порта D4
assign wr_ports_pos = wr_D4_pos;	// 0->1 для порта D4

// ---  ----
always @(posedge clkScan) begin
	if (Reset) begin
		d_upr <= 8'hFF;
		mous_strob_flag <= 1;
		
		debug_flag <= 0;
	end
	else begin
		if (wr_ports_neg) begin
			d_upr <= shd_buf; 	// сохранить байт с шины данных
//			d_upr <= vu_shd; 	// сохранить байт с шины данных
			mous_strob_flag <= 0;

			debug_flag <= debug_flag | 2;
		end
		else if (wr_ports_pos) begin
			mous_strob_flag <= 1;

			debug_flag <= debug_flag | 1;
		end
	end
end

assign sh_upr_mous = {mous_on, mous_strob, d_upr[3], d_upr[2], d_upr[1], d_upr[0]};	// out - шина управления контроллером


//---------------------------------
reg [7:0] buf_rx_Data [1:0];		// буфер шины данных контроллера мыши

always @(posedge clkScan) begin
	buf_rx_Data[1] <= buf_rx_Data[0];	// выход буфера шины данных мыши
	buf_rx_Data[0] <= sh_rd_mous;		// начало буфера шины данных мыши
end

wire [7:0] rx_Data_buf;		// буфер полученного от контроллера байта данных
assign rx_Data_buf = buf_rx_Data[1];

// переключить направление шины данных на время чтения из портов
// чтение порта D4 - данных
assign vu_shd = (rd_D4) ? rx_Data_buf : 8'bzzzzzzzz ;	
//=======================================================================

// debug
reg [7:0] deb_k;	// байт полученный от контроллера, по запросу Key
reg [7:0] deb_x;	// байт полученный от контроллера, по запросу Х
reg [7:0] deb_y;	// байт полученный от контроллера, по запросу Y
reg [7:0] deb_w;	// байт полученный от контроллера, по запросу W
reg [7:0] deb_mx;	// байт полученный от контроллера, по запросу mХ
reg [7:0] deb_my;	// байт полученный от контроллера, по запросу mY
reg [7:0] deb_id;	// байт полученный от контроллера, по запросу id

// ---  ----
always @(posedge clkScan) begin
	if (Reset) begin
		deb_k <= 8'h00;
		deb_x <= 8'h00;
		deb_y <= 8'h00;
		deb_w <= 8'h00;
		deb_mx <= 8'h00;
		deb_my <= 8'h00;
		deb_id <= 8'h00;
	end
	else begin
		if (rd_D4_neg) begin
			if (d_upr[3:0] == 0) begin	deb_k <= rx_Data_buf;	end
			if (d_upr[3:0] == 1) begin	deb_x <= rx_Data_buf;	end
			if (d_upr[3:0] == 2) begin	deb_y <= rx_Data_buf;	end
			if (d_upr[3:0] == 3) begin	deb_w <= rx_Data_buf;	end
			if (d_upr[3:0] == 4) begin	deb_mx <= rx_Data_buf;	end
			if (d_upr[3:0] == 5) begin	deb_my <= rx_Data_buf;	end
			if (d_upr[3:0] == 15) begin	deb_id <= rx_Data_buf;	end
		end
	end
end



endmodule
