;
;   USB-   ""  ""
;                             08.2024
;--------------------------------------------------
;   "":
;  5    -  - / , "0" - . , "1" - .      128/128
;  4    -  -   ,     ,     "0",    "1"
; 7-0      -  -      
;  3-0 -  -    
;------------
;   "":
;  D4h -   -    
;
;  5    -  - / , "0" - . , "1" - .      128/128
;  3-0 -  -    
;
;  D4h -   -      
;------------
;
;        :
;          "0" -       ""    512256
;                 7 - ""   "1" - 
;                 6 - ""   "1" - 
;                 5 - ""   "1" - 
;                 0 -    ""    512256,       "1"
;          "1" - ""    ( 0  255)
;          "2" - "Y"    ( 0  255)
;          "3" -     
;          "4" -    "X"      -128  127 (  80h  7fh )
;          "5" -    "Y"      -128  127 (  80h  7fh )
;          "6" -    "X"      0  127 (  7 -  "1" -  )
;          "7" -    "Y"      0  127 (  7 -  "1" -  )
;          "8" -  
;                 0 - ""   "1" - 
;                 1 - ""   "1" - 
;                 2 - ""   "1" - 
;          "9" - ""    ( -127  +127)   
;         "10" - "Y"    ( -127  +127)   
;         "15" -   ,   6Dh
; 
;=======================================================================================================
;      -    R4, R5, R6, R7 ()   
;      -      
;----------------------------------------------
;
;    -  
Min_X	.EQU	0C0H
Min_X2	.EQU	080H
;    -  
Top_Y	.EQU	0FFH
;    -  
ShowKey	.EQU 	0DFFDH
;    , ,    
ShowCount	.EQU	0DFFFH
;
;
;
	.ORG	0100H
;   
ASTART:	DI
	LXI	SP,0100H	;   
;----------------------------
;
	call	pu_mous_init	;        (  -  )
	call	vu_mous_off		;	     -  
;
;------------------------
	call	start_setup	;   
	LXI		SP,0FEF8H	;   
;--------------------------------
;
;     
	MVI	A,128	;    
	STA	POSMX		;    X
	STA	POSMY		;    Y
	STA	POSMXOld	; .   X
	STA	POSMYOld	; .   Y
	xra	a
	STA	MOVMX		;   X
	STA	MOVMY		;   Y
	STA	MOVMW		;   
	STA	TYPE_MOUS	;    0 -  , 1 - 
	STA	TYPE_MOVE	;     0 -  , 1 -  , 2 -   PS
	STA	regim		; 256x256, 00h-256, 10h-512
	lxi	h,0080h		; 128
	shld	POSMXd		;     X
	shld	POSMYd		;     Y
;
	LXI	H,D_FNT		;  
	shld	A_D_FNT
;
;----------------------------------------------------------
	call	set_color	;  
;=========================================================

;==========      ==============
	call	pu_mous_on	; .    

	mvi	a,00fh		;  15
	call	pu_mous_rd	;  
	sta		ShowKey-2	;     
	cpi	06dh	;  
	mvi	a,0		;    0 -  , 1 - 
	jz	test_pu_ok
	call	pu_mous_off	; .    
;
	call	vu_mous_on	; .    ,  15
	call	vu_mous_rd		;  
	sta		ShowKey-3	;     
	cpi	06dh	;  
	jz	test_vu_ok	;    
;--------------------
	mvi	a,2
	call	VYV_TYP	;     0 -  , 1 - , 2 -  
;--------------------
	call	pauses		;	   
;
	jmp	ASTART	;  
;--------------------
test_vu_ok:
	mvi	a,1		;    0 -  , 1 - 
test_pu_ok:
	STA	TYPE_MOUS	;    0 -  , 1 - 
;
	call	VYV_TYP	;       0 -  , 1 - 
;
;--------------------
;----          ----
	call	k_on
;
;=======================================================================
;   
;-----------------------------
;   /lat, , 
;    
;     
;    
;    
;=======================================================================
IRQ_S:
	EI	;    
	HLT

	lda	regim		;     256/512, 00h-256, 10h-512
	out	2			;     4-    02
	mvi	a,0ffh		;   
	out	3			;     03
	
	LDA	ShowCount	;   
	INR	A	 ;  ,   
	STA	ShowCount	;   
;
;------------------
;     0 -  , 1 -  , 2 -   PS
; : "/lat" -  , "" -  , "" -   PS
	in 01h
	rlc
	lxi	b,0007h		; /lat 0 -  , 7 - . /lat
	jnc	down_key
	inr	b		; 1 -  
	dcr	c		; 6 - . /lat
	rlc
	jnc	down_key	;   1 -  , 6 - . /lat
	rlc
	jc	down_no	;   
;----------------------------------
; down_	-     
	inr	b		; 2 -   PS
;----------------------------------
;
down_key:
	mov	a,b
	sta	TYPE_MOVE	;     0 -  , 1 -  , 2 -   PS
	mov	a,c
	OUT	00h		;   /lat
down_no:
;
;=====================================================================================
;===================      ============================
	lda	TYPE_MOUS	;    0 -  , 1 - 
	rrc
	jc	rd_mouse_vu	;     
;----------------------------------------------
;      
;
	mvi	a,01h	;  "1"
	call	pu_mous_rd	;  
	STA	REGMX	;   
	
	xra	a	;  "0"				   512256 -   "0"   "1"
	call	pu_mous_rd	;  
	STA	MKey	;   

	mvi	a,02h	;  "2"
	call	pu_mous_rd	;  
	STA	REGMY	;   Y
	
	mvi	a,03h	;  "3"
	call	pu_mous_rd	;  
	STA	MOVMW	;   
	
	mvi	a,04h	;  "4"
	call	pu_mous_rd	;  
	STA	MOVMX	;    
	
	mvi	a,05h	;  "5"
	call	pu_mous_rd	;  
	STA	MOVMY	;    Y
	
	mvi	a,06h	;  "6"
	call	pu_mous_rd	;  
	STA	MOVMXPS	;    
	
	mvi	a,07h	;  "7"
	call	pu_mous_rd	;  
	STA	MOVMYPS	;    Y
	
	mvi	a,08h	;  "8"
	call	pu_mous_rd	;  
	STA	MKeyS	;   
	
	mvi	a,09h	;  "9"
	call	pu_mous_rd	;  
	STA	MOVMXS	;    X
	
	mvi	a,0ah	;  "10"
	call	pu_mous_rd	;  
	STA	MOVMYS	;    Y

	jmp	rd_mouse_end
;
;----------------------------------------------
;      
rd_mouse_vu:
	mvi	a,01h	;  "1"
	call	vu_mous_rd	;  
	STA	REGMX	;   
	
	xra	a	;  "0"				   512256 -   "0"   "1"
	call	vu_mous_rd	;  
	STA	MKey	;   

	mvi	a,02h	;  "2"
	call	vu_mous_rd	;  
	STA	REGMY	;   Y
	
	mvi	a,03h	;  "3"
	call	vu_mous_rd	;  
	STA	MOVMW	;   

	mvi	a,04h	;  "4"
	call	vu_mous_rd	;  
	STA	MOVMX	;    
	
	mvi	a,05h	;  "5"
	call	vu_mous_rd	;  
	STA	MOVMY	;    Y
	
	mvi	a,06h	;  "6"
	call	vu_mous_rd	;  
	STA	MOVMXPS	;    
	
	mvi	a,07h	;  "7"
	call	vu_mous_rd	;  
	STA	MOVMYPS	;    Y
	
	mvi	a,08h	;  "8"
	call	vu_mous_rd	;  
	STA	MKeyS	;   
	
	mvi	a,09h	;  "9"
	call	vu_mous_rd	;  
	STA	MOVMXS	;    X
	
	mvi	a,0ah	;  "10"
	call	vu_mous_rd	;  
	STA	MOVMYS	;    Y

;-----------------------------------------------
rd_mouse_end:
;
;=============================================================================
;------------------------------------
;     
	call	k_off
;
;=============================================================================
;    256/512
	lda	ShowKey	 ;    
	cpi	0c0h		; + 256256
	jnz	drv_n
	xra	a		;     256/512, 00h-256, 10h-512
	jmp	drv_s
drv_n:
	cpi	60h		; + 512256
	jnz	drv_e
	mvi	a,10h
drv_s:
	sta	regim	;     256/512, 00h-256, 10h-512
drv_e:
;=============================================================================
;----------------------------------------------------------------------------------------
;     ,     
	lda	REGMX	; X  
	mov	b,a
	lda	REGMY	; Y  
	mov	c,a
;
	lda	TYPE_MOVE	;    0 -  , 1 -  , 2 -   PS
	rrc
	jc	typ_mov_xy		;       (4, 5)
	rrc
	jnc	typ_pos_xy		;         
;
;=============================================================================
;-------------------------     X       (9, 10) ---------
	lhld	POSMXd	;     X
	lda		MOVMXS	;     X
	mov	e,a
	mvi	d,0
	ani	80h		;    
	jz	mov_X_r9	;   - 
	dcr	d		;    - 
mov_X_r9:
	dad	d		;    
	mov	a,h
	ora	a
	ral
	jz	mov_X_9ok	;       256
	lxi	h,0		;    
	jc	mov_X_9ok	;     0
	dcr	l		;   255,    
mov_X_9ok:
	shld	POSMXd	;     X
;
;-------------------------     Y ---------
	lhld	POSMYd	;     Y
	lda		MOVMYS	;     Y
	mov	e,a
	mvi	d,0
	ani	80h		;    
	jz	mov_Y_rA	;   - 
	dcr	d		;    - 
mov_Y_rA:
	dad	d		;    
	mov	a,h
	ora	a
	ral
	jz	mov_Y_Aok	;       256
	lxi	h,0		;    
	jc	mov_Y_Aok	;     0
	dcr	l		;   255,    
mov_Y_Aok:
	shld	POSMYd	;     Y
;
	lda	POSMXd
	mov	b,a
	lda	POSMYd
	mov	c,a
;
	jmp	typ_pos_xy
;
;=============================
;    6  7 -  
;-------------------------     X    PS (6, 7) ---------
	lda		MOVMXPS	;     X
	mov	e,a
	ani	7fh
	cmp	e
	mov	e,a
	lda	POSMXd	;     X
	jz	mov_Xps_r	;   - 
;
	sub	e
	jnc	mov_Xps_ok	;    "0"
	xra	a			;    "0"
	jmp	mov_Xps_ok
;
mov_Xps_r:
	add	e
	jnc	mov_Xps_ok	;       256
	mvi	a,0ffh		;   255,    
mov_Xps_ok:
	sta	POSMXd	;     X
;
;-------------------------     Y ---------
	lda		MOVMYPS	;     Y
	mov	e,a
	ani	7fh
	cmp	e
	mov	e,a
	lda	POSMYd	;     X
	jz	mov_Yps_r	;   - 
;
	sub	e
	jnc	mov_Yps_ok	;    "0"
	xra	a			;    "0"
	jmp	mov_Yps_ok
;
mov_Yps_r:
	add	e
	jnc	mov_Yps_ok	;       256
	mvi	a,0ffh		;   255,    
mov_Yps_ok:
	sta	POSMYd	;     X
;
	lda	POSMXd
	mov	b,a
	lda	POSMYd
	mov	c,a
;
	jmp	typ_pos_xy
;
;=============================================================================
;-------------------------     X     4, 5) ---------
typ_mov_xy:
	lhld	POSMXd	;     X
	lda		MOVMX	;     X
	mov	e,a
	mvi	d,0
	ani	80h		;    
	jz	mov_X_r	;   - 
	dcr	d		;    - 
mov_X_r:
	dad	d		;    
	mov	a,h
	ora	a
	ral
	jz	mov_X_ok	;       256
	lxi	h,0		;    
	jc	mov_X_ok	;     0
	dcr	l		;   255,    
mov_X_ok:
	shld	POSMXd	;     X
;
;-------------------------     Y ---------
	lhld	POSMYd	;     Y
	lda		MOVMY	;     Y
	mov	e,a
	mvi	d,0
	ani	80h		;    
	jz	mov_Y_r	;   - 
	dcr	d		;    - 
mov_Y_r:
	dad	d		;    
	mov	a,h
	ora	a
	ral
	jz	mov_Y_ok	;       256
	lxi	h,0		;    
	jc	mov_Y_ok	;     0
	dcr	l		;   255,    
mov_Y_ok:
	shld	POSMYd	;     Y
;
	lda	POSMXd
	mov	b,a
	lda	POSMYd
	mov	c,a
;=============================================================================
;-----------------
typ_pos_xy:	;      
	mov	a,b
	sta	POSMX	;    X
	mov	a,c
	sta	POSMY	;    Y
;
;=============================================================================
;    
	call	k_on
;
;-----------------------------------------------------
;       
	call	KOD_0D1	;    1- 
	lda	MKey	;  
	call	VYV_HEX	;  HexByte
	lda	REGMX	;   
	call	VYV_HEX	;  HexByte
	lda	REGMY	;   Y
	call	VYV_HEX	;  HexByte
	lda	MOVMW	;  
	call	VYV_HEX	;  HexByte
	lda	MOVMX	;      4
	call	VYV_HEX	;  HexByte
	lda	MOVMY	;    Y  5
	call	VYV_HEX	;  HexByte
	lda	MOVMXPS	;      6
	call	VYV_HEX	;  HexByte
	lda	MOVMYPS	;    Y  7
	call	VYV_HEX	;  HexByte
;
	call	KOD_0D2	;    2- 
	lda	MKeyS	;    8
	call	VYV_HEX	;  HexByte
	lda	MOVMXS	;      9
	call	VYV_HEX	;  HexByte
	lda	MOVMYS	;    Y  10
	call	VYV_HEX	;  HexByte

;-----------------------------------------------------
;    ""    
	mvi	h,0c0h
	lda	MOVMX	;  4
	mov	l,a
	mov	m,a		;       X
	mvi	h,0c1h
	lda	MOVMY	;  5
	mov	l,a
	mov	m,a		;       Y
;
	mvi	h,0c2h
	lda	MOVMXPS	;  6
	mov	l,a
	mov	m,a		;       X
	mvi	h,0c3h
	lda	MOVMYPS	;  7
	mov	l,a
	mov	m,a		;       Y
;
	mvi	h,0c4h
	lda	MOVMXS	;  9
	mov	l,a
	mov	m,a		;       X
	mvi	h,0c5h
	lda	MOVMYS	;  10
	mov	l,a
	mov	m,a		;       Y
;
;--------------------------------------------------
;      
	call	KOD_0D4	;    3- 
	lda	regim	; 
	call	VYV_HEX	;  HexByte
	lda	POSMX	;   
	call	VYV_HEX	;  HexByte
	lda	POSMY	;   Y
	call	VYV_HEX	;  HexByte
	lda	TYPE_MOUS	;  
	call	VYV_HEX	;  HexByte
	lda	TYPE_MOVE	;  
	call	VYV_HEX	;  HexByte
;--------------------------------------------------
;
	JMP	IRQ_S	;   
;
;======================================================================
;
MKey:		.DB	0	; 80h - , 40h - , 20h - , 01h -   ""    512/256
POSMX:		.DB	128	;	   X
POSMY:		.DB	128	;	   Y
REGMX:		.DB	128	;      X
REGMY:		.DB	128	;      Y
MOVMW:		.DB	0
MKeyOld:	.DB	0	; 80h - , 40h - , 20h - , 01h -   ""    512/256
POSMXOld:	.DB	128
POSMYOld:	.DB	128
POSMXd:		.DB	128,0
POSMYd:		.DB	128,0
MOVMX:		.DB	0
MOVMY:		.DB	0
MOVMXPS:	.DB	0
MOVMYPS:	.DB	0
MKeyS:		.DB	0	; 01h - , 02h - , 04h - 
MOVMXS:		.DB	0
MOVMYS:		.DB	0
regim:		.DB	0	; 00h-256, 10h-512
TYPE_MOUS:	.DB	0	;    0 -  , 1 - 
TYPE_MOVE:	.DB	0	;     0 -  , 1 -  , 2 -   PS
;-------------------------------------------------------------------------------
;
#include "mod_port.asm"
#include "mod_util.asm"
#include "mod_char.asm"
;
	.END
