;compile sjasmplus --i8080 vids.asm, sjasmplus v1.14.2
	output xo.rom
	org $0100

;setup colors
	ld hl,38h
	ld (hl),0C9h
	ei
	halt
	ld b,15;
	ld hl,tabcol+15;
	ld sp,hl
sclp:
	ld a,b
	out (2),a ; color #
	ld a,(hl)
	out ($0C),a; loong routine for write color data
	ex (sp),hl
	ex (sp),hl
	dec hl
	dec b
	out ($0C),a
	jp p, sclp
	out (10h),a

	ld l,$7e;L=y,e=x
	ld e,a
cls: ;clear screen
	ld b,$7F
zm:
	ld (bc),a
	inc bc
	cp b
	jp nz,zm

	ld a,l
	sub e
	ld l,a
	xor e
	ld e,a

	ld b,10
plp: ;plot loop
	push bc
;	x=x-y/2
	ld a,l
	rlca
	rra
	rra
	cpl
	inc a
	add e
	ld e,a
;	y=y+x/2
	rlca
	rra
	rra
	add l
	ld l,a
;plot for D=y,e=x
;bit weight
	ld a,7
	and e
	ld b,a
	xor e
	rrca
	rrca
	scf
	rra
	ld h,a

	ld a,1
blp:
	rrca
	dec b
	jp p,blp
	ld c,a

	inc d
	ld b,d
;put dot with color
colp:
	ld a,b
	rrca
	ld b,a
	ld a,(hl)
	jp nc,notsetb
	or c
	db 0DAh		;jp c
notsetb
	or c
	xor c
	ld (hl),a
	ld a,20h
	add a,h
	ld h,a
	jp nc,colp

	pop bc
	dec bc
	ld a,b
	or c
	jp nz,plp
	jp cls
tabcol ; color data BBGGGRRR
		db 00000000b
		db 10000000b
		db 00000101b
		db 10000101b
		db 00101000b
		db 10101000b
		db 00101101b
		db 10101101b
		db 00000000b
		db 11000000b
		db 00000111b
		db 11000111b
		db 00111000b
		db 11111000b
		db 00111111b
		db 11111111b
