	device zxspectrum128
        ORG #4000
	incbin "3.scr"
        ORG #6400
begin
texture:
 db 0,0,0,0,0,0,0,0

PLOTTBL EQU #6000
 ld sp,$BFE0

; call FORMER
;gen texture
 ld hl,texture
 ld a,$AA
 ld b,8
gent:ld (hl),a:inc l:cpl:djnz gent

;copy to buffer
 ld hl,$4000,de,$C000,bc,6912:ldir

;-----------------------------------------------------------------------
test
   ld h,24              ; start pixel at centre of screen
   ld l,104

 call flood2
 jr $

; byte at a time fill
; h = y coord, l = x coord

flood2
   ld a,h
   call SPGetScrnAddr    ; b = pixel mask
   ex de,hl              ; hl = screen address

fill
   call Bytefill         ; wiggle around incoming pixel mask
   ret nc                ; if incoming pixels hit boundary, ret

up
   push hl               ; save screen address
   call SPPixelUp        ; move up one pixel
   jr c, offscreen1
   push bc               ; save pixel mask
   call fill             ; try to fill from new screen position
   pop bc                ; moving up, pixel mask remains same
offscreen1
   pop hl

down                    ; a replay of up
   push hl
   call SPPixelDown
   jr c, offscreen2
   push bc
   call fill
   pop bc
offscreen2
   pop hl

right
   bit 0,b               ; if first pixel in mask set, try right
   jr z, left
   inc l                 ; move right one byte
   ld a,l                ; have we wrapped off screen?
   and $1f               ; (if so, CCCCC=0 now)
   jr z, offscreen3
   push bc               ; save current pixel mask
   ld b,$80              ; new incoming mask = leftmost pixel set
   call fill             ; fill from new screen position
   pop bc
offscreen3
   dec l

left                    ; a replay of right
   bit 7,b
   ret z
   ld a,l
   and $1f
   ret z
   dec l
   ld b,$01
   call fill
   inc l
   ret

; enter: HL = valid screen address
; exit : Carry = moved off screen
;        HL = moves one pixel up
; used : AF, HL

SPPixelUp
   ld a,h
   dec h
   and $07
   ret nz
   ld a,$08
   add a,h
   ld h,a
   ld a,l
   sub $20
   ld l,a
   ret nc
   ld a,h
   sub $08
   ld h,a
   cp $40
   ret

SPGetScrnAddr
   and $07    ; A = 00000SSS
   or $40     ; A = 01000SSS
   ld d,a     ; D = 01000SSS
   ld a,h     ; A = Y coord = BBLLLSSS
   rra
   rra
   rra        ; A = ???BBLLL
   and $18    ; A = 000BB000
   or d       ; A = 010BBSSS
   ld d,a     ; D = 010BBSSS top 8 bits of address done

   ld a,l     ; A = X coord = CCCCCTTT
   and $07    ; A = 00000TTT
   ld b,a     ; B = 00000TTT = which pixel?
   ld a,$80   ; A = 10000000
   jr z, norotate   ; if B=0, A is the right pixel so skip

rotloop
   rra        ; rotate the pixel right one place B times
   djnz rotloop

norotate
   ld b,a     ; B = pixel mask
   srl l 
   srl l
   srl l      ; L = 000CCCCC
   ld a,h     ; A = Y coord = BBLLLSSS
   rla
   rla        ; A = LLLSSS??
   and $e0    ; A = LLL00000
   or l       ; A = LLLCCCCC
   ld e,a     ; E = LLLCCCCC
   ret        ; DE = 010BBSS LLLCCCCC, the screen address!

; hl = screen address
;  b = incoming pixel mask

Bytefill
   ld a,b         ; get pixel mask
   xor (hl)       ; zero out incoming pixels that
   and b          ; run into set pixels in display
   ret z          ; if no pixels left, ret

bfloop           ; carry flag never set here
   ld b,a         ; b = incoming pixels
   rra            ; expand incoming pixels
   ld c,a         ; to the right and left
   ld a,b         ; within byte
   add a,a
   or c
   or b           ; a = incoming pixels wiggled
   ld c,a         ; save in c
   xor (hl)       ; zero out pixels that run into
   and c          ; set pixels on display
   cp b           ; have pixels changed from last loop?
   jr nz, bfloop  ; keep going until incoming does not change

   or (hl)
   ld (hl),a      ; fill byte on screen
   scf            ; indicate that this was a viable step
   ret

SPPixelDown
 INC           H
 LD            A ,H
 AND           $07
 RET           NZ

 LD            A ,H
 SUB           $08
 LD            H ,A
 LD            A ,L
 ADD           A ,$20
 LD            L ,A
 RET           NC

 LD            A ,H
 ADD           A ,$08
 LD            H ,A
 CP            $58
 CCF
 RET

end
	display /d,end-begin
	savesna "!void.sna",begin

