                ; i8080 assembler code
                .project 86.rk
                .tape rk-bin

                line		equ 78
                row		equ 30
                
                dma_size        equ line * row - 1

                KR580VG75       equ $C000 ; $EF00
                KR580VT57       equ $E008 ; $F008
                KR580VV55       equ $8000 ; $ED00 
                KR580VI53       equ $9000
                
                restart         equ $F800

                org 0


		; Видеорежим:
		; https://www.computer-museum.ru/technlgy/i8275.htm
		; https://zx-pk.ru/threads/35112-radio86rk-opyat-pro-vg75-i-nestandartnye-rezhimy.html
		; https://ruecm.forum2x2.ru/t724-topic

                LXI HL, KR580VG75 + 1

		; Скрываем курсор

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		; Останов КР580ВГ75

		INR L
		MVI M, 0
		DCR L

        	MVI M, line - 1	; Столбцы
        	MVI M, row - 1  ; Строки
        	MVI M, $99	; Позиция курсора и кол-во линий в знакоместе
        	MVI M, $93 + 64	; 0101.0011

		; Старт КР580ВГ75

		INR L
        	MVI M, 027h
 		
		CALL VG75_READY

                ; Настройка ПДП
                ; https://www.computer-museum.ru/technlgy/ik57.htm

                LXI HL, KR580VT57
		MVI M, $80
		MVI L, $04
		MVI M, screen & $00ff
		MVI M, screen >> 8

		INR L
		MVI M, dma_size & 0x00ff
		MVI M, $4000 + dma_size >> 8
		MVI L, 8
		MVI M, $A4

                LXI DE, image
                LXI BC, screen
                CALL DZX0

		; Опрос клавиавтуры
                LXI H, KR580VV55
                MVI M, 11111110b

MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY

		; Счетчик-делитель

		LXI H, clock
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA clock
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA clock
		ANI 1
		CNZ X2_

                ; X4
		LDA clock
 		ANI 3
		CZ X4

                JMP MAIN

X1:

		RET

X2:

		RET

X2_:

                RET

X4:
                LDA KR580VV55 + 1
                CPI 11111011b
                JZ restart

		RET


DZX0:
		LXI H, $FFFF
		PUSH H
		INX H
		MVI A, $80
		
        DZX0_LITERALS:
        
		CALL DZX0_ELIAS
		CALL DZX0_LDIR
		JC DZX0_NEW_OFFSET
		CALL DZX0_ELIAS
		
        DZX0_COPY:
        
		XCHG
		XTHL
		PUSH H
		DAD B
		XCHG
		CALL DZX0_LDIR
		XCHG
		POP H
		XTHL
		XCHG
		JNC DZX0_LITERALS
		
        DZX0_NEW_OFFSET:
        
		CALL DZX0_ELIAS
		MOV H, A
		POP PSW
		XRA A
		SUB L
		RZ
		PUSH H
		RAR\ MOV H, A
		LDAX D
		RAR\ MOV L, A
		INX D
		XTHL
		MOV A, H
		LXI H, $0001
		CNC DZX0_ELIAS_BACKTRACK
		INX H
		JMP DZX0_COPY
		
        DZX0_ELIAS:
        
		INR L
		
        DZX0_ELIAS_LOOP:
        
		ADD A
		JNZ DZX0_ELIAS_SKIP
		LDAX D
		INX D
		RAL
		
        DZX0_ELIAS_SKIP:
        
		RC
		
        DZX0_ELIAS_BACKTRACK:
        
		DAD H
		ADD A
		JNC DZX0_ELIAS_LOOP
		JMP DZX0_ELIAS

        DZX0_LDIR:
        
		PUSH PSW
		
        DZX0_LDIR1:
        
		LDAX D
		STAX B
		INX D
		INX B
		DCX H
		MOV A, H
		ORA L
		JNZ DZX0_LDIR1
		POP PSW
		ADD A
		
		RET


VG75_READY: 	
		; Ждем обратный ход

                LXI HL, KR580VG75 + 1
		MOV A, M
VG75_WAIT: 
		MOV A, M
                ANI 020h
                JZ VG75_WAIT
                RET

clock:          db 0

image:

		db $96, $00, $9F, $17, $F0, $E5, $F2, $FB, $FB, $F8, $DF, $DA, $D4, $3D, $F4, $E5, 
		db $FC, $AF, $F1, $FE, $5F, $8C, $78, $EC, $0F, $E0, $69, $00, $0E, $64, $11, $FD, 
		db $FD, $5E, $7C, $D8, $C9, $C8, $28, $17, $10, $E0, $AC, $E4, $64, $F3, $FC, $C7, 
		db $50, $DC, $44, $D5, $C8, $A5, $00, $7F, $7F, $84, $0F, $64, $11, $F9, $FD, $FE, 
		db $C3, $F4, $14, $F5, $FE, $5F, $65, $DA, $FE, $03, $55, $7C, $64, $6E, $20, $FE, 
		db $18, $00, $E3, $70, $65, $72, $73, $6F, $6E, $61, $6C, $78, $6E, $79, $6A, $20, 
		db $6B, $6F, $6D, $70, $78, $60, $74, $65, $72, $20, $72, $61, $64, $69, $6F, $6C, 
		db $60, $62, $69, $E7, $6C, $71, $CC, $94, $C0, $2C, $0C, $D6, $C8, $0A, $6D, $69, 
		db $6B, $72, $E7, $70, $FB, $63, $65, $73, $32, $B9, $D9, $F6, $2E, $FE, $E1, $20, 
		db $D3, $E3, $35, $38, $30, $77, $6D, $F9, $61, $20, $90, $64, $61, $E3, $6F, $62, 
		db $27, $65, $6D, $F5, $7A, $75, $DF, $6E, $64, $64, $61, $31, $36, $20, $28, $33, 
		db $32, $29, $20, $6B, $62, $61, $6A, $74, $52, $81, $70, $2E, $32, $70, $1D, $D1, 
		db $90, $5D, $AC, $9A, $67, $21, $7F, $CB, $6D, $6D, $6E, $6F, $65, $B0, $70, $87, 
		db $93, $39, $7E, $65, $6E, $69, $65, $3A, $93, $BA, $61, $90, $5C, $DA, $1C, $2D, 
		db $AE, $6D, $7B, $61, $74, $6F, $72, $3D, $64, $42, $31, $69, $6E, $B2, $34, $B1, 
		db $7F, $65, $74, $61, $58, $23, $B9, $6A, $73, $0B, $29, $61, $D0, $64, $3A, $71, 
		db $64, $BE, $6B, $6E, $AB, $74, $6B, $CD, $5B, $C8, $52, $69, $61, $73, $73, $AC, 
		db $6D, $62, $6C, $72, $C1, $2C, $2F, $14, $FE, $54, $C6, $BC, $14, $7D, $64, $11, 
		db $5B, $F3, $75, $90, $04, $C0, $00, $20

screen: 