FS_RST:
;	call SD_INIT
;	ret

SD_INIT:
	call ch376reset
	rc

	mvi c,7
	call usb_setmode

	mvi c,6
	call usb_setmode

	lxi h, connect
	call PRINT
	mvi a,CMD_DISK_CONNECT
	call sendcmd
	cpi 14h
	jz rst1
	lxi h,noconn
	call	PRINT
	stc
	ret
rst1:
	lxi h, mount
	call PRINT
	mvi a,CMD_DISK_MOUNT
	call sendcmd
	call readbufdir
	lxi h,BUFDIR+8
	call PRINT		;print device id
	lxi h, maxlun
	call PRINT
	mvi a,CMD_DISK_MAX_LUN
	call sendcmd
	call readbufdir
	lxi h,BUFDIR
	mov a,m
	sta M_LUN
	call PRHEX		;print maxlun

;******

	lxi h,LINEBUF+2
	call R65
	lda M_LUN	;maxlun
	ani 0fh
	mov c,a
	lda LINEBUF+24	;lun from cmdline
	rlc
	rlc
	rlc
	rlc
	ani 0f0h
	ora c	
	mov c,a

	mvi a,CMD_WRITE_VAR8
	sta CMD_PORT
	mvi a,VAR_UDISK_LUN
	sta DATA_PORT
	mov a,c
	sta DATA_PORT

	lxi h, mount
	call PRINT
	mvi d,5			;mount retries
rst3:
	push d
	mvi a,CMD_DISK_MOUNT
	call sendcmd
	pop d
	cpi 14h
	jz rst4
	mvi c,'.'
	call PUTC
	lxi b,0
	call delayb
	dcr d
	jnz rst3
	lxi h, ERR
	call PRINT
	stc
	ret	
rst4:
	call setroot
	lxi h, lun
	call PRINT
	mvi a,CMD_READ_VAR8
	sta CMD_PORT
	mvi a,VAR_UDISK_LUN
	sta DATA_PORT
	lda DATA_PORT
	rrc
	rrc
	rrc
	rrc
	ani 0fh
	call PRHEX		;print lun
        ret

setroot:
	lxi h, SLASH
	SHLD CWD
	lxi d,eol
	call F_OPEN
	lxi d,root
	call F_OPEN
	ret

sendcmd:
	sta CMD_PORT

wait_int:
	lda CMD_PORT
	ani 80h
	jnz wait_int

getstatus:
	mvi a, CMD_GET_STATUS
	sta CMD_PORT
	lda DATA_PORT
	ret

setfname:
        mvi a,CMD_SET_FILE_NAME
	sta CMD_PORT
writeblock:
	ldax d
	cpi ','
	jnz wblk1
	xra a
wblk1:	sta DATA_PORT
	ora a
	rz
	inx d
	jmp writeblock


;printstatus:
;	lxi h,status
;	call PRINT
;	call getstatus
;	push psw
;	call PRHEX
;	pop psw
;	ret

readbufdir:
        lxi h,BUFDIR
readbuffer:
	mvi a,CMD_RD_USB_DATA0
	sta CMD_PORT
	lda DATA_PORT
	ora a
	rz		;nothing to read
	mov d,a		;byte counter
;	call PRHEX
rdb0:
	lda DATA_PORT
	mov m,a
	inx h
	dcr d
	jnz rdb0
        ret

F_CLOSE:			;input - c=0 - no update, c=1 - update filesize
	mvi a,CMD_FILE_CLOSE
	sta CMD_PORT
	mov a,c
	sta DATA_PORT
	call wait_int
	jmp setpath

F_OPEN:
FS_FNDF:
	call setfname
	mvi a, CMD_FILE_OPEN
fndf1:
	sta CMD_PORT
	call wait_int
	cpi USB_INT_DISK_READ
	jz fndf2
	cpi USB_INT_SUCCESS
	jz fndf3
	stc
	ret
fndf3:
	mvi a,CMD_DIR_INFO_READ
	sta CMD_PORT
	mvi a,255		;current open file
	sta DATA_PORT
	call wait_int
	cpi USB_INT_SUCCESS
	jz fndf2
	stc
	ret
fndf2:
	call readbufdir
	lxi h,BUFDIR
	ora a
	ret

FS_FNDN:
	mvi a, CMD_FILE_ENUM_GO
	jmp fndf1

F_READ:
	mvi a,CMD_BYTE_READ
	sta CMD_PORT
	mov a,c
	sta DATA_PORT
	mov a,b
	sta DATA_PORT	;set bytes to read - 64k max
frd1:	call wait_int
	cpi USB_INT_DISK_READ
	rnz
	call readbuffer
	mvi a,CMD_BYTE_RD_GO
	sta CMD_PORT
	jmp frd1

F_WRITE:
	mvi a,CMD_BYTE_WRITE
	sta CMD_PORT
	mov a,c
	sta DATA_PORT
	mov a,b
	sta DATA_PORT	;set bytes to write - 64k max
fwr1:	call wait_int
	cpi USB_INT_DISK_WRITE
	rnz
	mvi a,CMD_WR_REQ_DATA
	sta CMD_PORT
	lda DATA_PORT	;bytes to write
	ora a
	rz
	mov d,a

fwr2:	mov a,m
	sta DATA_PORT
	inx h
	dcr d
	jnz fwr2

	mvi a,CMD_BYTE_WR_GO
	sta CMD_PORT
	jmp fwr1

	ret

C_DEL:
	lxi d,LINEBUF+4
	call F_OPEN
	cpi ERR_OPEN_DIR
	jnz del1
	lxi h,ERR
	call PRINT
	mvi c,0
	jmp F_CLOSE
	
del1:	mvi a,CMD_FILE_ERASE
	call sendcmd
	push psw
	call setpath
	pop psw
	cpi USB_INT_SUCCESS
	lxi h, RWR_OK
	jz PRINT
	cpi ERR_MISS_FILE
	jz C_DIRNO
	jmp PRHEX

;
; DE - 뫪   ४ਨ
;
FS_CHDIR:
	LDAX D
	SUI SLASH	; ="\" or "/"
	JNZ FS_CD1
	STA CWD+1	;store 0 to cwd+1
	push d
	call setroot	;set root dir if cmd starts with \
	pop d
	INX D
	LDAX D
	ORA A
	RZ		; 室  ७, ᫨ ᫥ "\"  00h

FS_CD1:	PUSH D

FS_CD2:	LDAX D
	ORA A
	JZ	FS_CD3	; >>  ப
	INX D
	SUI SLASH	; ="\"
	JNZ	FS_CD2	; 饬  ப  "\"
	DCX D
	STAX D
	INX D		; १  譥

FS_CD3:			; । ᮪ 
	XCHG		; HL =  ப
	POP D		; DE = 砫

	PUSH H
	PUSH D

	call setfname
	mvi a, CMD_FILE_OPEN
	call sendcmd
	cpi ERR_OPEN_DIR
	stc
        POP B
        jnz FS_CD4
	ora a
FS_CD4:	POP D
	RC		;not found or not dir

	PUSH D

;	PUSH B
;	POP D
	mov d,b
	mov e,c

	LXI H,CWD
	MOV A,M
	INX H		; <-(1)
	MOV B,A
	MOV A,M
	ORA A
	JNZ $-4		; (1)->

	LDAX D
	CPI '.'
	JNZ	FS_CD5	;  窠 - 塞  騩 
	INX D
	LDAX D
	CPI '.'
	JNZ	FS_CD6	; ᫨   窠 - ਬ
	DCX H		; <-(2)
	MOV A,M
	MVI M,0
	CPI SLASH	; = "\"
	JNZ $-6		; (2)->
	STA CWD
	JMP FS_CD6

FS_CD5:	MOV A,B
	CPI SLASH
	JZ $+6		; ->(3)
	MVI M,SLASH
	INX H		; <-(3)
	CALL	STRCPY	; >>

FS_CD6:	POP D
	LDAX D
	ORA A
	JNZ	FS_CD1	;᫥騩 ᮪
	RET

SD_OFF:
	mvi c,0
	call F_CLOSE
	mvi c,4
	call usb_setmode
	ret

STRCHR: MOV A,M		;seek char(C) in null terminated string [HL]
	CMP C
	RZ
	ORA A
	STC
	RZ		;set c flag if not found
	INX H
	JMP STRCHR

STRCPY: LDAX D		;copy null terminated string [DE]->[HL]
	MOV M,A
	ORA A
	RZ
	INX D
	INX H
	JMP STRCPY

ch376reset:
	mvi a,CMD_RESET_ALL
	sta CMD_PORT  		;reset ch376
	mvi d,80h
w1:
	lxi b,100h
	call delayb
	lda CMD_PORT
	ani 10h
	jz w2
	dcr d
	jnz w1
	lxi h,no
	call PRINT			;ch376 not found
	stc
	ret

w2:	mvi a,CMD_CHECK_EXIST
	sta CMD_PORT
	mvi a,55h
	sta DATA_PORT
	lda DATA_PORT
	cpi 0aah
	lxi h,no
	jz w3
	call PRINT			;error
	stc
	ret

w3:	lxi h,exist
	call PRINT
	mvi a, CMD_GET_IC_VER
	sta CMD_PORT
	lxi h, version
	call PRINT
	lda DATA_PORT
	call PRHEX
;	call PRINT_NEWLINE
	ora a
	ret

usb_setmode:
	mvi a,CMD_SET_USB_MODE
	sta CMD_PORT
	mov a,c			;usb mode
	sta DATA_PORT
sm1:	lda DATA_PORT		;get status
	cpi CMD_RET_ABORT
	jz set_err
	cpi CMD_RET_SUCCESS
	jnz sm1
	ora a
	ret
set_err:
	call PRHEX
	lxi h,mode
	call PRINT		;print setmode error
	stc
	ret

delayb:
	dcx b
	mov a,b
	ora c
	jnz delayb
	ret

root: DB SLASH
eol: DB 0
no: DB "NO "
exist:	DB "CH376 FOUND. ",  0
present: DB 0dh,0ah,"FILE EXISTS",0
version: DB "CHIP ID: ",0
;status: DB  " INT STATUS: ",0
connect: DB 0dh,0ah, "DISK CONNECT",0
mount: DB 0dh,0ah,"DISK MOUNT: ",0
maxlun: DB 0dh,0ah,"MAX "
lun: DB "LUN ",0
noconn: DB " USB DISCONNECTED", 0dh, 0ah,0