#include "defs.inc"
#include "ch376inc.h"

;RKS header

;  ORG START_ADDR-4
;  DW START_ADDR
;  DW END_ADDR
;  DB 00,70h,0ffh,7fh

  ORG START_ADDR
; 0xCB7F  => BC=crc

;CALL FS_FNDF ; DE - name of file for finding, out HL - string FAT record of file
;CALL F_OPEN ; DE - name of file for opening, out C==1 if file not founded
;CALL F_READ ; HL - addr for store readed data, BC - size of readed data

ENTRY:

;#ifdef GAL
;  ORG START_ADDR-10
;  DB 0,0,0,0,0
;  DB 0A5h
;  DB 00,70h,0ffh,7fh
;#endif

#ifdef RK86
#ifdef SD_ROM
#else
  jmp 0f800H
  nop
#endif
#endif


#ifdef TRS80
  call 001c9H  ;   
  mvi a,20h
  STA 4022h
#endif

#ifdef MX2
  call 0c84eH  ;   
#endif

#ifdef ORION
  mvi A,01fh
  call 0f80fh ;clear screen
#endif

;#ifdef STD
;  ORG START_ADDR-4
;  DB 00,0d0h,0d0h,0d8h
;  LXI SP,0F6CFH
;#endif

;=============================================
;print version

#ifdef SD_DBG_PRINT0 
  LXI H,TSD_INIT
  CALL PRINT
#endif
;=============================================
BEGIN:
;clear buffer

	lxi h,BUF
	lxi b,ENDBUF-BUF
	call clrmem

;init card 

	CALL FS_RST	    ;init controller

LOOP:
;	call  PRINT_NEWLINE
;	lxi h,0
;	dad sp
;	call 0cc6ch
 
	lxi b,38H         ;clear linebuf
	LXI H,LINEBUF
	call clrmem

;LOOP0:
;	mvi m,0
;	inx h
;	DCR C             
;	JNZ LOOP0

	LXI H,A_DRIVE
	CALL PRINT        ;print drvletter
	LXI H,CWD
	CALL PRINT        ;print current dir
	MVI C,'>'
	CALL PUTC         ;print >

	CALL READLN       ;get line from kbd
	LXI H,LOOP        ;return addr from commands
	PUSH H
	LXI H,CMDLST	  ;cmd list
LOOP1:  MOV A,M
	ORA A
	JZ RUNFILE        ;command not found - assuming filename
	LXI D,LINEBUF
LOOP2:  MOV A,M
	ORA A
	JZ LOOP3          ;end of current cmd in cmdlist
	LDAX D
	CMP M
	JNZ LOOP4         ;cmd != line buffer
	INX D
	INX H
	JMP LOOP2         ;continue

LOOP3:  LDAX D
	ORA A
	JZ LOOP5          ;end of line in line buffer
	CPI 20H
	JZ LOOP5

LOOP4:  MOV A,M
	INX H
	ORA A
	JNZ LOOP4         ;skip to end of cmd
	INX H
	INX H             ;skip current cmd jump addr
	JMP LOOP1         ;try next cmd

LOOP5:  INX H
	MOV E,M
	INX H
	MOV D,M            ;get cmd jump address to de

#ifdef GAL
  call 02edH
#else
  CALL PRINT_NEWLINE
#endif
	XCHG
	PCHL               ;jmp to cmd, will return to loop


PRINTN: MOV C,M
  INX H
  CALL PUTC
  DCR B
  JNZ PRINTN
  RET

clrmem:
	mvi m,0
	inx h
	dcx b
	mov a,c
	ora b
	jnz clrmem
	ret

C_DIR:			;dir command
	CALL IfKeyPress
	CPI 0FFH
	JNZ $-5         ;wait key release

	LXI D,LINEBUF+2
	INX D
	LDAX D
	CPI 20H
	JZ $-4
	ORA A
	JNZ $+6
	LXI D,ALLFILS
	CALL FS_FNDF
	JC C_DIRNO	;no files
C_DIR1:
	PUSH H
	LXI B,11	;8+3
	DAD B
	MOV A,M		;attribs
	POP H
	ANI 8		;volume label - skip
	JNZ C_DIR2
	MVI B,8
	CALL PRINTN	;print 8 chars = filename
	MVI C,' '
	CALL PUTC	;print space
	MVI B,3
	CALL PRINTN	;print 3 chars = ext
	MVI C,' '
	CALL PUTC	;print space
	mov A,M		;attribs
	ani 010H        
	jz C_DIR11      ;not a dir
	LXI H,NODIR+4	;DIR
	CALL PRINT
	jmp C_DIR12	;next entry
C_DIR11:
	mov A,L

#ifdef full_size

	aci 014H
	mov L,A
	mov A,M
	call PRHEX
	dcx H
	mov A,M
	call PRHEX	;print file size hi word
	dcx H
#else
	aci 012H
	mov L,A
#endif
	mov A,M
	call PRHEX
	dcx H
	mov A,M
	call PRHEX	;print file size lo word
C_DIR12:
	CALL IfKeyPress	;    
	CPI 0FFH	;         
	JZ C_DIR3
	call GETC
	cpi dir_exit	;
	rz
C_DIR3:
	CALL PRINT_NEWLINE
C_DIR2: CALL FS_FNDN
	JNC C_DIR1
	RET

C_DIRNO_POPH:
	pop H
C_DIRNO:
	LXI H,NOFILES
  	JMP PRINT

C_CD:	LXI H,LINEBUF+1
C_CD0:	INX H
	MOV A,M
	CPI 20H
	JZ C_CD0	;skip spaces at start of line
	ORA A
	JNZ C_CD1
	CALL PRINT_NEWLINE
	LXI H,CWD
	JMP PRINT	;print current path
C_CD1:
	XCHG            ;de=dir to go
	CALL FS_CHDIR	;set dir
	JC C_CD2	;no dir

#ifndef CH376		;ch376 cannot go back dir tree, cd .. not working
	ret
#else

setpath:
	lxi d,CWD
	lxi h,LINEBUF
	call STRCPY
	lxi d,LINEBUF
	call FS_CHDIR
	rnc
#endif

C_CD2:	LXI H,NODIR
	JMP PRINT

C_I:                    ;reinit card

#ifdef CH376
	call FS_RST
	pop h
	jmp LOOP
#else
	CALL SD_OFF
	pop H
	JMP BEGIN
#endif

C_X: 			;exit to monitor
  CALL SD_OFF
#ifdef MX2
  JMP 0F800H
#endif

#ifdef STD
  JMP 0C800H
#endif

#ifdef APOGEE
  JMP 0F800H
#endif

#ifdef RK86
  JMP 0F800H
#endif

#ifdef UT88
  JMP 0F800H
#endif

#ifdef GAL
  pop D ;garbage read
  ret   ;return to promt
#endif

#ifdef TRS80
  pop D ;garbage read
  LXI B,01a18H
  jmp 019AEh
;  ret   ;return to promt
#endif

#ifdef ORION
  JMP 0F800H
#endif

#ifdef RWR ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
C_RWR: 
	LXI H,LINEBUF+2      ;filename
C_RWR1: 
	MOV A,M
	CPI 0
	JZ C_RWR2
	CPI ','
	INX H
	JNZ C_RWR1
C_RWR2:			;0h or , in buffer
	CALL R65        ;get start and len from cmdline
	LXI H,ERR
	JC PRINT
			;here we got cmdline and addresses

	lda LINEBUF
	cpi 'R'
	lxi d,LINEBUF+2	;filename
	jnz C_RWR3	;write
	call FS_FNDF
	JC C_DIRNO	;no file
	shld LINEBUF+28	;pointer to fat record

#ifndef CH376		;for ch376 FS_FNDF==F_OPEN
	lxi d,LINEBUF+2
	call F_OPEN
	JC C_DIRNO	;no file
#endif
	call getlen
	jnz c_rwr5	;file size from cmdline !=0

	lhld LINEBUF+28
	lxi b,1ch
	dad b		;set pointer to file size
	mov c,m
	inx h
	mov b,m         ;get file size to bc

c_rwr5:			;bc=size to load
	LHLD LINEBUF+24 ;   
	CALL F_READ
	mvi c,0		;no update on file read
	JMP C_RWR4
C_RWR3:			;write file
	call getlen
	lxi h,ERR
	jz PRINT	;len cannot be 0

#ifndef CH376
	call F_OPEN
	jc C_DIRNO	;file not found
#else
	lda LINEBUF+1
	lxi d,LINEBUF+3	;filename for WA, WO
	cpi 'O'		;WO - overwrite
	jz create
	cpi 'A'		;WA - append
	jz append
	dcx d		;set to LINEBUF+2

norm:          		;W - normal write
	call F_OPEN
	lxi d,LINEBUF+2
	jc create	;file not found - creating
        lxi h,present
	call PRINT
	jmp F_CLOSE

append:
	call F_OPEN
	lxi d,LINEBUF+3
	jc create
	mvi a,CMD_BYTE_LOCATE
	sta CMD_PORT
	mvi a,255
	lxi d,DATA_PORT
	stax d
	stax d
	stax d
	stax d		;set pointer to end of file
	call wait_int
	cpi USB_INT_SUCCESS
	lxi h,ERR
	jnz PRINT	;byte_locate failed
	jmp fwrite		
create:
	call setfname
	mvi a,CMD_FILE_CREATE
	call fndf1	;create file - deletes file if exists
#endif

fwrite:
	call getlen     ;bc = file size
	LHLD LINEBUF+24 ;   
	CALL F_WRITE
	mvi c,1		;update file size on write
C_RWR4: 

#ifdef CH376
	CALL F_CLOSE
#endif
	LXI H,RWR_OK
	JMP PRINT
getlen:			;get cmdline file size to bc
	LHLD LINEBUF+26	;size 
	MOV  C,L
	MOV  B,H
	mov a,b
	ora c
	ret

#endif ;!!!!!!!!!!!!!!!!!!!!!!!!!!!

#ifdef ORION
#include "dos_orion_RUNF.inc"
#endif

#ifdef MX2
#include "dos_mx_RUNF.inc"
#endif

#ifdef STD
#include "dos_std_RUNF.inc"
#endif

#ifdef GAL
#include "dos_gal_RUNF.inc"
#endif

#ifdef TRS80
#include "dos_trs_RUNF.inc"
#endif

#ifdef APOGEE
#include "dos_rk_RUNF.inc"
#endif

#ifdef RK86
#include "dos_rk_RUNF.inc"
#endif

#ifdef UT88
#include "dos_rk_RUNF.inc"
#endif

READLN:
	LXI H,LINEBUF
READL1:
	CALL GETC
	CPI 8         ;backspace
	JZ READL3
	CPI 5FH
	JZ READL3
	CPI 18H
	JZ READL4
	MVI M,0
	CPI 0DH
	RZ            ;cr pressed - exit, 0h in end of buffer

#ifdef GAL
	CPI 1DH       
	JNZ READL5    
	DCX H         
	JMP READL2    
READL5:
#endif
	MOV M,A
	INX H            ;store key code to buffer
READL2: MOV C,A
	CALL PUTC
	JMP READL1       ;print key char and continue
READL3:
	MOV A,L
	CPI LINEBUF & 255
	JZ READL1
	MVI C,8
	CALL PUTC
	MVI C,20H
	CALL PUTC
	MVI C,8
	CALL PUTC
	DCX H
	JMP READL1
READL4:
	MOV A,M
	ORA A
	JZ READL1
	CPI 0DH
	JZ READL1
	INX H
	JMP READL2

;**********************************************
#ifdef RWR ;!!!!!!!!!!!!!!!!!!!!!!!!!!!


;**********************************************
;    
;**********************************************
R65:
	XCHG
#ifdef MX2

;	call SET_LAST_SPACE

SET_LAST_SPACE:
	INX D
	push D
	mvi c,0AH
R66:
	LDAX D
	CPI 0
	JNZ R68
	MVI A,20H
	STAX D
	JMP R67
R68:
	INX D
	DCR C
	JNZ R66
R67:
	pop D
;	ret

	call 0c839H ;     DE  ,   HL
	shld LINEBUF+24
	RC
	call 0c839H ;     DE  ,   HL
	shld LINEBUF+26
	ret

#else

	LXI  H,0
	shld LINEBUF+24
	shld LINEBUF+26
	CALL R7C 
	shld LINEBUF+24
	RC
	CALL R7C 
	shld LINEBUF+26
	ret

;*********************************************
;   16 
;*********************************************
R7C:  
      LXI  H,0 
      MVI  B,0
R7F:  
      LDAX D
      INX  D
      CPI  00H
      JZ   R7E    ;return ok
      CPI  ','
      RZ          ;return ok
      CPI  20H
      JZ   R7F    ;skip spaces
      SUI  30H
      JM   R79    ;<"0" - err
      CPI  0AH
      JM   R80    ;<3ah - digit
      CPI  11H
      JM   R79    ;<"A" - err
      CPI  17H
      JP   R79    ;>"F" - err
      SUI  07H    ;get 0ah-0fh
R80:
      MOV  C,A
      DAD  H
      DAD  H
      DAD  H
      DAD  H      ;shift hl
      JC   R79    ;?
      DAD  B      ;add symbol
      JMP  R7F    ;next symbol
R79:
      STC
R7E:
      RET
#endif
#endif ;!!!!!!!!!!!!!!!!!!!!!!!!!!!

;*********************************************
PRINT_NEWLINE:
  LXI H,NEWLINE
  JMP PRINT
;  RET


NODIR:  DB 0DH,"NO " 
CMDLST: DB "DIR",0
        DW C_DIR
        DB "CD",0
        DW C_CD
        DB "X",0
        DW C_X
        DB "I",0
        DW C_I

#ifdef CH376
        DB "WO",0
        DW C_RWR	;write-overwrite
        DB "WA",0
        DW C_RWR	;write-append
        DB "DEL",0
        DW C_DEL	;delete file
#ifdef help
        DB "?",0
        DW C_HELP
#endif
#endif

#ifdef RWR ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
        DB "R",0
        DW C_RWR
        DB "W",0
        DW C_RWR

#ifdef GAL
        DB "WB",0
        DW C_WB
#endif

#ifdef ORION
        DB "L",0
        DW C_LRD
        DB "S",0
        DW C_SRD
#endif

#ifdef MX2
        DB "L",0
        DW C_LRD
        DB "S",0
        DW C_SRD
#endif

#endif ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
        DB 0


#ifdef CH376

#include "376proc.inc"

#else

#include "sd_proc.inc"
#include "fs_proc.inc"

#endif

#ifdef CH376
#ifdef help
C_HELP:
	lxi h,helptext
	jmp PRINT
helptext:
DB "NAME - RUN FILE",new_line
DB "DIR [MASK] - DIR LISTING",new_line
DB "CD - CHANGE DIR",new_line
DB "R NAME[,START][,LEN] - READ FILE",new_line
DB "W NAME,START,LEN - WRITE FILE",new_line
DB "WO NAME,START,LEN - OVERWRITE FILE",new_line
DB "WA NAME,START,LEN - APPEND FILE",new_line
DB "DEL NAME - DELETE FILE",new_line
DB "I [LUN] - INIT DISK [LUN]",new_line
DB "X - EXIT",new_line
DB "? - HELP",new_line,0
#endif
#endif

#ifdef SD_DBG_PRINT0
TSD_INIT: DB new_line,SDOS_VER,new_line,0
#endif

NEWLINE: DB new_line,0

#ifdef GAL
A_DRIVE:DB "A:",0
NOFILES:DB "NO FILE(S)",0DH,0
#else
#ifdef TRS80
A_DRIVE:DB "A:",0
NOFILES:DB "NO FILE(S)",0DH,0
#else
A_DRIVE:DB 0DH,0AH,"A:",0
NOFILES:DB "NO FILE(S)",0
#endif
#endif

#ifdef CH376
mode: DB 0dh, 0ah, "SETMODE "	;for ch376
#endif

ERR:    DB "ERR",0DH,0
RWR_OK: DB "OK",0DH,0
ALLFILS:DB "*",0


DOTRK:  DB RK_EXT,0

#ifdef MX2
DOTRKS: DB ".RKS",0
M2MON:  DB "M2_C000.MON",0
#endif

#ifdef UT88
ORG START_ADDR+0fffh
    nop
#endif

#ifdef APOGEE
ORG START_ADDR+0fffh
    nop
#endif

#ifdef RK86
ORG START_ADDR+0fffh
    nop
#endif

#ifdef GAL
ORG START_ADDR+0fffh
    nop
#endif

#ifdef ORION
ORG START_ADDR+0a7fh
;ORG 0a0ffh
;ORG 0b0ffh
 nop
;ORG 0bffdh
; jmp 0b800h
#endif

;ORG 0dbffh
; nop

END_ADDR:
;	DW 0FFFFh
  .end
