; DOS

CHKFAT: LXI H,BUF+36H
  MOV A,M
  INX H
  CPI 'F'
  RNZ
  MOV A,M
  INX H
  CPI 'A'
  RNZ
  MOV A,M
  CPI 'T'
  RET

ADDW2D: XRA A
  CALL $+3
  CALL $+3
  LDAX B
  ADC L
  STAX D
  MOV L,H
  MVI H,0
  INX B
  INX D
  RET

LD_D: MOV E,M
  INX H
  MOV D,M
  INX H
  MOV C,M
  INX H
  MOV B,M
  RET

ADD_D:  MOV A,M
  ADD E
  MOV M,A
  INX H
  MOV A,M
  ADC D
  MOV M,A
  INX H
  MOV A,M
  ADC C
  MOV M,A
  INX H
  MOV A,M
  ADC B
  MOV M,A
  RET

ADD_DR: MOV A,M
  ADD E
  MOV E,A
  INX H
  MOV A,M
  ADC D
  MOV D,A
  INX H
  MOV A,M
  ADC C
  MOV C,A
  INX H
  MOV A,M
  ADC B
  MOV B,A
  RET

SHL_D:  MOV A,E
  ADD A
  MOV E,A
  MOV A,D
  ADC A
  MOV D,A
  MOV A,C
  ADC A     ; <- PVV change from ADD A !!!!
  MOV C,A
  MOV A,B
  ADC A
  MOV B,A
  RET

MULDB:  CALL $+3 ;(HL)+=A*DE and (HL)+=A*BC
  CALL $+3
  CALL $+3
  RRC
  PUSH PSW
  JNC MULDB1
  PUSH H
  CALL ADD_D
  POP H
MULDB1: CALL SHL_D
  POP PSW
  RET

INCD: CALL INCW
  RNZ
  INX H
INCW: INR M
  RNZ
  INX H
  INR M
  RET

INCDR:  INR E
  RNZ
  INR D
  RNZ
  INR C
  RNZ
  INR B
  RET

CMPD: INX D
  INX D
  INX D
        INX H
  INX H
  INX H
  CALL $+6
  RNZ
  DCX D
  DCX H
  LDAX D
  SUB M
  RNZ
  DCX D
  DCX H
  LDAX D
  SUB M
  RET

CMPD0:  MOV A,M
  INX H
  ORA M
  INX H
  ORA M
  INX H
  ORA M
  RET

SUBHB:  MOV A,L
  SUB C
  MOV L,A
  MOV A,H
  SBB B
  MOV H,A
  RET

COPY4:  LXI B,4
COPY: MOV A,C
  ORA A
  JZ COPY1
  INR B
COPY1:  LDAX D
  MOV M,A
  INX D
  INX H
  DCR C
  JNZ COPY1
  DCR B
  JNZ COPY1
  RET

STRCMP: LDAX D
  SUB M
  RNZ
  INX D
  INX H
  DCX B
  MOV A,B
  ORA C
  JNZ STRCMP
  RET

STRCHR: MOV A,M
  CMP C
  RZ
  ORA A
  STC
  RZ
  INX H
  JMP STRCHR

STRCPY: LDAX D
  MOV M,A
  ORA A
  RZ
  INX D
  INX H
  JMP STRCPY
  
STRMSLD:LDAX D
  CPI 'a'
  RC
  CPI 'z'+1
  RNC
  ANI 0DFH
  RET

STRMASK:MVI C,11
STRMS1: CALL STRMSLD
  ORA A
  JZ STRMS5
  CPI '.'
  JZ STRMS4
  CPI '*'
  JZ STRMS6
  CPI '?'
  JZ STRMS3
STRMS2: CMP M
  RNZ
STRMS3: INX D
  INX H
  DCR C
  JNZ STRMS1
  RET
STRMS4: MOV A,C
  CPI 11
  JZ STRMS9
  CPI 4
  JC STRMS5a
  JNZ STRMS5
  INX D
STRMS5: MVI A,20H
  DCX D
  JMP STRMS2
STRMS5a:INX D
  JMP STRMS1
STRMS6: INX D
  CALL STRMSLD
  ORA A
  RZ
  MVI B,10H
  CPI '.'
  JNZ STRMS7
  MOV A,C
  SUI 2
  MOV B,A
  MVI A,20H
STRMS7: DCR B
  JZ STRMS5a
  CMP M
  JZ STRMS8
  INX H
  DCR C
  JNZ STRMS7
  ORA A
  RET
STRMS8: LDAX D
  CPI '.'
  JZ STRMS1
  JMP STRMS3
STRMS9: LDAX D
  ORA A
  JNZ $+6
  DCX D
  MVI A,20H
  CMP M
  RNZ
  INX D
  INX H
  DCR C
  JNZ STRMS9
  LDAX D
  ORA A
  RET

FS_RDBC:LXI H,BUFSEC
  MOV A,M
  CMP E
  JNZ FS_RDBF
  INX H
  MOV A,M
  CMP D
  JNZ FS_RDBF
  INX H
  MOV A,M
  CMP C
  RZ
FS_RDBF:LXI H,BUFSEC
  MOV M,E
  INX H
  MOV M,D
  INX H
  MOV M,C
  LXI H,BUF
  JMP SD_READ

;=============================================
#ifdef SD_DBG_PRINT2

DBGP_F16:
  push psw
;  push H
  LXI H,SD_F16
  CALL PRINT
;  pop H
  pop psw
  ret
SD_F16: DB "16",0ah,0

#ifdef FAT12_ON
DBGP_F32:
  push psw
;  push H
  LXI H,SD_F32
  CALL PRINT
;  pop H
  pop psw
  ret
SD_F32: DB "32",0ah,0

DBGP_F12:
;  push psw
;  push H
  LXI H,SD_F12
  CALL PRINT
;  pop H
;  pop psw
  ret
SD_F12: DB "12",0ah,0
#endif
#endif
#ifdef SD_DBG_PRINT2
SD_FAT: DB "FAT",0
#endif

;=============================================

FS_RST: CALL SD_INIT
  STC
  RNZ
  LXI D,0
  MOV C,E
  CALL FS_RDBF
  RC
  CALL FSRST1
  RNC
  LHLD BUF+1C6H
  XCHG
  LDA BUF+1C8H
  MOV C,A
  CALL FS_RDBF
  RC
FSRST1: CALL CHKFAT
  STC
  RNZ
;=============================================
#ifdef SD_DBG_PRINT2
;  push H
  LXI H,SD_FAT
  CALL PRINT
;  pop H
#endif
;=============================================

  LHLD BUF+0EH
  LXI B,BUF+1CH
  LXI D,FATSEC
  CALL ADDW2D
  LHLD BUF+16H
  XCHG
  LHLD BUF+0EH
  LDA BUF+10H
  DAD D
  DCR A
  JNZ $-2
  LXI B,BUF+1CH
  LXI D,ROOTSEC
  CALL ADDW2D
  LHLD BUF+11H
  SHLD ROOTLEN
  DAD H
  ADC A
  DAD H
  ADC A
  DAD H
  ADC A
  DAD H
  ADC A
  MOV L,H
  MOV H,A
  SHLD ROOTLNS
  LXI B,ROOTSEC
  LXI D,DATASEC
  CALL ADDW2D
  LDA BUF+0DH
  STA SECINBL
  MVI A,0C3H
  STA FAT_NXT
#ifdef FAT12_ON
  LDA BUF+39H
  CPI '3'
;=============================================[
#ifdef SD_DBG_PRINT2
  CZ DBGP_F32
#endif
;=============================================]
  LXI H,FAT_N32
  JZ FSRST2
#endif
  LDA BUF+3AH
  CPI '6'
;=============================================[
#ifdef SD_DBG_PRINT2
  CZ DBGP_F16
#endif
;=============================================]
  LXI H,FAT_N16
#ifdef FAT12_ON
  JZ FSRST2
;=============================================[
#ifdef SD_DBG_PRINT2
  CALL DBGP_F12
#endif
;=============================================]
  LXI H,FAT_N12
#endif
FSRST2: SHLD FAT_NXT+1
  LXI H,SLASH
  SHLD CWD
  XRA A
  RET

FAT_N16:
#ifdef FAT16_ON
  LXI H,BNEXT+1
  CALL LD_D
  LXI H,FATSEC
  CALL ADD_DR
  CALL FS_RDBC
  JC FAT_EOF
  LHLD BNEXT
  MVI H,0
  DAD H
  LXI D,BUF
  DAD D
  MOV E,M
  INX H
  MOV D,M
  MOV A,E
  ORI 7
  ANA D
  INR A
  JZ FAT_EOF
  XCHG
  SHLD BNEXT
#endif
  RET

FAT_N12:
#ifdef FAT12_ON
  LHLD BNEXT
  MOV E,L
  MOV D,H
  DAD H
  DAD D
  MOV A,H
  RAR
  MOV H,A
  MOV A,L
  RAR
  MOV L,A
  PUSH PSW
  PUSH H
  MOV A,H
  RRC
  ANI 0FH
  MOV E,A
  MVI D,0
  MOV C,D
  LXI H,FATSEC
  CALL ADD_DR
  CALL FS_RDBC
  POP H
  MOV A,H
  ANI 1
  MOV H,A
  SUI 2
  ANA L
  LXI D,BUF
  DAD D
  MOV E,M
  INX H
  MOV D,M
  INR A
  JNZ FATN12A
  PUSH D
  LXI H,BUFSEC
  CALL LD_D
  CALL INCDR
  CALL FS_RDBC
  POP D
  LDA BUF
  MOV D,A
FATN12A:XCHG
  POP PSW
  JNC FATN12B
  XRA A
  DAD H
  ADC A
  DAD H
  ADC A
  DAD H
  ADC A
  DAD H
  ADC A
  MOV L,H
  MOV H,A
FATN12B:MOV A,H
  ANI 0FH
  MOV H,A
  RRC
  RRC
  RRC
  RRC
  ANA L
  ADI 10H
  JC FAT_EOF
  SHLD BNEXT
  RET
#endif

FAT_N32:
FAT_EOF:
	XRA A
	MOV L,A
	MOV H,A
	SHLD BNEXT
	SHLD BNEXT+2
	RET

FS_RDWR:
   PUSH H
  LDA BLKLEN
  ORA A
  JNZ FSRD2
  LXI H,BNEXT
  CALL CMPD0
  JNZ FSRD1
  POP H
  STC
  RET
FSRD1:  LXI D,DATASEC
  LXI H,BLKSEC
  CALL COPY4
  LXI B,2
  LXI H,BNEXT
  MOV A,M
  SUB C
  MOV E,A
  INX H
  MOV A,M
  SBB B
  MOV D,A
  INX H
  MOV A,M
  SBB B
  MOV C,A
  INX H
  MOV A,M
  SBB B
  MOV B,A
  LDA SECINBL
  LXI H,BLKSEC
  CALL MULDB
#ifdef FAT12_ON
  CALL FAT_NXT
#else
  call FAT_N16 ; PVV only fat16
#endif
  LDA SECINBL
FSRD2:  DCR A
  STA BLKLEN
  LXI H,BLKSEC
  MOV E,M
  INX H
  MOV D,M
  INX H
  MOV C,M
  DCX H
  DCX H
  CALL INCD
  POP H
  RET

FS_READ: CALL FS_RDWR
  JMP SD_READ

#ifdef RWR ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
FS_WRITE: CALL FS_RDWR
  JMP SD_WRITE
#endif ;!!!!!!!!!!!!!!!!!!!!!!!!!!!

FS_NEXT:LDA DIRREC
  ORA A
  JNZ FSNX1
  LXI H,BUFDIR
  CALL FS_READ
  RC
  XRA A 
FSNX1:  MOV L,A
  MVI H,0
  INR A
  CPI 10H
  JC $+4
  XRA A
  STA DIRREC
  DAD H
  DAD H
  DAD H
  DAD H
  DAD H
  LXI D,BUFDIR
  DAD D
  RET

FS_FNDF:PUSH D
  LDA CWD+1
  ORA A
  JNZ FS_FF1
  CALL FAT_EOF
  LXI D,ROOTSEC
  LXI H,BLKSEC
  CALL COPY4
  LDA ROOTLNS
  JMP FS_FF2
FS_FF1: LXI D,CWDBLK
  LXI H,BNEXT
  CALL COPY4
  XRA A
FS_FF2: STA BLKLEN
  XRA A
  STA DIRREC
  POP D

FS_FNDN:

  PUSH D
  CALL FS_NEXT
  POP D
  RC
  PUSH H
  MVI C,20H
  XRA A
  ORA M
  INX H
  DCR C
  JNZ $-3
  POP H
  ORA A
  STC
  RZ
  MOV A,M
  CPI 0E5H
  JZ FS_FNDN
  PUSH D
  PUSH H
  CALL STRMASK
  POP H
  POP D
  RZ
  JMP FS_FNDN

FS_GETB:LXI D,20
  DAD D
  MOV C,M
  INX H
  MOV B,M
  LXI D,5
  DAD D
  MOV E,M
  INX H
  MOV D,M
  RET

FS_CHDIR:LDAX D
	SUI SLASH
	JNZ FS_CD1
	STA CWD+1
	INX D
	LDAX D
	ORA A
	RZ
FS_CD1: PUSH D
FS_CD2: LDAX D
	ORA A
	JZ FS_CD3
	INX D
	SUI SLASH
	JNZ FS_CD2
	DCX D
	STAX D
	INX D
FS_CD3: XCHG
	POP D
	PUSH H
	PUSH D
	CALL FS_FNDF
	POP B
	JC FS_CD4
	PUSH H
	LXI D,11
	DAD D
	MOV A,M
	POP H
	RLC
	RLC
	RLC
	RLC
	CMC
FS_CD4: POP D
	RC
  PUSH D
  PUSH B
  CALL FS_GETB
  LXI H,CWDBLK
  MOV M,E
  INX H
  MOV M,D
  INX H
  MOV M,C
  INX H
  MOV M,B
  POP D
  LXI H,CWD
  MOV A,M
  INX H
  MOV B,A
  MOV A,M
  ORA A
  JNZ $-4
  LDAX D
  CPI '.'
  JNZ FS_CD5
  INX D
  LDAX D
  CPI '.'
  JNZ FS_CD6
  DCX H
  MOV A,M
  MVI M,0
	CPI SLASH
  JNZ $-6
  STA CWD
  JMP FS_CD6
FS_CD5: MOV A,B
  CPI SLASH
  JZ $+6
  MVI M,SLASH
  INX H
  CALL STRCPY
FS_CD6: POP D
  LDAX D
  ORA A
  JNZ FS_CD1
  RET

F_OPEN: LXI H,0
  SHLD FBLEN
FS_OPEN:CALL FS_FNDF
  RC
  CALL FS_GETB
  LXI H,BNEXT
  MOV M,E
  INX H
  MOV M,D
  INX H
  MOV M,C
  INX H
  MOV M,B
  XRA A
  STA BLKLEN
  RET

F_READ: MOV A,B
  ORA C
  RZ
  PUSH H
  LHLD FBLEN
  MOV A,H
  ORA L
  JZ F_RD1
  CALL SUBHB
  JNC F_RD3
  POP D
  PUSH B
  LHLD FBLEN
  MOV B,H
  MOV C,L
  POP H
  CALL SUBHB
  PUSH H
  LHLD FBPOS
  XCHG
  CALL COPY
  POP B
  PUSH H
F_RD1:  MOV A,B
  CPI 2
  JNC F_RD2
  PUSH B
  LXI H,200H
  SHLD FBLEN
  LXI H,BUFDIR
  SHLD FBPOS
  CALL FS_READ
  POP B
  POP H
  JNC F_READ
  RET
F_RD2:  LXI H,0
  SHLD FBLEN
  POP H
  PUSH B
  CALL FS_READ
  POP B
  RC
  DCR B
  DCR B
  JMP F_READ
F_RD3:  SHLD FBLEN
  LHLD FBPOS
  XCHG
  POP H
  CALL COPY
  XCHG
  SHLD FBPOS
  XCHG
  RET

#ifdef RWR ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
F_WRITE: MOV A,B
  ORA C
  RZ
  PUSH H
  LHLD FBLEN
  MOV A,H
  ORA L
  JZ F_WR1
  POP H
  RET
F_WR1:  MOV A,B
  CPI 2
  JNC F_WR2
  LXI H,200H
  SHLD FBLEN
  POP H
  PUSH B
  CALL FS_WRITE
  POP B
  JNC F_WRITE
  RET
F_WR2:  LXI H,0
  SHLD FBLEN
  POP H
  PUSH B
  CALL FS_WRITE
  POP B
  RC
  DCR B
  DCR B
  JMP F_WRITE
#endif ;!!!!!!!!!!!!!!!!!!!!!!!!!!!
