
;Huby beeper music engine by Shiru (shiru@mail.ru) 04'11
;updated 99b version 11'13
;Two channels of tone, no volume, global speed
;One drum, replaces note on the first channel
;Feel free to do whatever you want with the code, it is PD
;
;Specialist 8080 version by Ivan Gorodetsky 11'24


	org #0000

	;test code

begin
	ld hl,musicData
	call huby.play
	jp 0C800h


	;engine code

OP_INCL		equ #2c

	module huby

play
	ld e,(hl)				;read speed word
	inc hl
	ld d,(hl)
	inc hl					;speed is in BC
	dec de
	inc e
	inc d
	ex de,hl
	ld (SetBC+1),hl			;store speed
	ex de,hl
	ld e,(hl)				;read patterns offset
	inc hl
	ld d,(hl)				;it is always in DE, and HL is order list pointer now

readPos
	inc hl
	ld a,(hl)				;read first byte of the order list
	inc hl
	or a
	ret z					;if it is zero, it is the end of the song

	push hl					;store the order list pointer
	push de					;store patterns offset
	ld l,(hl)				;read second byte of the order list
	ld b,2					;calculate addresses of two patterns
.read
	ld h,0					;pattern number*8
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,de				;add patterns offset
	push hl					;store pattern address
	ld l,a					;now second address
	dec b
	jp nz,.read

	pop hl					;restore pattern addresses in alternative set
	pop de

	ld a,8					;play 8 rows
readRow
	ld (soundLoop.Set8+1),a
	ld a,(de)				;read first note
	inc de					;increase first pattern pointer

	ld (soundLoop.SetCh2d+1),a
	ld (SetCh1+2),a

	ld a,(hl)				;read second note
	inc hl					;increase second pattern pointer

	ld (SetCh2+1),a
	ld (SetCh1+1),a

	cp OP_INCL				;if first note is #2c, it is drum sound
	jp z,$+4
	xor a
	ld (soundLoop.slide),a

SetBC
	ld bc,0					;load speed into duration counter

	push hl
	push de
SetCh2
	ld l,0
SetCh1
	ld de,0

	ld h,5*2
soundLoop
	ld a,h

	dec e					;counter of the first channel
	jp nz,.l1
	ld e,l					;reload if overflow
	xor a
	cp e					;set carry if the note is not zero (mute)
.slide=$
	nop						;slide for drum
	adc a
	or h
.l1

	dec d					;counter of the second channel
	jp nz,.l2
.SetCh2d
	ld d,0					;reload if overflow
	xor a
	cp d					;set carry if the note is not zero (mute)
	adc a
	or h
.l2

	ld (0FF03h),a

	dec c
	jp nz,soundLoop
	dec b
	jp nz,soundLoop
	
.l3
	pop de
	pop hl

.Set8
	ld a,0
	dec a
	jp nz,readRow
.l4
	pop de
	pop hl
	jp readPos			;continue

	ret

	endmodule


musicData
	dw #0800
	dw .p-8
	db #01,#02
	db #03,#04
	db #05,#06
	db #07,#08
	db #09,#0a
	db #0b,#0c
	db #01,#0d
	db #0e,#0f
	db #01,#02
	db #03,#04
	db #05,#06
	db #07,#10
	db #09,#11
	db #0b,#12
	db #05,#13
	db #14,#15
	db #16,#17
	db #18,#19
	db #1a,#17
	db #1b,#1c
	db #1d,#1e
	db #1f,#20
	db #1d,#1e
	db #21,#20
	db #16,#17
	db #18,#1c
	db #1a,#17
	db #1b,#22
	db #23,#24
	db #25,#24
	db #23,#26
	db #27,#28
	db #16,#17
	db #18,#19
	db #1a,#17
	db #1b,#1c
	db #1d,#1e
	db #1f,#20
	db #1d,#1e
	db #21,#20
	db #16,#17
	db #18,#1c
	db #1a,#17
	db #1b,#22
	db #29,#28
	db #2a,#28
	db #29,#2b
	db #2c,#2d
	db #2e,#2e
	db #00
.p
	db #e2,#00,#e2,#00,#e2,#00,#e2,#00
	db #00,#00,#38,#38,#32,#32,#2d,#2d
	db #2c,#00,#e2,#00,#e2,#00,#e2,#00
	db #38,#38,#38,#38,#3c,#3c,#38,#38
	db #97,#00,#97,#00,#97,#00,#97,#00
	db #38,#38,#3c,#3c,#00,#00,#00,#00
	db #2c,#00,#97,#00,#97,#00,#97,#00
	db #43,#43,#3c,#3c,#00,#00,#4b,#4b
	db #a9,#00,#a9,#00,#a9,#00,#a9,#00
	db #4b,#4b,#54,#54,#4b,#4b,#43,#43
	db #2c,#00,#a9,#00,#a9,#00,#a9,#00
	db #4b,#4b,#4b,#4b,#54,#54,#4b,#4b
	db #4b,#4b,#59,#00,#59,#00,#59,#00
	db #2c,#00,#ca,#00,#b3,#00,#b3,#00
	db #54,#00,#54,#00,#4b,#00,#4b,#00
	db #38,#38,#32,#32,#00,#00,#3c,#3c
	db #3c,#3c,#43,#43,#4b,#4b,#54,#54
	db #65,#65,#59,#59,#00,#00,#4b,#4b
	db #4b,#4b,#4b,#4b,#4b,#4b,#4b,#4b
	db #2c,#00,#97,#00,#2c,#00,#2c,#00
	db #4b,#4b,#4b,#4b,#00,#00,#00,#00
	db #a9,#00,#a9,#a9,#54,#00,#54,#54
	db #43,#43,#38,#38,#32,#32,#43,#43
	db #2c,#00,#a9,#a9,#54,#00,#54,#54
	db #38,#38,#32,#32,#38,#38,#32,#32
	db #97,#00,#97,#97,#4b,#00,#4b,#4b
	db #2c,#00,#97,#97,#2c,#00,#2c,#4b
	db #38,#38,#32,#32,#43,#43,#38,#38
	db #86,#00,#86,#86,#43,#00,#43,#43
	db #3c,#3c,#38,#38,#32,#32,#3c,#3c
	db #2c,#00,#86,#86,#43,#00,#43,#43
	db #38,#38,#32,#32,#3c,#3c,#38,#38
	db #2c,#00,#86,#86,#2c,#00,#2c,#43
	db #38,#38,#32,#32,#43,#43,#3c,#3c
	db #ca,#00,#ca,#ca,#65,#00,#65,#65
	db #43,#00,#43,#00,#43,#00,#43,#00
	db #2c,#00,#ca,#ca,#65,#00,#65,#65
	db #3c,#00,#3c,#00,#3c,#00,#3c,#00
	db #2c,#00,#2c,#ca,#2c,#00,#2c,#65
	db #38,#00,#38,#00,#38,#00,#38,#00
	db #e2,#00,#e2,#e2,#71,#00,#71,#71
	db #2c,#00,#e2,#e2,#71,#00,#71,#71
	db #38,#38,#38,#38,#38,#38,#38,#38
	db #2c,#e2,#e2,#e2,#e2,#e2,#00,#00
	db #38,#38,#38,#38,#38,#38,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00
