

	org #0000

	;test code
	
begin
	ld	hl,musicData
	call	play
	jp 0C800h


	;engine code

;Two channel beeper music engine from Earth Shaker game
;original code by Michael Batty, 1990
;reversed by Oleg Origin, 2012
;1tracker version by Shiru, 2013
; most of the code and song format has been changed
; sound generation loop and sound features are kept intact
;
; Specialist 8080 version by Ivan Gorodetsky, 2024

play

playLoop

	ld a,(hl)			;row length, #ff is end of the song
	cp #ff
	ret z
	ld d,a

	inc hl
	ld a,(hl)			;ch1 note, bit 7 is drum 1
	add a
	ld e,a
	ld a,0
	adc a
	ld b,a
	inc hl
	ld a,(hl)			;ch2 note, bit 7 is drum 2
	add a
	ld c,a
	ld a,b
	adc a
	inc hl
	push hl				;remember song pointer
	ld h,d
	ld l,0
	ld d,l
	ld b,l
	dec hl
	inc l
	inc h
	push hl				;remember row length
	push de
	push bc

	or a
	jp z,noDrum
	dec a
	jp nz,playDrum2
	ld a,5*2
	ld c,22
	ld e,40
	ld d,e
DrumLoop1:
	ld (0FF03h),a
	xor 1
DrumWait1:
	dec e
	jp nz,DrumWait1
	ld e,d
	dec c
	jp nz,DrumLoop1

	jp noDrum
playDrum2
	ld a,5*2
	ld c,12
	ld e,80
	ld d,e
DrumLoop2:
	ld (0FF03h),a
	xor 1
DrumWait2:
	dec e
	jp nz,DrumWait2
	ld e,d
	dec c
	jp nz,DrumLoop2
	
noDrum

	pop bc
	pop de

	ld hl,noteTable		;get first channel freq
	add hl,de
	ld   e,(hl)
	inc  hl
	ld   d,(hl)
	push de
	dec de
	inc e
	inc d
	ex de,hl
	ex (sp),hl
	dec hl
	dec hl
	inc l
	inc h
	
	ld (SetTone1+1),hl

	ld hl,noteTable		;get second channel freq
	add hl,bc
	ld   e,(hl)
	inc  hl
	ld   d,(hl)
	ex de,hl
	dec hl
	inc l
	inc h
	ld (SetTone2+1),hl
	ld c,l
	ld b,h
	pop de

	pop hl				;restore row length
	ld a,h
	ld (SetH),a
	ld a,l
playTone0
	ld hl,0FF03h
playTone
	dec  e
	jp   nz,playTone1
	dec  d
	jp   nz,playTone1
	ld (hl),10
	ld (hl),11
SetTone1:
	ld de,0
	
playTone1

	dec  c
	jp   nz,playTone2
	dec  b
	jp   nz,playTone2
	ld (hl),11
	ld (hl),10
SetTone2:
	ld bc,0
	
playTone2
	add h
	jp nz,playTone
	ld hl,SetH
	dec (hl)
	jp nz,playTone0
	pop hl				;restore song pointer
	jp playLoop

SetH
	db 0



noteTable

	dw #0400,#03C7,#0390,#035D,#032D,#02FF,#02D4,#02AB
	dw #0285,#0261,#023F,#021E,#0200,#01E3,#01C8,#01AF
	dw #0196,#0180,#016A,#0156,#0143,#0130,#011F,#010F
	dw #0100,#00F2,#00E4,#00D7,#00CB,#00C0,#00B5,#00AB
	dw #00A1,#0098,#0090,#0088,#0080,#0079,#0072,#006C
	dw #0066,#0060,#005B,#0055,#0051,#004C,#0048,#0044
	dw #0040,#003C,#0039,#0036,#0033,#0030,#002D,#002B
	dw #0028,#0026,#0024,#0022,#0020,#001E,#001D,#001B
	dw #0019,#0018,#0017,#0015,#0014,#0013,#0012,#0011
	dw #0010

;compiled music data

musicData
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1f,#1a
	db #14,#1f,#1a
	db #14,#1e,#19
	db #14,#1e,#19
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1e,#12
	db #14,#12,#12
	db #14,#1f,#13
	db #14,#13,#13
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1f,#1a
	db #14,#1f,#1a
	db #14,#1e,#19
	db #14,#1e,#19
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#12,#12
	db #14,#12,#12
	db #14,#12,#12
	db #14,#12,#12
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#9f,#1a
	db #14,#1f,#1a
	db #14,#1e,#19
	db #14,#1e,#19
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1e,#92
	db #14,#92,#12
	db #14,#1f,#93
	db #14,#93,#13
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#9f,#1a
	db #14,#1f,#1a
	db #14,#1e,#19
	db #14,#1e,#19
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1a,#15
	db #14,#9c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#1c,#17
	db #14,#15,#92
	db #14,#15,#12
	db #14,#15,#12
	db #14,#15,#12
	db #14,#9c,#10
	db #14,#1c,#10
	db #14,#1c,#1c
	db #14,#9a,#10
	db #14,#1c,#90
	db #14,#1c,#10
	db #14,#9c,#1f
	db #14,#1a,#1e
	db #14,#9c,#10
	db #14,#1c,#10
	db #14,#1c,#1c
	db #14,#9a,#10
	db #14,#1c,#90
	db #14,#1c,#10
	db #14,#9c,#17
	db #14,#1a,#15
	db #14,#98,#0c
	db #14,#18,#0c
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1e
	db #14,#97,#1c
	db #14,#18,#1a
	db #14,#9a,#1e
	db #14,#1a,#1e
	db #14,#1a,#1f
	db #14,#9a,#1f
	db #14,#1a,#9e
	db #14,#1a,#1e
	db #14,#18,#98
	db #14,#1a,#9a
	db #14,#9c,#10
	db #14,#1c,#10
	db #14,#1c,#1c
	db #14,#9a,#10
	db #14,#1c,#90
	db #14,#1c,#10
	db #14,#9c,#1f
	db #14,#1a,#1e
	db #14,#9c,#10
	db #14,#1c,#10
	db #14,#1c,#1c
	db #14,#9a,#10
	db #14,#1c,#90
	db #14,#1c,#10
	db #14,#9c,#17
	db #14,#1a,#15
	db #14,#98,#0c
	db #14,#18,#0c
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1e
	db #14,#97,#1c
	db #14,#18,#1a
	db #14,#9a,#1e
	db #14,#1a,#1e
	db #14,#1a,#1f
	db #14,#9a,#1f
	db #14,#1a,#9e
	db #14,#1a,#1e
	db #14,#18,#98
	db #14,#1a,#9a
	db #14,#98,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#98,#1f
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1f
	db #14,#9a,#1e
	db #14,#9a,#0e
	db #14,#1a,#9e
	db #14,#9a,#1e
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#1a,#9c
	db #14,#1a,#1c
	db #14,#9c,#1f
	db #14,#9c,#1e
	db #14,#1c,#9a
	db #14,#9c,#1f
	db #14,#1c,#1e
	db #14,#9c,#1a
	db #14,#1a,#9f
	db #14,#1a,#1e
	db #14,#9c,#1f
	db #14,#9c,#1e
	db #14,#1c,#9a
	db #14,#9c,#1f
	db #14,#1c,#1e
	db #14,#9c,#1a
	db #14,#1a,#9f
	db #14,#1a,#9e
	db #14,#98,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#98,#1f
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1f
	db #14,#9a,#1e
	db #14,#9a,#0e
	db #14,#1a,#9f
	db #14,#9a,#1f
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#1a,#9e
	db #14,#1a,#1e
	db #14,#9c,#1f
	db #14,#9c,#1e
	db #14,#1c,#9a
	db #14,#9c,#1f
	db #14,#1c,#1e
	db #14,#9c,#1a
	db #14,#1a,#9f
	db #14,#1a,#1e
	db #14,#9c,#1a
	db #14,#9c,#1f
	db #14,#1c,#9e
	db #14,#9c,#1a
	db #28,#1c,#9f
	db #28,#1c,#1f
	db #28,#1c,#1f
	db #28,#1c,#1f
	db #14,#90,#17
	db #14,#10,#17
	db #14,#1c,#17
	db #14,#10,#17
	db #14,#10,#23
	db #14,#10,#23
	db #14,#1c,#17
	db #14,#10,#17
	db #14,#10,#21
	db #14,#10,#21
	db #14,#1c,#23
	db #14,#10,#23
	db #14,#10,#17
	db #14,#10,#17
	db #14,#1c,#17
	db #14,#10,#17
	db #14,#8e,#1e
	db #14,#0e,#1e
	db #14,#1a,#1e
	db #14,#0e,#1e
	db #14,#0e,#2a
	db #14,#0e,#2a
	db #14,#1a,#1e
	db #14,#0e,#1e
	db #14,#0e,#28
	db #14,#0e,#28
	db #14,#1a,#2a
	db #14,#0e,#2a
	db #14,#0e,#1e
	db #14,#0e,#1e
	db #14,#9a,#1e
	db #14,#0e,#1e
	db #14,#8c,#1c
	db #14,#0c,#1c
	db #14,#18,#1c
	db #14,#0c,#1c
	db #14,#0c,#28
	db #14,#0c,#28
	db #14,#18,#1c
	db #14,#0c,#1c
	db #14,#0c,#2b
	db #14,#0c,#2b
	db #14,#18,#28
	db #14,#0c,#28
	db #14,#0c,#1c
	db #14,#0c,#1c
	db #14,#18,#1c
	db #14,#0c,#1c
	db #14,#92,#17
	db #14,#12,#17
	db #14,#1e,#17
	db #14,#12,#17
	db #14,#12,#23
	db #14,#12,#23
	db #14,#1e,#17
	db #14,#12,#17
	db #14,#92,#21
	db #14,#12,#21
	db #14,#9e,#23
	db #14,#12,#23
	db #14,#12,#ad
	db #14,#12,#2d
	db #14,#9e,#2f
	db #14,#12,#2f
	db #14,#90,#17
	db #14,#10,#17
	db #14,#1c,#97
	db #14,#9c,#17
	db #14,#10,#23
	db #14,#90,#23
	db #14,#1c,#97
	db #14,#10,#17
	db #14,#90,#21
	db #14,#10,#21
	db #14,#1c,#a3
	db #14,#9c,#23
	db #14,#10,#17
	db #14,#90,#17
	db #14,#1c,#97
	db #14,#9c,#17
	db #14,#8e,#1e
	db #14,#0e,#1e
	db #14,#1a,#9e
	db #14,#9a,#1e
	db #14,#0e,#2a
	db #14,#8e,#2a
	db #14,#1a,#9e
	db #14,#0e,#9e
	db #14,#8e,#28
	db #14,#0e,#28
	db #14,#1a,#aa
	db #14,#9a,#2a
	db #14,#0e,#9e
	db #14,#0e,#9e
	db #14,#1a,#9e
	db #14,#1a,#9e
	db #14,#8c,#1c
	db #14,#0c,#1c
	db #14,#18,#9c
	db #14,#98,#1c
	db #14,#0c,#28
	db #14,#8c,#28
	db #14,#18,#9c
	db #14,#0c,#1c
	db #14,#8c,#2b
	db #14,#0c,#2b
	db #14,#18,#a8
	db #14,#98,#28
	db #14,#0c,#1c
	db #14,#8c,#1c
	db #14,#18,#9c
	db #14,#98,#1c
	db #14,#92,#17
	db #14,#12,#17
	db #14,#1e,#97
	db #14,#9e,#17
	db #14,#12,#23
	db #14,#92,#23
	db #14,#1e,#97
	db #14,#12,#17
	db #14,#92,#21
	db #14,#12,#21
	db #14,#1e,#23
	db #14,#1e,#23
	db #14,#12,#2d
	db #14,#12,#2d
	db #14,#1e,#2f
	db #14,#1e,#2f
	db #14,#98,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#98,#1f
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1f
	db #14,#9a,#1e
	db #14,#9a,#0e
	db #14,#1a,#9e
	db #14,#9a,#1e
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#1a,#9c
	db #14,#1a,#1c
	db #14,#9c,#1f
	db #14,#9c,#1e
	db #14,#1c,#9a
	db #14,#9c,#1f
	db #14,#1c,#1e
	db #14,#9c,#1a
	db #14,#1a,#9f
	db #14,#1a,#1e
	db #14,#9c,#1f
	db #14,#9c,#1e
	db #14,#1c,#9a
	db #14,#9c,#1f
	db #14,#1c,#1e
	db #14,#9c,#1a
	db #14,#1a,#9f
	db #14,#1a,#9e
	db #14,#98,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#98,#1f
	db #14,#18,#0c
	db #14,#98,#0c
	db #14,#18,#9f
	db #14,#18,#1f
	db #14,#9a,#1e
	db #14,#9a,#0e
	db #14,#1a,#9e
	db #14,#9a,#1e
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#1a,#9c
	db #14,#1a,#1c
	db #14,#a8,#1f
	db #14,#a8,#1e
	db #14,#26,#9a
	db #14,#a8,#1f
	db #14,#a8,#1e
	db #14,#a6,#1a
	db #14,#28,#9f
	db #14,#a8,#1e
	db #14,#2b,#9f
	db #14,#aa,#1e
	db #14,#26,#9a
	db #14,#ab,#1f
	db #14,#2a,#9e
	db #14,#26,#9a
	db #14,#2b,#9f
	db #14,#2a,#9e
	db #14,#a4,#0c
	db #14,#a4,#0c
	db #14,#24,#9f
	db #14,#a4,#1f
	db #14,#24,#0c
	db #14,#a4,#0c
	db #14,#24,#9f
	db #14,#24,#1f
	db #14,#a6,#1e
	db #14,#a6,#0e
	db #14,#26,#9e
	db #14,#a6,#1e
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#26,#9c
	db #14,#26,#1c
	db #14,#1f,#9f
	db #14,#1c,#9e
	db #14,#9a,#1a
	db #14,#9c,#1f
	db #14,#1e,#9e
	db #14,#1c,#9a
	db #14,#9f,#1f
	db #14,#9a,#1e
	db #14,#1f,#9f
	db #14,#9c,#1e
	db #14,#1a,#9a
	db #14,#9c,#1f
	db #14,#1e,#9e
	db #14,#1c,#9a
	db #14,#9f,#1f
	db #14,#9a,#1e
	db #14,#a4,#0c
	db #14,#a4,#0c
	db #14,#24,#9f
	db #14,#a4,#1f
	db #14,#24,#0c
	db #14,#a4,#0c
	db #14,#24,#9f
	db #14,#24,#1f
	db #14,#a6,#1e
	db #14,#a6,#0e
	db #14,#26,#9f
	db #14,#a6,#1f
	db #14,#1a,#0e
	db #14,#9a,#0e
	db #14,#26,#9e
	db #14,#26,#1e
	db #14,#2b,#9f
	db #14,#9e,#1e
	db #14,#26,#9a
	db #14,#9f,#2b
	db #14,#1e,#b6
	db #14,#9a,#32
	db #14,#2b,#9f
	db #14,#9e,#1e
	db #14,#26,#9a
	db #14,#1f,#ab
	db #14,#9e,#36
	db #14,#9a,#32
	db #05,#1c,#9f
	db #05,#1c,#9f
	db #05,#1c,#9f
	db #05,#1c,#9f
	db #0a,#1c,#1f
	db #0a,#1c,#1f
	db #0a,#1c,#1f
	db #0a,#1c,#1f
	db #14,#1c,#1f
	db #14,#1c,#1f
	db #14,#1c,#1f
	db #14,#1c,#1f
	db #28,#1c,#1f
	db #28,#1c,#1f
	db #28,#1c,#1f
	db #ff 