    device  zxspectrum128

 LUA PASS1

    -- trim implementations /from https://www.folkstalk.com/2022/09/lua-trim-with-code-examples.html
    function IHEXtrim1(s)
      return (s:gsub("^%s*(.-)%s*$", "%1"))
    end
    -- from PiL2 20.4

    function IHEXbyte(bt)        -- byte to hex string
      local h = (bt>>4) +48
      local l = (bt%16) +48
      if h>=58
       then h = h+7
      end
      if l>=58
       then l = l+7
      end
      return string.char(h,l)
    end




    IHEXfilename = ""
    IHEXerror = ""

    function IHEXsetname(s)

     IHEXfilename = IHEXtrim1(s)
     if (IHEXfilename == "") then
      IHEXerror = "Invalid file name"
      return
     end
     fl=io.open(IHEXfilename,"w")
     if not(fl) then
       IHEXerror = "File error"
     end
     fl:close()
    end


    function IHEXsaveDATA(adrs,lng)

     if IHEXfilename == "" then
      IHEXerror = "No file name"
      return
     end

     local sadr =  _c(IHEXtrim1(adrs))
     if sadr > 65535 then
      IHEXerror = "Address too big"
      return
     end

     local dlen =  _c(IHEXtrim1(lng))
     local ll=0
     local o
     local rec = {}

     if ( sadr < 0 or sadr >= 65536 or dlen <= 0 or dlen >= 65536 or sadr+dlen >= 65536 ) then
         IHEXerror = "Invalid address or length"
        return
     end

     fl=io.open(IHEXfilename,"a")
     if fl then

       while (dlen > 0) do
         local sum=0
         ll = 16
         if dlen < 16
           then ll = dlen
         end
         dlen = dlen-ll

         rec[1] = IHEXbyte(ll)
         rec[2] = IHEXbyte(sadr>>8)
         rec[3] = IHEXbyte(sadr%256)
         rec[4] ="00"             -- type binary data
         sum = (ll+(sadr>>8)+(sadr%256))%256
         local i=5
         while  (ll > 0) do
          o = sj.get_byte(sadr)
          sum = (sum+o)%256
          rec[i] = IHEXbyte(o)
          sadr = sadr+1
          ll = ll-1
          i = i+1
         end

         rec[i] = IHEXbyte((256-sum)%256)

         fl:write(":")
         for j=1, i do
            fl:write(rec[j])
         end
         fl:write("\n")
       end

     end
     fl:close()
    end

    function IHEXend()
     fl=io.open(IHEXfilename,"a")
     if fl then
       fl:write(":00000001FF")
     end
     fl:close()
     IHEXfilename = ""
    end


 ENDLUA

;[integer] sj.get_byte(address)
;    Get byte from memory. Works only in real device emulation mode and
;    only in last assembling pass.



;----------------------------------------------------------------------------------
; INTEL HEX format

; :LL AAAA TT  DD...DD  CC

; LL - длина
; AAAA - адрес
; TT   - тип записи

 ;   00 запись содержит данные двоичного файла.
 ;   01 запись является концом файла.
 ;   02 запись адреса сегмента (подробнее см. ниже).
 ;   03 Стартовый адрес запуска программы в формате 80x86 (значения регистров CS:IP счетчика команд и регистра смещения)
 ;   04 запись расширенного адреса (подробнее см. ниже).
 ;   05 32-битный адрес запуска программы в «линейном» адресном пространстве

; DD - данные
; CC - контрольная сумма
;    Поле контрольной суммы вычисляется путём сложения значений
; всех байт (пар 16-ричных цифр) записи по модулю 256
; с последующим переводом в дополнительный формат
;(отнять получившееся значение от 0).
; Таким образом, если просуммировать все пары шестнадцатеричных чисел,
; включая LL, AA, TT, DD, CC, получится 0.


    MACRO IHEXNAME# pFileName
     LUA PASS3
      IHEXsetname(sj.get_define("pFileName",true))
      if IHEXerror ~= "" then
         sj.error(IHEXerror,nil)
         IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO ihexname# pFileName
     LUA PASS3
      IHEXsetname(sj.get_define("pFileName",true))
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

   MACRO IHEX# pSADDR,pLENGHT
    LUA PASS3
     IHEXsaveDATA(sj.get_define("pSADDR",true),sj.get_define("pLENGHT",true))
     if IHEXerror ~= "" then
      sj.error(IHEXerror,nil)
      IHEXerror = ""
     end
    ENDLUA
   ENDM

   MACRO ihex# pSADDR,pLENGHT
    LUA PASS3
     IHEXsaveDATA(sj.get_define("pSADDR",true),sj.get_define("pLENGHT",true))
     if IHEXerror ~= "" then
      sj.error(IHEXerror,nil)
      IHEXerror = ""
     end
    ENDLUA
   ENDM

   MACRO IHEXEND#
     LUA PASS3
      IHEXend()
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

   MACRO ihexend#
     LUA PASS3
      IHEXend()
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM