;         Intel HEX format output library v 0.1 for SjASMplus v 1.0.3 and later
;
;-----------------------------------------------------------------------------------------
;
; It works only in real device emulation mode.
;
; To use, include the file at the beginning of the source code text before using.
;
; To create a hex-file, a macro is used:    INDEXNAME# <file name>
;
; it creates a file (overwrites as a new one) with the specified name
; and writes a null extended address
;
; To write a data area to a file the macro is used:
;
;           IHEX#  <address of the beginning of the area>,<length in bytes>
;
; To record the end of the file, use the macro:   IHEXEND#
;
; Macros work on the last 3rd pass of the assembler
;
;-----------------------------------------------------------------------------------------
;
; Copyright (C) 2024
;
;        Permission to use, copy, modify, and/or distribute this software
;           for any purpose with or without fee is hereby granted.
;
; THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
; WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT,
; OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
; DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
; ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;
;-----------------------------------------------------------------------------------------

  LUA PASS1

    -- trim implementations from  https://www.lua.org/pil/20.3.html
    function IHEXtrim1(s)
      return (s:gsub("^%s*(.-)%s*$", "%1"))
    end

    function IHEXbyte(bt)        -- byte to hex string
      local h = (bt>>4) +48
      local l = (bt%16) +48
      if h>=58
       then h = h+7
      end
      if l>=58
       then l = l+7
      end
      return string.char(h,l)
    end

    IHEXfilename = ""
    IHEXerror = ""

    function IHEXcheckname(s)
     IHEXerror = "Invalid file name"
     local fn = IHEXtrim1(s)
     if fn == "" then
      return fn
     end
     local o=string.byte(fn,1)
     if o==34 or o==39 then
       if string.len(fn)>2 and string.byte(fn,string.len(fn))==o then
         fn = IHEXtrim1(string.sub (fn,2,string.len(fn)-1))
       else
         fn = ""
         return fn
       end
      end
      IHEXerror = ""
      return fn
     end

     function IHEXnametrue()
     if IHEXfilename == "" then
       HEXerror = "No file for used"
       return false
     else
       return true
     end
    end

    function IHEXfiletrue(fl)
      if not fl then
        IHEXerror = "File error"
        fl:close()
        return false
      else
        return true
      end
    end

    function IHEXsetname(s)
     IHEXfilename = IHEXcheckname(s)
     if IHEXerror ~= "" then
      return
     end
     local fl=io.open(IHEXfilename,"w")
     if  IHEXfiletrue(fl) then
       fl:write(":020000040000FA\n")
     else
       return
     end
     fl:close()
    end

    function IHEXsaveDATA(adrs,lng)

     if not IHEXnametrue() then
      return
     end

     local sadr =  _c(IHEXtrim1(adrs))
     if sadr > 65535 then
      IHEXerror = "Address too big"
      return
     end

     local dlen =  _c(IHEXtrim1(lng))
     local ll=0
     local o
     local rec = {}

     if sadr < 0 or sadr >= 65536 or dlen <= 0 or dlen >= 65536 or sadr+dlen >= 65536 then
         IHEXerror = "Invalid address or length"
        return
     end

     local fl=io.open(IHEXfilename,"a")

     if not IHEXfiletrue(fl) then
       return
     end

       while (dlen > 0) do
         local s=":"
         local sum=0
         ll = 255
         if dlen < 255
           then ll = dlen
         end
         dlen = dlen-ll

         rec[1] = IHEXbyte(ll)
         rec[2] = IHEXbyte(sadr>>8)
         rec[3] = IHEXbyte(sadr%256)
         rec[4] ="00"             -- type binary data
         sum = (ll+(sadr>>8)+(sadr%256))%256
         local i=5
         while  (ll > 0) do
          o = sj.get_byte(sadr)
          sum = (sum+o)%256
          rec[i] = IHEXbyte(o)
          sadr = sadr+1
          ll = ll-1
          i = i+1
         end

         rec[i] = IHEXbyte((256-sum)%256)

         for j=1, i do
            s=s..rec[j]
         end
            s=s.."\n"
         fl:write(s)
         if not IHEXfiletrue(fl) then
            return
         end
       end

     fl:close()
    end

    function IHEXend()
     if not IHEXnametrue() then
      return
     end
     local fl=io.open(IHEXfilename,"a")
     IHEXfilename = ""
     if not IHEXfiletrue(fl) then
      return
     end
     fl:write(":00000001FF\n")
     if not IHEXfiletrue(fl) then
      return
     end
     fl:close()
    end

  ENDLUA


    MACRO IHEXNAME# pFileName
     LUA PASS3
      IHEXsetname(sj.get_define("pFileName",true))
      if IHEXerror ~= "" then
         sj.error(IHEXerror,nil)
         IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO ihexname# pFileName
     LUA PASS3
      IHEXsetname(sj.get_define("pFileName",true))
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO IHEX# pSADDR,pLENGHT
     LUA PASS3
      IHEXsaveDATA(sj.get_define("pSADDR",true),sj.get_define("pLENGHT",true))
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO ihex# pSADDR,pLENGHT
     LUA PASS3
      IHEXsaveDATA(sj.get_define("pSADDR",true),sj.get_define("pLENGHT",true))
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO IHEXEND#
     LUA PASS3
      IHEXend()
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

    MACRO ihexend#
     LUA PASS3
      IHEXend()
      if IHEXerror ~= "" then
       sj.error(IHEXerror,nil)
       IHEXerror = ""
      end
     ENDLUA
    ENDM

;-----------------------------------------------------------------------------------------
