                ; i8080 assembler code
                .project wnoise.rk
                .tape rk-bin

                line		equ 64
                row		equ 35
                
                dma_size        equ 1 * 1 - 1 
                dma_size_       equ line * row - 1

                KR580VG75       equ $C000 ; $EF00
                KR580VT57       equ $E008 ; $F008
                KR580VV55       equ $8000 ; $ED00 
                KR580VI53       equ $9000

                org 0


		; Видеорежим:
		; https://www.computer-museum.ru/technlgy/i8275.htm
		; https://zx-pk.ru/threads/35112-radio86rk-opyat-pro-vg75-i-nestandartnye-rezhimy.html
		; https://ruecm.forum2x2.ru/t724-topic

                LXI HL, KR580VG75 + 1

		; Скрываем курсор

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		; Останов КР580ВГ75

		INR L
		MVI M, 0
		DCR L

        	MVI M, line - 1	; Столбцы
        	MVI M, row - 1  | 11000000b; Строки
        	MVI M, $77	; Позиция курсора и кол-во линий в знакоместе
        	MVI M, 01010000b | 00001010b

		; Старт КР580ВГ75

		INR L
        	MVI M, 027h
 		
		CALL VG75_READY

                ; Настройка ПДП
                ; https://www.computer-museum.ru/technlgy/ik57.htm

                LXI H, KR580VT57
		MVI M, $80
		MVI L, $04
		MVI M, sprite & $00ff
		MVI M, sprite >> 8

		INR L
		MVI M, dma_size & 0x00ff
		MVI M, $4000 + dma_size >> 8
		MVI L, 8
		MVI M, $A4

                ; Клавиатура
                LXI H, KR580VV55
                MVI M, 11111101b

MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY
		
		; Счетчик-делитель

		LXI H, clock
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA clock
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA clock
		ANI 1
		CNZ X2_

                ; X4
		LDA clock
 		ANI 3
		CZ X4

                JMP MAIN

X1:

		RET

X2:

                LXI D, sprite
                LXI H, KR580VT57 - 4
		MOV M, E
		MOV M, D
                INR L
		MVI M, dma_size & 0x00ff
		MVI M, $4000 + dma_size >> 8

		RET

X2_:


                LXI D, screen
                LXI H, KR580VT57 - 4
		MOV M, E
		MOV M, D

                LXI H, KR580VT57 - 3
		MVI M, (line * row -1) & 0x00ff
		MVI M, $4000 + dma_size_ >> 8


                RET

X4:

		RET

SPRITE_4X4:	

                PUSH H
                PUSH D
                
                LXI B, line - 3
                
		CALL SPRITE_ROW_4
		
		DAD B
		CALL SPRITE_ROW_4
		
		DAD B
		CALL SPRITE_ROW_4
		
		DAD B
		CALL SPRITE_ROW_4
		
                POP D
                POP H
                LXI B, 4
		DAD B

                RET

SPRITE_ROW_4:
                LDAX D
                MOV M, A
                INX H
                INX D
  		
                LDAX D
                MOV M, A
                INX H
                INX D
		
                LDAX D
                MOV M, A
                INX H
                INX D
		
                LDAX D
                MOV M, A
                INX D

                RET

RANDOM: 
                ; https://www.cpcwiki.eu/index.php/Programming:Random_Number_Generator
                ; A - случайное число 0-255
                LHLD randomSEED
                LDA clock
                MOV D, A
                MOV E, A
                DAD D
                XRA L
                ADD A
                XRA H
                MOV L, A
                SHLD randomSEED

                RET

VG75_READY: 	
		; Ждем обратный ход

VG75_WAIT: 
                CALL RANDOM
                ANI 00010111b
                LXI H, sprite
                MOV M, A

                LXI H, KR580VG75 + 1
		MOV A, M
                ANI 020h
                JZ VG75_WAIT
                RET

clock:          db 0
randomSEED:     dw $0000

sine: 

		db $00, $00, $00, $00, $01, $01, $01, $02
		db $02, $03, $04, $05, $05, $06, $07, $09
		db $0A, $0B, $0C, $0E, $0F, $11, $12, $14
		db $15, $17, $19, $1B, $1D, $1F, $21, $23
		db $25, $28, $2A, $2C, $2F, $31, $34, $36
		db $39, $3B, $3E, $41, $43, $46, $49, $4C
		db $4F, $52, $55, $58, $5A, $5D, $61, $64
		db $67, $6A, $6D, $70, $73, $76, $79, $7C
		db $80, $83, $86, $89, $8C, $8F, $92, $95
		db $98, $9B, $9E, $A2, $A5, $A7, $AA, $AD
		db $B0, $B3, $B6, $B9, $BC, $BE, $C1, $C4
		db $C6, $C9, $CB, $CE, $D0, $D3, $D5, $D7
		db $DA, $DC, $DE, $E0, $E2, $E4, $E6, $E8
		db $EA, $EB, $ED, $EE, $F0, $F1, $F3, $F4
		db $F5, $F6, $F8, $F9, $FA, $FA, $FB, $FC
		db $FD, $FD, $FE, $FE, $FE, $FF, $FF, $FF
		db $FF, $FF, $FF, $FF, $FE, $FE, $FE, $FD
		db $FD, $FC, $FB, $FA, $FA, $F9, $F8, $F6
		db $F5, $F4, $F3, $F1, $F0, $EE, $ED, $EB
		db $EA, $E8, $E6, $E4, $E2, $E0, $DE, $DC
		db $DA, $D7, $D5, $D3, $D0, $CE, $CB, $C9
		db $C6, $C4, $C1, $BE, $BC, $B9, $B6, $B3
		db $B0, $AD, $AA, $A7, $A5, $A2, $9E, $9B
		db $98, $95, $92, $8F, $8C, $89, $86, $83
		db $80, $7C, $79, $76, $73, $70, $6D, $6A
		db $67, $64, $61, $5D, $5A, $58, $55, $52
		db $4F, $4C, $49, $46, $43, $41, $3E, $3B
		db $39, $36, $34, $31, $2F, $2C, $2A, $28
		db $25, $23, $21, $1F, $1D, $1B, $19, $17
		db $15, $14, $12, $11, $0F, $0E, $0C, $0B
		db $0A, $09, $07, $06, $05, $05, $04, $03
		db $02, $02, $01, $01, $01, $00, $00, $00


sprite:

                ; 01
                db $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84
                db $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84
                
                ; 02
                db $00, $00, $00, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $14, $00, $00, $00,      $00, $00, $00, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $14, $00, $00, $00
                db $00, $00, $00, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $14, $00, $00, $00,      $00, $00, $00, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $14, $00, $00, $00
                
                ; 03
                db $00, $00, $00, $11, $34, $30, $34, $00,      $00, $00, $00, $34, $06, $00, $00, $00,      $00, $00, $00, $11, $34, $30, $34, $00,      $00, $00, $00, $34, $06, $00, $00, $00
                db $00, $00, $00, $11, $34, $30, $34, $00,      $00, $00, $00, $34, $06, $00, $00, $00,      $00, $00, $00, $11, $34, $30, $34, $00,      $00, $00, $00, $34, $06, $00, $00, $00
                
                ; 04
                db $00, $00, $00, $51, $60, $54, $54, $54,      $54, $54, $54, $60, $46, $00, $00, $00,      $00, $00, $00, $51, $60, $54, $54, $54,      $54, $54, $54, $60, $46, $00, $00, $00
                db $00, $00, $00, $51, $60, $54, $54, $54,      $54, $54, $54, $60, $46, $00, $00, $00,      $00, $00, $00, $51, $60, $54, $54, $54,      $54, $54, $54, $60, $46, $00, $00, $00
                
                ; 05
                db $00, $00, $00, $51, $46, $41, $47, $43,      $43, $53, $42, $51, $46, $00, $00, $00,      $00, $00, $00, $51, $46, $41, $47, $43,      $43, $53, $42, $51, $46, $00, $00, $00
                db $00, $00, $00, $51, $46, $41, $47, $43,      $43, $53, $42, $51, $46, $00, $00, $00,      $00, $00, $00, $51, $46, $41, $47, $43,      $43, $53, $42, $51, $46, $00, $00, $00
                
                ; 06
                db $00, $00, $00, $51, $42, $55, $57, $57,      $57, $57, $56, $41, $46, $00, $00, $00,      $00, $00, $00, $51, $42, $55, $57, $57,      $57, $57, $56, $41, $46, $00, $00, $00
                db $00, $00, $00, $51, $42, $55, $57, $57,      $57, $57, $56, $41, $46, $00, $00, $00,      $00, $00, $00, $51, $42, $55, $57, $57,      $57, $57, $56, $41, $46, $00, $00, $00
                
                ; 07
                db $00, $00, $00, $55, $54, $54, $54, $54,      $54, $54, $54, $54, $56, $00, $00, $00,      $00, $00, $00, $55, $54, $54, $54, $54,      $54, $54, $54, $54, $56, $00, $00, $00
                db $00, $00, $00, $55, $54, $54, $54, $54,      $54, $54, $54, $54, $56, $00, $00, $00,      $00, $00, $00, $55, $54, $54, $54, $54,      $54, $54, $54, $54, $56, $00, $00, $00
                
                ; 08
                db $00, $00, $00, $57, $47, $55, $57, $57,      $57, $57, $56, $53, $57, $00, $00, $00,      $00, $00, $00, $57, $47, $55, $57, $57,      $57, $57, $56, $53, $57, $00, $00, $00
                db $00, $00, $00, $57, $47, $55, $57, $57,      $57, $57, $56, $53, $57, $00, $00, $00,      $00, $00, $00, $57, $47, $55, $57, $57,      $57, $57, $56, $53, $57, $00, $00, $00
                
                ; 09
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 10
                db $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80
                db $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80
                
                
                
                ; 01
                db $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84
                db $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84,      $84, $84, $84, $84, $84, $84, $84, $84
                
                ; 02
                db $00, $00, $04, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $10, $00, $00, $00,      $00, $00, $04, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $10, $00, $00, $00
                db $00, $00, $04, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $10, $00, $00, $00,      $00, $00, $04, $14, $14, $14, $14, $14,      $14, $14, $14, $14, $10, $00, $00, $00
                
                ; 03
                db $00, $00, $06, $24, $34, $24, $30, $00,      $00, $00, $24, $30, $11, $00, $00, $00,      $00, $00, $06, $24, $34, $24, $30, $00,      $00, $00, $24, $30, $11, $00, $00, $00
                db $00, $00, $06, $24, $34, $24, $30, $00,      $00, $00, $24, $30, $11, $00, $00, $00,      $00, $00, $06, $24, $34, $24, $30, $00,      $00, $00, $24, $30, $11, $00, $00, $00
                
                ; 04
                db $00, $00, $06, $60, $44, $54, $54, $54,      $54, $54, $50, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $44, $54, $54, $54,      $54, $54, $50, $60, $11, $00, $00, $00
                db $00, $00, $06, $60, $44, $54, $54, $54,      $54, $54, $50, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $44, $54, $54, $54,      $54, $54, $50, $60, $11, $00, $00, $00
                
                ; 05
                db $00, $00, $06, $60, $53, $42, $53, $43,      $47, $41, $47, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $53, $42, $53, $43,      $47, $41, $47, $60, $11, $00, $00, $00
                db $00, $00, $06, $60, $53, $42, $53, $43,      $47, $41, $47, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $53, $42, $53, $43,      $47, $41, $47, $60, $11, $00, $00, $00
                
                ; 06
                db $00, $00, $06, $60, $47, $56, $57, $57,      $57, $55, $53, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $47, $56, $57, $57,      $57, $55, $53, $60, $11, $00, $00, $00
                db $00, $00, $06, $60, $47, $56, $57, $57,      $57, $55, $53, $60, $11, $00, $00, $00,      $00, $00, $06, $60, $47, $56, $57, $57,      $57, $55, $53, $60, $11, $00, $00, $00
                
                ; 07
                db $00, $00, $06, $54, $54, $54, $54, $54,      $54, $54, $54, $54, $11, $00, $00, $00,      $00, $00, $06, $54, $54, $54, $54, $54,      $54, $54, $54, $54, $11, $00, $00, $00
                db $00, $00, $06, $54, $54, $54, $54, $54,      $54, $54, $54, $54, $11, $00, $00, $00,      $00, $00, $06, $54, $54, $54, $54, $54,      $54, $54, $54, $54, $11, $00, $00, $00
                
                ; 08
                db $00, $00, $06, $53, $57, $56, $57, $57,      $57, $55, $57, $47, $11, $00, $00, $00,      $00, $00, $06, $53, $57, $56, $57, $57,      $57, $55, $57, $47, $11, $00, $00, $00
                db $00, $00, $06, $53, $57, $56, $57, $57,      $57, $55, $57, $47, $11, $00, $00, $00,      $00, $00, $06, $53, $57, $56, $57, $57,      $57, $55, $57, $47, $11, $00, $00, $00
                
                ; 09
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 10
                db $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80
                db $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80,      $80, $80, $80, $80, $80, $80, $80, $80
                
screen: 
		
                ; 01
                db $84, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 02
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 03
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 04
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 05
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 06
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 07
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 08
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 09
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 10
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 11
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $04, $00
                db $16, $10, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 12
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $57, $11
                db $57, $01, $16, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 13
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $57, $00
                db $57, $00, $57, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 14
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $57, $00
                db $57, $04, $13, $00, $04, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 15
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $06, $00
                db $03, $06, $11, $00, $57, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 16
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $04, $14
                db $14, $02, $00, $16, $01, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 17
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $02, $57
                db $57, $15, $10, $01, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 18
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $06, $57, $10, $00, $00, $00, $02
                db $03, $57, $57, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 19
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $02, $01, $00, $14, $14, $00
                db $00, $57, $13, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 20
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $02, $57, $57, $15
                db $16, $57, $11, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 21
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $02, $57, $13
                db $07, $13, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 22
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 23
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 24
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 25
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 26
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 27
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 28
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 29
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 30
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 31
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                
                ; 32
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $80

                ; Подвал
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db '5', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db '4', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db '3', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db '2', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

		db '1', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $17
