// Дмитрий Иванов, 2024г.
// R,7FFF - загрузка проверочной утилиты
// http://radio-86rk.local/ - загрузка файла

#include "WiFi.h"
#include <ESPmDNS.h>
#include <NetworkClient.h>
#include <WebServer.h>

#include "dos.h"

#define HOSTNAME "Radio-86RK"

// Данные для подключения к WiFi
const char* ssid = "ariadna";
const char* password = "123789qwerty";

WebServer server(80);

#define D0      0     // PA0 через резистор 1к
#define D1      1     // PA1 через резистор 1к
#define D2      2     // PA2 через резистор 1к
#define D3      3     // PA3 через резистор 1к
#define D4      4     // PA4 через резистор 1к
#define D5      5     // PA5 через резистор 1к
#define D6      6     // PA6 через резистор 1к
#define D7      7     // PA7 через резистор 1к

#define ADDR    20    // PB0 через резистор 1к
#define RD      21    // PC7 через резистор 1к
#define LED     8

#define ADDR_SSID     0x08AC
#define ADDR_RSSI     0x00E2

#define DELAY_MS      64

struct KR580VV55
{
  uint8_t rd = 0xFF;
  uint32_t inputs = 0x00;
  uint16_t index = 4;
};

KR580VV55 BUS;

uint8_t data[32768];
uint16_t INDEX;

bool loaded = false;

String directive = "РАДИО-86РК - загрузка файла";

// Прерывание при смене адреса, пишем очередной байт в порт или принимаем
void IRAM_ATTR ISR_ADDR() 
{
  if (BUS.rd != 0) return;

  // Делать задержку в прерываниях, это прям фуууу....
  // Делаем задержку, чтобы заранее выставить в порт данные, которые потом заберёт ППА, иначе не хватает скорости порта для вывода GPIO_OUT_REG
  delayMicroseconds(DELAY_MS);
  BUS.index++;
  REG_WRITE(GPIO_OUT_REG, data[BUS.index]);
}

// Прерывание при смене сигнала чтения ROM-диска
void IRAM_ATTR ISR_RD() 
{
  portDISABLE_INTERRUPTS();

  REG_WRITE(GPIO_OUT_REG, data[4]);

  // digitalRead больше нельзя использовать
  BUS.inputs = REG_READ(GPIO_IN_REG);
  BUS.rd = bitRead(BUS.inputs, RD);

  BUS.index = 4;

  // Начало передачи
  if (BUS.rd == 0) ISR_ADDR();

  portENABLE_INTERRUPTS();
}

void setup() {

  pinMode(LED, OUTPUT);

  // Устраняем косяки с коннектом ESP32C3
  WiFi.useStaticBuffers(true);
  WiFi.setMinSecurity(WIFI_AUTH_WPA_PSK);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  WiFi.setSleep(false);

  // Закомментировать эту строку, если у вас новая версия платы без ошибок с антенной
  WiFi.setTxPower(WIFI_POWER_8_5dBm);

  // Мигаем светодиодом, пока нет коннекта
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(100);
    digitalWrite(LED, HIGH);
    delay(100);
    digitalWrite(LED, LOW);
  }

  MDNS.begin(HOSTNAME);

  server.on("/", HTTP_GET, handleRoot);
  server.on("/", HTTP_POST, []() {server.sendHeader("Connection", "close");}, handleUpload);
  server.onNotFound(handleNotFound);

  server.begin();

  pinMode(D0, INPUT);
  pinMode(D1, INPUT);
  pinMode(D2, INPUT);
  pinMode(D3, INPUT);
  pinMode(D4, INPUT);
  pinMode(D5, INPUT);
  pinMode(D6, INPUT);
  pinMode(D7, INPUT);
 
  pinMode(ADDR, INPUT_PULLUP);
  pinMode(RD, INPUT_PULLUP);

  // Прервания
  attachInterrupt(digitalPinToInterrupt(ADDR), ISR_ADDR, CHANGE);  
  attachInterrupt(digitalPinToInterrupt(RD), ISR_RD, CHANGE);  
  
  for (uint32_t i = 0; i < sizeof(dos); i++) {data[i] = dos[i];}

  for (uint32_t i = 0; i < strlen(ssid); i++) {data[ADDR_SSID + i] = toupper(ssid[i]);}

  REG_WRITE(GPIO_ENABLE_W1TS_REG, 0xFF);

  // Заранее пишем в порт первый байт, чтобы нивелировать дребезг прерываний - раскомментировать, если портится первый байт
  REG_WRITE(GPIO_OUT_REG, data[4]);

  digitalWrite(LED, HIGH);

}

void handleRoot() {
  String HTML = "<!doctype html>";
  HTML += "<head>";
  HTML += "<meta charset='utf-8'>";
  HTML += "<meta name='viewport' content='width=device-width, initial-scale=1, shrink-to-fit=no'>";
  HTML += "<link href='https://fonts.googleapis.com/css?family=Roboto&display=swap' rel='stylesheet'>";
  HTML += "<style>";
  HTML += "*{font-family: 'Roboto', sans-serif;}";
  HTML += "html, body {width: 100%; height: 100%; margin: 0; padding: 0; background: black;}";
  HTML += "#upload {color: white; padding: 1rem; background: rgba(0, 0, 0, 0.5); border-top: solid white 2px; border-bottom: solid white 2px; border-radius: 1rem; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center;}";
  HTML += "</style>";
  HTML += "<title>Загрузчик файлов для Радио-86РК</title>";
  HTML += "</head>";
  HTML += "<body>";
  HTML += "<div id='upload'>";
  HTML = HTML + directive + "<br><br>";
  HTML += "<form enctype='multipart/form-data' action='/' method='POST'>";
  HTML += "<input type='file' name='file' id='file' class='form-control' onchange='this.form.submit();'>";
  HTML += "</form>";
  HTML += "</div>";
  HTML += "</body>";
  HTML += "</html>";
  
  server.send(200, "text/html", HTML);
}

void handleUpload() {

  HTTPUpload& upload = server.upload();

  if (upload.status == UPLOAD_FILE_START)
  {
    INDEX = 0;
  }

  if (upload.status == UPLOAD_FILE_WRITE)
  {
    // memcpy глючит здесь, поэтому данные перекидываем в цикле
    for (uint32_t i = 0; i < upload.currentSize; i++) {data[INDEX] = upload.buf[i]; INDEX++;}
  }

  if (upload.status == UPLOAD_FILE_END)
  {
    uint16_t LENGTH_16, ADDR_16;
    String LENGTH_, ADDR_;

    ADDR_16 = data[0] * 256 + data[1];
    LENGTH_16 = data[2] * 256 + data[3];

    if (ADDR_16 > 0)
    {
      ADDR_ = String(ADDR_16, HEX);
      while (ADDR_.length() < 4) ADDR_ = "0" + ADDR_;
      ADDR_ = ", " + ADDR_;
    } else {ADDR_ = "";}

    LENGTH_ = String(LENGTH_16, HEX);
    while (LENGTH_.length() < 4) LENGTH_ = "0" + LENGTH_;
		
	  directive = "R,7FFF или R, " + LENGTH_ + ADDR_;
    directive.toUpperCase();

    // Заранее пишем в порт первый байт, чтобы нивелировать дребезг прерываний - раскомментировать, если портится первый байт
    REG_WRITE(GPIO_OUT_REG, data[4]);

    loaded = true;
    
    server.sendHeader("Location", "/", true);
    server.send(302);
 }
}

void handleNotFound() {
  server.send(404, "text/plain", "");
}

void loop() {

  server.handleClient();
  delay(1); // Даём время процессору на выполнение других задач

  if (!loaded) data[ADDR_RSSI] = abs(WiFi.RSSI());

}
