                ; i8080 assembler code
                .project wifi.rk
                .tape rk-bin

                line		equ 78
                row		equ 38
                
                dma_size        equ line * row - 1

                KR580VG75       equ $C000
                KR580VT57       equ $E008
                KR580VV55       equ $8000

                restart         equ $F800

                org 0
                
                ; Видеорежим:
		; https://www.computer-museum.ru/technlgy/i8275.htm
		; https://zx-pk.ru/threads/35112-radio86rk-opyat-pro-vg75-i-nestandartnye-rezhimy.html
		; https://ruecm.forum2x2.ru/t724-topic

                LXI H, KR580VG75 + 1

		; Скрываем курсор

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		; Останов КР580ВГ75

		INR L
		MVI M, 0
		DCR L

        	MVI M, line - 1	; Столбцы
        	MVI M, row - 1	; Строки
        	MVI M, $77	; Позиция курсора и кол-во линий в знакоместе
        	MVI M, $53	; 0101.0011
        	
 		; Старт КР580ВГ75

		INR L
        	MVI M, $27
 		
                ;CALL RANDOM_SEED
		CALL VG75_READY

                ; Настройка ПДП
                ; https://www.computer-museum.ru/technlgy/ik57.htm
                
                LXI HL, KR580VT57
		MVI M, $80
		MVI L, $04
		MVI M, screen & $00FF
		MVI M, screen >> 8

		INR L
		MVI M, dma_size & 0x00FF
		MVI M, $4000 + dma_size >> 8
		MVI L, 8
		MVI M, $A4

MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY

		; Счетчик-делитель

		LXI H, clock
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA clock
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA clock
		ANI 1
		CNZ X2_

                ; X4
		LDA clock
 		ANI 3
		CZ X4
   
                JMP MAIN

X1:
                ; Мигаем курсором для красоты
		LDA clock
                ANI 00001111b
                RNZ
                
                LXI H, screen + line * 26 + 39
                MVI A, $7F
                XRA M
                MOV M, A

                RET

X2:
                		
		; Вывод RSSI
                LXI H, rssi_
		LDA rssi
		CMP M
		JZ . + 7 \\ INR A \\ STA rssi
		
                LXI H, screen + line * 3 + 29
                CALL DEC_8

		RET

X2_:
                
                RET

X4:

		; Опрос клавиавтуры
                LXI H, KR580VV55
                MVI M, 11111110b

		; Выход
                LDA KR580VV55 + 1
                CPI 11111011b
                JZ restart

		RET
                
SPRITE_3X3:	

                LXI B, line - 2
                
		CALL SPRITE_ROW_3
		
		DAD B
		CALL SPRITE_ROW_3
		
		DAD B
		CALL SPRITE_ROW_3

                RET

SPRITE_ROW_3:

                LDAX D
                MOV M, A
                INX H
                INX D
  		
                LDAX D
                MOV M, A
                INX H
                INX D

                LDAX D
                MOV M, A
                INX D

                RET

DEC_8:

                MVI B, 0
                
        DEC_10:
                
                INR B
                MOV C, A
                SBI 10
                JP DEC_10
                
                DCR B
                MOV A, B
                CALL PRINT_NUM
                MOV A, C
                MVI B, 0

        DEC_1:
                
                CALL PRINT_NUM

                RET

PRINT_NUM:

                PUSH B
                PUSH H
                
		XCHG
		
                LXI H, numbers
                MVI B, 0
                MOV C, A
                ADD A
                ADD A
                ADD A
                ADD C
                MOV C, A
                DAD B
                
		XCHG

                CALL SPRITE_3X3

                POP H
                LXI B, $0003
                DAD B
                
                POP B
                
                RET

VG75_READY: 	
		; Ждем обратный ход

                LXI H, KR580VG75 + 1
		MOV A, M
VG75_WAIT: 
		MOV A, M
                ANI $20
                JZ VG75_WAIT
                RET
                
clock:          db $00

rssi:           db $00
rssi_:          db $00

numbers: 
                db $06, $03, $17
                db $06, $12, $06
                db $02, $03, $03
                db $00, $16, $00
                db $00, $06, $00
                db $00, $03, $01
                db $02, $03, $05
                db $04, $03, $01
                db $02, $03, $03
                db $02, $03, $07
                db $02, $03, $07
                db $02, $03, $03
                db $00, $12, $00
                db $06, $14, $15
                db $00, $00, $01
                db $06, $03, $03
                db $02, $03, $07
                db $02, $03, $01
                db $06, $03, $03
                db $06, $03, $07
                db $02, $03, $03
                db $02, $03, $07
                db $00, $04, $01
                db $00, $02, $00
                db $06, $03, $07
                db $06, $03, $07
                db $02, $03, $03
                db $06, $03, $07
                db $02, $03, $07
                db $02, $03, $03

screen:

                ; 01
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00     
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 02
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 03
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 04
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 05
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 06
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 07
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 08
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $14, $14, $14
                db $14, $14, $14, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 09
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $14, $17, $17, $17, $17
                db $17, $17, $17, $17, $14, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 10
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $14, $17, $17, $17, $17, $17, $17
                db $17, $17, $17, $17, $17, $17, $14, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 11
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $16, $17, $17, $17, $13, $01, $00, $00
                db $00, $00, $02, $07, $17, $17, $17, $15,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 12
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $16,      $17, $17, $13, $01, $00, $00, $14, $14
                db $14, $14, $00, $00, $02, $07, $17, $17,      $15, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 13
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $06, $17,      $17, $13, $00, $00, $14, $17, $17, $17
                db $17, $17, $17, $14, $00, $00, $07, $17,      $17, $11, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 14
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $02, $17,      $13, $00, $04, $17, $17, $17, $17, $17
                db $17, $17, $17, $17, $17, $10, $00, $07,      $17, $01, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 15
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $04, $17, $17, $17, $13, $01, $00
                db $00, $02, $07, $17, $17, $17, $10, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 16
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $17, $17, $17, $01, $00, $04, $14
                db $14, $10, $00, $02, $17, $17, $17, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 17
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $07, $17, $01, $00, $16, $17, $17
                db $17, $17, $15, $00, $02, $17, $13, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 18
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $16, $17, $17, $17
                db $17, $17, $17, $15, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 19
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $07, $17, $01, $00
                db $00, $02, $17, $13, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 20
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $04, $17
                db $17, $10, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 21
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $06, $17
                db $17, $11, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 22
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $02, $17
                db $17, $01, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 23
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 24
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 25
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, 'S', 'S', 'I', 'D', ':', $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 26
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 27
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, 'P', 'A', 'S', 'S', ':', $00, '*'
                db '*', '*', '*', '*', '*', '*', '*', $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 28
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 29
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 30
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 31
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 32
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, 'I',      'V', 'A', 'N', 'O', 'V', $00, 'D', 'M'
                db 'I', 'T', 'R', 'Y', $00, '2', '0', '2',      '4', $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; Подвал
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F3, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		