; CRC table for the standard 100000100110000010001110110110111 polynomial.
; Chunked little endian, the 256 LSBs first, the 256 MSBs last, for fast access.
;
; Copyright (C) 2012-2023 Patrik Rak (patrik@raxoft.cz)
;
; This source code is released under the MIT license, see included license.txt.

crctable:
            db      0x00    ; 00 00000000
            db      0x96    ; 01 77073096
            db      0x2c    ; 02 ee0e612c
            db      0xba    ; 03 990951ba
            db      0x19    ; 04 076dc419
            db      0x8f    ; 05 706af48f
            db      0x35    ; 06 e963a535
            db      0xa3    ; 07 9e6495a3
            db      0x32    ; 08 0edb8832
            db      0xa4    ; 09 79dcb8a4
            db      0x1e    ; 0a e0d5e91e
            db      0x88    ; 0b 97d2d988
            db      0x2b    ; 0c 09b64c2b
            db      0xbd    ; 0d 7eb17cbd
            db      0x07    ; 0e e7b82d07
            db      0x91    ; 0f 90bf1d91
            db      0x64    ; 10 1db71064
            db      0xf2    ; 11 6ab020f2
            db      0x48    ; 12 f3b97148
            db      0xde    ; 13 84be41de
            db      0x7d    ; 14 1adad47d
            db      0xeb    ; 15 6ddde4eb
            db      0x51    ; 16 f4d4b551
            db      0xc7    ; 17 83d385c7
            db      0x56    ; 18 136c9856
            db      0xc0    ; 19 646ba8c0
            db      0x7a    ; 1a fd62f97a
            db      0xec    ; 1b 8a65c9ec
            db      0x4f    ; 1c 14015c4f
            db      0xd9    ; 1d 63066cd9
            db      0x63    ; 1e fa0f3d63
            db      0xf5    ; 1f 8d080df5
            db      0xc8    ; 20 3b6e20c8
            db      0x5e    ; 21 4c69105e
            db      0xe4    ; 22 d56041e4
            db      0x72    ; 23 a2677172
            db      0xd1    ; 24 3c03e4d1
            db      0x47    ; 25 4b04d447
            db      0xfd    ; 26 d20d85fd
            db      0x6b    ; 27 a50ab56b
            db      0xfa    ; 28 35b5a8fa
            db      0x6c    ; 29 42b2986c
            db      0xd6    ; 2a dbbbc9d6
            db      0x40    ; 2b acbcf940
            db      0xe3    ; 2c 32d86ce3
            db      0x75    ; 2d 45df5c75
            db      0xcf    ; 2e dcd60dcf
            db      0x59    ; 2f abd13d59
            db      0xac    ; 30 26d930ac
            db      0x3a    ; 31 51de003a
            db      0x80    ; 32 c8d75180
            db      0x16    ; 33 bfd06116
            db      0xb5    ; 34 21b4f4b5
            db      0x23    ; 35 56b3c423
            db      0x99    ; 36 cfba9599
            db      0x0f    ; 37 b8bda50f
            db      0x9e    ; 38 2802b89e
            db      0x08    ; 39 5f058808
            db      0xb2    ; 3a c60cd9b2
            db      0x24    ; 3b b10be924
            db      0x87    ; 3c 2f6f7c87
            db      0x11    ; 3d 58684c11
            db      0xab    ; 3e c1611dab
            db      0x3d    ; 3f b6662d3d
            db      0x90    ; 40 76dc4190
            db      0x06    ; 41 01db7106
            db      0xbc    ; 42 98d220bc
            db      0x2a    ; 43 efd5102a
            db      0x89    ; 44 71b18589
            db      0x1f    ; 45 06b6b51f
            db      0xa5    ; 46 9fbfe4a5
            db      0x33    ; 47 e8b8d433
            db      0xa2    ; 48 7807c9a2
            db      0x34    ; 49 0f00f934
            db      0x8e    ; 4a 9609a88e
            db      0x18    ; 4b e10e9818
            db      0xbb    ; 4c 7f6a0dbb
            db      0x2d    ; 4d 086d3d2d
            db      0x97    ; 4e 91646c97
            db      0x01    ; 4f e6635c01
            db      0xf4    ; 50 6b6b51f4
            db      0x62    ; 51 1c6c6162
            db      0xd8    ; 52 856530d8
            db      0x4e    ; 53 f262004e
            db      0xed    ; 54 6c0695ed
            db      0x7b    ; 55 1b01a57b
            db      0xc1    ; 56 8208f4c1
            db      0x57    ; 57 f50fc457
            db      0xc6    ; 58 65b0d9c6
            db      0x50    ; 59 12b7e950
            db      0xea    ; 5a 8bbeb8ea
            db      0x7c    ; 5b fcb9887c
            db      0xdf    ; 5c 62dd1ddf
            db      0x49    ; 5d 15da2d49
            db      0xf3    ; 5e 8cd37cf3
            db      0x65    ; 5f fbd44c65
            db      0x58    ; 60 4db26158
            db      0xce    ; 61 3ab551ce
            db      0x74    ; 62 a3bc0074
            db      0xe2    ; 63 d4bb30e2
            db      0x41    ; 64 4adfa541
            db      0xd7    ; 65 3dd895d7
            db      0x6d    ; 66 a4d1c46d
            db      0xfb    ; 67 d3d6f4fb
            db      0x6a    ; 68 4369e96a
            db      0xfc    ; 69 346ed9fc
            db      0x46    ; 6a ad678846
            db      0xd0    ; 6b da60b8d0
            db      0x73    ; 6c 44042d73
            db      0xe5    ; 6d 33031de5
            db      0x5f    ; 6e aa0a4c5f
            db      0xc9    ; 6f dd0d7cc9
            db      0x3c    ; 70 5005713c
            db      0xaa    ; 71 270241aa
            db      0x10    ; 72 be0b1010
            db      0x86    ; 73 c90c2086
            db      0x25    ; 74 5768b525
            db      0xb3    ; 75 206f85b3
            db      0x09    ; 76 b966d409
            db      0x9f    ; 77 ce61e49f
            db      0x0e    ; 78 5edef90e
            db      0x98    ; 79 29d9c998
            db      0x22    ; 7a b0d09822
            db      0xb4    ; 7b c7d7a8b4
            db      0x17    ; 7c 59b33d17
            db      0x81    ; 7d 2eb40d81
            db      0x3b    ; 7e b7bd5c3b
            db      0xad    ; 7f c0ba6cad
            db      0x20    ; 80 edb88320
            db      0xb6    ; 81 9abfb3b6
            db      0x0c    ; 82 03b6e20c
            db      0x9a    ; 83 74b1d29a
            db      0x39    ; 84 ead54739
            db      0xaf    ; 85 9dd277af
            db      0x15    ; 86 04db2615
            db      0x83    ; 87 73dc1683
            db      0x12    ; 88 e3630b12
            db      0x84    ; 89 94643b84
            db      0x3e    ; 8a 0d6d6a3e
            db      0xa8    ; 8b 7a6a5aa8
            db      0x0b    ; 8c e40ecf0b
            db      0x9d    ; 8d 9309ff9d
            db      0x27    ; 8e 0a00ae27
            db      0xb1    ; 8f 7d079eb1
            db      0x44    ; 90 f00f9344
            db      0xd2    ; 91 8708a3d2
            db      0x68    ; 92 1e01f268
            db      0xfe    ; 93 6906c2fe
            db      0x5d    ; 94 f762575d
            db      0xcb    ; 95 806567cb
            db      0x71    ; 96 196c3671
            db      0xe7    ; 97 6e6b06e7
            db      0x76    ; 98 fed41b76
            db      0xe0    ; 99 89d32be0
            db      0x5a    ; 9a 10da7a5a
            db      0xcc    ; 9b 67dd4acc
            db      0x6f    ; 9c f9b9df6f
            db      0xf9    ; 9d 8ebeeff9
            db      0x43    ; 9e 17b7be43
            db      0xd5    ; 9f 60b08ed5
            db      0xe8    ; a0 d6d6a3e8
            db      0x7e    ; a1 a1d1937e
            db      0xc4    ; a2 38d8c2c4
            db      0x52    ; a3 4fdff252
            db      0xf1    ; a4 d1bb67f1
            db      0x67    ; a5 a6bc5767
            db      0xdd    ; a6 3fb506dd
            db      0x4b    ; a7 48b2364b
            db      0xda    ; a8 d80d2bda
            db      0x4c    ; a9 af0a1b4c
            db      0xf6    ; aa 36034af6
            db      0x60    ; ab 41047a60
            db      0xc3    ; ac df60efc3
            db      0x55    ; ad a867df55
            db      0xef    ; ae 316e8eef
            db      0x79    ; af 4669be79
            db      0x8c    ; b0 cb61b38c
            db      0x1a    ; b1 bc66831a
            db      0xa0    ; b2 256fd2a0
            db      0x36    ; b3 5268e236
            db      0x95    ; b4 cc0c7795
            db      0x03    ; b5 bb0b4703
            db      0xb9    ; b6 220216b9
            db      0x2f    ; b7 5505262f
            db      0xbe    ; b8 c5ba3bbe
            db      0x28    ; b9 b2bd0b28
            db      0x92    ; ba 2bb45a92
            db      0x04    ; bb 5cb36a04
            db      0xa7    ; bc c2d7ffa7
            db      0x31    ; bd b5d0cf31
            db      0x8b    ; be 2cd99e8b
            db      0x1d    ; bf 5bdeae1d
            db      0xb0    ; c0 9b64c2b0
            db      0x26    ; c1 ec63f226
            db      0x9c    ; c2 756aa39c
            db      0x0a    ; c3 026d930a
            db      0xa9    ; c4 9c0906a9
            db      0x3f    ; c5 eb0e363f
            db      0x85    ; c6 72076785
            db      0x13    ; c7 05005713
            db      0x82    ; c8 95bf4a82
            db      0x14    ; c9 e2b87a14
            db      0xae    ; ca 7bb12bae
            db      0x38    ; cb 0cb61b38
            db      0x9b    ; cc 92d28e9b
            db      0x0d    ; cd e5d5be0d
            db      0xb7    ; ce 7cdcefb7
            db      0x21    ; cf 0bdbdf21
            db      0xd4    ; d0 86d3d2d4
            db      0x42    ; d1 f1d4e242
            db      0xf8    ; d2 68ddb3f8
            db      0x6e    ; d3 1fda836e
            db      0xcd    ; d4 81be16cd
            db      0x5b    ; d5 f6b9265b
            db      0xe1    ; d6 6fb077e1
            db      0x77    ; d7 18b74777
            db      0xe6    ; d8 88085ae6
            db      0x70    ; d9 ff0f6a70
            db      0xca    ; da 66063bca
            db      0x5c    ; db 11010b5c
            db      0xff    ; dc 8f659eff
            db      0x69    ; dd f862ae69
            db      0xd3    ; de 616bffd3
            db      0x45    ; df 166ccf45
            db      0x78    ; e0 a00ae278
            db      0xee    ; e1 d70dd2ee
            db      0x54    ; e2 4e048354
            db      0xc2    ; e3 3903b3c2
            db      0x61    ; e4 a7672661
            db      0xf7    ; e5 d06016f7
            db      0x4d    ; e6 4969474d
            db      0xdb    ; e7 3e6e77db
            db      0x4a    ; e8 aed16a4a
            db      0xdc    ; e9 d9d65adc
            db      0x66    ; ea 40df0b66
            db      0xf0    ; eb 37d83bf0
            db      0x53    ; ec a9bcae53
            db      0xc5    ; ed debb9ec5
            db      0x7f    ; ee 47b2cf7f
            db      0xe9    ; ef 30b5ffe9
            db      0x1c    ; f0 bdbdf21c
            db      0x8a    ; f1 cabac28a
            db      0x30    ; f2 53b39330
            db      0xa6    ; f3 24b4a3a6
            db      0x05    ; f4 bad03605
            db      0x93    ; f5 cdd70693
            db      0x29    ; f6 54de5729
            db      0xbf    ; f7 23d967bf
            db      0x2e    ; f8 b3667a2e
            db      0xb8    ; f9 c4614ab8
            db      0x02    ; fa 5d681b02
            db      0x94    ; fb 2a6f2b94
            db      0x37    ; fc b40bbe37
            db      0xa1    ; fd c30c8ea1
            db      0x1b    ; fe 5a05df1b
            db      0x8d    ; ff 2d02ef8d

            db      0x00    ; 00 00000000
            db      0x30    ; 01 77073096
            db      0x61    ; 02 ee0e612c
            db      0x51    ; 03 990951ba
            db      0xc4    ; 04 076dc419
            db      0xf4    ; 05 706af48f
            db      0xa5    ; 06 e963a535
            db      0x95    ; 07 9e6495a3
            db      0x88    ; 08 0edb8832
            db      0xb8    ; 09 79dcb8a4
            db      0xe9    ; 0a e0d5e91e
            db      0xd9    ; 0b 97d2d988
            db      0x4c    ; 0c 09b64c2b
            db      0x7c    ; 0d 7eb17cbd
            db      0x2d    ; 0e e7b82d07
            db      0x1d    ; 0f 90bf1d91
            db      0x10    ; 10 1db71064
            db      0x20    ; 11 6ab020f2
            db      0x71    ; 12 f3b97148
            db      0x41    ; 13 84be41de
            db      0xd4    ; 14 1adad47d
            db      0xe4    ; 15 6ddde4eb
            db      0xb5    ; 16 f4d4b551
            db      0x85    ; 17 83d385c7
            db      0x98    ; 18 136c9856
            db      0xa8    ; 19 646ba8c0
            db      0xf9    ; 1a fd62f97a
            db      0xc9    ; 1b 8a65c9ec
            db      0x5c    ; 1c 14015c4f
            db      0x6c    ; 1d 63066cd9
            db      0x3d    ; 1e fa0f3d63
            db      0x0d    ; 1f 8d080df5
            db      0x20    ; 20 3b6e20c8
            db      0x10    ; 21 4c69105e
            db      0x41    ; 22 d56041e4
            db      0x71    ; 23 a2677172
            db      0xe4    ; 24 3c03e4d1
            db      0xd4    ; 25 4b04d447
            db      0x85    ; 26 d20d85fd
            db      0xb5    ; 27 a50ab56b
            db      0xa8    ; 28 35b5a8fa
            db      0x98    ; 29 42b2986c
            db      0xc9    ; 2a dbbbc9d6
            db      0xf9    ; 2b acbcf940
            db      0x6c    ; 2c 32d86ce3
            db      0x5c    ; 2d 45df5c75
            db      0x0d    ; 2e dcd60dcf
            db      0x3d    ; 2f abd13d59
            db      0x30    ; 30 26d930ac
            db      0x00    ; 31 51de003a
            db      0x51    ; 32 c8d75180
            db      0x61    ; 33 bfd06116
            db      0xf4    ; 34 21b4f4b5
            db      0xc4    ; 35 56b3c423
            db      0x95    ; 36 cfba9599
            db      0xa5    ; 37 b8bda50f
            db      0xb8    ; 38 2802b89e
            db      0x88    ; 39 5f058808
            db      0xd9    ; 3a c60cd9b2
            db      0xe9    ; 3b b10be924
            db      0x7c    ; 3c 2f6f7c87
            db      0x4c    ; 3d 58684c11
            db      0x1d    ; 3e c1611dab
            db      0x2d    ; 3f b6662d3d
            db      0x41    ; 40 76dc4190
            db      0x71    ; 41 01db7106
            db      0x20    ; 42 98d220bc
            db      0x10    ; 43 efd5102a
            db      0x85    ; 44 71b18589
            db      0xb5    ; 45 06b6b51f
            db      0xe4    ; 46 9fbfe4a5
            db      0xd4    ; 47 e8b8d433
            db      0xc9    ; 48 7807c9a2
            db      0xf9    ; 49 0f00f934
            db      0xa8    ; 4a 9609a88e
            db      0x98    ; 4b e10e9818
            db      0x0d    ; 4c 7f6a0dbb
            db      0x3d    ; 4d 086d3d2d
            db      0x6c    ; 4e 91646c97
            db      0x5c    ; 4f e6635c01
            db      0x51    ; 50 6b6b51f4
            db      0x61    ; 51 1c6c6162
            db      0x30    ; 52 856530d8
            db      0x00    ; 53 f262004e
            db      0x95    ; 54 6c0695ed
            db      0xa5    ; 55 1b01a57b
            db      0xf4    ; 56 8208f4c1
            db      0xc4    ; 57 f50fc457
            db      0xd9    ; 58 65b0d9c6
            db      0xe9    ; 59 12b7e950
            db      0xb8    ; 5a 8bbeb8ea
            db      0x88    ; 5b fcb9887c
            db      0x1d    ; 5c 62dd1ddf
            db      0x2d    ; 5d 15da2d49
            db      0x7c    ; 5e 8cd37cf3
            db      0x4c    ; 5f fbd44c65
            db      0x61    ; 60 4db26158
            db      0x51    ; 61 3ab551ce
            db      0x00    ; 62 a3bc0074
            db      0x30    ; 63 d4bb30e2
            db      0xa5    ; 64 4adfa541
            db      0x95    ; 65 3dd895d7
            db      0xc4    ; 66 a4d1c46d
            db      0xf4    ; 67 d3d6f4fb
            db      0xe9    ; 68 4369e96a
            db      0xd9    ; 69 346ed9fc
            db      0x88    ; 6a ad678846
            db      0xb8    ; 6b da60b8d0
            db      0x2d    ; 6c 44042d73
            db      0x1d    ; 6d 33031de5
            db      0x4c    ; 6e aa0a4c5f
            db      0x7c    ; 6f dd0d7cc9
            db      0x71    ; 70 5005713c
            db      0x41    ; 71 270241aa
            db      0x10    ; 72 be0b1010
            db      0x20    ; 73 c90c2086
            db      0xb5    ; 74 5768b525
            db      0x85    ; 75 206f85b3
            db      0xd4    ; 76 b966d409
            db      0xe4    ; 77 ce61e49f
            db      0xf9    ; 78 5edef90e
            db      0xc9    ; 79 29d9c998
            db      0x98    ; 7a b0d09822
            db      0xa8    ; 7b c7d7a8b4
            db      0x3d    ; 7c 59b33d17
            db      0x0d    ; 7d 2eb40d81
            db      0x5c    ; 7e b7bd5c3b
            db      0x6c    ; 7f c0ba6cad
            db      0x83    ; 80 edb88320
            db      0xb3    ; 81 9abfb3b6
            db      0xe2    ; 82 03b6e20c
            db      0xd2    ; 83 74b1d29a
            db      0x47    ; 84 ead54739
            db      0x77    ; 85 9dd277af
            db      0x26    ; 86 04db2615
            db      0x16    ; 87 73dc1683
            db      0x0b    ; 88 e3630b12
            db      0x3b    ; 89 94643b84
            db      0x6a    ; 8a 0d6d6a3e
            db      0x5a    ; 8b 7a6a5aa8
            db      0xcf    ; 8c e40ecf0b
            db      0xff    ; 8d 9309ff9d
            db      0xae    ; 8e 0a00ae27
            db      0x9e    ; 8f 7d079eb1
            db      0x93    ; 90 f00f9344
            db      0xa3    ; 91 8708a3d2
            db      0xf2    ; 92 1e01f268
            db      0xc2    ; 93 6906c2fe
            db      0x57    ; 94 f762575d
            db      0x67    ; 95 806567cb
            db      0x36    ; 96 196c3671
            db      0x06    ; 97 6e6b06e7
            db      0x1b    ; 98 fed41b76
            db      0x2b    ; 99 89d32be0
            db      0x7a    ; 9a 10da7a5a
            db      0x4a    ; 9b 67dd4acc
            db      0xdf    ; 9c f9b9df6f
            db      0xef    ; 9d 8ebeeff9
            db      0xbe    ; 9e 17b7be43
            db      0x8e    ; 9f 60b08ed5
            db      0xa3    ; a0 d6d6a3e8
            db      0x93    ; a1 a1d1937e
            db      0xc2    ; a2 38d8c2c4
            db      0xf2    ; a3 4fdff252
            db      0x67    ; a4 d1bb67f1
            db      0x57    ; a5 a6bc5767
            db      0x06    ; a6 3fb506dd
            db      0x36    ; a7 48b2364b
            db      0x2b    ; a8 d80d2bda
            db      0x1b    ; a9 af0a1b4c
            db      0x4a    ; aa 36034af6
            db      0x7a    ; ab 41047a60
            db      0xef    ; ac df60efc3
            db      0xdf    ; ad a867df55
            db      0x8e    ; ae 316e8eef
            db      0xbe    ; af 4669be79
            db      0xb3    ; b0 cb61b38c
            db      0x83    ; b1 bc66831a
            db      0xd2    ; b2 256fd2a0
            db      0xe2    ; b3 5268e236
            db      0x77    ; b4 cc0c7795
            db      0x47    ; b5 bb0b4703
            db      0x16    ; b6 220216b9
            db      0x26    ; b7 5505262f
            db      0x3b    ; b8 c5ba3bbe
            db      0x0b    ; b9 b2bd0b28
            db      0x5a    ; ba 2bb45a92
            db      0x6a    ; bb 5cb36a04
            db      0xff    ; bc c2d7ffa7
            db      0xcf    ; bd b5d0cf31
            db      0x9e    ; be 2cd99e8b
            db      0xae    ; bf 5bdeae1d
            db      0xc2    ; c0 9b64c2b0
            db      0xf2    ; c1 ec63f226
            db      0xa3    ; c2 756aa39c
            db      0x93    ; c3 026d930a
            db      0x06    ; c4 9c0906a9
            db      0x36    ; c5 eb0e363f
            db      0x67    ; c6 72076785
            db      0x57    ; c7 05005713
            db      0x4a    ; c8 95bf4a82
            db      0x7a    ; c9 e2b87a14
            db      0x2b    ; ca 7bb12bae
            db      0x1b    ; cb 0cb61b38
            db      0x8e    ; cc 92d28e9b
            db      0xbe    ; cd e5d5be0d
            db      0xef    ; ce 7cdcefb7
            db      0xdf    ; cf 0bdbdf21
            db      0xd2    ; d0 86d3d2d4
            db      0xe2    ; d1 f1d4e242
            db      0xb3    ; d2 68ddb3f8
            db      0x83    ; d3 1fda836e
            db      0x16    ; d4 81be16cd
            db      0x26    ; d5 f6b9265b
            db      0x77    ; d6 6fb077e1
            db      0x47    ; d7 18b74777
            db      0x5a    ; d8 88085ae6
            db      0x6a    ; d9 ff0f6a70
            db      0x3b    ; da 66063bca
            db      0x0b    ; db 11010b5c
            db      0x9e    ; dc 8f659eff
            db      0xae    ; dd f862ae69
            db      0xff    ; de 616bffd3
            db      0xcf    ; df 166ccf45
            db      0xe2    ; e0 a00ae278
            db      0xd2    ; e1 d70dd2ee
            db      0x83    ; e2 4e048354
            db      0xb3    ; e3 3903b3c2
            db      0x26    ; e4 a7672661
            db      0x16    ; e5 d06016f7
            db      0x47    ; e6 4969474d
            db      0x77    ; e7 3e6e77db
            db      0x6a    ; e8 aed16a4a
            db      0x5a    ; e9 d9d65adc
            db      0x0b    ; ea 40df0b66
            db      0x3b    ; eb 37d83bf0
            db      0xae    ; ec a9bcae53
            db      0x9e    ; ed debb9ec5
            db      0xcf    ; ee 47b2cf7f
            db      0xff    ; ef 30b5ffe9
            db      0xf2    ; f0 bdbdf21c
            db      0xc2    ; f1 cabac28a
            db      0x93    ; f2 53b39330
            db      0xa3    ; f3 24b4a3a6
            db      0x36    ; f4 bad03605
            db      0x06    ; f5 cdd70693
            db      0x57    ; f6 54de5729
            db      0x67    ; f7 23d967bf
            db      0x7a    ; f8 b3667a2e
            db      0x4a    ; f9 c4614ab8
            db      0x1b    ; fa 5d681b02
            db      0x2b    ; fb 2a6f2b94
            db      0xbe    ; fc b40bbe37
            db      0x8e    ; fd c30c8ea1
            db      0xdf    ; fe 5a05df1b
            db      0xef    ; ff 2d02ef8d

            db      0x00    ; 00 00000000
            db      0x07    ; 01 77073096
            db      0x0e    ; 02 ee0e612c
            db      0x09    ; 03 990951ba
            db      0x6d    ; 04 076dc419
            db      0x6a    ; 05 706af48f
            db      0x63    ; 06 e963a535
            db      0x64    ; 07 9e6495a3
            db      0xdb    ; 08 0edb8832
            db      0xdc    ; 09 79dcb8a4
            db      0xd5    ; 0a e0d5e91e
            db      0xd2    ; 0b 97d2d988
            db      0xb6    ; 0c 09b64c2b
            db      0xb1    ; 0d 7eb17cbd
            db      0xb8    ; 0e e7b82d07
            db      0xbf    ; 0f 90bf1d91
            db      0xb7    ; 10 1db71064
            db      0xb0    ; 11 6ab020f2
            db      0xb9    ; 12 f3b97148
            db      0xbe    ; 13 84be41de
            db      0xda    ; 14 1adad47d
            db      0xdd    ; 15 6ddde4eb
            db      0xd4    ; 16 f4d4b551
            db      0xd3    ; 17 83d385c7
            db      0x6c    ; 18 136c9856
            db      0x6b    ; 19 646ba8c0
            db      0x62    ; 1a fd62f97a
            db      0x65    ; 1b 8a65c9ec
            db      0x01    ; 1c 14015c4f
            db      0x06    ; 1d 63066cd9
            db      0x0f    ; 1e fa0f3d63
            db      0x08    ; 1f 8d080df5
            db      0x6e    ; 20 3b6e20c8
            db      0x69    ; 21 4c69105e
            db      0x60    ; 22 d56041e4
            db      0x67    ; 23 a2677172
            db      0x03    ; 24 3c03e4d1
            db      0x04    ; 25 4b04d447
            db      0x0d    ; 26 d20d85fd
            db      0x0a    ; 27 a50ab56b
            db      0xb5    ; 28 35b5a8fa
            db      0xb2    ; 29 42b2986c
            db      0xbb    ; 2a dbbbc9d6
            db      0xbc    ; 2b acbcf940
            db      0xd8    ; 2c 32d86ce3
            db      0xdf    ; 2d 45df5c75
            db      0xd6    ; 2e dcd60dcf
            db      0xd1    ; 2f abd13d59
            db      0xd9    ; 30 26d930ac
            db      0xde    ; 31 51de003a
            db      0xd7    ; 32 c8d75180
            db      0xd0    ; 33 bfd06116
            db      0xb4    ; 34 21b4f4b5
            db      0xb3    ; 35 56b3c423
            db      0xba    ; 36 cfba9599
            db      0xbd    ; 37 b8bda50f
            db      0x02    ; 38 2802b89e
            db      0x05    ; 39 5f058808
            db      0x0c    ; 3a c60cd9b2
            db      0x0b    ; 3b b10be924
            db      0x6f    ; 3c 2f6f7c87
            db      0x68    ; 3d 58684c11
            db      0x61    ; 3e c1611dab
            db      0x66    ; 3f b6662d3d
            db      0xdc    ; 40 76dc4190
            db      0xdb    ; 41 01db7106
            db      0xd2    ; 42 98d220bc
            db      0xd5    ; 43 efd5102a
            db      0xb1    ; 44 71b18589
            db      0xb6    ; 45 06b6b51f
            db      0xbf    ; 46 9fbfe4a5
            db      0xb8    ; 47 e8b8d433
            db      0x07    ; 48 7807c9a2
            db      0x00    ; 49 0f00f934
            db      0x09    ; 4a 9609a88e
            db      0x0e    ; 4b e10e9818
            db      0x6a    ; 4c 7f6a0dbb
            db      0x6d    ; 4d 086d3d2d
            db      0x64    ; 4e 91646c97
            db      0x63    ; 4f e6635c01
            db      0x6b    ; 50 6b6b51f4
            db      0x6c    ; 51 1c6c6162
            db      0x65    ; 52 856530d8
            db      0x62    ; 53 f262004e
            db      0x06    ; 54 6c0695ed
            db      0x01    ; 55 1b01a57b
            db      0x08    ; 56 8208f4c1
            db      0x0f    ; 57 f50fc457
            db      0xb0    ; 58 65b0d9c6
            db      0xb7    ; 59 12b7e950
            db      0xbe    ; 5a 8bbeb8ea
            db      0xb9    ; 5b fcb9887c
            db      0xdd    ; 5c 62dd1ddf
            db      0xda    ; 5d 15da2d49
            db      0xd3    ; 5e 8cd37cf3
            db      0xd4    ; 5f fbd44c65
            db      0xb2    ; 60 4db26158
            db      0xb5    ; 61 3ab551ce
            db      0xbc    ; 62 a3bc0074
            db      0xbb    ; 63 d4bb30e2
            db      0xdf    ; 64 4adfa541
            db      0xd8    ; 65 3dd895d7
            db      0xd1    ; 66 a4d1c46d
            db      0xd6    ; 67 d3d6f4fb
            db      0x69    ; 68 4369e96a
            db      0x6e    ; 69 346ed9fc
            db      0x67    ; 6a ad678846
            db      0x60    ; 6b da60b8d0
            db      0x04    ; 6c 44042d73
            db      0x03    ; 6d 33031de5
            db      0x0a    ; 6e aa0a4c5f
            db      0x0d    ; 6f dd0d7cc9
            db      0x05    ; 70 5005713c
            db      0x02    ; 71 270241aa
            db      0x0b    ; 72 be0b1010
            db      0x0c    ; 73 c90c2086
            db      0x68    ; 74 5768b525
            db      0x6f    ; 75 206f85b3
            db      0x66    ; 76 b966d409
            db      0x61    ; 77 ce61e49f
            db      0xde    ; 78 5edef90e
            db      0xd9    ; 79 29d9c998
            db      0xd0    ; 7a b0d09822
            db      0xd7    ; 7b c7d7a8b4
            db      0xb3    ; 7c 59b33d17
            db      0xb4    ; 7d 2eb40d81
            db      0xbd    ; 7e b7bd5c3b
            db      0xba    ; 7f c0ba6cad
            db      0xb8    ; 80 edb88320
            db      0xbf    ; 81 9abfb3b6
            db      0xb6    ; 82 03b6e20c
            db      0xb1    ; 83 74b1d29a
            db      0xd5    ; 84 ead54739
            db      0xd2    ; 85 9dd277af
            db      0xdb    ; 86 04db2615
            db      0xdc    ; 87 73dc1683
            db      0x63    ; 88 e3630b12
            db      0x64    ; 89 94643b84
            db      0x6d    ; 8a 0d6d6a3e
            db      0x6a    ; 8b 7a6a5aa8
            db      0x0e    ; 8c e40ecf0b
            db      0x09    ; 8d 9309ff9d
            db      0x00    ; 8e 0a00ae27
            db      0x07    ; 8f 7d079eb1
            db      0x0f    ; 90 f00f9344
            db      0x08    ; 91 8708a3d2
            db      0x01    ; 92 1e01f268
            db      0x06    ; 93 6906c2fe
            db      0x62    ; 94 f762575d
            db      0x65    ; 95 806567cb
            db      0x6c    ; 96 196c3671
            db      0x6b    ; 97 6e6b06e7
            db      0xd4    ; 98 fed41b76
            db      0xd3    ; 99 89d32be0
            db      0xda    ; 9a 10da7a5a
            db      0xdd    ; 9b 67dd4acc
            db      0xb9    ; 9c f9b9df6f
            db      0xbe    ; 9d 8ebeeff9
            db      0xb7    ; 9e 17b7be43
            db      0xb0    ; 9f 60b08ed5
            db      0xd6    ; a0 d6d6a3e8
            db      0xd1    ; a1 a1d1937e
            db      0xd8    ; a2 38d8c2c4
            db      0xdf    ; a3 4fdff252
            db      0xbb    ; a4 d1bb67f1
            db      0xbc    ; a5 a6bc5767
            db      0xb5    ; a6 3fb506dd
            db      0xb2    ; a7 48b2364b
            db      0x0d    ; a8 d80d2bda
            db      0x0a    ; a9 af0a1b4c
            db      0x03    ; aa 36034af6
            db      0x04    ; ab 41047a60
            db      0x60    ; ac df60efc3
            db      0x67    ; ad a867df55
            db      0x6e    ; ae 316e8eef
            db      0x69    ; af 4669be79
            db      0x61    ; b0 cb61b38c
            db      0x66    ; b1 bc66831a
            db      0x6f    ; b2 256fd2a0
            db      0x68    ; b3 5268e236
            db      0x0c    ; b4 cc0c7795
            db      0x0b    ; b5 bb0b4703
            db      0x02    ; b6 220216b9
            db      0x05    ; b7 5505262f
            db      0xba    ; b8 c5ba3bbe
            db      0xbd    ; b9 b2bd0b28
            db      0xb4    ; ba 2bb45a92
            db      0xb3    ; bb 5cb36a04
            db      0xd7    ; bc c2d7ffa7
            db      0xd0    ; bd b5d0cf31
            db      0xd9    ; be 2cd99e8b
            db      0xde    ; bf 5bdeae1d
            db      0x64    ; c0 9b64c2b0
            db      0x63    ; c1 ec63f226
            db      0x6a    ; c2 756aa39c
            db      0x6d    ; c3 026d930a
            db      0x09    ; c4 9c0906a9
            db      0x0e    ; c5 eb0e363f
            db      0x07    ; c6 72076785
            db      0x00    ; c7 05005713
            db      0xbf    ; c8 95bf4a82
            db      0xb8    ; c9 e2b87a14
            db      0xb1    ; ca 7bb12bae
            db      0xb6    ; cb 0cb61b38
            db      0xd2    ; cc 92d28e9b
            db      0xd5    ; cd e5d5be0d
            db      0xdc    ; ce 7cdcefb7
            db      0xdb    ; cf 0bdbdf21
            db      0xd3    ; d0 86d3d2d4
            db      0xd4    ; d1 f1d4e242
            db      0xdd    ; d2 68ddb3f8
            db      0xda    ; d3 1fda836e
            db      0xbe    ; d4 81be16cd
            db      0xb9    ; d5 f6b9265b
            db      0xb0    ; d6 6fb077e1
            db      0xb7    ; d7 18b74777
            db      0x08    ; d8 88085ae6
            db      0x0f    ; d9 ff0f6a70
            db      0x06    ; da 66063bca
            db      0x01    ; db 11010b5c
            db      0x65    ; dc 8f659eff
            db      0x62    ; dd f862ae69
            db      0x6b    ; de 616bffd3
            db      0x6c    ; df 166ccf45
            db      0x0a    ; e0 a00ae278
            db      0x0d    ; e1 d70dd2ee
            db      0x04    ; e2 4e048354
            db      0x03    ; e3 3903b3c2
            db      0x67    ; e4 a7672661
            db      0x60    ; e5 d06016f7
            db      0x69    ; e6 4969474d
            db      0x6e    ; e7 3e6e77db
            db      0xd1    ; e8 aed16a4a
            db      0xd6    ; e9 d9d65adc
            db      0xdf    ; ea 40df0b66
            db      0xd8    ; eb 37d83bf0
            db      0xbc    ; ec a9bcae53
            db      0xbb    ; ed debb9ec5
            db      0xb2    ; ee 47b2cf7f
            db      0xb5    ; ef 30b5ffe9
            db      0xbd    ; f0 bdbdf21c
            db      0xba    ; f1 cabac28a
            db      0xb3    ; f2 53b39330
            db      0xb4    ; f3 24b4a3a6
            db      0xd0    ; f4 bad03605
            db      0xd7    ; f5 cdd70693
            db      0xde    ; f6 54de5729
            db      0xd9    ; f7 23d967bf
            db      0x66    ; f8 b3667a2e
            db      0x61    ; f9 c4614ab8
            db      0x68    ; fa 5d681b02
            db      0x6f    ; fb 2a6f2b94
            db      0x0b    ; fc b40bbe37
            db      0x0c    ; fd c30c8ea1
            db      0x05    ; fe 5a05df1b
            db      0x02    ; ff 2d02ef8d

            db      0x00    ; 00 00000000
            db      0x77    ; 01 77073096
            db      0xee    ; 02 ee0e612c
            db      0x99    ; 03 990951ba
            db      0x07    ; 04 076dc419
            db      0x70    ; 05 706af48f
            db      0xe9    ; 06 e963a535
            db      0x9e    ; 07 9e6495a3
            db      0x0e    ; 08 0edb8832
            db      0x79    ; 09 79dcb8a4
            db      0xe0    ; 0a e0d5e91e
            db      0x97    ; 0b 97d2d988
            db      0x09    ; 0c 09b64c2b
            db      0x7e    ; 0d 7eb17cbd
            db      0xe7    ; 0e e7b82d07
            db      0x90    ; 0f 90bf1d91
            db      0x1d    ; 10 1db71064
            db      0x6a    ; 11 6ab020f2
            db      0xf3    ; 12 f3b97148
            db      0x84    ; 13 84be41de
            db      0x1a    ; 14 1adad47d
            db      0x6d    ; 15 6ddde4eb
            db      0xf4    ; 16 f4d4b551
            db      0x83    ; 17 83d385c7
            db      0x13    ; 18 136c9856
            db      0x64    ; 19 646ba8c0
            db      0xfd    ; 1a fd62f97a
            db      0x8a    ; 1b 8a65c9ec
            db      0x14    ; 1c 14015c4f
            db      0x63    ; 1d 63066cd9
            db      0xfa    ; 1e fa0f3d63
            db      0x8d    ; 1f 8d080df5
            db      0x3b    ; 20 3b6e20c8
            db      0x4c    ; 21 4c69105e
            db      0xd5    ; 22 d56041e4
            db      0xa2    ; 23 a2677172
            db      0x3c    ; 24 3c03e4d1
            db      0x4b    ; 25 4b04d447
            db      0xd2    ; 26 d20d85fd
            db      0xa5    ; 27 a50ab56b
            db      0x35    ; 28 35b5a8fa
            db      0x42    ; 29 42b2986c
            db      0xdb    ; 2a dbbbc9d6
            db      0xac    ; 2b acbcf940
            db      0x32    ; 2c 32d86ce3
            db      0x45    ; 2d 45df5c75
            db      0xdc    ; 2e dcd60dcf
            db      0xab    ; 2f abd13d59
            db      0x26    ; 30 26d930ac
            db      0x51    ; 31 51de003a
            db      0xc8    ; 32 c8d75180
            db      0xbf    ; 33 bfd06116
            db      0x21    ; 34 21b4f4b5
            db      0x56    ; 35 56b3c423
            db      0xcf    ; 36 cfba9599
            db      0xb8    ; 37 b8bda50f
            db      0x28    ; 38 2802b89e
            db      0x5f    ; 39 5f058808
            db      0xc6    ; 3a c60cd9b2
            db      0xb1    ; 3b b10be924
            db      0x2f    ; 3c 2f6f7c87
            db      0x58    ; 3d 58684c11
            db      0xc1    ; 3e c1611dab
            db      0xb6    ; 3f b6662d3d
            db      0x76    ; 40 76dc4190
            db      0x01    ; 41 01db7106
            db      0x98    ; 42 98d220bc
            db      0xef    ; 43 efd5102a
            db      0x71    ; 44 71b18589
            db      0x06    ; 45 06b6b51f
            db      0x9f    ; 46 9fbfe4a5
            db      0xe8    ; 47 e8b8d433
            db      0x78    ; 48 7807c9a2
            db      0x0f    ; 49 0f00f934
            db      0x96    ; 4a 9609a88e
            db      0xe1    ; 4b e10e9818
            db      0x7f    ; 4c 7f6a0dbb
            db      0x08    ; 4d 086d3d2d
            db      0x91    ; 4e 91646c97
            db      0xe6    ; 4f e6635c01
            db      0x6b    ; 50 6b6b51f4
            db      0x1c    ; 51 1c6c6162
            db      0x85    ; 52 856530d8
            db      0xf2    ; 53 f262004e
            db      0x6c    ; 54 6c0695ed
            db      0x1b    ; 55 1b01a57b
            db      0x82    ; 56 8208f4c1
            db      0xf5    ; 57 f50fc457
            db      0x65    ; 58 65b0d9c6
            db      0x12    ; 59 12b7e950
            db      0x8b    ; 5a 8bbeb8ea
            db      0xfc    ; 5b fcb9887c
            db      0x62    ; 5c 62dd1ddf
            db      0x15    ; 5d 15da2d49
            db      0x8c    ; 5e 8cd37cf3
            db      0xfb    ; 5f fbd44c65
            db      0x4d    ; 60 4db26158
            db      0x3a    ; 61 3ab551ce
            db      0xa3    ; 62 a3bc0074
            db      0xd4    ; 63 d4bb30e2
            db      0x4a    ; 64 4adfa541
            db      0x3d    ; 65 3dd895d7
            db      0xa4    ; 66 a4d1c46d
            db      0xd3    ; 67 d3d6f4fb
            db      0x43    ; 68 4369e96a
            db      0x34    ; 69 346ed9fc
            db      0xad    ; 6a ad678846
            db      0xda    ; 6b da60b8d0
            db      0x44    ; 6c 44042d73
            db      0x33    ; 6d 33031de5
            db      0xaa    ; 6e aa0a4c5f
            db      0xdd    ; 6f dd0d7cc9
            db      0x50    ; 70 5005713c
            db      0x27    ; 71 270241aa
            db      0xbe    ; 72 be0b1010
            db      0xc9    ; 73 c90c2086
            db      0x57    ; 74 5768b525
            db      0x20    ; 75 206f85b3
            db      0xb9    ; 76 b966d409
            db      0xce    ; 77 ce61e49f
            db      0x5e    ; 78 5edef90e
            db      0x29    ; 79 29d9c998
            db      0xb0    ; 7a b0d09822
            db      0xc7    ; 7b c7d7a8b4
            db      0x59    ; 7c 59b33d17
            db      0x2e    ; 7d 2eb40d81
            db      0xb7    ; 7e b7bd5c3b
            db      0xc0    ; 7f c0ba6cad
            db      0xed    ; 80 edb88320
            db      0x9a    ; 81 9abfb3b6
            db      0x03    ; 82 03b6e20c
            db      0x74    ; 83 74b1d29a
            db      0xea    ; 84 ead54739
            db      0x9d    ; 85 9dd277af
            db      0x04    ; 86 04db2615
            db      0x73    ; 87 73dc1683
            db      0xe3    ; 88 e3630b12
            db      0x94    ; 89 94643b84
            db      0x0d    ; 8a 0d6d6a3e
            db      0x7a    ; 8b 7a6a5aa8
            db      0xe4    ; 8c e40ecf0b
            db      0x93    ; 8d 9309ff9d
            db      0x0a    ; 8e 0a00ae27
            db      0x7d    ; 8f 7d079eb1
            db      0xf0    ; 90 f00f9344
            db      0x87    ; 91 8708a3d2
            db      0x1e    ; 92 1e01f268
            db      0x69    ; 93 6906c2fe
            db      0xf7    ; 94 f762575d
            db      0x80    ; 95 806567cb
            db      0x19    ; 96 196c3671
            db      0x6e    ; 97 6e6b06e7
            db      0xfe    ; 98 fed41b76
            db      0x89    ; 99 89d32be0
            db      0x10    ; 9a 10da7a5a
            db      0x67    ; 9b 67dd4acc
            db      0xf9    ; 9c f9b9df6f
            db      0x8e    ; 9d 8ebeeff9
            db      0x17    ; 9e 17b7be43
            db      0x60    ; 9f 60b08ed5
            db      0xd6    ; a0 d6d6a3e8
            db      0xa1    ; a1 a1d1937e
            db      0x38    ; a2 38d8c2c4
            db      0x4f    ; a3 4fdff252
            db      0xd1    ; a4 d1bb67f1
            db      0xa6    ; a5 a6bc5767
            db      0x3f    ; a6 3fb506dd
            db      0x48    ; a7 48b2364b
            db      0xd8    ; a8 d80d2bda
            db      0xaf    ; a9 af0a1b4c
            db      0x36    ; aa 36034af6
            db      0x41    ; ab 41047a60
            db      0xdf    ; ac df60efc3
            db      0xa8    ; ad a867df55
            db      0x31    ; ae 316e8eef
            db      0x46    ; af 4669be79
            db      0xcb    ; b0 cb61b38c
            db      0xbc    ; b1 bc66831a
            db      0x25    ; b2 256fd2a0
            db      0x52    ; b3 5268e236
            db      0xcc    ; b4 cc0c7795
            db      0xbb    ; b5 bb0b4703
            db      0x22    ; b6 220216b9
            db      0x55    ; b7 5505262f
            db      0xc5    ; b8 c5ba3bbe
            db      0xb2    ; b9 b2bd0b28
            db      0x2b    ; ba 2bb45a92
            db      0x5c    ; bb 5cb36a04
            db      0xc2    ; bc c2d7ffa7
            db      0xb5    ; bd b5d0cf31
            db      0x2c    ; be 2cd99e8b
            db      0x5b    ; bf 5bdeae1d
            db      0x9b    ; c0 9b64c2b0
            db      0xec    ; c1 ec63f226
            db      0x75    ; c2 756aa39c
            db      0x02    ; c3 026d930a
            db      0x9c    ; c4 9c0906a9
            db      0xeb    ; c5 eb0e363f
            db      0x72    ; c6 72076785
            db      0x05    ; c7 05005713
            db      0x95    ; c8 95bf4a82
            db      0xe2    ; c9 e2b87a14
            db      0x7b    ; ca 7bb12bae
            db      0x0c    ; cb 0cb61b38
            db      0x92    ; cc 92d28e9b
            db      0xe5    ; cd e5d5be0d
            db      0x7c    ; ce 7cdcefb7
            db      0x0b    ; cf 0bdbdf21
            db      0x86    ; d0 86d3d2d4
            db      0xf1    ; d1 f1d4e242
            db      0x68    ; d2 68ddb3f8
            db      0x1f    ; d3 1fda836e
            db      0x81    ; d4 81be16cd
            db      0xf6    ; d5 f6b9265b
            db      0x6f    ; d6 6fb077e1
            db      0x18    ; d7 18b74777
            db      0x88    ; d8 88085ae6
            db      0xff    ; d9 ff0f6a70
            db      0x66    ; da 66063bca
            db      0x11    ; db 11010b5c
            db      0x8f    ; dc 8f659eff
            db      0xf8    ; dd f862ae69
            db      0x61    ; de 616bffd3
            db      0x16    ; df 166ccf45
            db      0xa0    ; e0 a00ae278
            db      0xd7    ; e1 d70dd2ee
            db      0x4e    ; e2 4e048354
            db      0x39    ; e3 3903b3c2
            db      0xa7    ; e4 a7672661
            db      0xd0    ; e5 d06016f7
            db      0x49    ; e6 4969474d
            db      0x3e    ; e7 3e6e77db
            db      0xae    ; e8 aed16a4a
            db      0xd9    ; e9 d9d65adc
            db      0x40    ; ea 40df0b66
            db      0x37    ; eb 37d83bf0
            db      0xa9    ; ec a9bcae53
            db      0xde    ; ed debb9ec5
            db      0x47    ; ee 47b2cf7f
            db      0x30    ; ef 30b5ffe9
            db      0xbd    ; f0 bdbdf21c
            db      0xca    ; f1 cabac28a
            db      0x53    ; f2 53b39330
            db      0x24    ; f3 24b4a3a6
            db      0xba    ; f4 bad03605
            db      0xcd    ; f5 cdd70693
            db      0x54    ; f6 54de5729
            db      0x23    ; f7 23d967bf
            db      0xb3    ; f8 b3667a2e
            db      0xc4    ; f9 c4614ab8
            db      0x5d    ; fa 5d681b02
            db      0x2a    ; fb 2a6f2b94
            db      0xb4    ; fc b40bbe37
            db      0xc3    ; fd c30c8ea1
            db      0x5a    ; fe 5a05df1b
            db      0x2d    ; ff 2d02ef8d

; EOF ;
