	org #100

	di
	xor a
	out (10h),a
	ld hl,100h
	ld (1),hl
	ld sp,hl
	ld a,0C3h
	ld (0),a


	;test code

begin

	ld hl,music_data
	call play
	jp $
	
	
;Squeeker beeper engine by Zilogat0r
;- original version 2000
;- size optimized version 2012
;- new data format and loader by utz 2015
;- 8080 conversion by ivagor 2024


play

	ld a,(hl)		;configure global duty setting
	ld (duty1),a
	ld (duty2),a
	ld (duty3),a
	ld (duty4),a
	inc hl
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (seqpntr),hl
	ex de,hl
	ld (mLoopVar),hl
	
	ld hl,0
	add hl,sp
	ld (oldSP),hl

;******************************************************************
rdseq
seqpntr equ $+1
	ld sp,0
	xor a
	pop de			;pattern pointer to DE
	or d
	ld hl,0
	add hl,sp
	ld (seqpntr),hl
	jp nz,rdptn0
	
	;jp exit		;uncomment to disable looping
	
mLoopVar=$+1
	ld sp,0			;get loop point
	jp rdseq+3

;******************************************************************
rdptn0
	ex de,hl
	ld (patpntr),hl
rdptn
	in a,(1)		;read kbd US,SS,RUS/LAT
	and 11100000b
	cp 11100000b
	jp nz,exit

patpntr equ $+1			;fetch pointer to pattern data
	ld sp,0

	pop af	
	jp z,setAll		;#40
	jp c,set123		;#01
	jp pe,set12		;#04
	jp m,set1		;#80
	jp setNone		;#00

setAll
	pop hl
	ld (Cnt4add+1),hl
	ld (Cnt4+1),hl

set123
	pop hl
	ld (Cnt3add+1),hl
	ld (Cnt3+1),hl

set12
	pop hl
	ld (Cnt2add+1),hl
	ld (Cnt2+1),hl

set1
	pop hl
	ld (Cnt1add+1),hl
	ld (Cnt1+1),hl
	
setNone
	or a
	jp z,rdseq
	
	ld hl,0
	add hl,sp
	ld (patpntr),hl

	ld h,a			;set speed
	ld l,0
	ld (Counter),hl

Cnt1
	ld sp,0
Cnt2:
	ld de,0
;******************************************************************
mxb	

Cnt1add:
	ld hl,0
	add hl,sp
	ld sp,hl
duty1 equ $+1
	ld a,40			;duty
	add a,h

	ld a,0
	rla
Cnt2add:
	ld hl,0
	add hl,de
	ex de,hl
	ld l,a
duty2 equ $+1
	ld a,40			;duty
	add a,h

	ld a,l
	rla
Cnt3add:
	ld bc,0
Cnt3:
	ld hl,0
	add hl,bc
	ld (Cnt3+1),hl
	ld l,a
duty3 equ $+1
	ld a,40			;duty
	add a,h

	ld a,l
	rla
Cnt4add:
	ld bc,0
Cnt4:
	ld hl,0
	add hl,bc
	ld (Cnt4+1),hl
	ld l,a
duty4 equ $+1
	ld a,40			;duty
	add a,h
	
	ld a,127
	adc a,l
	rlca
	and 1
	out (0),a
	ld hl,Counter
	dec (hl)
	jp nz,mxb
	inc hl
	dec (hl)
	jp nz,mxb

	ex de,hl
	ld (Cnt2+1),hl

	ld hl,0
	add hl,sp
	ld (Cnt1+1),hl

	jp rdptn

Counter
	dw 0
;******************************************************************
exit
oldSP equ $+1
	ld sp,0
	ret
;******************************************************************

;compiled music data

music_data
	db 32
	dw .loop
	dw .pattern1
.loop:
	dw .pattern2
	dw 0
.pattern1
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#9e8,#7dd,#3ee
	dw #440,#0,#0,#0,#3ee
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#9e8,#7dd,#3ee
	dw #440,#0,#0,#0,#3ee
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#9e8,#7dd,#3ee
	dw #440,#0,#0,#0,#3ee
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#8d3,#bc8,#3ee
	dw #440,#0,#0,#0,#3ee
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#8d3,#bc8,#3ee
	dw #440,#0,#0,#0,#3ee
	dw #440,#1f6,#0,#0,#1f7
	dw #440,#0,#0,#0,#1f7
	dw #440,#1f6,#0,#0,#3ee
	dw #440,#0,#0,#0,#3ee
	dw 0
.pattern2
	dw #440,#2f1,#0,#0,#2f2
	dw #440,#0,#0,#0,#2f2
	dw #440,#2f1,#0,#0,#5e4
	dw #440,#0,#0,#0,#5e4
	dw #440,#29e,#0,#0,#29f
	dw #440,#0,#0,#0,#29f
	dw #440,#29e,#0,#0,#53f
	dw #440,#0,#0,#0,#53f
	dw 0
