//`define MEM_SIZE_32M    // uncomment for K4S561632, else (for K4S281632) comment it
`define MEM_SIZE_64M    // uncomment for MT48LC32M16A2, else comment it


module sdram_test
(
   input CLK_50MHZ,

   output VGA_RGB_R_OUT,
   output VGA_RGB_G_OUT,
   output VGA_RGB_B_OUT,
   output VGA_HSYNC_OUT,
   output VGA_VSYNC_OUT,

   // VASILI VHDL CODE
   input  PICO_CLK,                    // PICO_CLK_16MHz (VS note)
   //  usb_kbd signals
   //output A,                         // in std_logic_vector(15 downto 8);                // address bus for kbd
   //output KB,                        // out std_logic_vector(4 downto 0) := "ZZZZZ";     // data bus for kbd
   input  PICO_MOSI,
   output PICO_MISO,
   input  PICO_SCK,
   input  PICO_SS,
   //   output O_RESET,
   //   output O_TURBO,
   //   output O_MAGICK,
   //   output O_SPECIAL,
   //   // Debug
   //   output O_CLK,
   //   output O_TEST,
   //   output O_DEBUG,
   // SD-CARD
   input  SD_SO,
   output SD_CLK,
   output SD_SI,
   output SD_NCS,
   // BUTTONS    
   input RESET_n,                      //input BUTTON_RED,
   input BUTTON_BLACK,
   // REMOTE CONTROL
   input REMOTE_CONTROL,
   // USB
   //inout  USB(1), // Used for VGA via wire jumper - [66]
   //inout  USB(2), // USED for VGA via wire jumper - [67]
   // HDMI
   output HDMI_D0,
   output HDMI_D1,
   output HDMI_D1N = 1'b0,             // : out std_logic := '0';
   output HDMI_D2,
   output HDMI_CLK,

   input HDMI_NDET,
   inout HDMI_CEC,
   output HDMI_SCL = 1'b1,
   inout HDMI_SDA,

   // SD-RAM ports
   output DRAM_CLK,                    // SD-RAM Clock
   //   output DRAM_CLKE,                   // SD-RAM Clock enable   Vasili: logic "1" by resistor
   output DRAM_NCS,                    // SD-RAM Chip select    Vasili: logic "0" by jumper
   output DRAM_NRAS,                   // SD-RAM Row/RAS
   output DRAM_NCAS,                   // SD-RAM /CAS
   output DRAM_NWE,                    // SD-RAM /WE
   output DQMH,                        // SD-RAM UDQM
   output DQML,                        // SD-RAM LDQM
   output DRAM_BA1,                    // SD-RAM Bank select address 1
   output DRAM_BA0,                    // SD-RAM Bank select address 0
   output [12:0] DRAM_A,               // SD-RAM Address
   inout  [15:0] DRAM_DQ               // SD-RAM Data

);

//-----------------------------------------------------------------------------

`ifdef MEM_SIZE_64M
   parameter DRAM_COL_SIZE = 10;
   parameter DRAM_ROW_SIZE = 13;
`else
//   assign    DRAM_A[12]    = 1'b0;
//   parameter DRAM_COL_SIZE = 9;
//   parameter DRAM_ROW_SIZE = 12;
`endif

//-----------------------------------------------------------------------------


 wire clk, sdram_clk, videoclk, locked;
 pll_new pll_new( .inclk0(CLK_50MHZ), .c0(clk), .c1(videoclk), .c2(sdram_clk), .locked(locked) );
 assign DRAM_CLK = sdram_clk;
 //assign DRAM_CLKE = 1'b1;


 wire rst_n;
 defparam my_reset.RST_CNT_SIZE = 16;
 resetter my_reset( .clk(clk), .rst_in_n( RESET_n & locked ), .rst_out_n(rst_n) );


 wire [31:0] passcount, failcount;
 wire [3:0] mmtst_state;
 wire [5:0] sdram_state;
 defparam my_memtst.DRAM_COL_SIZE = DRAM_COL_SIZE;
 defparam my_memtst.DRAM_ROW_SIZE = DRAM_ROW_SIZE;
 mem_tester my_memtst( .clk(clk), .rst_n(rst_n), .passcount(passcount), .failcount(failcount),
                       .mmtst_state(mmtst_state),
                       .sdram_state(sdram_state),
                       .DRAM_DQ(DRAM_DQ),      .DRAM_ADDR(DRAM_A[DRAM_ROW_SIZE-1:0]),
                       .DRAM_LDQM(DQML),       .DRAM_UDQM(DQMH),
                       .DRAM_WE_N(DRAM_NWE),   .DRAM_CS_N(DRAM_NCS),
                       .DRAM_RAS_N(DRAM_NRAS), .DRAM_CAS_N(DRAM_NCAS),
                       .DRAM_BA_0(DRAM_BA0),   .DRAM_BA_1(DRAM_BA1) );


 wire hs, vs;
 wire [1:0] b, r, g;
 vgaout showrez( .clk(videoclk),
                 .rez1(passcount),
                 .rez2(failcount),
                 .rez3({2'b00,mmtst_state}),
                 .rez4(sdram_state),
                 .hs(hs),
                 .vs(vs),
                 .b(b), .r(r), .g(g)
               );
 assign VGA_HSYNC_OUT = hs;
 assign VGA_VSYNC_OUT = vs;
// assign VGA_RGB_B_OUT = { 1'b0,b[1],b[0],b[1],b[0],b[1],b[0],b[1] };    // output [7:0] VIDEO_B
// assign VGA_RGB_R_OUT = { 1'b0,r[1],r[0],r[1],r[0],r[1],r[0],r[1] };    // output [7:0] VIDEO_R
// assign VGA_RGB_G_OUT = { 1'b0,g[1],g[0],g[1],g[0],g[1],g[0],g[1] };    // output [7:0] VIDEO_G

 assign VGA_RGB_B_OUT = ( b[1] | b[0] ) ;    // output [7:0] VIDEO_B
 assign VGA_RGB_R_OUT = ( r[1] | r[0] ) ;    // output [7:0] VIDEO_R
 assign VGA_RGB_G_OUT = ( g[1] | g[0] ) ;    // output [7:0] VIDEO_G

 

endmodule

//-----------------------------------------------------------------------------
