
; NRV2D DECOMPRESSOR FOR PDP-11
; IN:	R0 - PACKED DATA SOURCE ADDRESS
;	R1 - UNPACKED DATA DESTINATION ADDRESS
; OUT:	R0 - POINTS TO THE POSITION AFTER LAST BYTE OF INPUT DATA
;	R1 - POSITION AFTER LAST BYTE OF OUTPUT BUFFER
; STACK USAGE: 1 WORD (2 BYTES) + 1 WORD (2 BYTES) RETURN ADDRESS
; CODE SIZE: 158 BYTES

; IMPORTANT. THIS CODE DOES NOT ACCEPT ORIGINAL PACKED BYTE SEQUENCES'S FINAL
; MARKER. 32-BIT OFFSET USED IN ORIGINAL ALGORITHM IS DIFFICULT TO ENCODE ON
; 8-BIT PROCESSOR, THE COMPRESSION SUBROUTINE `ucl_nrv_99_compress` MUST BE
; MODIFICATED TO EMIT SHORT FINAL CODE PREFIX:
; UCL VERSION: 1.03, FILE `src\n2_99.ch`, LINE #605, ORIGINAL:
;	code_prefix_ss12(c, UCL_UINT32_C(0x1000000));
; SHOULD BE:
;	code_prefix_ss12(c, UCL_UINT32_C(0x100));

N2DUNPK:
	MOV	#-1, R4
	XOR	R2, R2
	BR	DCL

NXDC:	MOVB	(R0)+, (R1)+
DCL:	CALL	RB
	BCS	NXDC

	MOV	#1, R3
OFN:	ADD	R3, R3
	CALL	RB
	ADC	R3
	CALL	RB
	BCS	OFE
	DEC	R3
	ADD	R3, R3
	CALL	RB
	ADC	R3
	BR	OFN

RB:	ADD	R2, R2
	BEQ	RBZ
	RET
RBZ:	MOVB	(R0)+, R2
	SWAB	R2
	BIC	#177, R2
	BIS	#200, R2
	ADD	R2, R2
	RET

OFE:	SUB	#3, R3
	BCC	OF2

	MOV	R4, R3
	XOR	R5, R5
	CALL	RB
	ADC	R5
	BR	OF3

OF2:	SWAB	R3
	MOVB	(R0)+, R5
	BIC	#177400, R5
	BIS	R5, R3
	COM	R3
	BEQ	BRK
	XOR	R5, R5
	SEC
	ROR	R3
	ADC	R5
	MOV	R3, R4

OF3:	ADD	R5, R5
	CALL	RB
	ADC	R5
	BNE	LF1

	INC	R5
NXLF:	ADD	R5, R5
	CALL	RB
	ADC	R5
	CALL	RB
	BCC	NXLF
	ADD	#2, R5

LF1:	CMP	R3, #175400
	ADC	R5
	INC	R5

	ADD	R1, R3
NXMV:	MOVB	(R3)+, (R1)+
	SOB	R5, NXMV
	BR	DCL

BRK:	RET
