                ; i8080 assembler code
                .project trackr27.rk
                .tape rk-bin

                ROM             equ $F800               ; Начало ПЗУ

                KR580VG75       equ $C000
                KR580VT57       equ $E000
                KR580VV55_KBD   equ $8000
                KR580VV55_PPI   equ $A000
                KR580VI53       equ $B000
                KR580VV51A      equ $0000
                K555IR27        equ $D000

                COLS		equ 78
                ROWS		equ 38
                DMA_SIZE        equ COLS * ROWS - 1

                ; Видеорежимы
                DISPLAY_78X38   equ (ROWS - 1) << 8 | (COLS - 1)
                GRAPH_78X38     equ $5377
                DMA_SIZE_78X38  equ DMA_SIZE

                org $0000

                JMP START
                
                ; Конфигурация платформы
                
                RECORD_00:      dw KR580VG75
                RECORD_01:      dw KR580VT57
                RECORD_02:      dw KR580VV55_KBD
                RECORD_03:      dw KR580VV55_PPI
                RECORD_04:      dw KR580VI53
                RECORD_05:      dw KR580VV51A
                RECORD_06:      dw K555IR27
                
                RECORD_07:      dw $0000
                RECORD_08:      dw $0000

                CLOCK:          dw $00
                
                TRACK_POINTER   db $00
                VALUE_NOISE     db $00
                VALUE_FILTER    db $00
                

        SET_DISPLAY: ; Настройка ВГ75
        
                ; DE - строки и столбцы
                ; BC - размер знакоместа и курсор

		; Останов КР580ВГ75
		LXI H, KR580VG75 + 1


		; Скрываем курсор

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		; Останов КР580ВГ75

		INR L
		MVI M, 0
		DCR L

        	MOV M, E	; Столбцы
        	MOV M, D	; Строки
        	MOV M, C	; Позиция курсора и кол-во линий в знакоместе
        	MOV M, B	; 0101.0011
        	
 		; Старт КР580ВГ75

		INR L
        	MVI M, 025h

		CALL VG75_READY
		
		RET

		
        SET_DMA: ; Настройка ПДП

                ; DE - адрес экрана
                ; BC - размер экрана
                
                LXI H, KR580VT57
		MVI L, $08
		MVI M, $80
		MVI L, $04
		MOV M, E
		MOV M, D

		INR L
		MOV M, C
		MOV M, B
		MVI L, $08
		MVI M, $A4

                RET


        VG75_READY: ; Ждем обратный ход

                LXI H, KR580VG75 + 1
		MOV A, M
		MOV A, M \\ ANI $20 \\ JZ . - 3
                RET            


        VI53_RST: ; Сброс ВИ53
        
                LXI H, KR580VI53 + 3
                MVI M, $36 \\ MVI M, $66 \\ MVI M, $B6
                RET

                
        PRINT_TEXT:

		LDAX D
		CPI $0D \\ RZ
		MOV M, A \\ INX H \\ INX D
                JMP PRINT_TEXT
                
		RET


        SPRITE_3X3:	

                LXI B, COLS - 2
		CALL SPRITE_ROW_3 \\ DAD B
		CALL SPRITE_ROW_3 \\ DAD B
		CALL SPRITE_ROW_3

                RET


        SPRITE_ROW_3:

                LDAX D \\ MOV M, A \\ INX D \\ INX H
                LDAX D \\ MOV M, A \\ INX D \\ INX H
                LDAX D \\ MOV M, A \\ INX D

                RET


        DEC_8:

                MVI B, 0
                
                DEC_100:
                
                INR B
                MOV C, A
                SBI 100
                JNC DEC_100
                
                DCR B
                MOV A, B
                CALL PRINT_NUM
                MOV A, C
                MVI B, 0

                DEC_10:
                
                INR B
                MOV C, A
                SBI 10
                JNC DEC_10
                
                DCR B
                MOV A, B
                CALL PRINT_NUM
                MOV A, C
                MVI B, 0

                DEC_1:
                
                CALL PRINT_NUM

                RET


        PRINT_NUM:

                PUSH B
                PUSH H
                
		XCHG
		
                LXI H, NUMBERS
                MVI B, 0
                MOV C, A
                ADD A
                ADD A
                ADD A
                ADD C
                MOV C, A
                DAD B
                
		XCHG

                CALL SPRITE_3X3

                POP H
                LXI B, $0003
                DAD B
                
                POP B
                
                RET


        DRAW_TRACK:		
        
                LXI H, TRACK_POINTER
                MVI B, 0
                MOV C, M
                LXI H, TRACK_LEAD - 3
                DAD B
                
                PUSH H
                POP B
                
                LXI H, SCREEN + COLS * 4 + 27

                MVI A, $07

                DRAW_CYCLE:                
                
                PUSH PSW

                LDAX B
                CPI $FF
                JNZ . + 5
                MVI A, $01

                PUSH B

                XCHG
                LXI H, SCALES_TEXT
                MVI B, 0
                MOV C, A
                DAD B
                DAD B
                DAD B
                XCHG
                
                LXI B, COLS - 2
                
		CALL SPRITE_ROW_3
		DAD B

                POP B
                INX B
                POP PSW
                DCR A
                JNZ DRAW_CYCLE

                RET


        DRAW_LEVEL:		

                LDA VALUE_FILTER
                ORA A \\ RAR
                MOV B, A

                MVI A, $07
                LXI H, SCREEN + COLS * 3 + 31
                LXI D, COLS - 1

                DRW_FILTER:
                
                MVI C, $7F
                CMP B \\ JC . + 5 \\ MVI C, $00
                MOV M, C \\ INX H \\ MOV M, C

                DAD D
                DCR A
                
                JP DRW_FILTER
        
                LDA VALUE_NOISE
                ANI 00000111b
                MOV B, A

                MVI A, $07
                LXI H, SCREEN + COLS * 3 + 34
                LXI D, COLS - 1

                DRW_NOISE:
                
                MVI C, $7F
                CMP B \\ JC . + 5 \\ MVI C, $00
                MOV M, C \\ INX H \\ MOV M, C

                DAD D
                DCR A
                
                JP DRW_NOISE

                RET


        TRACKER:

                MVI B, 0

                ; Значение для шума
		LDA TRACK_POINTER
                LXI H, TRACK_NOISE
                MOV C, A \\ DAD B \\ MOV A, M
                CPI $00 \\ JZ . + 6 \\ STA VALUE_NOISE

                ; Нота
		LDA TRACK_POINTER
                LXI H, TRACK_LEAD
                MOV C, A \\ DAD B \\ MOV A, M

                CPI $00 \\ JZ TRACKER_COUNTER ; Нота не изменилась
                
                ; Новая нота, сброс настроек канала
                LXI H, KR580VI53 + 3
                MVI M, $36
                
                CPI $FF \\ JZ TRACKER_COUNTER ; Нота останов

                TRACKER_SOUND: ; Загружаем ноту

                LXI H, SCALES
                
                ADD A \\ MVI B, 0 \\ MOV C, A \\ DAD B
                MOV B, M \\ INX H \\ MOV C, M
                
                LXI H, KR580VI53
                MOV M, B \\ MOV M, C
                
                MVI B, 0

                ; Значение для фильтра
		LDA TRACK_POINTER
                LXI H, TRACK_FILTER
                MOV C, A \\ DAD B \\ MOV A, M
                CPI $00 \\ JZ . + 6 \\ STA VALUE_FILTER

                MOV C, A
                LDA VALUE_NOISE
                RLC \\ RLC \\ RLC \\ RLC
                ORA B
                ;STA K555IR27

                TRACKER_COUNTER:
                
		LXI H, TRACK_POINTER
                INR M

		RET


START:
                ; Настройка знакогенератора
                LXI D, DISPLAY_78X38
                LXI B, GRAPH_78X38
                CALL SET_DISPLAY
                
                ; Настройка ПДП                
                LXI D, SCREEN
		MVI C, DMA_SIZE_78X38 & $00FF
		MVI B, ($4000 + DMA_SIZE_78X38) >> 8
                CALL SET_DMA
                
                ; Сброс ВИ53 и ИР27
                CALL VI53_RST
                ;LXI H, K555IR27
                MVI M, $00

                
        MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY

		; Счетчик-делитель

		LXI H, CLOCK
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA CLOCK
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA CLOCK
		ANI 1
		CNZ X2_

                ; X4
		LDA CLOCK
 		ANI 3
		CZ X4
   
                JMP MAIN


        X1:
        
                CALL DRAW_LEVEL

                LXI H, VALUE_NOISE \\ MOV A, M
                CPI $00 \\ JZ NO_NOISE
                CPI $08 \\ JZ NO_NOISE
                DCR A
                MOV M, A

                NO_NOISE:

                RLC \\ RLC \\ RLC \\ RLC
                MOV B, A
                
                LXI H, VALUE_FILTER \\ MOV A, M
                CPI $00 \\ JZ NO_FILTER
                DCR A
                MOV M, A
                
                NO_FILTER:
                
                ORA B
                ;STA K555IR27

                RET


        X2:

		LDA TRACK_POINTER
		ANI 00000111b

                LXI H, ROCKER
                MVI B, 0
                MOV C, A
                DAD B
                MOV A, M

                LXI H, SCREEN + 7 * COLS + 25
		MOV M, A

		LDA TRACK_POINTER
                LXI H, SCREEN + COLS * 12 + 27
                CALL DEC_8

                CALL DRAW_TRACK
                CALL TRACKER

		RET


        X2_:
        
		LDA TRACK_POINTER
                ORA A
                RAR
                
                MVI B, $00
                MOV C, A
                
                LXI H, TITLE - 8
                DAD B
                
                XCHG
                LXI H, SCREEN + COLS * 23 + 26
                MVI M, $06 \\ INX H
                MVI M, $11 \\ INX H
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D
                LDAX D \\ MOV M, A \\ INX H \\ INX D

                RET


        X4:

		; Опрос клавиавтуры
                LXI H, KR580VV55_KBD
                MVI M, 11111110b

		; Выход
                LDA KR580VV55_KBD + 1
                CPI 11111011b
                JZ ROM
                

		RET

ROCKER: 
                db $03, $13, $11, $15, $14, $16, $06, $07

NUMBERS: 
                db $06, $03, $17
                db $06, $12, $06
                db $02, $03, $03
                db $00, $16, $00
                db $00, $06, $00
                db $00, $03, $01
                db $02, $03, $05
                db $04, $03, $01
                db $02, $03, $03
                db $02, $03, $07
                db $02, $03, $07
                db $02, $03, $03
                db $00, $12, $00
                db $06, $14, $15
                db $00, $00, $01
                db $06, $03, $03
                db $02, $03, $07
                db $02, $03, $01
                db $06, $03, $03
                db $06, $03, $07
                db $02, $03, $03
                db $02, $03, $07
                db $00, $04, $01
                db $00, $02, $00
                db $06, $03, $07
                db $06, $03, $07
                db $02, $03, $03
                db $06, $03, $07
                db $02, $03, $07
                db $02, $03, $03

                
SCALES:         ;  C      C#     D      D#     E      F      F#     G      G#     A      A#     B
                dw $8000, $78DF, $7223, $6BC7, $65C6, $601A, $5AC0, $55B2, $50EB, $4C69, $4827, $4422
                dw $4057, $3CC1, $395F, $362C, $3328, $304E, $2D9D, $2B13, $28AC, $2668, $2445, $223F
                dw $2057, $1E8A, $1CD6, $1B3B, $19B7, $1848, $16EE, $15A7, $1472, $134E, $123B, $1137
                dw $1041, $0F5A, $0E7F, $0DB0, $0CED, $0C35, $0B86, $0AE2, $0A47, $09B4, $092A, $08A7
                dw $082C, $07B7, $0749, $06E1, $067F, $0623, $05CB, $0579, $052B, $04E1, $049B, $045A
                
SCALES_TEXT:
                db "---", "***", "   ", "   ", "   ", "   ", "   ", "   ", "   ", "   ", "   ", "   "
                db "C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "B-0"
                db "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1"
                db "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2"
                db "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3"

SCREEN:

                ; 01
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00     
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 02
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 03
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 04
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 05
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 06
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 07
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 08
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 09
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 10
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 11
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 12
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 13
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 14
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 15
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 16
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 17
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $15, $17, $07, $17, $17
                db $17, $13, $17, $16, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 18
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $03, $03, $03, $03, $03
                db $03, $03, $03, $03, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 19
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $00, $16, $07, $17, $17
                db $17, $13, $15, $00, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 20
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $00, $15, $04, $15, $14
                db $16, $10, $16, $00, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 21
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $00, $02, $03, $03, $03
                db $03, $03, $01, $00, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 22
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $06, $02, $03, $02, $01, $00
                db $00, $00, $02, $01, $11, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 23
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $02, $03, $03, $03, $03, $03
                db $03, $03, $03, $03, $01, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 24
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 25
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 26
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 27
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 28
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 29
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 30
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 31
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
                
                ; 32
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; Подвал
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F3, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00



TITLE:
                db "TR27 - |to mikkrotreker dlq zwukowoj shemy audiotron. sozdawajte swoi korotkie treki s pomo}x` fn~ i belogo {uma!"
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00

TRACK_LEAD:
                db $10, $00, $00, $00, $10, $00, $00, $00,      $1C, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $1A, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00
                db $18, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $16, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00,      $17, $00, $00, $00, $18, $00, $00, $00
                db $10, $00, $00, $00, $10, $00, $00, $00,      $1C, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $1A, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00
                db $18, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $16, $00, $00, $00,      $16, $16, $16, $16, $16, $16, $16, $16,      $16, $16, $16, $16, $16, $16, $16, $16
                db $10, $00, $00, $00, $10, $00, $00, $00,      $1C, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $1A, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00
                db $18, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $16, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00,      $17, $00, $00, $00, $18, $00, $00, $00
                db $10, $00, $00, $00, $10, $00, $00, $00,      $1C, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $1A, $00, $00, $00,      $10, $00, $00, $00, $10, $00, $00, $00
                db $18, $00, $00, $00, $10, $00, $00, $00,      $10, $00, $00, $00, $16, $00, $00, $00,      $29, $27, $26, $29, $2C, $2A, $29, $26,      $29, $2A, $2C, $2E, $2C, $2A, $29, $26

TRACK_FILTER:
                db $08, $00, $00, $00, $08, $00, $00, $00,      $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $08, $00, $00, $00
                db $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $00, $00, $00, $00,      $0F, $00, $00, $00, $0F, $00, $00, $00
                db $08, $00, $00, $00, $08, $00, $00, $00,      $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $08, $00, $00, $00
                db $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $00, $01, $02, $03, $04, $05, $06, $07,      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F
                db $08, $00, $00, $00, $08, $00, $00, $00,      $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $08, $00, $00, $00
                db $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $00, $00, $00, $00,      $0F, $00, $00, $00, $0F, $00, $00, $00
                db $08, $00, $00, $00, $08, $00, $00, $00,      $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $08, $00, $00, $00, $08, $00, $00, $00
                db $0F, $00, $00, $00, $08, $00, $00, $00,      $08, $00, $00, $00, $0F, $00, $00, $00,      $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F,      $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F

TRACK_NOISE:

                db $07, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $07, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $07, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00,      $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00
                db $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00,      $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00
                db $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00,      $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00
                db $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00,      $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00
                db $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00,      $07, $00, $0C, $00, $0C, $00, $0C, $00,      $08, $00, $0C, $00, $0C, $00, $0C, $00
