; sincos.z80
; CORDIC for sin() and cos() for the Zilog Z80 and Assembler Z80DT
; Author: Andre Adrian
; Version: 12apr2011
; length is 341 bytes

; 8080 version Ivan Gorodetsky 04apr2025
; length is 406 bytes


.include "tasm.inc"

			ORG 100h
; LOAD TEST VALUES
    LD      DE,12AFH                ; Angle = -1.57079632679 (-90)
    LD      BC,9B78H
    CALL    SINCOS
                            ; expected sin = 0C0000000H (-1.0)
                            ; expected cos = 000000000H (0.0)
                            ; delivered sin = MEM(Y) = 0BFFFFFFFH
                            ; delivered cos = MEM(X) = 000000031H
    HALT

;==================================================
; Constants
;
CN:        EQU        22
CM:        EQU        8

;==================================================
; variable storage (RAM)
;
Angle:
    DEFW    0,0
Y:
    DEFW    0,0
X:
    DEFW    0,0
Yold:
    DEFW    0,0
pATR:
    DEFW    0
Step:
    DEFB    0

;==================================================
; constant storage (ROM)
;
ATR:
    DEFW 0F6A8H,03243H      ; atan(1)
    DEFW 06705H,01DACH      ; atan(1/2)
    DEFW 0BAFCH,00FADH      ; atan(1/4)
    DEFW 06EA6H,007F5H      ; atan(1/8)
    DEFW 0AB76H,003FEH      ; ...
    DEFW 0D55BH,001FFH
    DEFW 0FAAAH,000FFH
    DEFW 0FF55H,0007FH
    DEFW 0FFEAH,0003FH

;==================================================
; N BIT ARITHMETRIC SHIFT RIGHT ROUTINE 32BIT = 32BIT
; BCDE >>= A
; CHANGES FLAGS and L
;
SRBCDE:
	ld l,8
	inc b
	dec b
	jp m,SRBCDEm
;>0
SRBCDEp:
    SUB     l               ; SET CARRY FLAG IF A < 8
    jp      C,SRBEBTp        ; NO MORE BYTES TO SHIFT
    LD      E,D             ; SHIFT BITS 8..15 TO 7..0
    LD      D,C             ; SHIFT BITS 16..23 TO 8..15
    LD      C,B             ; SHIFT BITS 24..31 TO 16..23
    LD      B,0             ; ASSUME POSITIVE NUMBER
    jp      SRBCDEp
SRBEBTp:
    ADD     A,l             ; UNDO SUB 8, SET ZERO FLAG IF A == 0
    ret z        ; NO MORE BITS TO SHIFT
	ld l,a
SRBELPp:
	xor a\ or b\ rra\ ld b,a
	ld a,c\ rra\ ld c,a
	ld a,d\ rra\ ld d,a
	ld a,e\ rra\ ld e,a
    DEC     l               ; SET ZERO FLAG IF A == 0
    jp nz,SRBELPp
    RET                                                ; RESULT IS IN BCDE.

SRBCDEm:
    SUB     l               ; SET CARRY FLAG IF A < 8
    jp      C,SRBEBTm        ; NO MORE BYTES TO SHIFT
    LD      E,D             ; SHIFT BITS 8..15 TO 7..0
    LD      D,C             ; SHIFT BITS 16..23 TO 8..15
    LD      C,B             ; SHIFT BITS 24..31 TO 16..23
    LD      B,255            ; ASSUME POSITIVE NUMBER
    jp      SRBCDEm
SRBEBTm:
    ADD     A,l             ; UNDO SUB 8, SET ZERO FLAG IF A == 0
    ret z        ; NO MORE BITS TO SHIFT
	ld l,a
SRBELPm:
	ld a,b\ scf\ rra\ ld b,a
	ld a,c\ rra\ ld c,a
	ld a,d\ rra\ ld d,a
	ld a,e\ rra\ ld e,a
    DEC     l               ; SET ZERO FLAG IF A == 0
    jp nz,SRBELPm
    RET                                                ; RESULT IS IN BCDE.

;==================================================
; SIN() COS() ROUTINE 2 * 32BIT = 32BIT
; (X),(Y) = f(BCDE)
; NEEDS REGISTERS A BC DE HL, CHANGES FLAGS
;
SINCOS:
	ex de,hl\ ld (Angle),hl			; store argument
	ld l,c\ ld h,b\ ld (Angle+2),hl

    SUB     A               ; A = 0
    LD      (Step),A        ; i = 0
    LD      L,A
    LD      H,A
    LD      (Y),HL          ; y = 0;
    LD      (Y+2),HL
    LD      HL,03B6AH       ; x = FIXED(0.607252935..);
    LD      (X),HL
    LD      HL,026DDH
    LD      (X+2),HL
    LD      HL,ATR          ; pATR = ATR;
    LD      (pATR),HL
SNCSDO:                         ; do {
    LD      HL,(Y)          ;   yold = y;
    LD      (Yold),HL

	ld hl,(X)\ ex de,hl		;   x >> i
	ld hl,(X+2)\ ld c,l\ ld b,h

    LD      HL,(Y+2)
    LD      (Yold+2),HL
                            ;   y += (angle >= 0)? x >> i: -(x >> i);
    LD      A,(Step)
    CALL    SRBCDE
    LD      A,(Angle+3)     ;   (angle >= 0)?
    RLA                     ;   Bit 7 to Carry
    LD      HL,(Y)
    jp      C,SNCSL1
    ADD     HL,DE           ;   y += x >> i
    LD      (Y),HL
    LD      HL,(Y+2)

	jp nc,$+4
	inc hl
	add hl,bc
	
    jp      SNCSE1
SNCSL1:
	ld a,l\ sub e\ ld l,a		;   y -= x >> i
	ld a,h\ sbc a,d\ ld h,a
	
    LD      (Y),HL
    LD      HL,(Y+2)
	
	ld a,l\ sbc a,c\ ld l,a
	ld a,h\ sbc a,b\ ld h,a

SNCSE1:
    LD      (Y+2),HL
                            ;   x -= (angle >= 0)? yold >> i: -(yold >> i);
	ld hl,(Yold)\ ex de,hl	;   yold >> i
	ld hl,(Yold+2)\ ld c,l\ ld b,h
	
    LD      A,(Step)
    CALL    SRBCDE
    LD      A,(Angle+3)     ;   (angle >= 0)?
    RLA
    LD      HL,(X)
    jp      C,SNCSL2

	ld a,l\ sub e\ ld l,a		;   x -= yold >> i
	ld a,h\ sbc a,d\ ld h,a

    LD      (X),HL
    LD      HL,(X+2)

	ld a,l\ sbc a,c\ ld l,a
	ld a,h\ sbc a,b\ ld h,a

    jp      SNCSE2
SNCSL2:
    ADD     HL,DE           ;   x += yold >> i
    LD      (X),HL
    LD      HL,(X+2)

	jp nc,$+4
	inc hl
	add hl,bc

SNCSE2:
    LD      (X+2),HL
                           ;   a = (i < M+1)? *pATR++: atr_fixed[M] >> (i-M);
    LD      A,(Step)       ;   (i < M+1)?
    SUB     CM+1           ;   i-(M+1)
    jp      NC,SNCSL3
    LD      HL,(pATR)      ;   *pATR++
    LD      E,(HL)
    INC     HL
    LD      D,(HL)
    INC     HL
    LD      C,(HL)
    INC     HL
    LD      B,(HL)
    INC     HL
    LD      (pATR),HL
    jp      SNCSE3
SNCSL3:
	ld hl,(ATR+32)\ ex de,hl	;   atr[M] >> i-M
	ld hl,(ATR+34)\ ld c,l\ ld b,h

    INC     A               ;   i-M
    CALL    SRBCDE
SNCSE3:
                            ;   angle -= (angle >= 0)? a: -a;
    LD      A,(Angle+3)     ;   (angle >= 0)?
    RLA
    LD      HL,(Angle)
    jp      C,SNCSL4

	ld a,l\ sub e\ ld l,a	;   angle -= a
	ld a,h\ sbc a,d\ ld h,a

    LD      (Angle),HL
    LD      HL,(Angle+2)

	ld a,l\ sbc a,c\ ld l,a
	ld a,h\ sbc a,b\ ld h,a

    jp      SNCSE4
SNCSL4:
    ADD     HL,DE           ;   angle += a
    LD      (Angle),HL
    LD      HL,(Angle+2)

	jp nc,$+4
	inc hl
	add hl,bc

SNCSE4:
    LD      (Angle+2),HL
                            ; } while (++i <= N-1);
    LD      HL,Step         ; ++i
    INC     (HL)
    LD      A,CN-1          ; N-1 >= ++i
    CP      (HL)
    JP      NC,SNCSDO
                            ; RESULT IS IN MEM(X) AND MEM(Y)
    RET

    END