// Aleste 520EX MAPPER prom (Gate Array 3, RAM banking) - 9 LE for MAX7000S.

module ALMAPPER (
	input	wire			W,
	input	wire	[7:0]	A,
	output	wire	[4:0]	Q
);
	reg [4:0] out;
	reg [3:0] ROM[0:255];

assign	Q[4]   = out[4];
assign	Q[3:0] = !out[3:0];
	always @(negedge W) begin
	//-#00-----------
		ROM[0]=4'h0;
		ROM[1]=4'h1;
		ROM[2]=4'h2;
		ROM[3]=4'h3;
		ROM[4]=4'h0;
		ROM[5]=4'h1;
		ROM[6]=4'h2;
		ROM[7]=4'h7;
		ROM[8]=4'h4;
		ROM[9]=4'h5;
		ROM[10]=4'h6;
		ROM[11]=4'h7;
		ROM[12]=4'h0;
		ROM[13]=4'h3;
		ROM[14]=4'h2;
		ROM[15]=4'h7;
	//-#10-----------
		ROM[16]=4'h0;	
		ROM[17]=4'h4;	
		ROM[18]=4'h2;	
		ROM[19]=4'h3;	
		ROM[20]=4'h0;	
		ROM[21]=4'h5;	
		ROM[22]=4'h2;	
		ROM[23]=4'h3;	
		ROM[24]=4'h0;	
		ROM[25]=4'h6;	
		ROM[26]=4'h2;	
		ROM[27]=4'h3;	
		ROM[28]=4'h0;	
		ROM[29]=4'h7;	
		ROM[30]=4'h2;	
		ROM[31]=4'h3;	
	//-#20-----------
		ROM[32]=4'h0;	
		ROM[33]=4'h1;	
		ROM[34]=4'h2;	
		ROM[35]=4'h3;	
		ROM[36]=4'h0;	
		ROM[37]=4'h1;	
		ROM[38]=4'h2;	
		ROM[39]=4'h7;	
		ROM[40]=4'h4;	
		ROM[41]=4'h5;	
		ROM[42]=4'h6;	
		ROM[43]=4'h7;	
		ROM[44]=4'h0;	
		ROM[45]=4'h3;	
		ROM[46]=4'h2;	
		ROM[47]=4'h7;	
	//-#30-----------
		ROM[48]=4'h0;	
		ROM[49]=4'h8;	
		ROM[50]=4'h2;	
		ROM[51]=4'h3;	
		ROM[52]=4'h0;	
		ROM[53]=4'h9;	
		ROM[54]=4'h2;	
		ROM[55]=4'h3;	
		ROM[56]=4'h0;	
		ROM[57]=4'hA;	
		ROM[58]=4'h2;	
		ROM[59]=4'h3;	
		ROM[60]=4'h0;	
		ROM[61]=4'hB;	
		ROM[62]=4'h2;	
		ROM[63]=4'h3;	
	//-#40-----------
		ROM[64]=4'h0;	
		ROM[65]=4'h0;	
		ROM[66]=4'h0;	
		ROM[67]=4'h0;	
		ROM[68]=4'h1;	
		ROM[69]=4'h1;	
		ROM[70]=4'h1;	
		ROM[71]=4'h1;	
		ROM[72]=4'h2;	
		ROM[73]=4'h2;	
		ROM[74]=4'h2;	
		ROM[75]=4'h2;	
		ROM[76]=4'h3;	
		ROM[77]=4'h3;	
		ROM[78]=4'h3;	
		ROM[79]=4'h3;	
	//-#50-----------
		ROM[80]=4'h4;	
		ROM[81]=4'h4;	
		ROM[82]=4'h4;	
		ROM[83]=4'h4;	
		ROM[84]=4'h5;	
		ROM[85]=4'h5;	
		ROM[86]=4'h5;	
		ROM[87]=4'h5;	
		ROM[88]=4'h6;	
		ROM[89]=4'h6;	
		ROM[90]=4'h6;	
		ROM[91]=4'h6;	
		ROM[92]=4'h7;	
		ROM[93]=4'h7;	
		ROM[94]=4'h7;	
		ROM[95]=4'h7;	
	//-#60-----------
		ROM[96]=4'h8;	
		ROM[97]=4'h8;	
		ROM[98]=4'h8;	
		ROM[99]=4'h8;	
		ROM[100]=4'h9;	
		ROM[101]=4'h9;	
		ROM[102]=4'h9;	
		ROM[103]=4'h9;	
		ROM[104]=4'hA;	
		ROM[105]=4'hA;	
		ROM[106]=4'hA;	
		ROM[107]=4'hA;	
		ROM[108]=4'hB;	
		ROM[109]=4'hB;	
		ROM[110]=4'hB;	
		ROM[111]=4'hB;	
	//-#70-----------
		ROM[112]=4'hC;	
		ROM[113]=4'hC;	
		ROM[114]=4'hC;	
		ROM[115]=4'hC;	
		ROM[116]=4'hD;	
		ROM[117]=4'hD;	
		ROM[118]=4'hD;	
		ROM[119]=4'hD;	
		ROM[120]=4'hE;	
		ROM[121]=4'hE;	
		ROM[122]=4'hE;	
		ROM[123]=4'hE;	
		ROM[124]=4'hF;	
		ROM[125]=4'hF;	
		ROM[126]=4'hF;	
		ROM[127]=4'hF;	
	//-#80-----------
		ROM[128]=4'h0;	
		ROM[129]=4'h1;	
		ROM[130]=4'h2;	
		ROM[131]=4'h3;	
		ROM[132]=4'h0;	
		ROM[133]=4'h1;	
		ROM[134]=4'h2;	
		ROM[135]=4'h7;	
		ROM[136]=4'h4;	
		ROM[137]=4'h5;	
		ROM[138]=4'h6;	
		ROM[139]=4'h7;	
		ROM[140]=4'h0;	
		ROM[141]=4'h3;	
		ROM[142]=4'h2;	
		ROM[143]=4'h7;	
	//-#90-----------
		ROM[144]=4'h0;	
		ROM[145]=4'hC;	
		ROM[146]=4'h2;	
		ROM[147]=4'h3;	
		ROM[148]=4'h0;	
		ROM[149]=4'hD;	
		ROM[150]=4'h2;	
		ROM[151]=4'h3;	
		ROM[152]=4'h0;	
		ROM[153]=4'hE;	
		ROM[154]=4'h2;	
		ROM[155]=4'h3;	
		ROM[156]=4'h0;	
		ROM[157]=4'hF;	
		ROM[158]=4'h2;	
		ROM[159]=4'h3;	
	//-#A0-----------
		ROM[160]=4'h0;	
		ROM[161]=4'h1;	
		ROM[162]=4'h2;	
		ROM[163]=4'h3;	
		ROM[164]=4'h0;	
		ROM[165]=4'h1;	
		ROM[166]=4'h2;	
		ROM[167]=4'h7;	
		ROM[168]=4'h4;	
		ROM[169]=4'h5;	
		ROM[170]=4'h6;	
		ROM[171]=4'h7;	
		ROM[172]=4'h0;	
		ROM[173]=4'h3;	
		ROM[174]=4'h2;	
		ROM[175]=4'h7;	
	//-#B0-----------
		ROM[176]=4'h0;	
		ROM[177]=4'hC;	
		ROM[178]=4'h2;	
		ROM[179]=4'h3;	
		ROM[180]=4'h0;	
		ROM[181]=4'hD;	
		ROM[182]=4'h2;	
		ROM[183]=4'h3;	
		ROM[184]=4'h0;	
		ROM[185]=4'hE;	
		ROM[186]=4'h2;	
		ROM[187]=4'h3;	
		ROM[188]=4'h0;	
		ROM[189]=4'hF;	
		ROM[190]=4'h2;	
		ROM[191]=4'h3;	
	//-#C0-----------
		ROM[192]=4'h0;	
		ROM[193]=4'h0;	
		ROM[194]=4'h0;	
		ROM[195]=4'h0;	
		ROM[196]=4'h1;	
		ROM[197]=4'h1;	
		ROM[198]=4'h1;	
		ROM[199]=4'h1;	
		ROM[200]=4'h2;	
		ROM[201]=4'h2;	
		ROM[202]=4'h2;	
		ROM[203]=4'h2;	
		ROM[204]=4'h3;	
		ROM[205]=4'h3;	
		ROM[206]=4'h3;	
		ROM[207]=4'h3;	
	//-#D0-----------
		ROM[208]=4'h4;	
		ROM[209]=4'h4;	
		ROM[210]=4'h4;	
		ROM[211]=4'h4;	
		ROM[212]=4'h5;	
		ROM[213]=4'h5;	
		ROM[214]=4'h5;	
		ROM[215]=4'h5;	
		ROM[216]=4'h6;	
		ROM[217]=4'h6;	
		ROM[218]=4'h6;	
		ROM[219]=4'h6;	
		ROM[220]=4'h7;	
		ROM[221]=4'h7;	
		ROM[222]=4'h7;	
		ROM[223]=4'h7;	
	//-#E0-----------
		ROM[224]=4'h8;	
		ROM[225]=4'h8;	
		ROM[226]=4'h8;	
		ROM[227]=4'h8;	
		ROM[228]=4'h9;	
		ROM[229]=4'h9;	
		ROM[230]=4'h9;	
		ROM[231]=4'h9;	
		ROM[232]=4'hA;	
		ROM[233]=4'hA;	
		ROM[234]=4'hA;	
		ROM[235]=4'hA;	
		ROM[236]=4'hB;	
		ROM[237]=4'hB;	
		ROM[238]=4'hB;	
		ROM[239]=4'hB;	
	//-#F0-----------
		ROM[240]=4'hC;	
		ROM[241]=4'hC;	
		ROM[242]=4'hC;	
		ROM[243]=4'hC;	
		ROM[244]=4'hD;	
		ROM[245]=4'hD;	
		ROM[246]=4'hD;	
		ROM[247]=4'hD;	
		ROM[248]=4'hE;	
		ROM[249]=4'hE;	
		ROM[250]=4'hE;	
		ROM[251]=4'hE;	
		ROM[252]=4'hF;	
		ROM[253]=4'hF;	
		ROM[254]=4'hF;	
		ROM[255]=4'hF;		
	//---------------
		out[3:0]=ROM[A];
		out[4]  =A[6]&&A[7];
  end



endmodule
