// Aleste 52EX ROMRAM prom (Gate Array 2, ROM/RAM enable) - 8 LE.
/*
Inputs:
 A0 PROM0 ;\from gate array (but translated via COLDAT,
 A1 PROM1 ;/ not the original value written by the CPU)
 A2 CPU A14 ;\the addressed 16K memory block
 A3 CPU A15 ;/
 A4 CPU A0
 A5 /MREQ
 A6 /RD
 A7 RAMDIS ;-RAMDIS pin on expansion port
Outputs:
 D0 BUFFER0 ;set LOW on read from even RAM address (16bit-to-8bit bus)
 D1 BUFFER1 ;set LOW on read from odd RAM address (16bit-to-8bit bus)
 D2 /ROMEN ;ROM enable (note: ROMDIS is handled elsewhere)
 D3 /RAMEN ;RAM enable
*/
/*
Page: 0000h 4000h 8000h C000h
----------------------------------------
0000: B 6 B 6 6 6 6 6 6 6 6 6 B B 6 6 ;even addresses
0010: B 5 B 5 5 5 5 5 5 5 5 5 B B 5 5 ;odd addresses
0020: F F F F F F F F F F F F F F F F ;\inactive because /MREQ=high
0030: F F F F F F F F F F F F F F F F ;/
0040: F F F F F F F F F F F F F F F F ;\inactive because /RD=high
0050: F F F F F F F F F F F F F F F F ;/
0060: F F F F F F F F F F F F F F F F ;\inactive because /MREQ=high and /RD=high
0070: F F F F F F F F F F F F F F F F ;/
0080: B 7 B 7 7 7 7 7 7 7 7 7 B B 7 7 ;\
0090: B 7 B 7 7 7 7 7 7 7 7 7 B B 7 7 ; same as above, but BUFFER0 and BUFFER1 bits all SET
00A0: F F F F F F F F F F F F F F F F ; (reading from internal RAM forcefully disabled via
00B0: F F F F F F F F F F F F F F F F ; RAMDIS signal from expansion port)
00C0: F F F F F F F F F F F F F F F F ; (however WRITING to RAM isn't disabled, the "7" means
00D0: F F F F F F F F F F F F F F F F ; signal /RAMEN=LOW, so writing is possible)
00E0: F F F F F F F F F F F F F F F F ;
00F0: F F F F F F F F F F F F F F F F ;/
*/

module ALROMRAM (
	input	wire			W,
	input	wire	[7:0]	A,
	output	wire	[3:0]	Q
);
	reg [3:0] out;
	reg [3:0] ROM[0:255];

assign	Q[3:0] = !out[3:0];
	always @(negedge W) begin

//-#00-----------
		ROM[0]=4'hB;
		ROM[1]=4'h6;
		ROM[2]=4'hB;
		ROM[3]=4'h6;
		ROM[4]=4'h6;
		ROM[5]=4'h6;
		ROM[6]=4'h6;
		ROM[7]=4'h6;
		ROM[8]=4'h6;
		ROM[9]=4'h6;
		ROM[10]=4'h6;
		ROM[11]=4'h6;
		ROM[12]=4'hB;
		ROM[13]=4'hB;
		ROM[14]=4'h6;
		ROM[15]=4'h6;
//-#10-----------
		ROM[16]=4'hB;	
		ROM[17]=4'h5;	
		ROM[18]=4'hB;	
		ROM[19]=4'h5;	
		ROM[20]=4'h5;	
		ROM[21]=4'h5;	
		ROM[22]=4'h5;	
		ROM[23]=4'h5;	
		ROM[24]=4'h5;	
		ROM[25]=4'h5;	
		ROM[26]=4'h5;	
		ROM[27]=4'h5;	
		ROM[28]=4'hB;	
		ROM[29]=4'hB;	
		ROM[30]=4'h5;	
		ROM[31]=4'h5;	
//-#20------------
		ROM[32]=4'hF;	
		ROM[33]=4'hF;	
		ROM[34]=4'hF;	
		ROM[35]=4'hF;	
		ROM[36]=4'hF;	
		ROM[37]=4'hF;	
		ROM[38]=4'hF;	
		ROM[39]=4'hF;	
		ROM[40]=4'hF;	
		ROM[41]=4'hF;	
		ROM[42]=4'hF;	
		ROM[43]=4'hF;	
		ROM[44]=4'hF;	
		ROM[45]=4'hF;	
		ROM[46]=4'hF;	
		ROM[47]=4'hF;	
//-#30-----------
		ROM[48]=4'hF;	
		ROM[49]=4'hF;	
		ROM[50]=4'hF;	
		ROM[51]=4'hF;	
		ROM[52]=4'hF;	
		ROM[53]=4'hF;	
		ROM[54]=4'hF;	
		ROM[55]=4'hF;	
		ROM[56]=4'hF;	
		ROM[57]=4'hF;	
		ROM[58]=4'hF;	
		ROM[59]=4'hF;	
		ROM[60]=4'hF;	
		ROM[61]=4'hF;	
		ROM[62]=4'hF;	
		ROM[63]=4'hF;	
//-#40-----------
		ROM[64]=4'hF;	
		ROM[65]=4'hF;	
		ROM[66]=4'hF;	
		ROM[67]=4'hF;	
		ROM[68]=4'hF;	
		ROM[69]=4'hF;	
		ROM[70]=4'hF;	
		ROM[71]=4'hF;	
		ROM[72]=4'hF;	
		ROM[73]=4'hF;	
		ROM[74]=4'hF;	
		ROM[75]=4'hF;	
		ROM[76]=4'hF;	
		ROM[77]=4'hF;	
		ROM[78]=4'hF;	
		ROM[79]=4'hF;	
//-#50-----------
		ROM[80]=4'hF;	
		ROM[81]=4'hF;	
		ROM[82]=4'hF;	
		ROM[83]=4'hF;	
		ROM[84]=4'hF;	
		ROM[85]=4'hF;	
		ROM[86]=4'hF;	
		ROM[87]=4'hF;	
		ROM[88]=4'hF;	
		ROM[89]=4'hF;	
		ROM[90]=4'hF;	
		ROM[91]=4'hF;	
		ROM[92]=4'hF;	
		ROM[93]=4'hF;	
		ROM[94]=4'hF;	
		ROM[95]=4'hF;	
//-#60-----------
		ROM[96]=4'hF;	
		ROM[97]=4'hF;	
		ROM[98]=4'hF;	
		ROM[99]=4'hF;	
		ROM[100]=4'hF;	
		ROM[101]=4'hF;	
		ROM[102]=4'hF;	
		ROM[103]=4'hF;	
		ROM[104]=4'hF;	
		ROM[105]=4'hF;	
		ROM[106]=4'hF;	
		ROM[107]=4'hF;	
		ROM[108]=4'hF;	
		ROM[109]=4'hF;	
		ROM[110]=4'hF;	
		ROM[111]=4'hF;	
//-#70-----------
		ROM[112]=4'hF;	
		ROM[113]=4'hF;	
		ROM[114]=4'hF;	
		ROM[115]=4'hF;	
		ROM[116]=4'hF;	
		ROM[117]=4'hF;	
		ROM[118]=4'hF;	
		ROM[119]=4'hF;	
		ROM[120]=4'hF;	
		ROM[121]=4'hF;	
		ROM[122]=4'hF;	
		ROM[123]=4'hF;	
		ROM[124]=4'hF;	
		ROM[125]=4'hF;	
		ROM[126]=4'hF;	
		ROM[127]=4'hF;	
//-#80-----------
		ROM[128]=4'hB;	
		ROM[129]=4'h7;	
		ROM[130]=4'hB;	
		ROM[131]=4'h7;	
		ROM[132]=4'h7;	
		ROM[133]=4'h7;	
		ROM[134]=4'h7;	
		ROM[135]=4'h7;	
		ROM[136]=4'h7;	
		ROM[137]=4'h7;	
		ROM[138]=4'h7;	
		ROM[139]=4'h7;	
		ROM[140]=4'hB;	
		ROM[141]=4'hB;	
		ROM[142]=4'h7;	
		ROM[143]=4'h7;	
//-#90-----------
		ROM[144]=4'hB;	
		ROM[145]=4'h7;	
		ROM[146]=4'hB;	
		ROM[147]=4'h7;	
		ROM[148]=4'h7;	
		ROM[149]=4'h7;	
		ROM[150]=4'h7;	
		ROM[151]=4'h7;	
		ROM[152]=4'h7;	
		ROM[153]=4'h7;	
		ROM[154]=4'h7;	
		ROM[155]=4'h7;	
		ROM[156]=4'hB;	
		ROM[157]=4'hB;	
		ROM[158]=4'h7;	
		ROM[159]=4'h7;	
//-#A0-----------
		ROM[160]=4'hF;	
		ROM[161]=4'hF;	
		ROM[162]=4'hF;	
		ROM[163]=4'hF;	
		ROM[164]=4'hF;	
		ROM[165]=4'hF;	
		ROM[166]=4'hF;	
		ROM[167]=4'hF;	
		ROM[168]=4'hF;	
		ROM[169]=4'hF;	
		ROM[170]=4'hF;	
		ROM[171]=4'hF;	
		ROM[172]=4'hF;	
		ROM[173]=4'hF;	
		ROM[174]=4'hF;	
		ROM[175]=4'hF;	
//-#B0-----------
		ROM[176]=4'hF;	
		ROM[177]=4'hF;	
		ROM[178]=4'hF;	
		ROM[179]=4'hF;	
		ROM[180]=4'hF;	
		ROM[181]=4'hF;	
		ROM[182]=4'hF;	
		ROM[183]=4'hF;	
		ROM[184]=4'hF;	
		ROM[185]=4'hF;	
		ROM[186]=4'hF;	
		ROM[187]=4'hF;	
		ROM[188]=4'hF;	
		ROM[189]=4'hF;	
		ROM[190]=4'hF;	
		ROM[191]=4'hF;	
//-#C0-----------
		ROM[192]=4'hF;	
		ROM[193]=4'hF;	
		ROM[194]=4'hF;	
		ROM[195]=4'hF;	
		ROM[196]=4'hF;	
		ROM[197]=4'hF;	
		ROM[198]=4'hF;	
		ROM[199]=4'hF;	
		ROM[200]=4'hF;	
		ROM[201]=4'hF;	
		ROM[202]=4'hF;	
		ROM[203]=4'hF;	
		ROM[204]=4'hF;	
		ROM[205]=4'hF;	
		ROM[206]=4'hF;	
		ROM[207]=4'hF;	
//-#D0-----------
		ROM[208]=4'hF;	
		ROM[209]=4'hF;	
		ROM[210]=4'hF;	
		ROM[211]=4'hF;	
		ROM[212]=4'hF;	
		ROM[213]=4'hF;	
		ROM[214]=4'hF;	
		ROM[215]=4'hF;	
		ROM[216]=4'hF;	
		ROM[217]=4'hF;	
		ROM[218]=4'hF;	
		ROM[219]=4'hF;	
		ROM[220]=4'hF;	
		ROM[221]=4'hF;	
		ROM[222]=4'hF;	
		ROM[223]=4'hF;	
//-#E0-----------
		ROM[224]=4'hF;	
		ROM[225]=4'hF;	
		ROM[226]=4'hF;	
		ROM[227]=4'hF;	
		ROM[228]=4'hF;	
		ROM[229]=4'hF;	
		ROM[230]=4'hF;	
		ROM[231]=4'hF;	
		ROM[232]=4'hF;	
		ROM[233]=4'hF;	
		ROM[234]=4'hF;	
		ROM[235]=4'hF;	
		ROM[236]=4'hF;	
		ROM[237]=4'hF;	
		ROM[238]=4'hF;	
		ROM[239]=4'hF;	
//-#F0-----------
		ROM[240]=4'hF;	
		ROM[241]=4'hF;	
		ROM[242]=4'hF;	
		ROM[243]=4'hF;	
		ROM[244]=4'hF;	
		ROM[245]=4'hF;	
		ROM[246]=4'hF;	
		ROM[247]=4'hF;	
		ROM[248]=4'hF;	
		ROM[249]=4'hF;	
		ROM[250]=4'hF;	
		ROM[251]=4'hF;	
		ROM[252]=4'hF;	
		ROM[253]=4'hF;	
		ROM[254]=4'hF;	
		ROM[255]=4'hF;		
//---------------
		out = ROM[A];
	end
endmodule
