// КЛАВИАТУРА, Иванов Дмитрий, 2025 г.
// Arduino Nano
// D4-D13 и A3-A5 - столбцы матрицы
// A0-A2 - строки матрицы (с диодами)

// Подключаем библиотеку для клавиатуры https://github.com/harvie/ps2dev
#include "ps2dev.h" 

#define   COLS      12
#define   ROWS      3

#define   KEY_FN      COLS * 2
#define   KEY_SHIFT   COLS * ROWS - 1

PS2dev keyboard(2, 3);  // CLOCK, DATA

// Массив состояний клавиш
bool KEY_STATUS[COLS * ROWS];

// Служебный сканкод для клавиши или обычный, см. сканкоды в ps2dev.h
bool KEY_SPECIAL[COLS * ROWS * 2] = {
  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,
  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  true,   false,
  false,  false,  false,  false,  false,  false,  false,  false,  false,  true,   true,   true,

  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,
  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,
  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false,  false
};

// Массив с раскладками клавиатуры
uint8_t KEY_CODES[COLS * ROWS * 2] = {
  PS2dev::Q,    PS2dev::W,            PS2dev::E,        PS2dev::R,    PS2dev::T,    PS2dev::Y,    PS2dev::U,    PS2dev::I,        PS2dev::O,          PS2dev::P,            PS2dev::ESCAPE,       PS2dev::BACKSPACE,
  PS2dev::A,    PS2dev::S,            PS2dev::D,        PS2dev::F,    PS2dev::G,    PS2dev::H,    PS2dev::J,    PS2dev::K,        PS2dev::L,          PS2dev::COMMA,        PS2dev::UP_ARROW,     PS2dev::ENTER,
  0x00,         PS2dev::Z,            PS2dev::X,        PS2dev::C,    PS2dev::V,    PS2dev::B,    PS2dev::N,    PS2dev::M,        PS2dev::SPACE,      PS2dev::LEFT_ARROW,   PS2dev::DOWN_ARROW,   PS2dev::RIGHT_ARROW,

  PS2dev::ONE,  PS2dev::TWO,          PS2dev::THREE,    PS2dev::FOUR, PS2dev::FIVE, PS2dev::SIX,  PS2dev::SEVEN,PS2dev::EIGHT,    PS2dev::NINE,       PS2dev::ZERO,         PS2dev::MINUS,        PS2dev::EQUAL,
  PS2dev::F1,   PS2dev::F2,           PS2dev::F3,       PS2dev::F4,   PS2dev::F5,   PS2dev::F6,   PS2dev::F7,   PS2dev::F8,       PS2dev::F9,         PS2dev::COMMA,        PS2dev::PERIOD,       PS2dev::ACCENT,
  0x00,         PS2dev::LEFT_CONTROL, PS2dev::LEFT_ALT, PS2dev::C,    PS2dev::V,    PS2dev::B,    PS2dev::N,    PS2dev::BACKSLASH,PS2dev::SLASH,      PS2dev::OPEN_BRACKET, PS2dev::CLOSE_BRACKET,PS2dev::LEFT_SHIFT
};

bool CAPS_LOCK = false;

void setup()
{

  // Определяем вводы/выводы

  DDRD = DDRD | 0b00000000; // D0-D7
  DDRB = DDRB | 0b00100000; // D8-D13
  DDRC = DDRC | 0b00000111; // A0-A2, A3-A5

  // Устанавливаем подтягивающие резисторы
  PORTD = PORTD | 0b11110000;
  PORTB = PORTB | 0b00011111;
  PORTC = PORTC | 0b00111000;
  
  // Светодиод горит, пока не закончится инициализация клавиатуры
  digitalWrite(LED_BUILTIN, LOW);
  
  keyboard.keyboard_init();
}

void loop()
{

  // Первая линия
  PORTC = 0B00111000 | 0B0000110;
  scanline(0);

  // Вторая линия
  PORTC = 0B00111000 | 0B00000101;
  scanline(1);

  // Третья линия
  PORTC = 0B00111000 | 0B00000011;
  scanline(2);

 }

void scanline(uint8_t line)
{
  uint8_t leds; 
  uint16_t data;
  uint8_t index;
  uint8_t indexFN;
  bool FN;

  // Кнопка смены раскладки
  FN = KEY_STATUS[KEY_FN];

  // Приём данных от хоста
  if(keyboard.keyboard_handle(&leds)) digitalWrite(LED_BUILTIN, !leds);
  else digitalWrite(LED_BUILTIN, !FN);

  if (CAPS_LOCK) digitalWrite(LED_BUILTIN, LOW);
 
  if (FN) indexFN = COLS * ROWS;
  else indexFN = 0;
 
  // Собираем биты опроса линии в слово
  data = PIND >> 4;
  data = data | ((PINB & B00011111) << 4);
  data = data | ((PINC & B00111000) << 6);

  // Ищем нажатые клавиши в линии

  for (int8_t i = 0; i < COLS; i++)
  {
    index = i + COLS * line;

    if (!bitRead(data, i))
    {
      // Нажата клавиша в линии line с индесом i
      if (!KEY_STATUS[index])
      {
        KEY_STATUS[index] = true;
        if (index != KEY_FN)
        {
          //keyboard.keyboard_press(KEY_CODES[index + indexFN]);
          if (KEY_SPECIAL[index + indexFN]) {keyboard.keyboard_press_special(KEY_CODES[index + indexFN]);}
          else {keyboard.keyboard_press(KEY_CODES[index + indexFN]);}
        }
      }

    } else {
      // Не нажата клавиша в линии line с индесом i
      if (KEY_STATUS[index])
      {
        KEY_STATUS[index] = false;
        if (index != KEY_FN)
        {
          //keyboard.keyboard_release(KEY_CODES[index + indexFN]);
          //Переключение раскладки
          if (index != KEY_SHIFT || !FN)
          {
            if (KEY_SPECIAL[index + indexFN]) {keyboard.keyboard_release_special(KEY_CODES[index + indexFN]);}
            else {keyboard.keyboard_release(KEY_CODES[index + indexFN]);}
          }
          else {
            if (FN && CAPS_LOCK) keyboard.keyboard_release(PS2dev::LEFT_SHIFT);
            if (FN && !CAPS_LOCK) keyboard.keyboard_press(PS2dev::LEFT_SHIFT);
            CAPS_LOCK = !CAPS_LOCK;
          }
        }
      }
    }
  }


}
