                ; i8080 assembler code
                .project 69.rk
                .tape rk-bin

                ROM             equ $F800               ; Начало ПЗУ

                KR580VG75       equ $C000
                KR580VT57       equ $E000
                KR580VV55_KBD   equ $8000
                KR580VV55_PPI   equ $A000
                KR580VI53       equ $B000

                COLS		equ 78
                ROWS		equ 38
                DMA_SIZE        equ COLS * ROWS - 1

                ; Шрифт 69
                COLS_FONT	equ 16 * 3
                ROWS_FONT	equ 8
                DMA_SIZE_FONT   equ COLS_FONT * ROWS_FONT - 1
                DISPLAY_FONT    equ (ROWS_FONT + $C0 - 1) << 8 | (COLS_FONT - 1)

                ; Видеорежимы
                DISPLAY_78X38   equ (ROWS - 1) << 8 | (COLS - 1)
                GRAPH_78X38     equ $5377
                DMA_SIZE_78X38  equ DMA_SIZE

                org $0000

                JMP START
                
                ; Конфигурация платформы
                
                RECORD_00:      dw KR580VG75
                RECORD_01:      dw KR580VT57
                RECORD_02:      dw KR580VV55_KBD
                RECORD_03:      dw KR580VV55_PPI
                RECORD_04:      dw KR580VI53
                RECORD_05:      dw $0000

                CLOCK:          dw $00
                LINE:           dw $00


        SET_DISPLAY: ; Настройка ВГ75
        
                ; DE - строки и столбцы
                ; BC - размер знакоместа и курсор

		; Останов КР580ВГ75
		LXI H, KR580VG75 + 1


		; Скрываем курсор

		; Останов КР580ВГ75

		MVI M, 0
		DCR L

        	MOV M, E	; Столбцы
        	MOV M, D	; Строки
        	MOV M, C	; Позиция курсора и кол-во линий в знакоместе
        	MOV M, B	; 0101.0011
        	
 		; Старт КР580ВГ75


		INR L

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		INR L
        	MVI M, $25
                
		CALL VG75_READY
		
		RET

		
        SET_DMA: ; Настройка ПДП

                ; DE - адрес экрана
                ; BC - размер экрана
                
                LXI H, KR580VT57
		MVI L, $08
		MVI M, $80
		MVI L, $04
		MOV M, E
		MOV M, D

		INR L
		MOV M, C
		MOV M, B
		MVI L, $08
		MVI M, $A4

                RET


        VG75_READY: ; Ждем обратный ход

                LXI H, KR580VG75 + 1
		MOV A, M
		MOV A, M \\ ANI $20 \\ JZ . - 3
                RET            
                
                
        FONT69:

                ; Настройка ПДП
                ; DE - адрес экрана
                ; BC - размер экрана
                
                LXI D, SCREEN_FONT
		MVI C, DMA_SIZE_FONT & $00FF
		MVI B, ($4000 + DMA_SIZE_FONT) >> 8
                
                CALL SET_DMA

                ; Размечаем экран под данные
                
                LXI H, SCREEN_FONT
                MVI A, $00
                
                FONT69_LOOP_SET:

                MVI M, $7F \\ INX H
                MVI M, $C0 \\ INX H
                MOV M, A \\ INX H

                INR A \\ CPI $80 \\ JNZ FONT69_LOOP_SET
                


                ; Загрузка шрифта
                MVI A, $00 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT \\ CALL FONT69_DATA
                MVI A, $01 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 1 \\ CALL FONT69_DATA
                MVI A, $02 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 2 \\ CALL FONT69_DATA
                MVI A, $03 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 3 \\ CALL FONT69_DATA
                MVI A, $04 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 4 \\ CALL FONT69_DATA
                MVI A, $05 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 5 \\ CALL FONT69_DATA
                MVI A, $06 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 6 \\ CALL FONT69_DATA
                MVI A, $07 \\ CALL FONT69_CRT \\ LXI H, SCREEN_FONT \\ LXI D, FONT + 7 \\ CALL FONT69_DATA


                RET
                
                
        FONT69_DATA:
                
                MVI A, $E0
                STA KR580VG75 + 1
                
                ; Вносим данные

                MVI A, $00
                LXI B, $0008
                
                FONT69_LOOP_DATA:
                
                PUSH PSW

                LDAX D \\ ANI 00111111b \\ MOV M, A
                INX H \\ INX H \\ INX H
                XCHG \\ DAD B \\ XCHG

                POP PSW

                INR A \\ CPI $80 \\ JNZ FONT69_LOOP_DATA
                
                MVI A, $25
                STA KR580VG75 + 1
                
		CALL VG75_READY
		CALL VG75_READY

                RET
                
                
        FONT69_CRT:

                ; DE - строки и столбцы
                ; BC - размер знакоместа и курсор

                LXI D, DISPLAY_FONT
                LXI B, GRAPH_78X38
                
                RLC \\ RLC \\ RLC \\ RLC
                ORI $07
                MOV C, A

                CALL SET_DISPLAY

                RET


START:

                CALL FONT69

                ; Настройка знакогенератора
                LXI D, DISPLAY_78X38
                LXI B, GRAPH_78X38
                CALL SET_DISPLAY
                
                ; Настройка ПДП                
                LXI D, SCREEN
		MVI C, DMA_SIZE_78X38 & $00FF
		MVI B, ($4000 + DMA_SIZE_78X38) >> 8
                CALL SET_DMA


        MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY

		; Счетчик-делитель

		LXI H, CLOCK
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA CLOCK
		ANI 00000001b
		CZ X2
		
                ; X2 FLOP
		LDA CLOCK
		ANI 00000001b
		CNZ X2_

                ; X4
		LDA CLOCK
 		ANI 00000011b
		CZ X4

                ; X8
		LDA CLOCK
 		ANI 00000111b
		CZ X8
   
                JMP MAIN


        X1:


                RET


        X2:


		RET


        X2_:

                RET


        X4:


		; Опрос клавиавтуры
                LXI H, KR580VV55_KBD
                MVI M, 11111110b

		; Выход
                LDA KR580VV55_KBD + 1
                CPI 11111011b
                JZ ROM
                

		RET


        X8:
        

		RET


SCREEN:

		; 01
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 02
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 03
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 04
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 05
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 06
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 07
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 08
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $01, $02, $03, $04, $05, $06, $07
		db $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 09
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $10, $11, $12, $13, $14, $15, $16, $17
		db $18, $19, $1A, $1B, $1C, $1D, $1E, $1F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 10
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $20, $21, $22, $23, $24, $25, $26, $27
		db $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 11
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $30, $31, $32, $33, $34, $35, $36, $37
		db $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 12
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $40, $41, $42, $43, $44, $45, $46, $47
		db $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 13
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $50, $51, $52, $53, $54, $55, $56, $57
		db $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 14
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $60, $61, $62, $63, $64, $65, $66, $67
		db $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 15
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $70, $71, $72, $73, $74, $75, $76, $77
		db $78, $79, $7A, $7B, $7C, $7D, $7E, $7F,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 16
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 17
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 18
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 19
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 20
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 21
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 22
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 23
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 24
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 25
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 26
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 27
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 28
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 29
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 30
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 31
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; 32
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
                db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

                ; Подвал
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00
		
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F3, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00

		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00,      $00, $00, $00, $00, $00, $00, $00, $00
		db $00, $00, $00, $00, $F1, $00, $00, $00,      $00, $00, $00, $00, $00, $00


FONT:           
	;  char 0x00
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x01
	DB	0C7h, 0C7h, 0C7h, 0C7h, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x02
	DB	0F8h, 0F8h, 0F8h, 0F8h, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x03
	DB	0C0h, 0C0h, 0C0h, 0C0h, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x04
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0F8h, 0F8h, 0F8h, 0F8h
	;  char 0x05
	DB	0C7h, 0C7h, 0C7h, 0C7h, 0F8h, 0F8h, 0F8h, 0F8h
	;  char 0x06
	DB	0F8h, 0F8h, 0F8h, 0F8h, 0F8h, 0F8h, 0F8h, 0F8h
	;  char 0x07
	DB	0C0h, 0C0h, 0C0h, 0C0h, 0F8h, 0F8h, 0F8h, 0F8h
	;  char 0x08
	DB	0FFh, 0DEh, 0EDh, 0FFh, 0FFh, 0EDh, 0DEh, 0FFh
	;  char 0x09
	DB	0F3h, 0F3h, 0FFh, 0E1h, 0D2h, 0F3h, 0EDh, 0EDh
	;  char 0x0a
	DB	0FFh, 0F3h, 0E1h, 0C8h, 0C0h, 0E1h, 0F3h, 0FFh
	;  char 0x0b
	DB	0F3h, 0E1h, 0C0h, 0F3h, 0F3h, 0F3h, 0F3h, 0F3h
	;  char 0x0c
	DB	0DEh, 0DEh, 0C0h, 0DEh, 0DEh, 0DEh, 0C0h, 0DEh
	;  char 0x0d
	DB	0FFh, 0C8h, 0C8h, 0CAh, 0FFh, 0E1h, 0C1h, 0C1h
	;  char 0x0e
	DB	0F7h, 0F3h, 0D1h, 0C0h, 0C0h, 0D1h, 0F3h, 0F7h
	;  char 0x0f
	DB	0F3h, 0F3h, 0F3h, 0F3h, 0F3h, 0C0h, 0E1h, 0F3h
	;  char 0x10
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0C7h, 0C7h, 0C7h, 0C7h
	;  char 0x11
	DB	0C7h, 0C7h, 0C7h, 0C7h, 0C7h, 0C7h, 0C7h, 0C7h
	;  char 0x12
	DB	0F8h, 0F8h, 0F8h, 0F8h, 0C7h, 0C7h, 0C7h, 0C7h
	;  char 0x13
	DB	0C0h, 0C0h, 0C0h, 0C0h, 0C7h, 0C7h, 0C7h, 0C7h
	;  char 0x14
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0C0h, 0C0h, 0C0h, 0C0h
	;  char 0x15
	DB	0C7h, 0C7h, 0C7h, 0C7h, 0C0h, 0C0h, 0C0h, 0C0h
	;  char 0x16
	DB	0F8h, 0F8h, 0F8h, 0F8h, 0C0h, 0C0h, 0C0h, 0C0h
	;  char 0x17
	DB	0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0C0h
	;  char 0x18
	DB	0EFh, 0D7h, 0EDh, 0FAh, 0FDh, 0F7h, 0D5h, 0D5h
	;  char 0x19
	DB	0F3h, 0F3h, 0FFh, 0D2h, 0D2h, 0F3h, 0EDh, 0EDh
	;  char 0x1a
	DB	0DFh, 0CFh, 0C7h, 0C3h, 0C1h, 0CFh, 0DFh, 0FFh
	;  char 0x1b
	DB	0F3h, 0F3h, 0F3h, 0F3h, 0F3h, 0F3h, 0F3h, 0F3h
	;  char 0x1c
	DB	0FFh, 0FFh, 0FFh, 0C0h, 0C0h, 0FFh, 0FFh, 0FFh
	;  char 0x1d
	DB	0FBh, 0F3h, 0E2h, 0C0h, 0C0h, 0E2h, 0F3h, 0FBh
	;  char 0x1e
	DB	0FCh, 0FBh, 0E9h, 0D2h, 0DEh, 0DEh, 0EDh, 0F3h
	;  char 0x1f
	DB	0D5h, 0EAh, 0D5h, 0EAh, 0D5h, 0EAh, 0D5h, 0EAh
	;  char 0x20
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x21
	DB	0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0FFh, 0FBh, 0FFh
	;  char 0x22
	DB	0F5h, 0F5h, 0F5h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x23
	DB	0F5h, 0F5h, 0E0h, 0F5h, 0E0h, 0F5h, 0F5h, 0FFh
	;  char 0x24
	DB	0EEh, 0F1h, 0F5h, 0F5h, 0F1h, 0EEh, 0FFh, 0FFh
	;  char 0x25
	DB	0E7h, 0E6h, 0FDh, 0FBh, 0F7h, 0ECh, 0FCh, 0FFh
	;  char 0x26
	DB	0FBh, 0F5h, 0F5h, 0F3h, 0EAh, 0EDh, 0F2h, 0FFh
	;  char 0x27
	DB	0F9h, 0F9h, 0FDh, 0FBh, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x28
	DB	0FDh, 0FBh, 0F7h, 0F7h, 0F7h, 0FBh, 0FDh, 0FFh
	;  char 0x29
	DB	0F7h, 0FBh, 0FDh, 0FDh, 0FDh, 0FBh, 0F7h, 0FFh
	;  char 0x2a
	DB	0FFh, 0FBh, 0EAh, 0F1h, 0EAh, 0FBh, 0FFh, 0FFh
	;  char 0x2b
	DB	0FFh, 0FBh, 0FBh, 0E0h, 0FBh, 0FBh, 0FFh, 0FFh
	;  char 0x2c
	DB	0FFh, 0FFh, 0FFh, 0F3h, 0F3h, 0FBh, 0F7h, 0FFh
	;  char 0x2d
	DB	0FFh, 0FFh, 0FFh, 0E0h, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x2e
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F3h, 0F3h, 0FFh
	;  char 0x2f
	DB	0FFh, 0FEh, 0FDh, 0FBh, 0F7h, 0EFh, 0FFh, 0FFh
	;  char 0x30
	DB	0F1h, 0EEh, 0ECh, 0EAh, 0E6h, 0EEh, 0F1h, 0FFh
	;  char 0x31
	DB	0FBh, 0F3h, 0FBh, 0FBh, 0FBh, 0FBh, 0F1h, 0FFh
	;  char 0x32
	DB	0F1h, 0EEh, 0FEh, 0F9h, 0F7h, 0EFh, 0E0h, 0FFh
	;  char 0x33
	DB	0E0h, 0FEh, 0FDh, 0F9h, 0FEh, 0EEh, 0F1h, 0FFh
	;  char 0x34
	DB	0FDh, 0F9h, 0F5h, 0EDh, 0E0h, 0FDh, 0FDh, 0FFh
	;  char 0x35
	DB	0E0h, 0EFh, 0E1h, 0FEh, 0FEh, 0EEh, 0F1h, 0FFh
	;  char 0x36
	DB	0F8h, 0F7h, 0EFh, 0E1h, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x37
	DB	0E0h, 0FEh, 0FDh, 0FBh, 0F7h, 0F7h, 0F7h, 0FFh
	;  char 0x38
	DB	0F1h, 0EEh, 0EEh, 0F1h, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x39
	DB	0F1h, 0EEh, 0EEh, 0F0h, 0FEh, 0FDh, 0E3h, 0FFh
	;  char 0x3a
	DB	0FFh, 0F3h, 0F3h, 0FFh, 0FFh, 0F3h, 0F3h, 0FFh
	;  char 0x3b
	DB	0F3h, 0F3h, 0FFh, 0F3h, 0F3h, 0FBh, 0F7h, 0FFh
	;  char 0x3c
	DB	0FDh, 0FBh, 0F7h, 0EFh, 0F7h, 0FBh, 0FDh, 0FFh
	;  char 0x3d
	DB	0FFh, 0FFh, 0E0h, 0FFh, 0E0h, 0FFh, 0FFh, 0FFh
	;  char 0x3e
	DB	0F7h, 0FBh, 0FDh, 0FEh, 0FDh, 0FBh, 0F7h, 0FFh
	;  char 0x3f
	DB	0F1h, 0EEh, 0FEh, 0FDh, 0FBh, 0FFh, 0FBh, 0FFh
	;  char 0x40
	DB	0F1h, 0EEh, 0ECh, 0EAh, 0E8h, 0EFh, 0F1h, 0FFh
	;  char 0x41
	DB	0FBh, 0F5h, 0EEh, 0EEh, 0E0h, 0EEh, 0EEh, 0FFh
	;  char 0x42
	DB	0E1h, 0EEh, 0EEh, 0E1h, 0EEh, 0EEh, 0E1h, 0FFh
	;  char 0x43
	DB	0F1h, 0EEh, 0EFh, 0EFh, 0EFh, 0EEh, 0F1h, 0FFh
	;  char 0x44
	DB	0E1h, 0F6h, 0F6h, 0F6h, 0F6h, 0F6h, 0E1h, 0FFh
	;  char 0x45
	DB	0E0h, 0EFh, 0EFh, 0E1h, 0EFh, 0EFh, 0E0h, 0FFh
	;  char 0x46
	DB	0E0h, 0EFh, 0EFh, 0E1h, 0EFh, 0EFh, 0EFh, 0FFh
	;  char 0x47
	DB	0F1h, 0EEh, 0EFh, 0EFh, 0ECh, 0EEh, 0F0h, 0FFh
	;  char 0x48
	DB	0EEh, 0EEh, 0EEh, 0E0h, 0EEh, 0EEh, 0EEh, 0FFh
	;  char 0x49
	DB	0F1h, 0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0F1h, 0FFh
	;  char 0x4a
	DB	0FEh, 0FEh, 0FEh, 0FEh, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x4b
	DB	0EEh, 0EDh, 0EBh, 0E7h, 0EBh, 0EDh, 0EEh, 0FFh
	;  char 0x4c
	DB	0EFh, 0EFh, 0EFh, 0EFh, 0EFh, 0EEh, 0E0h, 0FFh
	;  char 0x4d
	DB	0EEh, 0E4h, 0EAh, 0EAh, 0EEh, 0EEh, 0EEh, 0FFh
	;  char 0x4e
	DB	0EEh, 0EEh, 0E6h, 0EAh, 0ECh, 0EEh, 0EEh, 0FFh
	;  char 0x4f
	DB	0F1h, 0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x50
	DB	0E1h, 0EEh, 0EEh, 0E1h, 0EFh, 0EFh, 0EFh, 0FFh
	;  char 0x51
	DB	0F1h, 0EEh, 0EEh, 0EEh, 0EAh, 0EDh, 0F2h, 0FFh
	;  char 0x52
	DB	0E1h, 0EEh, 0EEh, 0E1h, 0EBh, 0EDh, 0EEh, 0FFh
	;  char 0x53
	DB	0F1h, 0EEh, 0EFh, 0F1h, 0FEh, 0EEh, 0F1h, 0FFh
	;  char 0x54
	DB	0E0h, 0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0FFh
	;  char 0x55
	DB	0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x56
	DB	0EEh, 0EEh, 0EEh, 0F5h, 0F5h, 0FBh, 0FBh, 0FFh
	;  char 0x57
	DB	0EEh, 0EEh, 0EEh, 0EAh, 0EAh, 0EAh, 0F5h, 0FFh
	;  char 0x58
	DB	0EEh, 0EEh, 0F5h, 0FBh, 0F5h, 0EEh, 0EEh, 0FFh
	;  char 0x59
	DB	0EEh, 0EEh, 0F5h, 0FBh, 0FBh, 0FBh, 0FBh, 0FFh
	;  char 0x5a
	DB	0E0h, 0FEh, 0FDh, 0F1h, 0F7h, 0EFh, 0E0h, 0FFh
	;  char 0x5b
	DB	0F1h, 0F7h, 0F7h, 0F7h, 0F7h, 0F7h, 0F1h, 0FFh
	;  char 0x5c
	DB	0FFh, 0EFh, 0F7h, 0FBh, 0FDh, 0FEh, 0FFh, 0FFh
	;  char 0x5d
	DB	0F1h, 0FDh, 0FDh, 0FDh, 0FDh, 0FDh, 0F1h, 0FFh
	;  char 0x5e
	DB	0F1h, 0EEh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
	;  char 0x5f
	DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0E0h, 0FFh
	;  char 0x60
	DB	0EDh, 0EAh, 0EAh, 0E2h, 0EAh, 0EAh, 0EDh, 0FFh
	;  char 0x61
	DB	0FBh, 0F5h, 0EEh, 0EEh, 0E0h, 0EEh, 0EEh, 0FFh
	;  char 0x62
	DB	0E0h, 0EFh, 0EFh, 0E1h, 0EEh, 0EEh, 0E1h, 0FFh
	;  char 0x63
	DB	0EDh, 0EDh, 0EDh, 0EDh, 0EDh, 0E0h, 0FEh, 0FFh
	;  char 0x64
	DB	0F9h, 0F5h, 0F5h, 0F5h, 0F5h, 0E0h, 0EEh, 0FFh
	;  char 0x65
	DB	0E0h, 0EFh, 0EFh, 0E1h, 0EFh, 0EFh, 0E0h, 0FFh
	;  char 0x66
	DB	0FBh, 0E0h, 0EAh, 0EAh, 0E0h, 0FBh, 0FBh, 0FFh
	;  char 0x67
	DB	0E0h, 0EEh, 0EFh, 0EFh, 0EFh, 0EFh, 0EFh, 0FFh
	;  char 0x68
	DB	0EEh, 0EEh, 0F5h, 0FBh, 0F5h, 0EEh, 0EEh, 0FFh
	;  char 0x69
	DB	0EEh, 0EEh, 0ECh, 0EAh, 0E6h, 0EEh, 0EEh, 0FFh
	;  char 0x6a
	DB	0EAh, 0EEh, 0ECh, 0EAh, 0E6h, 0EEh, 0EEh, 0FFh
	;  char 0x6b
	DB	0EEh, 0EDh, 0EBh, 0E7h, 0EBh, 0EDh, 0EEh, 0FFh
	;  char 0x6c
	DB	0F8h, 0F6h, 0F6h, 0F6h, 0F6h, 0F6h, 0E6h, 0FFh
	;  char 0x6d
	DB	0EEh, 0E4h, 0EAh, 0EAh, 0EEh, 0EEh, 0EEh, 0FFh
	;  char 0x6e
	DB	0EEh, 0EEh, 0EEh, 0E0h, 0EEh, 0EEh, 0EEh, 0FFh
	;  char 0x6f
	DB	0F1h, 0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0F1h, 0FFh
	;  char 0x70
	DB	0E0h, 0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0EEh, 0FFh
	;  char 0x71
	DB	0F0h, 0EEh, 0EEh, 0F0h, 0FAh, 0F6h, 0EEh, 0FFh
	;  char 0x72
	DB	0E1h, 0EEh, 0EEh, 0E1h, 0EFh, 0EFh, 0EFh, 0FFh
	;  char 0x73
	DB	0F1h, 0EEh, 0EFh, 0EFh, 0EFh, 0EEh, 0F1h, 0FFh
	;  char 0x74
	DB	0E0h, 0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0FBh, 0FFh
	;  char 0x75
	DB	0EEh, 0EEh, 0EEh, 0F5h, 0FBh, 0F7h, 0EFh, 0FFh
	;  char 0x76
	DB	0EEh, 0EAh, 0EAh, 0F1h, 0EAh, 0EAh, 0EEh, 0FFh
	;  char 0x77
	DB	0E1h, 0EEh, 0EEh, 0E1h, 0EEh, 0EEh, 0E1h, 0FFh
	;  char 0x78
	DB	0EFh, 0EFh, 0EFh, 0E1h, 0EEh, 0EEh, 0E1h, 0FFh
	;  char 0x79
	DB	0EEh, 0EEh, 0EEh, 0E6h, 0EAh, 0EAh, 0E6h, 0FFh
	;  char 0x7a
	DB	0F1h, 0EEh, 0FEh, 0F9h, 0FEh, 0EEh, 0F1h, 0FFh
	;  char 0x7b
	DB	0EEh, 0EAh, 0EAh, 0EAh, 0EAh, 0EAh, 0E0h, 0FFh
	;  char 0x7c
	DB	0F1h, 0EEh, 0FEh, 0F8h, 0FEh, 0EEh, 0F1h, 0FFh
	;  char 0x7d
	DB	0EAh, 0EAh, 0EAh, 0EAh, 0EAh, 0E0h, 0FEh, 0FFh
	;  char 0x7e
	DB	0EEh, 0EEh, 0EEh, 0E0h, 0FEh, 0FEh, 0FEh, 0FFh
	;  char 0x7f
	DB	0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0C0h, 0FFh

		
                
SCREEN_FONT:

                