;Vortex Tracker II v1.0 PT3 player for MSX
;Adapted by Alfonso D. C. aka Dioniso <dioniso072@yahoo.es>
;09-Jan-05
;
;8080 version by Ivan Gorodetsky 05-13.07.2025
;8080 mnemonics conversion by Viacheslav Slavinsky 06-Jul-25
;
;From:
;Vortex Tracker II v1.0 PT3 player for ZX Spectrum
;(c)2004 S.V.Bulba <vorobey@mail.khstu.ru> http://bulba.at.kz

;Release number
Release: .equ '6'

;Features
;--------
;-Can be compiled at any address (i.e. no need rounding .org
; address).
;-Variables (VARS) can be located at any address (not only after
;code block).
;-INIT subroutine detects module version and rightly generates
; both note and volume tables outside of code block (in VARS).
;-Two portamento (spc. command 3xxx) algorithms (depending of
; module version).
;-Any Tempo value are accepted (including Tempo=1 and Tempo=2).
;-Fully compatible with Ay_Emul PT3 player codes.
;-See also notes at the end of this source code.

;Limitations
;-----------
;-Can run in RAM only (self-modified code is used).

;Warning!!! PLAY subroutine can crash if no module are loaded
;into RAM or INIT subroutine was not called before.

;Call MUTE or INIT one more time to mute sound after stopping
;playing

;Entry and other points
;START initialization
;START+3 initialization with module address in HL
;START+6 play one quark
;START+9 mute
;START+12 setup and status flags
;START+13 pointer to current position value in PT3 module;
;After INIT (START+13) points to Postion0-1 (optimization)

START:
	lxi h, MDLADDR	;Address of PT3 module
	jmp INIT		;START+3
	jmp PLAY		;START+6
	jmp MUTE		;START+9
SETUP:	.db 0 ;set bit0 to 1, if you want to play without looping
	     ;bit7 is set each time, when loop point is passed
CrPsPtr:	.dw 0

;Identifier
	.db "=VTII PT3 Player r.",Release,"="

CHECKLP:
        lxi h, SETUP

	mov a, m
	ori 128
	mov m, a
	rrc
	rnc

	pop h
	lxi h, DelyCnt
	inr m
	lxi h, ChanA+CHNPRM_NtSkCn
	inr m
MUTE:	xra a
	mov h, a
	mov l, a
	sta AYREGS+AR_AmplA
	shld AYREGS+AR_AmplB
	ret

INIT:
;HL - AddressOfModule

	shld MODADDR
	shld MDADDR2
	push h
	lxi d, 100
	dad d
	mov a, m
	sta Delay

	shld regIX

	dad d
	shld CrPsPtr

	push h
	lhld regIX
	inx h\ inx h
	mov e, m
	inx h
	shld SetIX2+1
	pop h

	dad d
	inx h
	shld LPosPtr

SetIX2:
	lhld 0
	pop d

	dad d
	shld PatsPtr
	lxi h, 169
	dad d
	shld OrnPtrs
	lxi h, 105
	dad d
	shld SamPtrs

	lxi h, SETUP
	mov a, m
	ani 01111111b
	mov m, a


;note table data depacker
	lxi d, T_PACK
	lxi b, T1_+(2*49)-1
TP_0:
        ldax d
	inx d
	cpi 15*2
	jnc TP_1
	mov h, a
	ldax d
	mov l, a
	inx d
	jmp TP_2
TP_1:
        push d
	mvi d, 0
	mov e, a
	dad d
	dad d
	pop d
TP_2:
        mov a, h
	stax b
	dcx b
	mov a, l
	stax b
	dcx b
	sui $F0
	jnz TP_0

	lxi h, VARS
	mov m, a
	lxi d, VARS+1
	lxi b, VAR0END-VARS-1

	push psw
LdirLoop:
	mov a, m
	stax d
	inx h
	inx d
	dcr c
	jnz LdirLoop
	pop psw

	inr a
	sta DelyCnt
	lxi h, $F001 ;H - CHNPRM_Volume, L - CHNPRM_NtSkCn
	shld ChanA+CHNPRM_NtSkCn
	shld ChanB+CHNPRM_NtSkCn
	shld ChanC+CHNPRM_NtSkCn

	lxi h, EMPTYSAMORN
	shld AdInPtA ;ptr to zero
	shld ChanA+CHNPRM_OrnPtr ;ornament 0 is "0,1,0"
	shld ChanB+CHNPRM_OrnPtr ;in all versions from
	shld ChanC+CHNPRM_OrnPtr ;3.xx to 3.6x ani VTII

	shld ChanA+CHNPRM_SamPtr ;S1 There is no default
	shld ChanB+CHNPRM_SamPtr ;S2 sample in PT3, so, you
	shld ChanC+CHNPRM_SamPtr ;S3 can comment S1,2,3; see
				    ;also EMPTYSAMORN comment

	lhld regIX
	lxi b, 13-100
	dad b
	mov a, m

	sui $30
	jc L20
	cpi 10
	jc L21
L20:	mvi a, 6
L21:	sta Version
	push psw
	cpi 4

	lhld regIX
	dcx h
	mov a, m

	ral
	ani 7

;NoteTableCreator (c) Ivan Roshin
;A - NoteTableNumber*2+VersionForNoteTable
;(xx1b - 3.xx..3.4r, xx0b - 3.4x..3.6x..VTII1.0)

	lxi h, NT_DATA
	push d
	mvi d, 0
	add a
	mov e, a
	dad d
	mov e, m
	inx h

	sta $+8\ xra a\ ora e\ rar\ mov e, a\ mvi a, 0

	sbb a
	ani $A7 ;$00 (NOP) or $A7 (ana a)
	sta L3
	xchg
	pop b ;BC=T1_
	dad b

	ldax d

	lxi b, T_
	add c
	mov c, a
	adc b

	sub c
	mov b, a
	push b
	lxi d, NT_
	push d

	mvi b, 12
L1:
 	push b
	mov c, m
	inx h
	push h
	mov b, m

	push d
	xchg
	lxi d, 23

	mvi a, 8
L2:
	sta SetCnt1+1
	xra a\ ora b\ rar\ mov b, a
	mov a, c\ rar\ mov c, a

L3:
	.db 0

	mov a, c
	adc d	;=ADC 0
	mov m, a
	inx h
	mov a, b
	adc d
	mov m, a
	dad d

SetCnt1:
	mvi a,0
	dcr a
	jnz L2

	pop d
	inx d
	inx d
	pop h
	inx h
	pop b

	dcr b\ jnz L1

	pop h
	pop d

	mov a, e
	push d
	lxi d, TCOLD_1
	cmp e
	pop d
	jnz CORR_1
	mvi a, $FD
	sta NT_+$2E

CORR_1:
	ldax d
	ana a
	jz TC_EXIT
	rar
	push psw
	add a
	mov c, a
	dad b
	pop psw
	jnc CORR_2
	dcr m
	dcr m
CORR_2:
	inr m

	mov a, l\ sub c\ mov l, a
	mov a, h\ sbb b\ mov h, a

	inx d
	jmp CORR_1

TC_EXIT:

	pop psw

;VolTableCreator (c) Ivan Roshin
;A - VersionForVolumeTable (0..4 - 3.xx..3.4x;
			   ;5.. - 3.5x..3.6x..VTII1.0)

	cpi 5
	lxi h, $11
	mov d, h
	mov e, h
	mvi a, $17
	jnc M1
	dcr l
	mov e, l
	xra a
M1:
        sta M2

	push h
	lxi h, VT_+16
	shld regIX
	pop h

	mvi c, $10

INITV2:
        push h

	dad d
	xchg

	lxi h, 0

INITV1:
        mov a, l
M2:
	.db 0
	mov a, h
	aci 0

	push h
	lhld regIX
	mov m, a
	inx h
	shld regIX
	pop h

	dad d
	inr c
	mov a, c
	ani 15
	jnz INITV1

	pop h
	mov a, e
	cpi $77
	jnz M3
	inr e
M3:
        mov a, c
	ana a
	jnz INITV2

	ret

;pattern decoder
PD_OrSm:
	lhld regIX
	lxi d, -12+CHNPRM_Env_En
	dad d
	mvi m, 0

	call SETORN
	ldax b
	inx b
	rrc

PD_SAM:
	add a
PD_SAM_:
 	mov e, a
	mvi d, 0
SamPtrs: .equ $+1
	lxi h, $2121
	dad d
	mov e, m
	inx h
	mov d, m
MODADDR: .equ $+1
	lxi h, $2121
	dad d

	xchg
	lhld regIX
	inx h\ inx h\ inx h
	mov m, e
	inx h
	mov m, d

	jmp PD_LOOP

PD_VOL:
 	rlc
	rlc
	rlc
	rlc

	push b
	lhld regIX
	lxi b, -12+CHNPRM_Volume
	dad b
	mov m, a
	pop b

	jmp PD_LP2

PD_EOff:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_Env_En
	dad b
	mov m, a
	lxi b, CHNPRM_PsInOr-CHNPRM_Env_En
	dad b
	mov m, a
	pop b

	jmp PD_LP2

PD_SorE:
	dcr a
	jnz PD_ENV
	ldax b
	inx b

	lhld regIX
	inx h\ inx h\ inx h\ inx h\ inx h
	mov m, a

	jmp PD_LP2

PD_ENV:	call SETENV
	jmp PD_LP2

PD_ORN:	call SETORN
	jmp PD_LOOP

PD_ESAM:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_Env_En
	dad b
	mov m, a
	lxi b, CHNPRM_PsInOr-CHNPRM_Env_En
	dad b
	mov m, a
	pop b

	cnz SETENV
	ldax b
	inx b
	jmp PD_SAM_

PTDECOD:
	lhld regIX
	lxi d, -12+CHNPRM_Note
	dad d
	mov a, m

	sta PrNote+1

	lxi d, CHNPRM_CrTnSl-CHNPRM_Note
	dad d
	mov a, m
	inx h
	mov h, m
	mov l, a

	shld PrSlide+1

PD_LOOP:
	lxi d, $2010
PD_LP2:
	ldax b
	inx b
	add e
	jc PD_OrSm
	add d
	jz PD_FIN
	jc PD_SAM
	add e
	jz PD_REL
	jc PD_VOL
	add e
	jz PD_EOff
	jc PD_SorE
	adi 96
	jc PD_NOTE
	add e
	jc PD_ORN
	add d
	jc PD_NOIS
	add e
	jc PD_ESAM
	add a
	mov e, a

	push d
	lxi d, $DF20
	lxi h, SPCCOMS
	dad d
	pop d

	dad d
	mov e, m
	inx h
	mov d, m
	push d
	jmp PD_LOOP

PD_NOIS:
	sta Ns_Base
	jmp PD_LP2

PD_REL:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_Flags
	dad b
	mov a, m
	ani 11111110b
	mov m, a
	pop b

	jmp PD_RES_

PD_NOTE:
	lhld regIX
	inx h\ inx h\ inx h\ inx h\ inx h\ inx h
	mov m, a
	inx h\ inx h\ inx h
	mov a, m
	ori 1
	mov m, a

PD_RES_:
	xra a

PD_RES:
	lxi h, 0
	dad sp
	shld PDSP_+1
	lhld regIX
	sphl

	mov h, a
	mov l, a
	push h
	push h
	push h
	push h
	push h
	push h
PDSP_:
	lxi sp, $3131

PD_FIN:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_NNtSkp
	dad b
	mov a, m
	lxi b, CHNPRM_NtSkCn-CHNPRM_NNtSkp
	dad b
	mov m, a
	pop b

	RET

C_PORTM:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_Flags
	dad b
	mov a, m
	ani 11111011b
	mov m, a
	pop b

	ldax b
	inx b
;SKIP PRECALCULATED TONE DELTA (BECAUSE
;CANNOT BE RIGHT AFTER PT3 COMPILATION)
	inx b
	inx b

	lhld regIX
	lxi d, -12+CHNPRM_TnSlDl
	dad d
	mov m, a
	lxi d, CHNPRM_TSlCnt-CHNPRM_TnSlDl
	dad d
	mov m, a
	lxi d, CHNPRM_Note-CHNPRM_TSlCnt
	dad d
	mov a, m
	lxi d, CHNPRM_SlToNt-CHNPRM_Note
	dad d
	mov m, a
	lxi d, NT_

	add a
	mov l, a
	mvi h, 0
	dad d
	mov a, m
	inx h
	mov h, m
	mov l, a
	push h
PrNote:
	mvi a, $3E

	lhld regIX
	push b
	lxi b, -12+CHNPRM_Note
	dad b
	mov m, a
	pop b

	add a
	mov l, a
	mvi h, 0
	dad d
	mov e, m
	inx h
	mov d, m
	pop h

	mov a, l\ sbb e\ mov l, a
	mov a, h\ sbb d\ mov h, a

	xchg
	push b
	lhld regIX
	lxi b, -12+CHNPRM_TnDelt
	dad b
	mov m, e
	inx h
	mov m, d
	lxi b, CHNPRM_CrTnSl-CHNPRM_TnDelt
	dad b
	mov a, m
	inx h
	mov h, m
	mov l, a
	xchg
	pop b


Version: .equ $+1
	mvi a, $3E
	cpi 6
	jc OLDPRTM ;Old 3xxx for PT v3.5-
PrSlide:
	lxi d, $1111

	push h
	push b
	lhld regIX
	lxi b, -12+CHNPRM_CrTnSl
	dad b
	mov m, e
	inx h
	mov m, d
	pop b
	pop h

OLDPRTM:
	ldax b ;SIGNED TONE STEP
	inx b
	sta SetA2+1

	ldax b
	inx b
	ana a
	jz NOSIG
	xchg
NOSIG:
	sta $+10
	mov a, l\ sbb e\ mov l, a
	mov a, h\ sbb d\ mov h, a
	mvi a, 0

	jp SET_STP
	cma
	push psw
	lda SetA2+1
	cma
	inr a
	sta SetA2+1
	pop psw
SET_STP:
	push h
	push b
	lhld regIX
	lxi b, -12+CHNPRM_TSlStp+1
	dad b
	mov m, a
	dcx h
SetA2:
	mvi m, 0
	lxi b, CHNPRM_COnOff-CHNPRM_TSlStp
	dad b
	mvi m, 0
	pop b
	pop h

	RET

C_GLISS:
	push h
	push d
	lhld regIX
	lxi d, -12+CHNPRM_Flags
	dad d
	mov a, m
	ori 100b
	mov m, a
	ldax b
	inx b
	inx h
	mov m, a
	ana a
	jnz GL36
	lda Version		;AlCo PT3.7+
	cpi 7
	sbb a
	inr a
GL36:	
	lxi d, CHNPRM_TSlCnt-CHNPRM_TnSlDl
	dad d
	mov m, a
	pop d
	pop h

	ldax b
	inx b
	sta SetA2+1

	ldax b
	inx b
	jmp SET_STP

C_SMPOS:
	ldax b
	inx b

	push h
	push b
	lhld regIX
	lxi b, -12+CHNPRM_PsInSm
	dad b
	mov m, a
	pop b
	pop h

	RET

C_ORPOS:
	ldax b
	inx b

	push h
	push b
	lhld regIX
	lxi b, -12+CHNPRM_PsInOr
	dad b
	mov m, a
	pop b
	pop h

	RET

C_VIBRT:
	ldax b
	inx b

	push h
	push d
	lhld regIX
	dcx h
	mov m, a
	dcx h
	mov m, a
	ldax b
	inx b
	inx h\ inx h
	mov m, a
	xra a
	lxi d, CHNPRM_TSlCnt-CHNPRM_OffOnD
	dad d
	mov m, a
	inx h
	mov m, a
	inx h
	mov m, a
	pop d
	pop h

	RET

C_ENGLS:
	ldax b
	inx b
	sta Env_Del
	sta CurEDel
	ldax b
	inx b
	mov l, a
	ldax b
	inx b
	mov h, a
	shld ESldAdd
	RET

C_DELAY:
	ldax b
	inx b
	sta Delay
	RET

SETENV:
	push b
	lhld regIX
	lxi b, -12+CHNPRM_Env_En
	dad b
	mov m, e
	pop b

	sta AYREGS+AR_EnvTp
	ldax b
	inx b
	mov h, a
	ldax b
	inx b
	mov l, a
	shld EnvBase
	xra a

	push b
	lhld regIX
	lxi b, -12+CHNPRM_PsInOr
	dad b
	mov m, a
	pop b

	sta CurEDel
	mov h, a
	mov l, a
	shld CurESld
C_NOP:	RET

SETORN:
	push b
	add a
	mov e, a
	mvi d, 0

	lhld regIX
	lxi b, -12+CHNPRM_PsInOr
	dad b
	mov m, d

OrnPtrs:	.equ $+1
	lxi h, $2121
	dad d
	mov e, m
	inx h
	mov d, m
MDADDR2:	.equ $+1
	lxi h, $2121
	dad d

	xchg
	lhld regIX
	inx h
	mov m, e
	inx h
	mov m, d

	pop b
	RET

;ALL 16 ADDRESSES TO PROTECT FROM BROKEN PT3 MODULES
SPCCOMS: .dw C_NOP
	.dw C_GLISS
	.dw C_PORTM
	.dw C_SMPOS
	.dw C_ORPOS
	.dw C_VIBRT
	.dw C_NOP
	.dw C_NOP
	.dw C_ENGLS
	.dw C_DELAY
	.dw C_NOP
	.dw C_NOP
	.dw C_NOP
	.dw C_NOP
	.dw C_NOP
	.dw C_NOP

CHREGS:

	push h
	lxi h, 0
	dad sp
	shld CSP_+1

	lhld regIX
	lxi b, CHNPRM_Flags
	dad b
	mov a, m
	rrc
	mov a, b		;=0
	sta Ampl

	jnc CH_EXIT

	lxi b, CHNPRM_OrnPtr-CHNPRM_Flags
	dad b
	sphl
	pop h
	sphl
	pop d

	lhld regIX
	mov l, m

	mov h, a
	mov a, l
	dad sp
	inr a
	cmp d
	jc CH_ORPS
	mov a, e
CH_ORPS:

	xchg
	lhld regIX
	mov m, a
	lxi b, CHNPRM_Note
	dad b
	mov a, m
	xchg

	add m
	jp CH_NTP
	xra a
CH_NTP:
	cpi 96
	jc CH_NOK
	mvi a, 95
CH_NOK:
	add a
	sta SetA1+1

	lhld regIX
	lxi b, CHNPRM_SamPtr
	dad b
	mov e,m
	inx h
	mov d,m
	xchg
	sphl
	pop d

	lhld regIX
	inx h
	mov a, m
	mvi h, 0

	mov b, a
	add a
	add a
	mov l, a
	dad sp
	sphl
	mov a, b
	inr a
	cmp d
	jc CH_SMPS
	mov a, e
CH_SMPS:
	lhld regIX
	inx h
	mov m, a

	lxi b, 8-1
	dad b
	mov e, m
	shld SetIX1+1
	inx h
	mov d, m
	pop b
	pop h

	dad d

	mov a, b\ add a

	jp CH_NOAC

SetIX1:
	shld 0

CH_NOAC:
	xchg
SetA1:
	lxi h, 0

	lxi sp, NT_
	dad sp
	sphl
	pop h
	dad d

	xchg
	lhld regIX
	lxi sp,6
	dad sp
	mov a, m
	inx h
	mov h, m
	mov l, a
	xchg

	dad d
CSP_:
	lxi sp, $3131
	xthl
	xra a

	push h
	lhld regIX
	inx h\ inx h\ inx h\ inx h\ inx h
	ora m

	jz CH_AMP_

	dcr m

	jnz CH_AMP_

	pop psw
	push b
	push d
	lxi b, CHNPRM_TnSlDl-5
	dad b
	mov a, m
	inx h
	mov e, m
	inx h
	mov d, m
	lxi b, CHNPRM_TSlCnt-CHNPRM_TSlStp-1
	dad b
	mov m, a
	pop h

	mov a, d
	dad d

	xchg
	lhld regIX
	lxi b, CHNPRM_CrTnSl
	dad b
	mov m, e
	inx h
	mov m, d
	lxi b, CHNPRM_Flags-CHNPRM_CrTnSl-1
	dad b
	mov c, a
	mov a, m
	ani 100b
	mov a, c
	pop b
	xchg

	jnz CH_AMP

	push h
	lxi h, CHNPRM_TnDelt-CHNPRM_Flags
	dad d
	mov e, m
	inx h
	mov d, m
	pop h

	ana a
	jz CH_STPP
	xchg
CH_STPP:
	mov a, l\ sub e\ mov l, a
	mov a, h\ sbb d\ mov h, a

	jm CH_AMP

	lhld regIX
	lxi d, CHNPRM_SlToNt
	dad d
	mov a, m
	dcx h
	mov m, a
	xra a
	lxi d, CHNPRM_TSlCnt-CHNPRM_Note
	dad d
	mov m, a
	inx h
	mov m, a
	inx h
	mov m, a

	.db 0FEh
CH_AMP_:
	pop h
CH_AMP:
	lhld regIX
	inx h\ inx h
	shld CH_SVAM+1

	mov a, c\ add a
	mov a, m

	jnc CH_NOAM

	jp CH_AMIN
	
	cpi 15
	jz CH_NOAM
	inr a
	jmp CH_SVAM
CH_AMIN:
	cpi -15
	jz CH_NOAM
	dcr a
CH_SVAM:
	sta 0

CH_NOAM:
	mov l, a
	mvi a, 15
	ana b
	add l
	jp CH_APOS
	xra a
CH_APOS:
	cpi 16
	jc CH_VOL
	mvi a, 15
CH_VOL:
	lhld regIX
	lxi d, CHNPRM_Volume
	dad d
	ora m

	mov l, a
	mvi h, 0
	lxi d, VT_
	dad d
;CH_ENV:
	mov a, c\ rrc
	mov a, m

	jc CH_NOEN

	lhld regIX
	lxi d, CHNPRM_Env_En
	dad d
	ora m

CH_NOEN:
	sta Ampl

	xra a\ ora b

	mov a, c

	lhld regIX
	lxi d, 4
	dad d

	jp NO_ENSL
	add a
	add a
	
	jp $+5
	ori 11b
	rrc
	rrc
	rar

	add m

	mov e, a\ mvi a, 00100000b\ ana b

	jz NO_ENAC
	mov m, e
NO_ENAC:
	lxi h, AddToEn
	mov a, m
	add e	;BUG IN PT3 - NEED WORD HERE.
			;FIX IT IN NEXT VERSION?
	mov m, a
	jmp CH_MIX
NO_ENSL:
	rar
	add m

	sta AddToNs

	mov e, a
	mvi a, 00100000b\ ana b

	jz CH_MIX

	mov m, e

CH_MIX:	mov a, b
	rar
	ani $48
CH_EXIT:
	lxi h, AYREGS+AR_Mixer
	ora m
	rrc
	mov m, a
	xra a

	lhld regIX
	lxi d, CHNPRM_COnOff
	dad d
	ora m
	xchg
	pop h

	rz

	xchg
	dcr m
	xchg

	rnz

	xchg
	lxi b, CHNPRM_Flags-CHNPRM_COnOff
	dad b
	xra m
	mov m, a
	lxi b, CHNPRM_OnOffD-CHNPRM_Flags
	dad b
	rar
	mov a, m
	
	jc CH_ONDL

	inx h
	mov a,m
	dcx h
	
CH_ONDL:
	dcx h
	mov m, a
	xchg
	
	ret

PLAY:
    xra a
	sta AddToEn
	sta AYREGS+AR_Mixer
	dcr a
	sta AYREGS+AR_EnvTp
	lxi h, DelyCnt
	dcr m
	jnz PL2
	lxi h, ChanA+CHNPRM_NtSkCn
	dcr m
	jnz PL1B
AdInPtA:	.equ $+1
	lxi b, $0101
	ldax b
	ana a
	jnz PL1A
	mov d, a
	sta Ns_Base
	lhld CrPsPtr
	inx h
	mov a, m
	inr a
	jnz PLNLP
	call CHECKLP
LPosPtr:	.equ $+1
	lxi h, $2121
	mov a, m
	inr a
PLNLP:	shld CrPsPtr
	dcr a
	xchg
	mov l, a

	dad h

PatsPtr:	.equ $+1
	lxi d, $2121
	dad d

	xchg
	lxi h, 0
	dad sp
	shld PSP_+1
	lhld MODADDR
	xchg
	sphl

	pop h
	dad d
	mov b, h
	mov c, l
	pop h
	dad d
	shld AdInPtB
	pop h
	dad d
	shld AdInPtC
PSP_:
	lxi sp, $3131
PL1A:
	lxi h, ChanA+12
	shld regIX

	call PTDECOD

	mov l, c\ mov h, b\ shld AdInPtA

PL1B:
	lxi h, ChanB+CHNPRM_NtSkCn
	dcr m
	jnz PL1C

	lxi h, ChanB+12
	shld regIX

AdInPtB:	.equ $+1
	lxi b, $0101
	call PTDECOD

	mov l, c\ mov h, b\ shld AdInPtB


PL1C:
	lxi h, ChanC+CHNPRM_NtSkCn
	dcr m
	jnz PL1D

	lxi h, ChanC+12
	shld regIX

AdInPtC:	.equ $+1
	lxi b, $0101
	call PTDECOD

	mov l, c\ mov h, b\ shld AdInPtC

Delay:	.equ $+1
PL1D:
	mvi a, $3E
	sta DelyCnt

PL2:
	lxi h, ChanA
	shld regIX

	lhld AYREGS+AR_TonA
	call CHREGS
	shld AYREGS+AR_TonA
	lda Ampl
	sta AYREGS+AR_AmplA

	lxi h, ChanB
	shld regIX

	lhld AYREGS+AR_TonB
	call CHREGS
	shld AYREGS+AR_TonB
	lda Ampl
	sta AYREGS+AR_AmplB

	lxi h, ChanC
	shld regIX

	lhld AYREGS+AR_TonC
	call CHREGS
	shld AYREGS+AR_TonC

	lhld Ns_Base_AddToNs
	mov a, h
	add l
	sta AYREGS+AR_Noise

AddToEn: .equ $+1
	mvi a, $3E
	mov e, a
	add a
	sbb a
	mov d, a
	lhld EnvBase
	dad d

	xchg\ lhld CurESld \ xchg

	dad d
	shld AYREGS+AR_Env

	xra a
	lxi h, CurEDel
	ora m
	rz
	dcr m
	rnz
Env_Del:	.equ $+1
	mvi a, $3E
	mov m, a
ESldAdd:	.equ $+1
	lxi h, $2121
	dad d
	shld CurESld
	ret

NT_DATA:
	.db (T_NEW_0-T1_)*2
	.db TCNEW_0-T_
	.db (T_OLD_0-T1_)*2+1
	.db TCOLD_0-T_
	.db (T_NEW_1-T1_)*2+1
	.db TCNEW_1-T_
	.db (T_OLD_1-T1_)*2+1
	.db TCOLD_1-T_
	.db (T_NEW_2-T1_)*2
	.db TCNEW_2-T_
	.db (T_OLD_2-T1_)*2
	.db TCOLD_2-T_
	.db (T_NEW_3-T1_)*2
	.db TCNEW_3-T_
	.db (T_OLD_3-T1_)*2
	.db TCOLD_3-T_

T_:

TCOLD_0:	.db $00+1,$04+1,$08+1,$0A+1,$0C+1,$0E+1,$12+1,$14+1
	.db $18+1,$24+1,$3C+1,0
TCOLD_1:	.db $5C+1,0
TCOLD_2:	.db $30+1,$36+1,$4C+1,$52+1,$5E+1,$70+1,$82,$8C,$9C
	.db $9E,$A0,$A6,$A8,$AA,$AC,$AE,$AE,0
TCNEW_3:	.db $56+1
TCOLD_3:	.db $1E+1,$22+1,$24+1,$28+1,$2C+1,$2E+1,$32+1,$BE+1,0
TCNEW_0:	.db $1C+1,$20+1,$22+1,$26+1,$2A+1,$2C+1,$30+1,$54+1
	.db $BC+1,$BE+1,0
TCNEW_1: .equ TCOLD_1
TCNEW_2:	.db $1A+1,$20+1,$24+1,$28+1,$2A+1,$3A+1,$4C+1,$5E+1
	.db $BA+1,$BC+1,$BE+1,0

EMPTYSAMORN: .equ $-1
	.db 1,0,$90 ;delete $90 if you don't need default sample

;first 12 values of tone tables (packed)

T_PACK:	.db $06EC*2/256,$06EC*2
	.db $0755-$06EC
	.db $07C5-$0755
	.db $083B-$07C5
	.db $08B8-$083B
	.db $093D-$08B8
	.db $09CA-$093D
	.db $0A5F-$09CA
	.db $0AFC-$0A5F
	.db $0BA4-$0AFC
	.db $0C55-$0BA4
	.db $0D10-$0C55
	.db $066D*2/256,$066D*2
	.db $06CF-$066D
	.db $0737-$06CF
	.db $07A4-$0737
	.db $0819-$07A4
	.db $0894-$0819
	.db $0917-$0894
	.db $09A1-$0917
	.db $0A33-$09A1
	.db $0ACF-$0A33
	.db $0B73-$0ACF
	.db $0C22-$0B73
	.db $0CDA-$0C22
	.db $0704*2/256,$0704*2
	.db $076E-$0704
	.db $07E0-$076E
	.db $0858-$07E0
	.db $08D6-$0858
	.db $095C-$08D6
	.db $09EC-$095C
	.db $0A82-$09EC
	.db $0B22-$0A82
	.db $0BCC-$0B22
	.db $0C80-$0BCC
	.db $0D3E-$0C80
	.db $07E0*2/256,$07E0*2
	.db $0858-$07E0
	.db $08E0-$0858
	.db $0960-$08E0
	.db $09F0-$0960
	.db $0A88-$09F0
	.db $0B28-$0A88
	.db $0BD8-$0B28
	.db $0C80-$0BD8
	.db $0D60-$0C80
	.db $0E10-$0D60
	.db $0EF8-$0E10

;vars from here can be stripped
;you can move VARS to any other address

VARS:

;ChannelsVars
;struc	CHNPRM
;reset group
CHNPRM_PsInOr:	.equ 0	;RESB 1
CHNPRM_PsInSm:	.equ 1	;RESB 1
CHNPRM_CrAmSl:	.equ 2	;RESB 1
CHNPRM_CrNsSl:	.equ 3	;RESB 1
CHNPRM_CrEnSl:	.equ 4	;RESB 1
CHNPRM_TSlCnt:	.equ 5	;RESB 1
CHNPRM_CrTnSl:	.equ 6	;RESW 1
CHNPRM_TnAcc:	.equ 8	;RESW 1
CHNPRM_COnOff:	.equ 10	;RESB 1
;reset group

CHNPRM_OnOffD:	.equ 11	;RESB 1

;IX for PTDECOD here (+12)
CHNPRM_OffOnD:	.equ 12	;RESB 1
CHNPRM_OrnPtr:	.equ 13	;RESW 1
CHNPRM_SamPtr:	.equ 15	;RESW 1
CHNPRM_NNtSkp:	.equ 17	;RESB 1
CHNPRM_Note:	.equ 18	;RESB 1
CHNPRM_SlToNt:	.equ 19	;RESB 1
CHNPRM_Env_En:	.equ 20	;RESB 1
CHNPRM_Flags:	.equ 21	;RESB 1
 ;Enabled - 0,SimpleGliss - 2
CHNPRM_TnSlDl:	.equ 22	;RESB 1
CHNPRM_TSlStp:	.equ 23	;RESW 1
CHNPRM_TnDelt:	.equ 25	;RESW 1
CHNPRM_NtSkCn:	.equ 27	;RESB 1
CHNPRM_Volume:	.equ 28	;RESB 1
CHNPRM_Size	.equ 29	;RESB 1
;endstruc

ChanA:	.ds CHNPRM_Size
ChanB:	.ds CHNPRM_Size
ChanC:	.ds CHNPRM_Size

;struc	AR
AR_TonA:	.equ 0	;RESW 1
AR_TonB:	.equ 2	;RESW 1
AR_TonC:	.equ 4	;RESW 1
AR_Noise:	.equ 6	;RESB 1
AR_Mixer:	.equ 7	;RESB 1
AR_AmplA:	.equ 8	;RESB 1
AR_AmplB:	.equ 9	;RESB 1
AR_AmplC:	.equ 10	;RESB 1
AR_Env:	.equ 11	;RESW 1
AR_EnvTp:	.equ 13	;RESB 1
;endstruc

;GlobalVars
DelyCnt:	.db 0
CurESld:	.dw 0
CurEDel:	.db 0
Ns_Base_AddToNs:
Ns_Base:	.db 0
AddToNs:	.db 0

AYREGS:

VT_:	.ds 256 ;CreatedVolumeTableAddress

EnvBase:	.equ VT_+14

T1_:	.equ VT_+16 ;Tone tables data depacked here

T_OLD_1:	.equ T1_
T_OLD_2:	.equ T_OLD_1+24
T_OLD_3:	.equ T_OLD_2+24
T_OLD_0:	.equ T_OLD_3+2
T_NEW_0:	.equ T_OLD_0
T_NEW_1:	.equ T_OLD_1
T_NEW_2:	.equ T_NEW_0+24
T_NEW_3:	.equ T_OLD_3

NT_:	.ds 192 ;CreatedNoteTableAddress

regIX	.dw 0

;local var
Ampl:	.equ AYREGS+AR_AmplC

VAR0END:	.equ VT_+16 ;INIT zeroes from VARS to VAR0END-1

VARSEND: .equ $

MDLADDR: .equ $		;Place your song here.

;Release 0 steps:
;11.Sep.2004 - Note tables creator
;12.Sep.2004 - Volume tables creator; INIT subroutine
;13.Sep.2004 - Play counters, position counters
;14.Sep.2004 - Patterns decoder subroutine
;15.Sep.2004 - Resting (no code)
;16.Sep.2004 - CHREGS subroutine; global debugging; 1st stable
;version was born
;17.Sep.2004 - Debugging and optimization. First release!
;Release 1 steps:
;20.Sep.2004 - local vars moved to code (selfmodified code
;smaller and faster)
;22.Sep.2004 - added mute sound entry at START+8; position
;pointer moved to START+11; added setup and status byte at
;START+10 noloop mode and loop passed flags added
;Release 2 steps:
;28.Sep.2004 - Optimization: code around CHREGS's volume and
;vibrato faster now; zeroing PD_RES through stack; Ton and Ampl
;moved from channel vars to global ones; first position selector
;removed from INIT; optimization for packers(Ivan Roshin method)
;Release 3 steps:
;2.Oct.2004 - optimization in INIT and PD_LOOP (thanks to Ivan
;Roshin)
;4.Oct.2004 - load delay from (hl) in INIT (2 bytes shorter)
;5.Oct.2004 - optimization in PD_LOOP (->PD_LP2)
;7.Oct.2004 - swaping some commands for better packing
;Release 4 steps:
;9.Oct.2004 - optimization around LD HL,SPCCOMS (thanks to Ivan
;Roshin); in PTDECOD swapped BC and DE to optimize C_PORTM;
;removed sam and orn len and loop channel vars; CHREGS totally
;optimized
;Release 5 steps:
;11.Oct.2004 - PD_OrSm and C_PORTM optimized; Ivan Roshin's
;volume tables creator algorithm (51 bytes shorter than mine)
;12.Oct.2004 - Ivan Roshin's note tables creator algorithm (74
;bytes shorter than mine)
;Release 6 steps:
;14.Oct.2004 - loop and next position calculations moved to INIT
;15.Oct.2004 - AdInPt moved to code
;19.Oct.2004 - Env_Del moved to code
;20.Oct.2004 - Version PUSH and POP (1 byte shorter, thanks to
;Ivan Roshin)
;22.Oct.2004 - Env_En moved from Flags' bit to byte (shorter and
;faster code)
;25.Oct.2004 - SETENV optimized
;29.Oct.2004 - Optimized around AddToEn (SBC A,A, thanks to Ivan
;Roshin)
;3.Nov.2004 - Note tables data was compressed; with depacker it
;is 9 bytes shorter than uncompressed (thanks to Ivan Roshin)
;4.Nov.2004 - default sample and ornament both are fixed now
;and placed into code block (6 bytes shorter)
;7.Nov.2004 - LD A,(Ns_Base):LD L,A changed to LD HL,(Ns_Base)
;(thanks to Dima Bystrov)
;9.Nov.2004 - Ns_Base and AddToNs are merged to Ns_Base_AddToNs;
;LD A,255 changed to DEC A (at start of PLAY); added ROUT_A0
;12.Nov.2004 - NtSkCn&Volume are merged (8 bytes smaller init);
;LD BC,T1_ changed to PUSH DE...POP BC in note table creator
;19.Dec.2004 - NT_DATA reorganized (6 bytes shorter, thanks to
;Ivan Roshin); C_PORTM and C_GLISS are merged via SET_STP (48
;tacts slower, but 8 bytes smaller, thanks to Ivan Roshin)
;09.Jan.2005 - Adapted to MSX by Alfonso D.C. a.k.a. Dioniso

;Notes:
;Pro Tracker 3.4r can not be detected by header, so PT3.4r tone
;tables realy used only for modules of 3.3 and older versions.
