; -----------------------------------------------------------------------------
; ZX02 8080 decoder by Ivan Gorodetsky
; Based on ZX0 z80 decoder by Einar Saukas and ZX02 6502 decoder by DMSC
; v1 (2025-08-25) - 86 bytes forward / 85 bytes backward
; v2 (2025-08-28) - 85 bytes forward / 84 bytes backward (bug fix, -1 byte and slightly faster)
; v3 (2025-08-30) - 85 bytes forward / 84 bytes backward (1% faster)
; -----------------------------------------------------------------------------
; Parameters (forward):
;   HL: source address (compressed data)
;   BC: destination address (decompressing)
;
; Parameters (backward):
;   HL: last source address (compressed data)
;   BC: last destination address (decompressing)
; -----------------------------------------------------------------------------
;
; compress backward with -b option
;
; Compile with The Telemark Assembler (TASM) 3.2
; ----------------------------------------------------------------------------- 

;#define BACKWARD

#ifdef BACKWARD
#define NEXT_HL dcx h
#define NEXT_BC dcx b
#else
#define NEXT_HL inx h
#define NEXT_BC inx b
#endif


dzx02:
#ifdef BACKWARD
		lxi d,0000h
		push d
		mvi e,80h
#else
		lxi d,0FFFFh
		push d
		lxi d,0080h
#endif

dzx02_decode_literal:
		call dzx02_get_elias
		call dzx02_ldir
		jc dzx02_new_offset
		call dzx02_get_elias
dzx02_copy:
		xthl
		push h
#ifdef BACKWARD
		inx h
#endif
		dad b
		call dzx02_ldir
		pop h
		xthl
		jnc dzx02_decode_literal
dzx02_new_offset:
		call dzx02_get_elias
		pop psw
		xra a
#ifdef BACKWARD
		ora d
		rz
		dcr a
		rar
#else
		sub d
		rz
		rar
		cmc
#endif
		push psw
		mov a,m
		NEXT_HL
		rar
#ifndef BACKWARD
		cma
#endif
		inx sp
		push psw
		inx sp
		mvi d,1
		mov a,e
		cc dzx02_elias_get
		inr d
		jmp dzx02_copy
dzx02_get_elias:
		inr d
dzx02_get_elias_:
		mov a,e\ add a
		jnz dzx02_elias_skip
		mov a,m
		NEXT_HL
		ral
dzx02_elias_skip:
		mov e,a
		rnc
dzx02_elias_get:
		xchg\ dad h\ xchg
		jmp dzx02_get_elias_

dzx02_ldir:
		add a\ mov e,a
dzx02_ldir_loop:
		mov a,m
		stax b
		NEXT_HL
		NEXT_BC
		dcr d
		jnz dzx02_ldir_loop
		ret
		
		.end