; -----------------------------------------------------------------------------
; ZX02 (with <-1> option) 8080 decoder by Ivan Gorodetsky
; Based on ZX102 6502 decoder by DMSC and ZX0 z80 decoder by Einar Saukas
; v1 (2025-08-30):	reusable 95 bytes forward / 94 bytes backward;
;					single-use 88 bytes forward / 87 bytes backward
; -----------------------------------------------------------------------------
; Parameters (forward reusable):
;   DE: source address (compressed data)
;   BC: destination address (decompressing)
;
; Parameters (backward reusable):
;   DE: last source address (compressed data)
;   BC: last destination address (decompressing)
; -----------------------------------------------------------------------------
; Parameters (forward single-use):
;   HL: source address (compressed data)
;   BC: destination address (decompressing)
;
; Parameters (backward single-use):
;   HL: last source address (compressed data)
;   BC: last destination address (decompressing)
; -----------------------------------------------------------------------------
; compress forward with <-1> option
;
; compress backward with <-1 -b> options
;
; Compile with The Telemark Assembler (TASM) 3.2
; ----------------------------------------------------------------------------- 

#define REUSABLE
;#define BACKWARD

#ifdef BACKWARD
#define NEXT_HL dcx h
#define NEXT_BC dcx b
#else
#define NEXT_HL inx h
#define NEXT_BC inx b
#endif


dzx12:
#ifdef REUSABLE
#ifdef BACKWARD
		lxi h,0000h
#else
		lxi h,0FFFFh
#endif
		shld dzx12_offset
		xchg
#endif
		mvi e,80h
dzx12_decode_literal:
		call dzx12_get_elias
		add a\ mov e,a
		mov a,m
		stax b
		NEXT_HL
		NEXT_BC
		dcr d
		jnz $-5
		jc dzx12_new_offset
		call dzx12_get_elias
dzx12_copy:
		push h
dzx12_offset	.equ $+1
#ifdef BACKWARD
		lxi h,0000h
		inx h
#else
		lxi h,0FFFFh
#endif
		dad b
		add a\ mov e,a
		mov a,m
		stax b
		NEXT_HL
		NEXT_BC
		dcr d
		jnz $-5
		pop h
		jnc dzx12_decode_literal
dzx12_new_offset:
#ifdef BACKWARD
		xra a
		sta dzx12_offset+1
		ora m
		NEXT_HL
		rar
		jnc dzx12_offset_ok
		cpi 127
		rz
		sta dzx12_offset+1
		mov a,m
#else		
		mvi a,0FFh
		sta dzx12_offset+1
		ana m
		NEXT_HL
		rar
		cma
		jnc dzx12_offset_ok
		sta dzx12_offset+1
		add a
		rz
		mov a,m
		cma
#endif
		NEXT_HL
dzx12_offset_ok:
		sta dzx12_offset
		call dzx12_get_elias
		inr d
		jmp dzx12_copy
dzx12_get_elias:
		mvi d,1
dzx12_get_elias_:
		mov a,e\ add a
		jnz dzx12_elias_skip1
		mov a,m
		NEXT_HL
		ral
dzx12_elias_skip1:
		rnc
		mov e,a
dzx12_elias_get:
		xchg\ dad h\ xchg
		jmp dzx12_get_elias_

		
		.end