; -----------------------------------------------------------------------------
; ZX02 (with <-1> option) 8080 decoder by Ivan Gorodetsky
; Based on ZX102 6502 decoder by DMSC and ZX0 z80 decoder by Einar Saukas
; v1 (2025-08-30):	reusable 95 bytes forward
; -----------------------------------------------------------------------------
; Parameters (forward reusable):
;   DE: source address (compressed data)
;   BC: destination address (decompressing)
; -----------------------------------------------------------------------------
; compress forward with -1 option
;
; Compile with The Telemark Assembler (TASM) 3.2 or Pretty 8080 Assembler (svofski)
; ----------------------------------------------------------------------------- 

dzx12:
		lxi h,0FFFFh
		shld dzx12_offset
		xchg
		mvi e,80h
dzx12_decode_literal:
		call dzx12_get_elias
		add a
		mov e,a
		mov a,m
		stax b
		inx h
		inx b
		dcr d
		jnz $-5
		jc dzx12_new_offset
		call dzx12_get_elias
dzx12_copy:
		push h
dzx12_offset	.equ $+1
		lxi h,0FFFFh
		dad b
		add a
		mov e,a
		mov a,m
		stax b
		inx h
		inx b
		dcr d
		jnz $-5
		pop h
		jnc dzx12_decode_literal
dzx12_new_offset:
		mvi a,0FFh
		sta dzx12_offset+1
		ana m
		inx h
		rar
		cma
		jnc dzx12_offset_ok
		sta dzx12_offset+1
		add a
		rz
		mov a,m
		cma
		inx h
dzx12_offset_ok:
		sta dzx12_offset
		call dzx12_get_elias
		inr d
		jmp dzx12_copy
dzx12_get_elias:
		mvi d,1
dzx12_get_elias_:
		mov a,e
		add a
		jnz dzx12_elias_skip1
		mov a,m
		inx h
		ral
dzx12_elias_skip1:
		rnc
		mov e,a
dzx12_elias_get:
		xchg
		dad h
		xchg
		jmp dzx12_get_elias_

		
		.end