                ; i8080 assembler code
                .project marktest.rk
                .tape rk-bin


                ORIGIN          equ $0000               ;  

                ;###############
                ;##  ##
                ;###############

                KR580VG75       equ $C000
                KR580VT57       equ $E008
                KR580VV55_KBD   equ $8000

                COLS		equ 78
                ROWS		equ 30

                ROM             equ $F800

                MARGIN_TOP      equ 4
                MARGIN_LEFT     equ 9

                ; 
                DISPLAY_78X30   equ (ROWS - 1 + $40) << 8 | (COLS - 1)
                GRAPH_78X30     equ $D8FF
                DMA_SIZE_78X30  equ COLS * ROWS - 1

                DMA_SIZE        equ DMA_SIZE_78X30

                org ORIGIN

                JMP START

                ;################
                ;##  ##
                ;################

                ;  
                CLOCK:          db $00
                CARRIAGE        dw $0000
                CARRIAGE_ADDR   dw SCREEN
                MARKS_CPU       dw $0000
                MARKS_DMA       dw $0000
                TMP             dw $0000
                TMP_STR         dw $0000,  $0000,  $0000


        SET_DISPLAY: ;  75
        
                ; DE -   
                ; BC -    

		;  58075
		LXI H, KR580VG75 + 1


		;  

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		;  58075

		INR L
		MVI M, 0
		DCR L

        	MOV M, E	; 
        	MOV M, D	; 
        	MOV M, C	;    -   
        	MOV M, B	; 0101.0011
        	
 		;  58075

		INR L
        	MVI M, $27

		RET

		
        SET_DMA: ;  

                ; DE -  
                ; BC -  
                
                LXI H, KR580VT57
		MVI M, $80
		MVI L, $04
		MOV M, E
		MOV M, D

		INR L
		MOV M, C
		MOV M, B
		MVI L, 8
		MVI M, $A4

                RET


        VG75_READY: ;   

                LXI H, KR580VG75 + 1
		MOV A, M
		MOV A, M \\ ANI $20 \\ JZ . - 3
                RET            


        VG75_INIT: ;  

                ;  
                LXI D, $0000
                LXI B, COLS * ROWS / 2
                CALL FILL_SCREEN

                ;  
                LXI H, SCREEN + COLS - MARGIN_LEFT
                LXI B, COLS
                MVI A, ROWS
                
                LOOP_SETSCR:
        
                MVI M, $F1
                CPI MARGIN_TOP \\ JNZ . + 5 \\ MVI M, $F3
                DAD B
                DCR A
                JNZ LOOP_SETSCR

                ;  
                LXI D, DISPLAY_78X30
                LXI B, GRAPH_78X30
                CALL SET_DISPLAY
                
                CALL VG75_READY
                
                ;                  
                LXI D, SCREEN
		MVI C, DMA_SIZE_78X30 & $00FF
		MVI B, ($4000 + DMA_SIZE_78X30) >> 8
                CALL SET_DMA

                LXI H, $0000
                CALL CARRIAGE_SET

                RET            


        FILL_SCREEN: ;   
        
                ; DE -  
                ; BC -   / 2
                
                ;                  
                LXI H, $0000
                DAD SP
                
                LXI SP, SCREEN + COLS * ROWS
                
                PUSH D \\ DCX B
                MOV A, C \\ ORA B \\ JNZ . - 4

                SPHL

                RET

                
        BEEP:
        
                MOV A, B
                
                BEEP_LOP:
                
                EI \\ MOV B, C \\ DCR B \\ JNZ . - 1
                DI \\ MOV B, C \\ DCR B \\ JNZ . - 1
                
                DCR A \\ JNZ BEEP_LOP

                RET


                ;##################################
                ;##     ##
                ;##################################


        PRINT_TEXT:

                ; HL -  

                XCHG

                PRINT_TEXT_LOOP:

		LDAX D

                ;   ($00)
		CODE_00:
		ANA A \\ RZ

                ;  ($09)
		CODE_09:
		CPI $09 \\ JNZ CODE_0A
		LHLD CARRIAGE
		MOV A, L
		ORI 00000111B
		INR A
		MOV L, A
		SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                ;   ($0A)
		CODE_0A:
		CPI $0A \\ JNZ CODE_0D
		LHLD CARRIAGE \\ INR H \\ SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                ;   ($0D)
		CODE_0D:
		CPI $0D \\ JNZ PRINT_TEXT_CHAR
		LHLD CARRIAGE \\ MVI L, $00 \\ SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                PRINT_TEXT_CHAR:

		LHLD CARRIAGE_ADDR
		
		;  
		ADI 0 \\ JP . + 5 \\ MVI A, '.'

		;  
		MOV M, A
		
        	LXI H, CARRIAGE \\ INR M

		PRINT_TEXT_SKIP:
		
		LHLD CARRIAGE
		PUSH D \\ CALL CARRIAGE_SET \\ POP D
		INX D

		JMP PRINT_TEXT_LOOP
		
		RET

                
        PRINT_DEC:

                LXI B, TMP_STR
                
                MVI A, $2F
                
                PRINT_DEC_11:	
                
                XCHG
        	INR A
        	LXI H, $D8F0
        	DAD D
        	JC PRINT_DEC_11
        	
        	XCHG
        	STAX B
        	INX B
        	CALL PRINT_DEC_12
        	
                PRINT_DEC_12:
                
                CALL PRINT_DEC_13
                PRINT_DEC_13: 
                MVI A, $2F
        
                PRINT_DEC_14:	
                XCHG
        	INR	A
        	LXI	H, $FC18
        	DAD	D
        	JC	PRINT_DEC_14
        	STAX	B
        	INX	B
        	MOV	L,E
        	MOV	H,D
        	DAD	H
        	DAD	H
        	DAD	D
        	DAD	H
        	RET      


        CARRIAGE_SET:
        
                ; H - 
                ; L -   
                
                MOV A, L \\ CPI 64 \\ JC . + 06 \\ ANI 00111111B \\ INR H \\ MOV L, A
                MOV A, H \\ ANI 00011111B \\ MOV H, A

                SHLD CARRIAGE

                XCHG
                LXI H, SCREEN
                LXI B, COLS
                
                XRA A
                
                GET_ADDR_LOOP:
                
                CMP D \\ JZ GET_ADDR_SKIP
                DAD B \\ DCR D
                JMP GET_ADDR_LOOP
                
                GET_ADDR_SKIP:
                
                MOV C, E \\ DAD B
                
                SHLD CARRIAGE_ADDR

                RET


        TEST_RAM_4K:
        
                ; HL -    
                ; DE -   

                TEST_RAM_4K_LOOP:

                MOV A, M \\ MVI M, $00 \\ MOV M, A
                CMP M \\ JNZ TEST_RAM_4K_ERROR

                INX H
                
                XRA A
                CMP L
                JNZ TEST_RAM_4K_LOOP
                
                MOV A, H
                ANI 00001111B
                ANA A
                JNZ TEST_RAM_4K_LOOP

                ;   2                
                LDA KR580VV55_KBD + 1
                CPI 11111011b
                JZ TEST_RAM_4K_ERROR

                MVI A, $7F
                STAX D
                INX D

                MVI A, $80
                CMP H
                JNZ TEST_RAM_4K_LOOP
                
                RET
                
                TEST_RAM_4K_ERROR:

                STC
                
                RET


        TEST_MARKS:

		;      
		; 5 + 7 + 7 + 10
		
		CALL VG75_READY

                LXI D, $0000
                LXI H, KR580VG75 + 1
		MOV A, M
		INX D \\ MOV A, M \\ ANI $20 \\ JZ . - 4
		XCHG
                RET
                
                
        DRAW:
        
                LXI D, $0000
                LXI H, TMP_STR + 1
                MOV A, M \\ SUI $30
                ANA A
                JZ DRAW_LOOP_02
                
                MOV B, A
                MVI A, $7F
                LHLD CARRIAGE_ADDR

                DRAW_LOOP_01:
                
                MVI C, 10
                MOV M, A \\ INX H \\ INX D \\ DCR C \\ JNZ . - 4
                DCR B
                JNZ DRAW_LOOP_01

                DRAW_LOOP_02:

                LXI H, TMP_STR + 2
                MOV A, M \\ SUI $30
                ANA A
                JZ DRAW_CARRIAGE

                MOV C, A
                MVI A, $7F
                LHLD CARRIAGE_ADDR
                DAD D

                MOV M, A \\ INX H \\ INX D \\ DCR C \\ JNZ . - 4
                
                DRAW_CARRIAGE:

                LHLD CARRIAGE
                MOV A, E \\ ADD L \\ MOV L, A
		CALL CARRIAGE_SET
                

                RET
                
                
        LEAD_ZERO:
        
                MVI A, $30
                
                LEAD_ZERO_LOOP:
                
                LXI H, TMP_STR \\ CMP M \\ RNZ
                
                LHLD TMP_STR + 1 \\ SHLD TMP_STR
                LHLD TMP_STR + 3 \\ SHLD TMP_STR + 2
                LHLD TMP_STR + 5 \\ SHLD TMP_STR + 4
                LXI H, TMP_STR + 5 \\ MVI M, $00

                JMP LEAD_ZERO_LOOP

                RET


        START: 

                ;###########################
                ;##    ##
                ;###########################

                ;  
                MVI A, $20 \\ STA KR580VG75 + 1
                MVI A, $80 \\ STA KR580VT57

                ;  
                LXI B, $8040 \\ CALL BEEP

                CALL TEST_MARKS
                SHLD MARKS_CPU
                
                ;  
                CALL VG75_INIT

                ;   
                LXI H, TXT_TITLE \\ CALL PRINT_TEXT
                
                ;  
                LHLD CARRIAGE_ADDR
                LXI D, $0000 - COLS * 2 + 20
                DAD D
                XCHG
                LXI H, SCREEN + DMA_SIZE
                
                CALL TEST_RAM_4K
                
                ;      ,   2
                ;JC MAIN

                RAM_OK:
                
                ;  
                LXI H, TXT_TABLE_HEAD \\ CALL PRINT_TEXT
                
                ;    
                LHLD MARKS_CPU \\ CALL PRINT_DEC
                CALL DRAW \\ LHLD CARRIAGE \\ INR L \\ CALL CARRIAGE_SET

                CALL LEAD_ZERO \\ LXI H, TMP_STR \\ CALL PRINT_TEXT

                CALL TEST_MARKS \\ SHLD MARKS_DMA

                LXI H, TXT_EOL \\ CALL PRINT_TEXT
                
                ;    
                LHLD MARKS_DMA \\ CALL PRINT_DEC
                CALL DRAW \\ LHLD CARRIAGE \\ INR L \\ CALL CARRIAGE_SET

                CALL LEAD_ZERO \\ LXI H, TMP_STR \\ CALL PRINT_TEXT
                
                LXI H, TXT_PDP \\ CALL PRINT_TEXT
                
                ;  
                LHLD MARKS_DMA
                XCHG
                LHLD MARKS_CPU

                MOV A, E \\ CMA \\ MOV E, A
                MOV A, D \\ CMA \\ MOV D, A
                DAD D
                
                ; X10
                PUSH H \\ POP D
                
                DAD H
                DAD H
                DAD H
                DAD D
                DAD D
                
                ; X10
                PUSH H \\ POP D
                
                DAD H
                DAD H
                DAD H
                DAD D
                DAD D
                
                XCHG \\ LHLD MARKS_CPU \\ XCHG
                MOV A, E \\ CMA \\ MOV E, A
                MOV A, D \\ CMA \\ MOV D, A
                
                XRA A
                MOV C, A
                
                DIV_LOOP:
                
                INR C
                DAD D
                MOV A, H
                CMP D
                
                JC DIV_LOOP
                
                MVI H, $00
                MOV L, C
                
                ;  
                CALL PRINT_DEC \\ CALL LEAD_ZERO
                LHLD CARRIAGE \\ DCR L \\ DCR L \\ DCR L \\ DCR L \\ CALL CARRIAGE_SET                
                LXI H, TMP_STR \\ CALL PRINT_TEXT
                
                LXI H, TXT_NOTES \\ CALL PRINT_TEXT
                
		;  
		LXI H, KR580VG75 + 1
        	MVI M, $80
		DCR L
		MVI M, $42
		MVI M, $18

                

MAIN:

                ;######################
                ;## - ##
                ;######################

		;      
		CALL VG75_READY

		;  
		LXI H, CLOCK \\ INR M
		
		; X1
		CALL X1

                ; X2 FLIP
		LDA CLOCK
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA CLOCK
		ANI 1
		CNZ X2_

                ; X4
		LDA CLOCK
 		ANI 3
		CZ X4

                JMP MAIN

X1:

		;  
                LXI H, KR580VV55_KBD
                MVI M, 11111110b

		; 
                LDA KR580VV55_KBD + 1
                CPI 11111011b
                JZ ROM


                RET

X2:


		RET

X2_:


                RET

X4:


		RET

TXT_TITLE:      db $20, $04, $11, "radio-86rk kompx`ter radiol`bitelq", $0A, $0D
                db $04, $17, $11, "prowerka proizwoditelxnosti V3.78 / 2024 - 2026 SYNDICATE", $0A, $0A, $0D
                db "prowerka ozu (ar2): ", "********", " 0000 - 7FFF", $0A, $0A, $0D, $00

TXT_EOL:        db $0A, $0D, $00
TXT_TAB:        db $09, $09, $00

TXT_ERROR:      db "* o{ibka *", $0A, $0A, $0D, $00

TXT_TABLE_HEAD: db $0A
                db "radio-86rk: 78X30X10 / 50gc", $09, $09, $09, $09, "-->_", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, " 1224", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, " 899 (pdp 27%)", $0A, $0A, $0A, $0D

                db "partner-01.01: 78X30X10 / 50gc", $09, $09, $09, $09, ":->_", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F,  " 1396", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, " 968 (pdp 31%)", $0A, $0A, $0A, $0D

                db "sewernaq palxmira: 78X30X16 / 60gc (VGA)", $09, $09, ".48_", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, " 1004", $0A, $0D
                db $7F, $7F, $7F, $7F, $7F, $7F, " 675 (pdp 33%)", $0A, $0A, $0A, $0D

                db "wa{a p|wm: 78X30X16 / 60gc (VGA)", $09, $09, $09, ":-?", $0A, $0D
                db $00
                
TXT_NOTES:      db $0A, $0A, $0D, "* odna edinica = 29 taktow mikroprocessora kr580wm80a ", $00
                
TXT_PDP:        db " (pdp 00%)", $00


SCREEN:           
