; ---------------------------------------------------------------------------
; kbd.snc — Argo ZX hardware service (ULA replacement)
;
; This code is loaded by zx.com into RAM and then mapped to CPU address 0000h.
; It remains resident while the ZX Spectrum ROM (ROM.SNC) is executing.
;
; Purpose:
;   • Emulate essential ZX ULA functionality on Argo hardware
;   • Provide a ZX-compatible keyboard interface using the host keyboard
;   • Configure and maintain CRT and DMA so ZX screen memory is continuously
;     fetched and displayed
;
; Key features:
;   • Installs an NMI handler at 0066h
;   • Periodically scans the host keyboard via port A1h
;   • Maintains a ZX-compatible key matrix for the ROM
;   • Programs CRT (ports C0h/C4h) and DMA (ports E4h/E5h/E8h)
;   • Controls memory paging and ZX video mode via memcfg ports (A1h/B1h/B9h)
;
; The original ZX ROM assumes a hardware ULA is always present and therefore
; does not initialize video or keyboard hardware. This module provides that
; missing hardware layer so the unmodified ZX ROM can run correctly.
; ---------------------------------------------------------------------------


; kbd.snc — annotated disassembly for Argo ZX keyboard service
; Loaded by zx.com into 4000h, then a memcfg mode maps that page at CPU 0000h.
;
; Hardware I/O (per Argo config):
;   IN  (A1h)   = keyboard data (kbd.~idata)
;   OUT (A1h)   = memcfg offset 0 (paging / zxmode/font/timer page via reg1 bit7 + amm.memcfg)
;   OUT (A9h)   = memcfg offset 1
;   OUT (B1h)   = memcfg offset 2
;   OUT (B9h)   = memcfg offset 3
;   OUT (81h)   = casctl (tape control)
;   IN  (81h)   = amm.nmi.code
;
; Key idea: installs/uses an NMI handler at 0066h to poll the host keyboard and
; present ZX-Spectrum-compatible key state for ROM.SNC.
;
        ORG 0000h

; kbd.snc - Argo ZX keyboard service/NMI helper
; Key idea: NMI vector (0066h) polls the host keyboard matrix (port A1h) and
; updates a ZX-Spectrum-compatible key matrix that the Spectrum ROM can read.
L0000:
0000:   C3 BE 01     JP L01BE
0003:   00           NOP
0004:   00           NOP
0005:   00           NOP
0006:   00           NOP
0007:   00           NOP
0008:   00           NOP
0009:   00           NOP
000A:   00           NOP
000B:   00           NOP
000C:   00           NOP
000D:   00           NOP
000E:   00           NOP
000F:   00           NOP
0010:   00           NOP
0011:   00           NOP
0012:   00           NOP
0013:   00           NOP
0014:   00           NOP
0015:   00           NOP
0016:   00           NOP
0017:   00           NOP
0018:   00           NOP
0019:   00           NOP
001A:   00           NOP
001B:   00           NOP
001C:   00           NOP
001D:   00           NOP
001E:   00           NOP
001F:   00           NOP
0020:   00           NOP
0021:   00           NOP
0022:   00           NOP
0023:   00           NOP
0024:   00           NOP
0025:   00           NOP
0026:   00           NOP
0027:   00           NOP
0028:   00           NOP
0029:   00           NOP
002A:   00           NOP
002B:   00           NOP
002C:   00           NOP
002D:   00           NOP
002E:   00           NOP
002F:   00           NOP
0030:   00           NOP
0031:   00           NOP
0032:   00           NOP
0033:   00           NOP
0034:   00           NOP
0035:   00           NOP
0036:   18 C8        JR L0000
L0038:
0038:   C9           RET
0039:   00           NOP
003A:   00           NOP
003B:   00           NOP
003C:   00           NOP
003D:   00           NOP
003E:   00           NOP
003F:   00           NOP
0040:   00           NOP
0041:   00           NOP
0042:   00           NOP
0043:   00           NOP
0044:   00           NOP
0045:   00           NOP
0046:   FF           RST 38h
0047:   00           NOP
0048:   00           NOP
0049:   00           NOP
004A:   00           NOP
004B:   00           NOP
004C:   00           NOP
004D:   00           NOP
004E:   00           NOP
004F:   00           NOP
0050:   00           NOP
0051:   00           NOP
0052:   00           NOP
0053:   00           NOP
0054:   00           NOP
0055:   00           NOP
0056:   00           NOP
0057:   00           NOP
0058:   00           NOP
0059:   00           NOP
005A:   00           NOP
005B:   00           NOP
005C:   00           NOP
005D:   00           NOP
005E:   00           NOP
005F:   00           NOP
0060:   00           NOP
0061:   00           NOP
0062:   00           NOP
0063:   00           NOP
0064:   00           NOP
0065:   00           NOP
L0066:
0066:   22 3C 00     LD (003Ch),HL ; save_hl
0069:   EB           EX DE,HL
006A:   22 3E 00     LD (003Eh),HL ; save_de
006D:   21 00 00     LD HL,0000h
0070:   39           ADD HL,SP
0071:   22 44 00     LD (0044h),HL ; save_sp
0074:   21 65 00     LD HL,0065h
0077:   F9           LD SP,HL
0078:   C5           PUSH BC
0079:   E1           POP HL
007A:   22 40 00     LD (0040h),HL ; save_bc
007D:   F5           PUSH AF
007E:   E1           POP HL
007F:   22 42 00     LD (0042h),HL ; save_af
0082:   3E FF        LD A,FFh
0084:   32 3B 00     LD (003Bh),A ; kbd_last
0087:   67           LD H,A
0088:   6F           LD L,A
0089:   3A 46 00     LD A,(0046h) ; kbd_debounce
008C:   B7           OR A
008D:   20 0A        JR NZ,L0099
008F:   01 A1 07     LD BC,07A1h
0092:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0094:   F6 DF        OR DFh
0096:   BC           CP H
0097:   28 12        JR Z,L00AB
L0099:
0099:   3E 20        LD A,20h
009B:   D3 81        OUT (81h),A ; OUT: casctl (81h wo=tape control) or NMI-trap side effects
L009D:
009D:   3D           DEC A
009E:   20 FD        JR NZ,L009D
00A0:   D3 81        OUT (81h),A ; OUT: casctl (81h wo=tape control) or NMI-trap side effects
00A2:   32 39 00     LD (0039h),A ; kbd_state
00A5:   32 46 00     LD (0046h),A ; kbd_debounce
00A8:   C3 40 01     JP L0140
L00AB:
00AB:   01 A1 07     LD BC,07A1h
00AE:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
00B0:   F6 BF        OR BFh
00B2:   BC           CP H
00B3:   28 15        JR Z,L00CA
00B5:   3A 39 00     LD A,(0039h) ; kbd_state
00B8:   B7           OR A
00B9:   C2 40 01     JP NZ,L0140
00BC:   3E 04        LD A,04h
00BE:   32 39 00     LD (0039h),A ; kbd_state
00C1:   32 46 00     LD (0046h),A ; kbd_debounce
00C4:   D3 81        OUT (81h),A ; OUT: casctl (81h wo=tape control) or NMI-trap side effects
00C6:   D3 A0        OUT (A0h),A ; OUT: timer channel 0 (A0h)
00C8:   18 76        JR L0140
L00CA:
00CA:   01 A1 09     LD BC,09A1h
00CD:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
00CF:   F6 EF        OR EFh
00D1:   BC           CP H
00D2:   28 0F        JR Z,L00E3
00D4:   3A 39 00     LD A,(0039h) ; kbd_state
00D7:   B7           OR A
00D8:   20 66        JR NZ,L0140
00DA:   3E 08        LD A,08h
00DC:   32 39 00     LD (0039h),A ; kbd_state
00DF:   D3 81        OUT (81h),A ; OUT: casctl (81h wo=tape control) or NMI-trap side effects
00E1:   18 5D        JR L0140
L00E3:
00E3:   01 A1 06     LD BC,06A1h
00E6:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
00E8:   F6 DF        OR DFh
00EA:   BC           CP H
00EB:   28 0F        JR Z,L00FC
00ED:   3A 39 00     LD A,(0039h) ; kbd_state
00F0:   B7           OR A
00F1:   20 4D        JR NZ,L0140
00F3:   3E 10        LD A,10h
00F5:   32 39 00     LD (0039h),A ; kbd_state
00F8:   D3 81        OUT (81h),A ; OUT: casctl (81h wo=tape control) or NMI-trap side effects
00FA:   18 44        JR L0140
L00FC:
00FC:   01 A1 04     LD BC,04A1h
00FF:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0101:   F6 BF        OR BFh
0103:   BC           CP H
0104:   C2 17 05     JP NZ,L0517
0107:   01 A1 04     LD BC,04A1h
010A:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
010C:   F6 7F        OR 7Fh
010E:   BC           CP H
010F:   C2 BE 01     JP NZ,L01BE
0112:   01 A1 05     LD BC,05A1h
0115:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0117:   F6 DF        OR DFh
0119:   BC           CP H
011A:   28 02        JR Z,L011E
011C:   2E FE        LD L,FEh
L011E:
011E:   DB 81        IN A,(81h) ; IN: NMI status/code? (port 81h ro=amm.nmi.code)
0120:   FE DB        CP DBh
0122:   28 33        JR Z,L0157
0124:   FE 78        CP 78h
0126:   28 2F        JR Z,L0157
0128:   FE 40        CP 40h
012A:   28 56        JR Z,L0182
012C:   FE 48        CP 48h
012E:   28 5C        JR Z,L018C
0130:   FE 50        CP 50h
0132:   28 62        JR Z,L0196
0134:   FE 58        CP 58h
0136:   28 68        JR Z,L01A0
0138:   FE 60        CP 60h
013A:   28 6E        JR Z,L01AA
013C:   FE 68        CP 68h
013E:   28 74        JR Z,L01B4
L0140:
0140:   2A 42 00     LD HL,(0042h) ; save_af
0143:   26 FF        LD H,FFh
0145:   E5           PUSH HL
0146:   F1           POP AF
0147:   2A 40 00     LD HL,(0040h) ; save_bc
014A:   E5           PUSH HL
014B:   C1           POP BC
014C:   2A 3E 00     LD HL,(003Eh) ; save_de
014F:   EB           EX DE,HL
0150:   2A 44 00     LD HL,(0044h) ; save_sp
0153:   F9           LD SP,HL
0154:   C3 10 05     JP L0510
L0157:
0157:   3E 01        LD A,01h
0159:   32 3A 00     LD (003Ah),A
015C:   3A 43 00     LD A,(0043h)
L015F:
015F:   07           RLCA
0160:   D4 C9 01     CALL NC,L01C9
0163:   07           RLCA
0164:   D4 32 02     CALL NC,L0232
0167:   07           RLCA
0168:   D4 8C 02     CALL NC,L028C
016B:   07           RLCA
016C:   D4 E8 02     CALL NC,L02E8
016F:   07           RLCA
0170:   D4 44 03     CALL NC,L0344
0173:   07           RLCA
0174:   D4 A0 03     CALL NC,L03A0
0177:   07           RLCA
0178:   D4 FC 03     CALL NC,L03FC
017B:   07           RLCA
017C:   D4 58 04     CALL NC,L0458
017F:   C3 B3 04     JP L04B3
L0182:
0182:   3E 02        LD A,02h
0184:   32 3A 00     LD (003Ah),A
0187:   3A 41 00     LD A,(0041h)
018A:   18 D3        JR L015F
L018C:
018C:   3E 03        LD A,03h
018E:   32 3A 00     LD (003Ah),A
0191:   3A 40 00     LD A,(0040h) ; save_bc
0194:   18 C9        JR L015F
L0196:
0196:   3E 04        LD A,04h
0198:   32 3A 00     LD (003Ah),A
019B:   3A 3F 00     LD A,(003Fh)
019E:   18 BF        JR L015F
L01A0:
01A0:   3E 05        LD A,05h
01A2:   32 3A 00     LD (003Ah),A
01A5:   3A 3E 00     LD A,(003Eh) ; save_de
01A8:   18 B5        JR L015F
L01AA:
01AA:   3E 06        LD A,06h
01AC:   32 3A 00     LD (003Ah),A
01AF:   3A 3D 00     LD A,(003Dh)
01B2:   18 AB        JR L015F
L01B4:
01B4:   3E 07        LD A,07h
01B6:   32 3A 00     LD (003Ah),A
01B9:   3A 3C 00     LD A,(003Ch) ; save_hl
01BC:   18 A1        JR L015F
L01BE:
01BE:   2A 44 00     LD HL,(0044h) ; save_sp
01C1:   F9           LD SP,HL
01C2:   21 00 00     LD HL,0000h
01C5:   E5           PUSH HL
01C6:   C3 13 05     JP L0513
L01C9:
01C9:   57           LD D,A
01CA:   01 A1 06     LD BC,06A1h
01CD:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
01CF:   F6 F7        OR F7h
01D1:   BC           CP H
01D2:   28 08        JR Z,L01DC
01D4:   3A 3B 00     LD A,(003Bh) ; kbd_last
01D7:   E6 EF        AND EFh
01D9:   32 3B 00     LD (003Bh),A ; kbd_last
L01DC:
01DC:   01 A1 07     LD BC,07A1h
01DF:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
01E1:   F6 EF        OR EFh
01E3:   BC           CP H
01E4:   28 08        JR Z,L01EE
01E6:   3A 3B 00     LD A,(003Bh) ; kbd_last
01E9:   E6 F7        AND F7h
01EB:   32 3B 00     LD (003Bh),A ; kbd_last
L01EE:
01EE:   01 A1 08     LD BC,08A1h
01F1:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
01F3:   F6 EF        OR EFh
01F5:   BC           CP H
01F6:   28 08        JR Z,L0200
01F8:   3A 3B 00     LD A,(003Bh) ; kbd_last
01FB:   E6 FB        AND FBh
01FD:   32 3B 00     LD (003Bh),A ; kbd_last
L0200:
0200:   01 A1 09     LD BC,09A1h
0203:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0205:   F6 F7        OR F7h
0207:   BC           CP H
0208:   28 08        JR Z,L0212
020A:   3A 3B 00     LD A,(003Bh) ; kbd_last
020D:   E6 FD        AND FDh
020F:   32 3B 00     LD (003Bh),A ; kbd_last
L0212:
0212:   01 A1 06     LD BC,06A1h
0215:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0217:   F6 EF        OR EFh
0219:   BC           CP H
021A:   28 02        JR Z,L021E
021C:   18 0A        JR L0228
L021E:
021E:   01 A1 0A     LD BC,0AA1h
0221:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0223:   F6 F7        OR F7h
0225:   BC           CP H
0226:   28 08        JR Z,L0230
L0228:
0228:   3A 3B 00     LD A,(003Bh) ; kbd_last
022B:   E6 FE        AND FEh
L022D:
022D:   32 3B 00     LD (003Bh),A ; kbd_last
L0230:
0230:   7A           LD A,D
0231:   C9           RET
L0232:
0232:   57           LD D,A
0233:   01 A1 06     LD BC,06A1h
0236:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0238:   F6 BF        OR BFh
023A:   BC           CP H
023B:   28 08        JR Z,L0245
023D:   3A 3B 00     LD A,(003Bh) ; kbd_last
0240:   E6 FE        AND FEh
0242:   32 3B 00     LD (003Bh),A ; kbd_last
L0245:
0245:   01 A1 07     LD BC,07A1h
0248:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
024A:   F6 F7        OR F7h
024C:   BC           CP H
024D:   28 08        JR Z,L0257
024F:   3A 3B 00     LD A,(003Bh) ; kbd_last
0252:   E6 EF        AND EFh
0254:   32 3B 00     LD (003Bh),A ; kbd_last
L0257:
0257:   01 A1 08     LD BC,08A1h
025A:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
025C:   F6 F7        OR F7h
025E:   BC           CP H
025F:   28 08        JR Z,L0269
0261:   3A 3B 00     LD A,(003Bh) ; kbd_last
0264:   E6 F7        AND F7h
0266:   32 3B 00     LD (003Bh),A ; kbd_last
L0269:
0269:   01 A1 09     LD BC,09A1h
026C:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
026E:   F6 FB        OR FBh
0270:   BC           CP H
0271:   28 08        JR Z,L027B
0273:   3A 3B 00     LD A,(003Bh) ; kbd_last
0276:   E6 FB        AND FBh
0278:   32 3B 00     LD (003Bh),A ; kbd_last
L027B:
027B:   01 A1 0A     LD BC,0AA1h
027E:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0280:   F6 FB        OR FBh
0282:   BC           CP H
0283:   28 AB        JR Z,L0230
0285:   3A 3B 00     LD A,(003Bh) ; kbd_last
0288:   E6 FD        AND FDh
028A:   18 A1        JR L022D
L028C:
028C:   57           LD D,A
028D:   01 A1 07     LD BC,07A1h
0290:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0292:   F6 FB        OR FBh
0294:   BC           CP H
0295:   28 08        JR Z,L029F
0297:   3A 3B 00     LD A,(003Bh) ; kbd_last
029A:   E6 EF        AND EFh
029C:   32 3B 00     LD (003Bh),A ; kbd_last
L029F:
029F:   01 A1 08     LD BC,08A1h
02A2:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
02A4:   F6 FB        OR FBh
02A6:   BC           CP H
02A7:   28 08        JR Z,L02B1
02A9:   3A 3B 00     LD A,(003Bh) ; kbd_last
02AC:   E6 F7        AND F7h
02AE:   32 3B 00     LD (003Bh),A ; kbd_last
L02B1:
02B1:   01 A1 09     LD BC,09A1h
02B4:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
02B6:   F6 FD        OR FDh
02B8:   BC           CP H
02B9:   28 08        JR Z,L02C3
02BB:   3A 3B 00     LD A,(003Bh) ; kbd_last
02BE:   E6 FB        AND FBh
02C0:   32 3B 00     LD (003Bh),A ; kbd_last
L02C3:
02C3:   01 A1 0A     LD BC,0AA1h
02C6:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
02C8:   F6 FD        OR FDh
02CA:   BC           CP H
02CB:   28 08        JR Z,L02D5
02CD:   3A 3B 00     LD A,(003Bh) ; kbd_last
02D0:   E6 FD        AND FDh
02D2:   32 3B 00     LD (003Bh),A ; kbd_last
L02D5:
02D5:   01 A1 0A     LD BC,0AA1h
02D8:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
02DA:   F6 BF        OR BFh
02DC:   BC           CP H
02DD:   CA 30 02     JP Z,L0230
02E0:   3A 3B 00     LD A,(003Bh) ; kbd_last
02E3:   E6 FE        AND FEh
02E5:   C3 2D 02     JP L022D
L02E8:
02E8:   57           LD D,A
02E9:   01 A1 07     LD BC,07A1h
02EC:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
02EE:   F6 FD        OR FDh
02F0:   BC           CP H
02F1:   28 08        JR Z,L02FB
02F3:   3A 3B 00     LD A,(003Bh) ; kbd_last
02F6:   E6 EF        AND EFh
02F8:   32 3B 00     LD (003Bh),A ; kbd_last
L02FB:
02FB:   01 A1 08     LD BC,08A1h
02FE:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0300:   F6 FD        OR FDh
0302:   BC           CP H
0303:   28 08        JR Z,L030D
0305:   3A 3B 00     LD A,(003Bh) ; kbd_last
0308:   E6 F7        AND F7h
030A:   32 3B 00     LD (003Bh),A ; kbd_last
L030D:
030D:   01 A1 09     LD BC,09A1h
0310:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0312:   F6 FE        OR FEh
0314:   BC           CP H
0315:   28 08        JR Z,L031F
0317:   3A 3B 00     LD A,(003Bh) ; kbd_last
031A:   E6 FB        AND FBh
031C:   32 3B 00     LD (003Bh),A ; kbd_last
L031F:
031F:   01 A1 0A     LD BC,0AA1h
0322:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0324:   F6 FE        OR FEh
0326:   BC           CP H
0327:   28 08        JR Z,L0331
0329:   3A 3B 00     LD A,(003Bh) ; kbd_last
032C:   E6 FD        AND FDh
032E:   32 3B 00     LD (003Bh),A ; kbd_last
L0331:
0331:   01 A1 0A     LD BC,0AA1h
0334:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0336:   F6 7F        OR 7Fh
0338:   BD           CP L
0339:   CA 30 02     JP Z,L0230
033C:   3A 3B 00     LD A,(003Bh) ; kbd_last
033F:   E6 FE        AND FEh
0341:   C3 2D 02     JP L022D
L0344:
0344:   57           LD D,A
0345:   01 A1 02     LD BC,02A1h
0348:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
034A:   F6 FE        OR FEh
034C:   BC           CP H
034D:   28 08        JR Z,L0357
034F:   3A 3B 00     LD A,(003Bh) ; kbd_last
0352:   E6 FE        AND FEh
0354:   32 3B 00     LD (003Bh),A ; kbd_last
L0357:
0357:   01 A1 03     LD BC,03A1h
035A:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
035C:   F6 FD        OR FDh
035E:   BC           CP H
035F:   28 08        JR Z,L0369
0361:   3A 3B 00     LD A,(003Bh) ; kbd_last
0364:   E6 7D        AND 7Dh
0366:   32 3B 00     LD (003Bh),A ; kbd_last
L0369:
0369:   01 A1 04     LD BC,04A1h
036C:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
036E:   F6 FD        OR FDh
0370:   BC           CP H
0371:   28 08        JR Z,L037B
0373:   3A 3B 00     LD A,(003Bh) ; kbd_last
0376:   E6 FB        AND FBh
0378:   32 3B 00     LD (003Bh),A ; kbd_last
L037B:
037B:   01 A1 05     LD BC,05A1h
037E:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0380:   F6 FD        OR FDh
0382:   BC           CP H
0383:   28 08        JR Z,L038D
0385:   3A 3B 00     LD A,(003Bh) ; kbd_last
0388:   E6 F7        AND F7h
038A:   32 3B 00     LD (003Bh),A ; kbd_last
L038D:
038D:   01 A1 06     LD BC,06A1h
0390:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0392:   F6 FE        OR FEh
0394:   BC           CP H
0395:   CA 30 02     JP Z,L0230
0398:   3A 3B 00     LD A,(003Bh) ; kbd_last
039B:   E6 EF        AND EFh
039D:   C3 2D 02     JP L022D
L03A0:
03A0:   57           LD D,A
03A1:   01 A1 02     LD BC,02A1h
03A4:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
03A6:   F6 FD        OR FDh
03A8:   BC           CP H
03A9:   28 08        JR Z,L03B3
03AB:   3A 3B 00     LD A,(003Bh) ; kbd_last
03AE:   E6 FE        AND FEh
03B0:   32 3B 00     LD (003Bh),A ; kbd_last
L03B3:
03B3:   01 A1 03     LD BC,03A1h
03B6:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
03B8:   F6 FB        OR FBh
03BA:   BC           CP H
03BB:   28 08        JR Z,L03C5
03BD:   3A 3B 00     LD A,(003Bh) ; kbd_last
03C0:   E6 FD        AND FDh
03C2:   32 3B 00     LD (003Bh),A ; kbd_last
L03C5:
03C5:   01 A1 04     LD BC,04A1h
03C8:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
03CA:   F6 FB        OR FBh
03CC:   BC           CP H
03CD:   28 08        JR Z,L03D7
03CF:   3A 3B 00     LD A,(003Bh) ; kbd_last
03D2:   E6 FB        AND FBh
03D4:   32 3B 00     LD (003Bh),A ; kbd_last
L03D7:
03D7:   01 A1 05     LD BC,05A1h
03DA:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
03DC:   F6 FB        OR FBh
03DE:   BC           CP H
03DF:   28 08        JR Z,L03E9
03E1:   3A 3B 00     LD A,(003Bh) ; kbd_last
03E4:   E6 F7        AND F7h
03E6:   32 3B 00     LD (003Bh),A ; kbd_last
L03E9:
03E9:   01 A1 06     LD BC,06A1h
03EC:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
03EE:   F6 FD        OR FDh
03F0:   BC           CP H
03F1:   CA 30 02     JP Z,L0230
03F4:   3A 3B 00     LD A,(003Bh) ; kbd_last
03F7:   E6 EF        AND EFh
03F9:   C3 2D 02     JP L022D
L03FC:
03FC:   57           LD D,A
03FD:   01 A1 02     LD BC,02A1h
0400:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0402:   F6 FB        OR FBh
0404:   BC           CP H
0405:   28 08        JR Z,L040F
0407:   3A 3B 00     LD A,(003Bh) ; kbd_last
040A:   E6 FE        AND FEh
040C:   32 3B 00     LD (003Bh),A ; kbd_last
L040F:
040F:   01 A1 03     LD BC,03A1h
0412:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0414:   F6 F7        OR F7h
0416:   BC           CP H
0417:   28 08        JR Z,L0421
0419:   3A 3B 00     LD A,(003Bh) ; kbd_last
041C:   E6 FD        AND FDh
041E:   32 3B 00     LD (003Bh),A ; kbd_last
L0421:
0421:   01 A1 04     LD BC,04A1h
0424:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0426:   F6 F7        OR F7h
0428:   BC           CP H
0429:   28 08        JR Z,L0433
042B:   3A 3B 00     LD A,(003Bh) ; kbd_last
042E:   E6 FB        AND FBh
0430:   32 3B 00     LD (003Bh),A ; kbd_last
L0433:
0433:   01 A1 05     LD BC,05A1h
0436:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0438:   F6 F7        OR F7h
043A:   BC           CP H
043B:   28 08        JR Z,L0445
043D:   3A 3B 00     LD A,(003Bh) ; kbd_last
0440:   E6 F7        AND F7h
0442:   32 3B 00     LD (003Bh),A ; kbd_last
L0445:
0445:   01 A1 06     LD BC,06A1h
0448:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
044A:   F6 FB        OR FBh
044C:   BC           CP H
044D:   CA 30 02     JP Z,L0230
0450:   3A 3B 00     LD A,(003Bh) ; kbd_last
0453:   E6 EF        AND EFh
0455:   C3 2D 02     JP L022D
L0458:
0458:   01 A1 01     LD BC,01A1h
045B:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
045D:   F6 F7        OR F7h
045F:   BD           CP L
0460:   28 08        JR Z,L046A
0462:   3A 3B 00     LD A,(003Bh) ; kbd_last
0465:   E6 FE        AND FEh
0467:   32 3B 00     LD (003Bh),A ; kbd_last
L046A:
046A:   01 A1 02     LD BC,02A1h
046D:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
046F:   F6 F7        OR F7h
0471:   BC           CP H
0472:   28 08        JR Z,L047C
0474:   3A 3B 00     LD A,(003Bh) ; kbd_last
0477:   E6 FD        AND FDh
0479:   32 3B 00     LD (003Bh),A ; kbd_last
L047C:
047C:   01 A1 03     LD BC,03A1h
047F:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0481:   F6 EF        OR EFh
0483:   BC           CP H
0484:   28 08        JR Z,L048E
0486:   3A 3B 00     LD A,(003Bh) ; kbd_last
0489:   E6 FB        AND FBh
048B:   32 3B 00     LD (003Bh),A ; kbd_last
L048E:
048E:   01 A1 04     LD BC,04A1h
0491:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
0493:   F6 EF        OR EFh
0495:   BC           CP H
0496:   28 08        JR Z,L04A0
0498:   3A 3B 00     LD A,(003Bh) ; kbd_last
049B:   E6 F7        AND F7h
049D:   32 3B 00     LD (003Bh),A ; kbd_last
L04A0:
04A0:   01 A1 05     LD BC,05A1h
04A3:   ED 78        IN A,(C) ; IN: keyboard matrix read via port (C) (low byte selects device; B selects row mask)
04A5:   F6 EF        OR EFh
04A7:   BC           CP H
04A8:   CA 30 02     JP Z,L0230
04AB:   3A 3B 00     LD A,(003Bh) ; kbd_last
04AE:   E6 EF        AND EFh
04B0:   C3 2D 02     JP L022D
L04B3:
04B3:   2A 42 00     LD HL,(0042h) ; save_af
04B6:   E5           PUSH HL
04B7:   2A 40 00     LD HL,(0040h) ; save_bc
04BA:   E5           PUSH HL
04BB:   C1           POP BC
04BC:   2A 3E 00     LD HL,(003Eh) ; save_de
04BF:   EB           EX DE,HL
04C0:   3A 3A 00     LD A,(003Ah)
04C3:   FE 01        CP 01h
04C5:   28 18        JR Z,L04DF
04C7:   FE 02        CP 02h
04C9:   28 1A        JR Z,L04E5
04CB:   FE 03        CP 03h
04CD:   28 1C        JR Z,L04EB
04CF:   FE 04        CP 04h
04D1:   28 1E        JR Z,L04F1
04D3:   FE 05        CP 05h
04D5:   28 20        JR Z,L04F7
04D7:   FE 06        CP 06h
04D9:   28 22        JR Z,L04FD
04DB:   FE 07        CP 07h
04DD:   28 26        JR Z,L0505
L04DF:
04DF:   F1           POP AF
04E0:   3A 3B 00     LD A,(003Bh) ; kbd_last
04E3:   18 27        JR L050C
L04E5:
04E5:   3A 3B 00     LD A,(003Bh) ; kbd_last
04E8:   47           LD B,A
04E9:   18 20        JR L050B
L04EB:
04EB:   3A 3B 00     LD A,(003Bh) ; kbd_last
04EE:   4F           LD C,A
04EF:   18 1A        JR L050B
L04F1:
04F1:   3A 3B 00     LD A,(003Bh) ; kbd_last
04F4:   57           LD D,A
04F5:   18 14        JR L050B
L04F7:
04F7:   3A 3B 00     LD A,(003Bh) ; kbd_last
04FA:   5F           LD E,A
04FB:   18 0E        JR L050B
L04FD:
04FD:   3A 3B 00     LD A,(003Bh) ; kbd_last
0500:   32 3D 00     LD (003Dh),A
0503:   18 06        JR L050B
L0505:
0505:   3A 3B 00     LD A,(003Bh) ; kbd_last
0508:   32 3C 00     LD (003Ch),A ; save_hl
L050B:
050B:   F1           POP AF
L050C:
050C:   2A 44 00     LD HL,(0044h) ; save_sp
050F:   F9           LD SP,HL
L0510:
0510:   2A 3C 00     LD HL,(003Ch) ; save_hl
L0513:
0513:   D3 C1        OUT (C1h),A ; OUT: COM 8251 data/control (C1h/C3h)
0515:   ED 45        RETN
L0517:
0517:   F3           DI
0518:   3E 61        LD A,61h
051A:   D3 B9        OUT (B9h),A ; OUT: memcfg (B9h wo=memcfg offset=3)
051C:   21 00 7F     LD HL,7F00h
051F:   11 2E 05     LD DE,052Eh
0522:   06 08        LD B,08h
L0524:
0524:   1A           LD A,(DE)
0525:   77           LD (HL),A
0526:   23           INC HL
0527:   13           INC DE
0528:   05           DEC B
0529:   20 F9        JR NZ,L0524
052B:   C3 00 7F     JP L7F00
052E:   D3 C1        OUT (C1h),A ; OUT: COM 8251 data/control (C1h/C3h)
0530:   00           NOP
0531:   00           NOP
0532:   00           NOP
0533:   C3 36 45     JP L4536
0536:   21 B0 F7     LD HL,F7B0h
0539:   36 94        LD (HL),94h
053B:   3E 26        LD A,26h
053D:   D3 80        OUT (80h),A
053F:   23           INC HL
L0540:
0540:   36 20        LD (HL),20h
0542:   23           INC HL
0543:   7C           LD A,H
0544:   FE 00        CP 00h
0546:   20 F8        JR NZ,L0540
0548:   3E 61        LD A,61h
054A:   D3 A9        OUT (A9h),A ; OUT: memcfg (A9h wo=memcfg offset=1)
L054C:
054C:   DB C4        IN A,(C4h) ; IN: CRT data register (C4h=crt.data+1)
054E:   E6 20        AND 20h
0550:   20 FA        JR NZ,L054C
L0552:
0552:   DB C4        IN A,(C4h) ; IN: CRT data register (C4h=crt.data+1)
0554:   E6 20        AND 20h
0556:   28 FA        JR Z,L0552
0558:   AF           XOR A
0559:   D3 C4        OUT (C4h),A ; OUT: CRT controller data (C0h/C4h)
055B:   3E 4F        LD A,4Fh
055D:   D3 C0        OUT (C0h),A ; OUT: CRT controller data (C0h/C4h)
055F:   3E D8        LD A,D8h
0561:   D3 C0        OUT (C0h),A ; OUT: CRT controller data (C0h/C4h)
0563:   3E 99        LD A,99h
0565:   D3 C0        OUT (C0h),A ; OUT: CRT controller data (C0h/C4h)
0567:   3E DE        LD A,DEh
0569:   D3 C0        OUT (C0h),A ; OUT: CRT controller data (C0h/C4h)
056B:   3E E0        LD A,E0h
056D:   D3 C4        OUT (C4h),A ; OUT: CRT controller data (C0h/C4h)
056F:   3E 80        LD A,80h
0571:   D3 E8        OUT (E8h),A ; OUT: DMA registers (E0h-EFh)
0573:   3E B0        LD A,B0h
0575:   D3 E4        OUT (E4h),A ; OUT: DMA registers (E0h-EFh)
0577:   3E F7        LD A,F7h
0579:   D3 E4        OUT (E4h),A ; OUT: DMA registers (E0h-EFh)
057B:   3E CF        LD A,CFh
057D:   D3 E5        OUT (E5h),A ; OUT: DMA registers (E0h-EFh)
057F:   3E 87        LD A,87h
0581:   D3 E5        OUT (E5h),A ; OUT: DMA registers (E0h-EFh)
0583:   3E 23        LD A,23h
0585:   D3 C4        OUT (C4h),A ; OUT: CRT controller data (C0h/C4h)
0587:   3E E4        LD A,E4h
0589:   D3 E8        OUT (E8h),A ; OUT: DMA registers (E0h-EFh)
058B:   01 00 50     LD BC,5000h
058E:   21 00 D6     LD HL,D600h
L0591:
0591:   0A           LD A,(BC)
0592:   77           LD (HL),A
0593:   23           INC HL
0594:   03           INC BC
0595:   7C           LD A,H
0596:   FE F8        CP F8h
0598:   20 F7        JR NZ,L0591
059A:   21 AA F7     LD HL,F7AAh
059D:   36 00        LD (HL),00h
059F:   23           INC HL
05A0:   36 00        LD (HL),00h
05A2:   21 00 00     LD HL,0000h
05A5:   11 20 4D     LD DE,4D20h
L05A8:
05A8:   1A           LD A,(DE)
05A9:   77           LD (HL),A
05AA:   23           INC HL
05AB:   13           INC DE
05AC:   3E 01        LD A,01h
05AE:   BC           CP H
05AF:   20 F7        JR NZ,L05A8
05B1:   C3 00 00     JP L0000
05B4:   00           NOP
05B5:   00           NOP
05B6:   00           NOP
05B7:   00           NOP
05B8:   00           NOP
05B9:   00           NOP
05BA:   00           NOP
05BB:   00           NOP
05BC:   00           NOP
05BD:   00           NOP
05BE:   00           NOP
05BF:   00           NOP
05C0:   00           NOP
05C1:   00           NOP
05C2:   00           NOP
05C3:   00           NOP
05C4:   00           NOP
05C5:   00           NOP
05C6:   00           NOP
05C7:   00           NOP
05C8:   00           NOP
05C9:   00           NOP
05CA:   00           NOP
05CB:   00           NOP
05CC:   00           NOP
05CD:   00           NOP
05CE:   00           NOP
05CF:   00           NOP
05D0:   00           NOP
05D1:   00           NOP
05D2:   00           NOP
05D3:   00           NOP
05D4:   00           NOP
05D5:   00           NOP
05D6:   00           NOP
05D7:   00           NOP
05D8:   00           NOP
05D9:   00           NOP
05DA:   00           NOP
05DB:   00           NOP
05DC:   00           NOP
05DD:   00           NOP
05DE:   00           NOP
05DF:   00           NOP
05E0:   00           NOP
05E1:   00           NOP
05E2:   00           NOP
05E3:   00           NOP
05E4:   00           NOP
05E5:   00           NOP
05E6:   00           NOP
05E7:   00           NOP
05E8:   00           NOP
05E9:   00           NOP
05EA:   00           NOP
05EB:   00           NOP
05EC:   00           NOP
05ED:   00           NOP
05EE:   00           NOP
05EF:   00           NOP
05F0:   00           NOP
05F1:   00           NOP
05F2:   00           NOP
05F3:   00           NOP
05F4:   00           NOP
05F5:   00           NOP
05F6:   00           NOP
05F7:   00           NOP
05F8:   00           NOP
05F9:   00           NOP
05FA:   00           NOP
05FB:   00           NOP
05FC:   00           NOP
05FD:   00           NOP
05FE:   00           NOP
05FF:   00           NOP
