{
Civilization (ZX Spectrum remake)
created by Andrew771
2018-2025
}

program civilization;

const

	{settings}

	x_global=64;
	y_global=48;

	map_window_color1=6;
	map_window_color2=49;
	message_window_color1=7;
	message_window_color2=56;
	error_window_color1=2;
	error_window_color2=23;
	city_window_color1=5;
	city_window_color2=0;

	x_scr_max=11;
	y_scr_max=11;
	x_scr_city_max=5;
	y_scr_city_max=5;
	dx_scr=0;
	dy_scr=2;
	dx_scr_city=10;
	dy_scr_city=0;
	dx_user_scr=5;
	dy_user_scr=5;

	civ_max=8;
	science_speed_base=10;
	science_max=80;
	type_u_max=20;
	type_b_max=24;
	unit_max=100;
	unit_user_max=58;
	unit_civ_max=6;
	city_max=80;
	city_per_civ=10;
	luxury_max=7;
	menu_max=6;
	key_help_max=14;
	wiki_max=26;
	history_max=384;

	city_population_min=10;
	city_money_min=30;

	build_percent=10;

	city_min_dist=3;

	{prices}

	price_science_money_produce=0;
	price_science_money_consume=4;
	price_land_grain_produce=1;
	price_land_power_produce=3;
	price_b_produce=1;
	price_b_consume=3;
	price_u_consume=1;
	price_city_from_treasure=30;
	price_trade=50;
	price_luxury=10000;
	happy_min=25;

	{civilizations}

	civ_i=1;
	civ_color=2;
	civ_science=3;
	civ_unit=4;
	civ_city=5;
	civ_level=6;
	civ_strategy=7;
	civ_color_history=8;
	civ_pact=9;

	{AI}

	str_build_city=1;
	str_occup_city=2;
	str_build_infr=3;

	{unit commands}

	com_build=1;
	com_1_pass=2;
	com_2_pass=3;
	com_3_pass=4;
	com_trade=5;
	com_all_look=6;

	{landscape}

	cell_sea=0;
	cell_meadow=1;
	cell_forest=4;
	cell_hill=5;
	cell_irrig=6;
	cell_power=7;
	cell_road=8;
	cell_rail=9;
	cell_city=61;

	mapsprite_delta_unit=61;

	{science}

	s_i=1;
	s_s1=2;
	s_s2=3;
	s_b=4;
	s_u=5;

	s_i_civ=1;
	s_i_user=2;

	sc_calendar=14;
	sc_trading=10;
	sc_road=11;
	sc_railroad=28;

	{cities}

	c_civ=1;		{civ number, 0=empty}
	c_x=2;
	c_y=3;
	c_b1=4;
	c_b2=5;
	c_b3=6;
	c_b_table=7;
	c_b_id=8;
	c_b_percent=9;
	c_riot=10;

	{unit types}

	u_i=1;
	u_move=2;
	u_at=3;
	u_def=4;
	u_speed=5;
	u_com=6;

	civ_all_cell=1;
	civ_earth=2;
	civ_sea=3;

	{units}

	u_civ=1;		{civ number, 0=empty}
	u_type=2;
	u_x=3;
	u_y=4;
	u_x_target=5;
	u_y_target=6;
	u_param=7;

	unit_colonist=1;
	unit_caravan=7;

	{luxury}

	l_i=1;
	l_b=2;

	{wiki}

	w_view=1;
	w_elem=2;
	w_adv=3;

	w_a_r_resource=1;
	w_a_r_vol_cost=2;
	w_a_r_vol_give=3;

	{history}

	hist_city_create=0;
	hist_science=1;
	hist_building=2;
	hist_unit=3;
	hist_city_occupied=4;
	hist_destroy_civ=5;

	{window_dialogs}

	view_science_1=1;
	view_city_1=2;
	view_civ_1=3;
	view_unit_1=4;
	view_building_1=5;
	view_tax_1=6;
	view_help_1=7;
	view_luxury_1=8;
	view_wiki_1=9;

var

{------------------------------- RUSSIAN -----------------------------------------}
{---------         --------}
{---------delete a comment for Russian compilation--------------------------------}


	text1: string[11] = '?';
	text2: string[2] = '';
	text10: string[21] = '  ';
	text11: string[14] = ' , ';
	text12: string[17] = ' ,';
	text15: string[21] = '  ,';
	text16: string[15] = ' , ';
	text17: string[7] = '';
	text21: string[23] = '  ,';
	text22: string[9] = ':';
	text23: string[10] = '  ';
	text24: string[12] = '  .';
	text25: string[10] = '  ';
	text26: string[14] = ' ';
	text27: string[11] = ' ';
	text28: string[16] = '  ';
	text29: string[15] = '  ';
	text30: string[18] = ':  , ';
	text31: string[3] = ' .';
	text32: string[8] = ' . ';
	text33: string[16] = '  ';
	text34: string[24] = '   ,';
	text36: string[20] = '  ,';
	text37: string[18] = '  -';
	text38: string[4] = '.';
	text39: string[4] = '';
	text40: string[11] = '//';
	text41: string[4] = '';
	text42: string[8] = ':';
	text43: string[8] = ':';
	text44: string[10] = '';
	text45: string[3] = '000';
	text46: string[8] = '$#';
	text47: string[27] = '    100$#';
	text48: string[32] = '  ,  ';
	text49: string[12] = ', ';
	text50: string[15] = '  ';
	text51: string[5] = '!';

	civ_text: array[1..civ_max] of string[10] =
	[
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		''
	];

	civ_leader: array[1..civ_max] of string[14] =
	[
		' ',
		' ',
		' ',
		'',
		' ',
		' ',
		' ',
		' '
	];

	civ_slogan: array[1..civ_max] of string[20] =
	[
		'',
		' ',
		' ',
		'  ',
		'  ',
		'???',
		' ',
		'???'
	];

	s_text: array[1..science_max] of string[18] =
	[
		' ',
		' ',
		'',
		' ',
		'',
		'',
		'',
		' ',
		'',
		'',
		' ',
		' ',
		'',
		'',
		'',
		' ',
		'',
		'',
		'',
		' ',
		'',
		'',
		'',
		' ',
		'',
		'',
		'',
		' ',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		' ',
		'',
		'',
		'',
		'',
		'',
		'',
		'.',
		'',
		'',
		'',
		' ',
		'',
		' ',
		'',
		' ',
		'',
		'',
		'',
		' ',
		' ',
		'.',
		'',
		'ZX Spectrum',
		'',
		' ',
		'.',
		'',
		'',
		'',
		'.',
		' '
	];

	c_text: array[1..city_max] of string[14] =
	[
		'',
		'',
		'.',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'-',
		'',
		'-',
		'-',
		'',
		'',
		'',
		'-',
		'',
		'--',
		'',
		'-',
		'',
		'',
		'',
		'',
		'-',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'-',
		'',
		'--',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		''
	];

	u_text: array[1..20] of string[10] =
	[
		'',			{1}
		'',			{2}
		'',			{3}
		'',			{4}
		'',			{5}
		'',			{6}
		'',			{7}
		'',			{8}
		'',			{9}
		'',			{10}
		'',			{11}
		'',			{12}
		'',			{13}
		'',			{14}
		'',			{15}
		'',				{16}
		'',			{17}
		'',				{18}
		'.',			{19}
		''			{20}
	];


	b_text: array[1..25] of string[12] =
	[
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'.',
		'',
		'',
		'',
		'.',
		'.',
		''
	];

	l_text: array[1..luxury_max] of string[9] =
	[
		'   ',
		' ',
		' ',
		'     ',
		'   ',
		'  ',
		'.'	
	];

	menu_text: array[1..menu_max] of string[13] =
	[
		'',
		'',
		'',
		'',
		'',
		''
	];

	key_help_text: array[1..key_help_max] of string[22] =
	[
		'      ',
		'        ',
		'           ',
		'        ',
		'       ',
		'  -          ',
		'  -          ',
		'  -          ',
		'  -          ',
		'           ',
		' :      ',
		'        ',
		' /..  ',
		'         '
	];

	wiki_adv_text: array[1..wiki_max] of string[48] =
	[
		'     .  ',			{1 - }
		'   ,   ',			{2 - }
		' /,  /',				{3 - }
		'  //',					{4 - :}
		'  , ',					{5 - :}
		'  .,   ',				{6 - }
		':3$#,    2 ',			{7 - }
		':3$#,    4 ',			{8 - .}
		' /  ',					{9 - }
		':3$#/,:1$#/',					{10 - }
		':3$#/,   /',				{11 - }
		'  ,   ',			{12 - :}
		',,, /',			{13 - :}
		'    . :50$#',				{14 - }
		' , /',				{15 - }
		'       ',			{16 - }
		'     ',						{17 - }
		'     ',				{18 - }
		':3$#,:1$#/   ',				{19 - }
		'      ',			{20 -   }
		':10000$#, ,  ',			{21 - }
		':3$#/   ',					{22 - }
		'     ',				{23 - }
		'   .1$#/10.',			{24 - }
		'    . :50$#',			{25 - }
		':1$#/,://'				{26 - }
	];

	wiki: array[1..wiki_max] of string[13] =
	[
		'',				{1}
		'',					{2}
		'',				{3}
		':',				{4}
		':',			{5}
		'',				{6}
		'',				{7}
		'.',				{8}
		'',				{9}
		'',				{10}
		'',				{11}
		':',				{12}
		':',			{13}
		'',				{14}
		'',				{15}
		'',				{16}
		'',				{17}
		'',				{18}
		'',				{19}
		'  ',				{20}
		'',				{21}
		'',				{22}
		'',				{23}
		'',				{24}
		'',				{25}
		''					{26}
	];

{------------------------------- ENGLISH ---------------------------------------------}
{---------        ----------}
{---------delete a comment for English compilation------------------------------------}

{
	text1: string[9] = 'Overlord?';
	text2: string[4] = 'News';
	text3: string[3] = 'Tax';
	text4: string[11] = 'Civilopedia';
	text5: string[7] = 'History';
	text8: string[7] = 'Trading';
	text9: string[6] = 'Cities';
	text10: string[19] = 'What next to invent';
	text11: string[16] = 'our scientists, ';
	text12: string[18] = 'Your civilization,';
	text15: string[19] = 'Which city to show,';
	text16: string[15] = 'What to build, ';
	text17: string[5] = 'Build';
	text18: string[6] = 'It is ';
	text19: string[5] = ' year';
	text21: string[21] = 'What is the tax rate,';
	text22: string[6] = 'Build:';
	text23: string[9] = ' built a ';
	text24: string[9] = ' founded ';
	text25: string[14] = ' invented the ';
	
	civ_text: array[1..8] of string[10] =
	[
		'Russians',
		'Europeans',
		'Americans',
		'Latinos',
		'Muslims',
		'Africans',
		'Chinese',
		'Hindus'
	];

	civ_leader: array[1..8] of string[20] =
	[
		' ',
		' ',
		' ',
		'  ',
		' ',
		'  ',
		'  ',
		' '
	];

	civ_slogan: array[1..8] of string[20] =
	[
		' ',
		' ',
		' ',
		'  ',
		'  ',
		'???',
		' ',
		'???'
	];

	s_text: array[1..80] of string[18] =
	[
		'Stone cutting',
		'Fire usage',
		'Agriculture',
		'Religious cult',
		'Cattle breeding',
		'Wheel',
		'Claymaking',
		'Bronze Smelting',
		'Theatre',
		'Trade',
		'Paving roads',
		'Iron Smelting',
		'Writing',
		'Calendar',
		'Abacus',
		'Basic Medicine',
		'Compass',
		'Lever arm',
		'Astrolabe',
		'Religion',
		'Alchemy',
		'Paper',
		'Gunpowder',
		'Blast furnace',
		'Typography',
		'Differential',
		'Adding machine',
		'Steam engine',
		'Sextant',
		'Machine',
		'Accounting',
		'Electroplating',
		'Dynamite',
		'Electric motor',
		'Diesel',
		'Photography',
		'Electric lamp',
		'Radioactivity',
		'Antibiotic',
		'Fertilizers',
		'Aeronautics',
		'Transformer',
		'Telegraph',
		'Canning',
		'Ferroconcrete',
		'Telephone',
		'Phonograph',
		'X-ray',
		'AC',
		'Radio',
		'Airplane',
		'Cinema',
		'Diode',
		'Plastic',
		'Superconductivity',
		'Jet engine',
		'Generator',
		'TV',
		'Computer',
		'Nuclear fusion',
		'Rocket',
		'Nuclear weapon',
		'Transistor',
		'Deciphering DNA',
		'Sputnik',
		'Chip',
		'Laser',
		'Computer network',
		'Optical Diode',
		'Thermonucl.fusion',
		'Microprocessor',
		'ZX Spectrum',
		'Robotics',
		'Mobile network',
		'Synthetic organ',
		'Fullerene',
		'Dactyloscopy',
		'Optoelectronics',
		'Synthetic cell',
		'Genome decoding'
	];

	c_text: array[1..100] of string[14] =
	[
		'Moscow',
		'Petersburg',
		'Nizhny Novgorod',
		'Yekaterinburg',
		'Novosibirsk',
		'Stalingrad',
		'Krasnodar',
		'Samara',
		'Yaroslavl',
		'Arkhangelsk',
		'Krasnoyarsk',
		'Vladivostok',
		'Paris',
		'London',
		'Berlin',
		'Rome',
		'Madrid',
		'Lisbon',
		'Warsaw',
		'Amsterdam',
		'Brussels',
		'Stockholm',
		'Prague',
		'Athens',
		'Washington',
		'New York',
		'Chicago',
		'Los Angeles',
		'San Francisco',
		'Philadelphia',
		'Boston',
		'Miami',
		'Las Vegas',
		'Dallas',
		'Houston',
		'Seattle',
		'Rio de Janeiro',
		'Mexico City',
		'Buenos Aires',
		'Havana',
		'Bogota',
		'Santiago',
		'Panama',
		'San Salvador',
		'Lima',
		'Quito',
		'Montevideo',
		'Sao Paulo',
		'Mecca',
		'Medina',
		'Cairo',
		'Baghdad',
		'Damascus',
		'Tehran',
		'Istanbul',
		'Algeria',
		'Dubai',
		'Samarkand',
		'Rabat',
		'El Kuwait',
		'Lagos',
		'Kinshasa',
		'Johannesburg',
		'Luanda',
		'Abidjan',
		'Cape Town',
		'Nairobi',
		'Addis Ababa',
		'Antananarivo',
		'Dar es Salaam',
		'Dakar',
		'Mogadishu',
		'Beijing',
		'Shanghai',
		'Chengdu',
		'Wuhan',
		'Tianjin',
		'Guangzhou',
		'Chongqing',
		'Hangzhou',
		'Shenzhen',
		'Qingdao',
		'Nanking',
		'Harbin',
		'Delhi',
		'Mumbai',
		'Bangalore',
		'Hyderabad',
		'Ahmedabad',
		'Chennai',
		'Calcutta',
		'Varanasi',
		'Jaipur',
		'Lucknow',
		'Kanpur',
		'Bhopal',
		'Sydney',
		'Toronto',
		'Tokyo',
		'Bangkok'
	];

	u_text: array[1..25] of string[13] =
	[
		'Colonists',
		'Militia',
		'Galley',
		'Cavalry',
		'Chariot',
		'Falange',
		'Caravan',
		'Legion',
		'Catapult',
		'Frigate',
		'Knights',
		'Musketeers',
		'Cannon',
		'Steamboat',
		'',
		'Gunners',
		'Cruiser',
		'Tank',
		'Airship',
		'Airplane',
		'Aerocarrier',
		'Air defense',
		'Atomic bomb',
		'Sputnik',
		''
	];


	b_text: array[1..25] of string[12] =
	[
		'Walls',
		'Barracks',
		'Granary',
		'Shrine',
		'Farm',
		'Workshop',
		'Theatre',
		'Bazaar',
		'Stadium',
		'Library',
		'Courthouse',
		'School',
		'Hospital',
		'Aqueduct',
		'Monastery',
		'University',
		'Factory',
		'Bank',
		'Powerhouse',
		'Transport',
		'Telegraph',
		'TV tower',
		'Nucl.station',
		'Data center',
		''
	];

}

	i_debug_window: byte;
	prom1,prom2: word;
	prom_random,prom3: byte;
	key1,key2,key3: byte;
	x_user,x_user2,y_user: byte;
	dx_scr_1,dx_scr_2,x_scr_1,x_scr_2: byte;
	x_user_proc,dx_scr_proc,x_scr_proc: byte;
	x_user_map,y_user_map: byte;
	i_main,i1,i2,j1: byte;
	i_unit_put,i_city_put,i_all_put: byte;
	sprite_number,sprite_color,sprite_x,sprite_y: byte;
	calc_x,calc_y,calc_z,calc_result: word;

	{abs}
	arg1,arg2,abs_arg: byte;

	{years}
	year,year_calc,year_word,year_science: word = 0;
	year0: word = 7;
	year_era: string[9];

	{civilizations}
	civ_current,civ_user: byte;
	tax,tax_view: byte;

	{science}
	science_speed: byte = 10;
	science_research: byte = 1;
	sc_error_create: byte;

	{units}
	ut: array[1..unit_max,1..7] of byte;	{1-, 2- , 3,4- x,y, 5,6-  x,y, 7-}
	unit_current,unit_empty: word;
	unit_create_max: byte;
	cell_current,x_current,y_current,x_move,y_move: byte;
	step_volume,flag_step_done: byte;
	current_unit_type,current_unit_com,current_unit_move: byte;

	{cities}
	city_current,city_x,city_y: byte;
	city_building_volume: byte;
	bb_com: byte;
	b_buffer: array[1..24] of byte;
	c_popul,c_defence,c_happy: byte;

	{resources}
	price_current,map_build_current: byte;
	user_money: word = 150;

	{menu}
	i_menu: byte;

	{window_dialog}
	w_dialog_center: byte = 1;
	w_dialog_x,w_dialog_y,w_dialog_w,w_dialog_h: byte;
	w_dialog_color1: byte = map_window_color1;
	w_dialog_color2: byte = map_window_color2;
	w_dialog_color3: byte = 48;
	w_dialog_color4: byte = 6;
	w_dialog_items,w_dialog_case,w_dialog_i,w_dialog_i1,w_dialog_i2,w_dialog_cursor,w_dialog_cancel: byte;
	w_dialog_text1,w_dialog_text2: string[40];
	w_items: array[1..128,1..2] of byte;		{1- , 2- }
	w_item_elem_current: byte;

	{map}
	map_search_x,map_search_y,map_search_el,map_search_vol: byte;
	map_search_i,map_search_j: byte;
	landscape_color: byte;
	land_j1,land_i1: byte;

	{history}
	history_last: word = 0;
	history_current: word;
	history_year: word;
	history_civ,history_action,history_element: byte;

	{AI}
	city_search_civ,city_search_par,city_search_id,city_search_dist: byte;
	city_search_x,city_search_y: byte;
	city_min_i,city_max_i: byte;

	minimap_attr: array[1..6,1..8] of byte;

	map: array[1..y_global,1..x_global] of byte =
	[
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,3,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,3,3,0,0,0,0,3,3,0,0,0,0,3,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,1,3,3,3,3,3,3,3,3,0,0,0,0,0,3,3,3,3,0,0,
0,0,3,3,3,3,3,3,3,3,0,0,0,3,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
0,3,5,4,1,1,1,1,3,0,0,3,0,0,3,3,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,5,5,1,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,0,0,0,
0,1,0,0,5,4,1,1,1,3,3,3,3,3,3,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,1,5,1,1,1,0,0,4,0,0,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,3,0,0,0,0,0,
0,0,0,0,0,4,4,1,1,1,1,1,3,0,0,0,3,0,0,0,3,3,0,0,0,0,0,0,0,1,5,1,1,1,0,0,4,4,4,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,1,1,0,0,0,0,0,0,
0,0,0,0,1,5,4,4,4,1,1,1,0,0,0,3,0,0,0,0,3,0,0,5,0,0,0,0,1,1,1,0,4,4,0,4,4,4,4,5,4,4,4,4,4,4,4,4,4,4,4,5,4,0,0,0,5,5,0,0,0,0,0,0,
0,0,0,0,5,4,4,4,4,4,1,1,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,4,0,0,4,4,4,4,4,4,5,4,4,4,4,4,4,4,5,4,4,5,4,0,0,0,0,0,5,0,0,0,0,0,0,
0,0,0,0,1,4,4,4,4,4,4,1,0,1,1,3,0,0,0,0,0,0,0,0,0,0,4,0,0,4,0,0,4,4,4,4,4,4,5,4,4,4,4,4,4,4,0,4,4,5,4,4,0,0,0,0,0,1,0,0,0,0,0,0,
0,0,0,5,2,1,4,4,4,4,4,4,1,1,1,1,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,4,4,4,4,1,1,1,5,4,1,4,4,4,4,4,4,5,2,2,1,4,4,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,1,5,2,1,4,4,4,0,4,4,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,4,4,4,4,4,1,1,1,1,5,1,1,1,1,4,4,4,5,5,1,1,1,1,1,4,4,0,5,0,0,0,0,0,0,0,0,
0,1,5,5,2,2,2,1,4,4,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,5,4,0,1,0,0,0,0,0,0,0,0,
0,1,5,2,1,2,1,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,4,5,4,5,1,0,1,0,5,0,1,1,2,2,2,5,5,5,5,1,1,1,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,
0,5,2,1,1,1,1,1,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,5,1,0,0,0,1,0,2,2,2,2,5,5,5,5,1,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,
0,0,2,2,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,5,1,2,5,2,2,5,1,5,5,5,5,1,1,1,1,4,0,0,0,0,4,0,0,0,0,0,0,0,0,
0,0,5,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,2,5,2,2,2,1,1,5,1,1,1,1,5,5,5,1,1,4,4,4,0,0,4,0,0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,0,0,1,1,0,2,2,2,0,0,1,1,1,1,1,4,4,4,5,5,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,
0,0,5,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,1,2,1,0,0,2,2,2,0,0,1,0,1,4,4,4,4,4,5,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,1,4,4,4,0,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,0,0,4,4,4,0,0,0,4,4,4,4,0,0,4,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,1,0,1,4,4,4,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,4,4,0,0,0,0,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,5,1,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,4,0,0,0,0,0,0,4,4,0,0,0,4,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,5,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,4,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,5,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,5,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,1,4,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,5,5,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,4,4,0,0,0,0,0,0,
0,0,0,0,0,0,0,5,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,0,4,0,0,0,4,4,0,0,0,0,0,
0,0,0,0,0,0,0,0,5,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,5,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,4,1,4,4,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,5,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,4,1,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,5,4,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,4,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,5,4,4,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,4,4,4,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,4,4,4,4,0,0,0,4,0,0,
0,0,0,0,0,0,0,0,0,0,0,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,4,0,0,
0,0,0,0,0,0,0,0,0,0,0,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,3,3,3,3,0,0,0,0,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,
0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0
	];

	init_ut: array[1..civ_max,1..2] of byte =	{1-x,2-y}
	[
		35,11,
		28,14,
		12,13,
		16,31,
		35,19,
		28,25,
		49,13,
		43,19
	];

	civ: array[1..civ_max,1..9] of byte =		{1-, 2-, 3- , 4- , 5- ,
						6-, 7- , 8-  , 9- (0=,1=,2=)}
	[
		1, 56, 1, 1, 0, 0, str_build_city, 2,0,			{1, 8*7+0}
		1, 41, 1, 1, 0, 0, str_build_city, 3,1,			{2, 8*5+1}
		1, 58, 1, 1, 0, 0, str_build_city, 2,0,			{3, 8*7+2}
		1, 21, 1, 1, 0, 0, str_build_city, 3,0,			{4, 8*2+5}
		1, 6,  1, 1, 0, 0, str_build_city, 4,2,			{5, 8*0+6}
		1, 24, 1, 1, 0, 0, str_build_city, 5,0,			{6, 8*3+0}
		1, 22, 1, 1, 0, 0, str_build_city, 6,0,			{7, 8*2+6}
		1, 30, 1, 1, 0, 0, str_build_city, 7,0			{8, 8*3+6}
	];

	s: array[1..science_max,1..5] of byte =		{1-, 2-1, 3-2, 4-, 5-}
	[
		0,  0,  0,  1,  1,			{1}
		0,  1,  1,  2,  3,			{2}
		0,  1,  1,  3,  2,			{3}
		0,  2,  2,  4,  0,			{4}
		0,  3,  3,  5,  4,			{5}
		0,  5,  5,  0,  5,			{6}
		0,  1,  2,  6,  0,			{7}
		0,  6,  7,  0,  6,			{8}
		0,  4,  4,  7,  0,			{9}
		0,  3,  8,  8,  7,			{10}
		0,  1,  6,  0,  0,			{11}
		0,  8,  8,  9,  8,			{12}
		0,  4, 10,  10, 0,			{13}
		0, 13, 13,  11, 0,			{14}
		0,  6, 13,  12, 0,			{15}
		0,  4, 13,  13, 0,			{16}
		0, 12, 12,  0,  0,			{17}
		0, 12, 15,  14, 9,			{18}
		0, 14, 17,  0,  10,			{19}
		0,  9, 16,  15, 11,			{20}
		0, 18, 20,  16, 0,			{21}
		0, 10, 21,  0,  0,			{22}
		0, 21, 22,  0,  12,			{23}
		0, 21, 21,  0,  13,			{24}
		0, 22, 22,  0,  0,			{25}
		0, 25, 25,  0,  0,			{26}
		0, 26, 26,  0,  0,			{27}
		0, 24, 26,  0,  14,			{28}
		0, 19, 26,  0,  0,			{29}
		0, 24, 26,  17, 0,			{30}
		0, 25, 27,  18, 0,			{31}
		0, 17, 26,  0,  0,			{32}
		0, 23, 30,  0,  15,			{33}
		0, 32, 35,  19, 0,			{34}
		0, 28, 28,  20, 16,			{35}
		0, 25, 32,  0,  0,			{36}
		0, 32, 32,  0,  0,			{37}
		0, 36, 36,  0,  0,			{38}
		0, 36, 36,  0,  0,			{39}
		0, 32, 33,  0,  0,			{40}
		0, 35, 35,  0,  0,			{41}
		0, 34, 34,  0,  0,			{42}
		0, 42, 42,  21, 0,			{43}
		0, 39, 39,  0,  0,			{44}
		0, 40, 40,  0,  0,			{45}
		0, 43, 43,  0,  0,			{46}
		0, 43, 43,  0,  0,			{47}
		0, 37, 38,  0,  0,			{48}
		0, 42, 42,  0,  0,			{49}
		0, 47, 49,  0,  0,			{50}
		0, 41, 41,  0,  17,			{51}
		0, 36, 47,  0,  0,			{52}
		0, 50, 50,  0,  0,			{53}
		0, 45, 51,  0,  0,			{54}
		0, 49, 49,  0,  0,			{55}
		0, 51, 51,  0,  0,			{56}
		0, 49, 49,  0,  0,			{57}
		0, 50, 52,  22, 0,			{58}
		0, 53, 56,  0,  0,			{59}
		0, 38, 54,  23, 0,			{60}
		0, 56, 56,  0,  18,			{61}
		0, 56, 60,  0,  19,			{62}
		0, 59, 59,  0,  0,			{63}
		0, 39, 48,  0,  0,			{64}
		0, 59, 61,  0,  20,			{65}
		0, 63, 63,  0,  0,			{66}
		0, 48, 57,  0,  0,			{67}
		0, 66, 66,  24, 0,			{68}
		0, 67, 67,  0,  0,			{69}
		0, 62, 62,  0,  0,			{70}
		0, 66, 66,  0,  0,			{71}
		0, 71, 71,  0,  0,			{72}
		0, 71, 71,  0,  0,			{73}
		0, 68, 68,  0,  0,			{74}
		0, 64, 71,  0,  0,			{75}
		0, 54, 67,  0,  0,			{76}
		0, 69, 69,  0,  0,			{77}
		0, 69, 74,  0,  0,			{78}
		0, 73, 75,  0,  0,			{79}
		0, 78, 79,  0,  0			{80}
	];

	c: array[1..city_max,1..10] of byte =				{}
	[
		0,35,11,0,0,0,0,0,0,0,			{1}
		0,43,19,0,0,0,0,0,0,0,			{2}
		0,43,19,0,0,0,0,0,0,0,			{3}
		0,43,19,0,0,0,0,0,0,0,			{4}
		0,43,19,0,0,0,0,0,0,0,			{5}
		0,43,19,0,0,0,0,0,0,0,			{6}
		0,43,19,0,0,0,0,0,0,0,			{7}
		0,43,19,0,0,0,0,0,0,0,			{8}
		0,43,19,0,0,0,0,0,0,0,			{9}
		0,43,19,0,0,0,0,0,0,0,			{10}
		0,28,14,0,0,0,0,0,0,0,			{11}
		0,43,19,0,0,0,0,0,0,0,			{12}
		0,43,19,0,0,0,0,0,0,0,			{13}
		0,43,19,0,0,0,0,0,0,0,			{14}
		0,43,19,0,0,0,0,0,0,0,			{15}
		0,43,19,0,0,0,0,0,0,0,			{16}
		0,43,19,0,0,0,0,0,0,0,			{17}
		0,43,19,0,0,0,0,0,0,0,			{18}
		0,43,19,0,0,0,0,0,0,0,			{19}
		0,43,19,0,0,0,0,0,0,0,			{20}
		0,12,13,0,0,0,0,0,0,0,			{21}
		0,43,19,0,0,0,0,0,0,0,			{22}
		0,43,19,0,0,0,0,0,0,0,			{23}
		0,43,19,0,0,0,0,0,0,0,			{24}
		0,43,19,0,0,0,0,0,0,0,			{25}
		0,43,19,0,0,0,0,0,0,0,			{26}
		0,43,19,0,0,0,0,0,0,0,			{27}
		0,43,19,0,0,0,0,0,0,0,			{28}
		0,43,19,0,0,0,0,0,0,0,			{29}
		0,43,19,0,0,0,0,0,0,0,			{30}
		0,16,31,0,0,0,0,0,0,0,			{31}
		0,43,19,0,0,0,0,0,0,0,			{32}
		0,43,19,0,0,0,0,0,0,0,			{33}
		0,43,19,0,0,0,0,0,0,0,			{34}
		0,43,19,0,0,0,0,0,0,0,			{35}
		0,43,19,0,0,0,0,0,0,0,			{36}
		0,43,19,0,0,0,0,0,0,0,			{37}
		0,43,19,0,0,0,0,0,0,0,			{38}
		0,43,19,0,0,0,0,0,0,0,			{39}
		0,43,19,0,0,0,0,0,0,0,			{40}
		0,35,19,0,0,0,0,0,0,0,			{41}
		0,43,19,0,0,0,0,0,0,0,			{42}
		0,43,19,0,0,0,0,0,0,0,			{43}
		0,43,19,0,0,0,0,0,0,0,			{44}
		0,43,19,0,0,0,0,0,0,0,			{45}
		0,43,19,0,0,0,0,0,0,0,			{46}
		0,43,19,0,0,0,0,0,0,0,			{47}
		0,43,19,0,0,0,0,0,0,0,			{48}
		0,43,19,0,0,0,0,0,0,0,			{49}
		0,43,19,0,0,0,0,0,0,0,			{50}
		0,28,25,0,0,0,0,0,0,0,			{51}
		0,43,19,0,0,0,0,0,0,0,			{52}
		0,43,19,0,0,0,0,0,0,0,			{53}
		0,43,19,0,0,0,0,0,0,0,			{54}
		0,43,19,0,0,0,0,0,0,0,			{55}
		0,43,19,0,0,0,0,0,0,0,			{56}
		0,43,19,0,0,0,0,0,0,0,			{57}
		0,43,19,0,0,0,0,0,0,0,			{58}
		0,43,19,0,0,0,0,0,0,0,			{59}
		0,43,19,0,0,0,0,0,0,0,			{60}
		0,49,13,0,0,0,0,0,0,0,			{61}
		0,43,19,0,0,0,0,0,0,0,			{62}
		0,43,19,0,0,0,0,0,0,0,			{63}
		0,43,19,0,0,0,0,0,0,0,			{64}
		0,43,19,0,0,0,0,0,0,0,			{65}
		0,43,19,0,0,0,0,0,0,0,			{66}
		0,43,19,0,0,0,0,0,0,0,			{67}
		0,43,19,0,0,0,0,0,0,0,			{68}
		0,43,19,0,0,0,0,0,0,0,			{69}
		0,43,19,0,0,0,0,0,0,0,			{70}
		0,43,19,0,0,0,0,0,0,0,			{71}
		0,43,19,0,0,0,0,0,0,0,			{72}
		0,43,19,0,0,0,0,0,0,0,			{73}
		0,43,19,0,0,0,0,0,0,0,			{74}
		0,43,19,0,0,0,0,0,0,0,			{75}
		0,43,19,0,0,0,0,0,0,0,			{76}
		0,43,19,0,0,0,0,0,0,0,			{77}
		0,43,19,0,0,0,0,0,0,0,			{78}
		0,43,19,0,0,0,0,0,0,0,			{79}
		0,43,19,0,0,0,0,0,0,0			{80}
	];

	c_money: array[1..city_max] of word;				{ }

	u: array[1..20,1..6] of byte =					{ : 1-, 2- ,
						 			3-, 4-, 5-, 6-.}
	[
		1,  civ_earth,		1, 1, 1,  com_build,		{1}
		0,  civ_earth,		2, 2, 1,  0,			{2}
		0,  civ_sea,		1, 1, 2,  com_1_pass,		{3}
		0,  civ_earth,		4, 3, 2,  0,			{4}
		0,  civ_earth,		5, 2, 2,  0,			{5}
		0,  civ_earth,		5, 5, 1,  0,			{6}
		0,  civ_earth,		1, 1, 1,  com_trade,		{7}
		0,  civ_earth,		7, 6, 1,  0,			{8}
		0,  civ_earth,		12,2, 2,  0,			{9}
		0,  civ_sea,		5, 5, 3,  com_2_pass,		{10}
		0,  civ_earth,		8, 8, 1,  0,			{11}
		0,  civ_earth,		12,10,1,  0,			{12}
		0,  civ_earth,		15,3, 1,  0,			{13}
		0,  civ_sea,		20,20,4,  com_3_pass,		{14}
		0,  civ_earth,		15,15,1,  0,			{15}
		0,  civ_earth,		20,10,3,  0,			{16}
		0,  civ_all_cell,	25,20,8,  0,			{17}
		0,  civ_earth,		30,30,1,  0,			{18}
		0,  civ_all_cell,	100,1,15, 0,			{19}
		0,  civ_all_cell,	1, 50,50, com_all_look		{20}
	];

	b: array[1..25] of byte;			{ }

	l: array[1..luxury_max,1..2] of byte =		{: 1-,2-}
	[
		1,0,
		1,0,
		0,0,
		0,0,
		0,0,
		0,0,
		0,0
	];

	move_cell: array[1..14] of byte =		{1- }
	[
		2,	{0 - }
		4,	{1 - }
		4,	{2 - }
		4,	{3 - }
		4,	{4 - }
		8,	{5 - }
		8,	{6 - }
		4,	{7 - }
		4,	{8 - }
		4,	{9 - }
		8,	{10 - }
		8,	{11 - }
		2,	{12 - }
		1	{13 -  }
	];

	menu: array[1..menu_max] of byte =		{ : 1-}
	[
		1,
		11,
		21,
		29,
		37,
		53
	];

	menu_key: array[1..menu_max] of string[1] =
	[
		'Z',
		'L',
		'T',
		'C',
		'W',
		'H'
	];

	history: array[1..history_max,1..3] of byte;

	key_help_key: array[1..key_help_max] of string[3] =
	[
		'SPC',
		'Q,7',
		'A,6',
		'O,5',
		'P,8',
		'1',
		'2',
		'3',
		'4',
		'D',
		'',
		'B',
		'R',
		'I'
	];


procedure debug_window;
begin

color(7);
clrscr;

writeln('            ');
writeln('---------------------------------------------------------------');
for i_debug_window:=1 to civ_max do
	begin
		gotoxy(0,i_debug_window+2);
		write(civ_text[i_debug_window]);
		gotoxy(12,i_debug_window+2);
		write(civ[i_debug_window,civ_science]);
		gotoxy(31,i_debug_window+2);
		write(civ[i_debug_window,civ_unit]);
		gotoxy(38,i_debug_window+2);
		write(civ[i_debug_window,civ_city]);
		gotoxy(46,i_debug_window+2);
		write(civ[i_debug_window,civ_level]);
		gotoxy(54,i_debug_window+2);
		write(civ[i_debug_window,civ_strategy]);
	end;

writeln;
writeln;

writeln('civ_current = ',civ_current);
writeln('x_current = ',x_current);
writeln('y_current = ',y_current);
writeln('city_search_par = ',city_search_par);

{writeln('city_search_civ = ',city_search_civ);}
writeln('city_search_id = ',city_search_id);
writeln('city_search_dist = ',city_search_dist);
writeln('city_search_x = ',city_search_x);
writeln('city_search_y = ',city_search_y);
writeln('city_min_i = ',city_min_i);
writeln('city_max_i = ',city_max_i);
{
writeln('unit_create_max = ',unit_create_max);
writeln('science_speed = ',science_speed);
writeln('science_research = ',science_research);
writeln('science_speed=',science_speed);
}

readln;

end;



procedure year_calculate;

{year_calc -  year_word     year}

begin

if year0<>0 then
	if year_calc>=year0 then
		begin
			year:=year_calc+1-year0;
			year_era:=text31;
		end
	else
		begin
			year:=year0-year_calc;
			year_era:=text32;
		end;


end;



procedure window_clear_put;

{
w_dialog_center -    (1=/0=)
w_dialog_x - x    ,  w_dialog_center=0
w_dialog_y - y    ,  w_dialog_center=0
w_dialog_w -  
w_dialog_h -  
w_dialog_color1 -  
w_dialog_color2 -  
}

begin

if w_dialog_center=1 then
	begin
		w_dialog_x:=(32-w_dialog_w)/2;
		w_dialog_y:=(24-w_dialog_h)/2;
	end;

color(w_dialog_color2);

WindowSet(w_dialog_x,w_dialog_y,w_dialog_w,w_dialog_h);
WindowClear;

for i2:=1 to w_dialog_w-2 do
	begin
		SpritePutOr(FRAME_H,w_dialog_color1,i2+w_dialog_x,w_dialog_y);
		SpritePutOr(FRAME_H,w_dialog_color1,i2+w_dialog_x,w_dialog_y+w_dialog_h-1);
	end;
for i2:=1 to w_dialog_h-2 do
	begin
		SpritePutOr(FRAME_V,w_dialog_color1,w_dialog_x,i2+w_dialog_y);
		SpritePutOr(FRAME_V,w_dialog_color1,w_dialog_x+w_dialog_w-1,i2+w_dialog_y);
	end;
SpritePutOr(FRAME_LU,w_dialog_color1,w_dialog_x,w_dialog_y);
SpritePutOr(FRAME_RU,w_dialog_color1,w_dialog_x+w_dialog_w-1,w_dialog_y);
SpritePutOr(FRAME_LD,w_dialog_color1,w_dialog_x,w_dialog_y+w_dialog_h-1);
SpritePutOr(FRAME_RD,w_dialog_color1,w_dialog_x+w_dialog_w-1,w_dialog_y+w_dialog_h-1);

end;


procedure window_message_sub1;

{
w_dialog_w -  
w_dialog_color1 -  
w_dialog_color2 -  
w_dialog_text1 -  
}

begin

w_dialog_h:=3;
window_clear_put;

gotoxy((w_dialog_x+1)*2,w_dialog_y+1);
writeln(w_dialog_text1);

delay(20);

repeat
	readkey(key1,key2,key3);
until key1=13;

delay(20);

w_dialog_color1:=map_window_color1;
w_dialog_color2:=map_window_color2;

end;



procedure window_message;
begin

w_dialog_color1:=message_window_color1;
w_dialog_color2:=message_window_color2;
window_message_sub1;

end;



procedure window_error;
begin

w_dialog_center:=1;
w_dialog_color1:=error_window_color1;
w_dialog_color2:=error_window_color2;
window_message_sub1;

end;



procedure window_treasure_deficit;
begin

w_dialog_w:=16;
w_dialog_text1:=text28+text49;
window_error;
end;



procedure window_dialog_sub1;
begin

w_item_elem_current:=w_items[w_dialog_i,2];

case w_items[w_dialog_i,1] of
	view_science_1: write(s_text[w_item_elem_current]);
	view_civ_1: write(civ_text[w_item_elem_current]);
	view_city_1: write(c_text[w_item_elem_current]);
	view_unit_1: write(u_text[w_item_elem_current],'  ',u[w_item_elem_current,u_at],'/',
			u[w_item_elem_current,u_def],'/',u[w_item_elem_current,u_speed]);
	view_building_1: write(b_text[w_item_elem_current]);
	view_tax_1:
		begin
			tax_view:=(w_item_elem_current-1)*10;
			write(tax_view,'%');
		end;
	view_help_1:
		begin
			color(7*8+2);
			write(' ',key_help_key[w_item_elem_current]);
			color(w_dialog_color3);
			write(' ',key_help_text[w_item_elem_current]);
		end;
	view_luxury_1:
		begin
			write(l_text[w_item_elem_current]);
			if l[w_item_elem_current,l_b]=1 then write('   +');
		end;
	view_wiki_1:
		begin
			if w_item_elem_current<>w_dialog_case
				then color(6*8+2)
				else color(2);
			write(wiki[w_item_elem_current],' ');
			if w_item_elem_current<>w_dialog_case
				then color(w_dialog_color3)
				else color(w_dialog_color4);
			write(wiki_adv_text[w_item_elem_current]);
		end;

end;

end;


procedure window_dialog;

{
  window_dialog:

:

w_dialog_center -    (1=/0=)
w_dialog_x - x    ,  w_dialog_center=0
w_dialog_y - y    ,  w_dialog_center=0
w_dialog_w -  
w_dialog_h -  
w_dialog_items -  
w_items[] -  :  ,  
w_dialog_text1 -  1 
w_dialog_text2 -  2 
w_dialog_color1 -  
w_dialog_color2 -  
w_dialog_color3 -    
w_dialog_color4 -    
w_dialog_cancel -     (1=/0=)

:
w_dialog_case -   (0,    )

:
w_dialog_i1 -   
w_dialog_i2 -   
w_dialog_cursor - . 
}


begin

w_dialog_case:=1;
w_dialog_cursor:=1;
w_dialog_i1:=1;
if (w_dialog_h-4)>w_dialog_items
	then w_dialog_i2:=w_dialog_items
	else w_dialog_i2:=w_dialog_h-4;

window_clear_put;

color(w_dialog_color2);

gotoxy((w_dialog_x+1)*2,w_dialog_y+1);
writeln(w_dialog_text1);
gotoxy((w_dialog_x+1)*2,w_dialog_y+2);
writeln(w_dialog_text2);

repeat

	color(w_dialog_color3);

	WindowSet(w_dialog_x+1,w_dialog_y+3,w_dialog_w-2,w_dialog_h-4);
	WindowClear;

	for w_dialog_i:=w_dialog_i1 to w_dialog_i2 do
		begin
			gotoxy((w_dialog_x+1)*2,w_dialog_y+3+w_dialog_i-w_dialog_i1);
			window_dialog_sub1;
		end;

	color(w_dialog_color4);
	gotoxy((w_dialog_x+1)*2,w_dialog_y+2+w_dialog_cursor);
	for w_dialog_i:=1 to (w_dialog_w-2)*2 do
		write(' ');
	gotoxy((w_dialog_x+1)*2,w_dialog_y+2+w_dialog_cursor);
	w_dialog_i:=w_dialog_case;
	window_dialog_sub1;

	repeat
		readkey(key1,key2,key3);

		if key1=81 then
			if w_dialog_case>1 then
				begin
					w_dialog_case:=w_dialog_case-1;
					w_dialog_cursor:=w_dialog_cursor-1;
					if w_dialog_case<w_dialog_i1 then
						begin
							w_dialog_i1:=w_dialog_i1-1;
							w_dialog_i2:=w_dialog_i2-1;
							w_dialog_cursor:=w_dialog_cursor+1;
						end;
				end;
{			else
				begin
					w_dialog_case:=w_dialog_items;
					w_dialog_i2:=w_dialog_case;
					w_dialog_i1:=w_dialog_i2+5-w_dialog_h;
					w_dialog_cursor:=w_dialog_y+3+w_dialog_i2-w_dialog_i1;

					gotoxy(0,0);
					color(1);
					writeln('w_dialog_case=',w_dialog_case);
					writeln('w_dialog_h=',w_dialog_h);
					writeln('w_dialog_i1=',w_dialog_i1);
					writeln('w_dialog_i2=',w_dialog_i2);
					writeln('w_dialog_cursor=',w_dialog_cursor);
					readln;
					key1:=0;
				end;
}
		if key1=65 then
			if w_dialog_case<w_dialog_items then
				begin
					w_dialog_case:=w_dialog_case+1;
					w_dialog_cursor:=w_dialog_cursor+1;
					if w_dialog_case>w_dialog_i2 then
						begin
							w_dialog_i1:=w_dialog_i1+1;
							w_dialog_i2:=w_dialog_i2+1;
							w_dialog_cursor:=w_dialog_cursor-1;
						end;
				end;

		if key1<>0 then delay(10);

	until key1<>0;

if key1=32 and w_dialog_cancel=1 then w_dialog_case:=0;

until key1=13 or w_dialog_case=0;

end;



procedure history_look;
begin

{
if s[sc_calendar,s_i]=0
	then
		begin
			w_dialog_w:=15;
			w_dialog_text1:=text33;
			window_error;
		end
	else
		begin
}
			clrscr;
			landscape_color:=1*8+0;
			asm(LANDSCAPE_SCREEN);
			for i1:=1 to history_last do
				begin
					history_current:=i1;
					asm(HISTORY_READ);

					year_calc:=history_year;
					year_calculate;

					color(6*8+1);
					WindowSet(0,23,32,1);
					WindowClear;
					gotoxy(0,23);
					write(' ',year,year_era,' - ');
					case history_action of
						hist_city_create:
							begin
								write(civ_text[history_civ],text24,c_text[history_element]);
								city_x:=c[history_element,c_x];
								city_y:=c[history_element,c_y];
								landscape_color:=1*8+civ[history_civ,civ_color_history];
								for land_i1:=(city_y-1)/2 to (city_y+1)/2 do
									for land_j1:=(city_x-1)/2 to (city_x+2)/2 do
										asm(LANDSCAPE_TILE);

							end;
						hist_science:	write(civ_text[history_civ],text25,s_text[history_element]);
					end;
					read;
				end;
		{ end; }

end;


procedure end_game;
begin

repeat
	color(7);
	clrscr;
	write('  !   !');
	readln;
	history_look;
until 1=2;

end;



procedure science_complete_sub1;
begin

w_dialog_items:=w_dialog_items+1;
w_items[w_dialog_items,1]:=view_science_1;
w_items[w_dialog_items,2]:=i1;

end;


procedure science_complete;
begin

w_dialog_w:=25;
w_dialog_text1:=text27+text25+s_text[science_research];
window_message;

if s[science_research,s_i]=0 then
	begin
		history_civ:=civ_user;
		history_action:=hist_science;
		history_element:=science_research;
		ASM(HISTORY_WRITE);
	end;

s[science_research,s_i]:=s_i_user;
civ[civ_user,civ_science]:=science_research;
if user_money<60000 then user_money:=user_money+price_science_money_produce;

if s[science_research,s_b]<>0 then b[s[science_research,s_b]]:=1;
if s[science_research,s_u]<>0 then u[s[science_research,s_u],u_i]:=1;

if science_research=sc_calendar then year0:=year_word;

w_dialog_items:=0;

for i1:=1 to science_max do
	if s[i1,s_i]=0 then
		begin
			if s[s[i1,s_s1],s_i]=2 and s[s[i1,s_s2],s_i]=2 then science_complete_sub1;
{			
			case i1 of
				1,2,3: science_complete_sub1;
			end;
}			
		end;

if w_dialog_items>0
	then
		begin
			w_dialog_text1:=text10;
			w_dialog_text2:=text11+text1;
			w_dialog_w:=2+13;
			w_dialog_h:=w_dialog_items+4;
			w_dialog_cancel:=0;

			window_dialog;

			science_research:=w_items[w_dialog_case,2];
		end
	else
		end_game;


end;



procedure is_cell_city;
{

:
x_current
y_current

:
city_search_civ (0 -  )
}

begin

city_search_civ:=0;

for map_search_i:=1 to city_max do
	if c[map_search_i,c_x]=x_current and c[map_search_i,c_y]=y_current then
		city_search_civ:=c[map_search_i,c_civ];

end;



procedure city_search_sub1;
begin

arg1:=x_current;
arg2:=c[map_search_i,c_x];
asm(ABS);
prom3:=abs_arg;

arg1:=y_current;
arg2:=c[map_search_i,c_y];
asm(ABS);

prom3:=prom3+abs_arg;

if prom3<city_search_dist then
	begin
		city_search_id:=map_search_i;
		city_search_dist:=prom3;
		city_search_x:=c[map_search_i,c_x];
		city_search_y:=c[map_search_i,c_y];
	end;

end;



procedure city_search;
{

:
x_current
y_current
civ_current
city_search_par -   :
	0 -  
	1 - 
	2 - 
	3 -   

:
city_search_id (0,    )
city_search_dist (255,    )
city_search_x
city_search_y

}

begin

city_search_id:=0;
city_search_dist:=255;

city_min_i:=1;
city_max_i:=city_max;

if city_search_par=0 then
	begin
		city_min_i:=civ_current*city_per_civ-city_per_civ+1;
		city_max_i:=civ_current*city_per_civ;
	end;

for map_search_i:=city_min_i to city_max_i do
	case city_search_par of
		0: if c[map_search_i,c_civ]=0 then city_search_sub1;
		1: if c[map_search_i,c_civ]=civ_current then city_search_sub1;
		2: if c[map_search_i,c_civ]<>0 and c[map_search_i,c_civ]<>civ_current then city_search_sub1;
		3: if c[map_search_i,c_civ]<>0 then city_search_sub1;
	end;

end;



procedure error_create;
begin

if s[sc_error_create,s_i]<>s_i_user
	then
		begin
			w_dialog_w:=25;
			w_dialog_text1:=text33+s_text[sc_error_create]+text49;
		end
	else
		begin
			w_dialog_w:=19;
			w_dialog_text1:=text17+text29+text49;
		end;

end;



procedure irrig_create;
begin

case cell_current of
	cell_meadow,cell_forest:
		begin
			map[y_current,x_current]:=cell_irrig;
			flag_step_done:=1;
		end;
	else
		begin
			sc_error_create:=1;
			error_create;
		end;
end;

end;



procedure rail_create;
begin

if cell_current=cell_road and s[sc_railroad,s_i]=s_i_user
	then
		begin
			map[y_current,x_current]:=cell_rail;
			flag_step_done:=1;
		end
	else
		begin
			sc_error_create:=sc_railroad;
			error_create;
		end;

end;



procedure road_create;
begin

if cell_current>=cell_meadow and cell_current<=cell_irrig and cell_current<>cell_hill and s[sc_road,s_i]=s_i_user
	then
		begin
			map[y_current,x_current]:=cell_road;
			flag_step_done:=1;
		end
	else
		begin
			sc_error_create:=sc_road;
			error_create;
		end;

end;



procedure unit_empty_search;
begin

unit_empty:=0;

repeat
	unit_empty:=unit_empty+1;	
until ut[unit_empty,u_civ]=0;

end;



procedure unit_create;
begin

if civ_current=civ_user
	then unit_create_max:=unit_user_max
	else unit_create_max:=unit_civ_max;

if civ[civ_current,civ_unit]<unit_create_max then
	begin
		unit_empty_search;
		ut[unit_empty,u_civ]:=civ_current;
		ut[unit_empty,u_type]:=c[city_current,c_b_id];
		ut[unit_empty,u_x]:=c[city_current,c_x];
		ut[unit_empty,u_y]:=c[city_current,c_y];
		civ[civ_current,civ_unit]:=civ[civ_current,civ_unit]+1;
	end;

end;


procedure unit_move;
begin

case current_unit_move of
	civ_sea:
		if map[y_move,x_move]=cell_sea then
			begin
				step_volume:=step_volume+move_cell[map[y_current,x_current]+1];
				x_current:=x_move;
				y_current:=y_move;
			end;
	civ_earth:
		if map[y_move,x_move]<>cell_sea then
			begin
				step_volume:=step_volume+move_cell[map[y_current,x_current]+1];
				x_current:=x_move;
				y_current:=y_move;
			end;

	civ_all_cell:
			begin
				step_volume:=step_volume+4;
				x_current:=x_move;
				y_current:=y_move;
			end;

end;

if step_volume>=(u[ut[unit_current,u_type],u_speed]*4) then flag_step_done:=1;

end;



procedure unit_put_sub1;
begin

if ut[i_unit_put,u_civ]<>0 then
	if	ut[i_unit_put,u_x]>=x_user_proc
		and ut[i_unit_put,u_x]<=(x_user_proc+x_scr_proc-1)
		and ut[i_unit_put,u_y]>=y_user
		and ut[i_unit_put,u_y]<=(y_user+y_scr_max-1)
	then
		begin
			sprite_number:=ut[i_unit_put,u_type]+mapsprite_delta_unit;
			sprite_color:=civ[ut[i_unit_put,u_civ],civ_color];
			if i_unit_put=unit_current then sprite_color:=sprite_color+128;
			sprite_x:=(ut[i_unit_put,u_x]-x_user_proc)*2+dx_scr_proc;
			sprite_y:=(ut[i_unit_put,u_y]-y_user)*2+dy_scr;

			asm(sprite2x2_put);
		end;

end;


procedure unit_put;
begin

x_user_proc:=x_user;
x_scr_proc:=x_scr_1;
dx_scr_proc:=dx_scr_1;
unit_put_sub1;

if x_user2<>0 then
	begin
		x_user_proc:=x_user2;
		x_scr_proc:=x_scr_2;
		dx_scr_proc:=dx_scr_2;
		unit_put_sub1;
	end;

end;


procedure city_put_coord;
begin

if c[i_city_put,c_civ]<>0 then
	if	c[i_city_put,c_x]>=x_user_proc
		and c[i_city_put,c_x]<=(x_user_proc+x_scr_proc-1)
		and c[i_city_put,c_y]>=y_user
		and c[i_city_put,c_y]<=(y_user+y_scr_max-1)
	then
		begin
			sprite_number:=cell_city;
			sprite_color:=civ[c[i_city_put,c_civ],civ_color];
			sprite_x:=(c[i_city_put,c_x]-x_user_proc)*2+dx_scr_proc;
			sprite_y:=(c[i_city_put,c_y]-y_user)*2+dy_scr;

			asm(sprite2x2_put);

			if c[i_city_put,c_riot]>0 then SpritePutClear(RIOT,8*7+2,sprite_x,sprite_y);

			if (sprite_x<(x_scr_max*2+dx_scr+1-7)) and (sprite_y>dy_scr) then
				begin
					color(8*4+0);
					gotoxy(sprite_x*2+2,sprite_y-1);
					write(c_text[i_city_put]);
				end;
			map[c[i_city_put,c_y],c[i_city_put,c_x]]:=cell_road;
		end;

end;


procedure city_put;
begin

x_user_proc:=x_user;
x_scr_proc:=x_scr_1;
dx_scr_proc:=dx_scr_1;
city_put_coord;

if x_user2<>0 then
	begin
		x_user_proc:=x_user2;
		x_scr_proc:=x_scr_2;
		dx_scr_proc:=dx_scr_2;
		city_put_coord;
	end;

end;




procedure background_put;
begin

border(0);
color(6);
clrscr;

minimap_attr[(y_current-1)/8+1,(x_current-1)/8+1]:=8*3+6;

MapSet(map,MAP_SPRITES,dx_scr_1,dy_scr,x_scr_1,y_scr_max);
x_user_map:=x_user;
y_user_map:=y_user;
asm(MAP_PUT);


if x_user2<>0 then
	begin
		MapSet(map,MAP_SPRITES,dx_scr_2,dy_scr,x_scr_2,y_scr_max);
		x_user_map:=x_user2;
		y_user_map:=y_user;
		asm(MAP_PUT);
	end;


for i_unit_put:=1 to unit_max do
	unit_put;

for i_city_put:=1 to city_max do
	city_put;

for i_menu:=1 to menu_max do
	begin
		color(8*7+2);
		gotoxy(menu[i_menu],0);
		write(menu_key[i_menu]);
		color(6);
		write(menu_text[i_menu]);
	end;

color(7);

asm(MINIMAP_PUT);
minimap_attr[(y_current-1)/8+1,(x_current-1)/8+1]:=8*1+4;

{
gotoxy(46,9);
writeln(text18,year_word,text31);
}

year_calc:=year_word;
year_calculate;

SpritePutOr(YEAR,5,23,9);
gotoxy(48,9);
writeln(year,year_era);

SpritePutOr(MONEY,6,23,10);
gotoxy(48,10);
writeln(user_money);

SpritePutOr(TAX,5,23,11);
gotoxy(48,11);
writeln(tax,'%');

end;




procedure calc_coord_all_put;
begin

if (ut[unit_current,u_x]>dx_user_scr) and (ut[unit_current,u_x]<(x_global-dx_user_scr+1))
	then
		begin
			x_user:=ut[unit_current,u_x]-dx_user_scr;
			x_user2:=0;
			x_scr_1:=x_scr_max;
			x_scr_2:=0;
			dx_scr_1:=dx_scr;
			dx_scr_2:=0;
		end;

if ut[unit_current,u_x]<=dx_user_scr
	then
		begin
			x_user:=x_global-(dx_user_scr-ut[unit_current,u_x]);
			x_user2:=1;
			x_scr_1:=dx_user_scr-ut[unit_current,u_x]+1;
			x_scr_2:=x_scr_max-x_scr_1;
			dx_scr_1:=dx_scr*2;
			dx_scr_2:=(dx_scr+(x_scr_max-x_scr_2))*2;
		end;

if ut[unit_current,u_x]>=(x_global-dx_user_scr+1)
	then
		begin
			x_user:=ut[unit_current,u_x]-dx_user_scr;
			x_user2:=1;
			x_scr_1:=x_global-ut[unit_current,u_x]+dx_user_scr+1;
			x_scr_2:=x_scr_max-x_scr_1;
			dx_scr_1:=dx_scr*2;
			dx_scr_2:=(dx_scr+x_scr_1)*2;
		end;

if ut[unit_current,u_y]>dy_user_scr then y_user:=ut[unit_current,u_y]-dy_user_scr else y_user:=1;

if ut[unit_current,u_y]>(y_global-y_scr_max+dy_user_scr) then y_user:=y_global-y_scr_max+1;

end;



procedure all_put;
begin

calc_coord_all_put;

background_put;

i_unit_put:=unit_current;
unit_put;

color(7);
gotoxy(46,14);
writeln(u_text[current_unit_type]);
gotoxy(46,15);
writeln(u[current_unit_type,u_at],'/',u[current_unit_type,u_def],'/',u[current_unit_type,u_speed]);
gotoxy(50,16);
writeln(text2);

sprite_number:=ut[unit_current,u_type]+mapsprite_delta_unit;
sprite_color:=civ[ut[unit_current,u_civ],civ_color];
sprite_x:=23;
sprite_y:=16;
asm(sprite2x2_put);

MapSet(map,MAP_SPRITES,26,16,1,1);
x_user_map:=ut[unit_current,u_x];
y_user_map:=ut[unit_current,u_y];
is_cell_city;
if city_search_civ>0
	then
		begin
			sprite_number:=cell_city;
			sprite_color:=civ[city_search_civ,civ_color];
			sprite_x:=26;
			sprite_y:=16;
			asm(sprite2x2_put);
		end
	else
		asm(MAP_PUT);

end;



procedure city_money_from_treasure;
begin
if user_money>=price_city_from_treasure
	then
		begin
			user_money:=user_money-price_city_from_treasure;
			c_money[city_current]:=c_money[city_current]+price_city_from_treasure;
		end
	else
		window_treasure_deficit;

key1:=66;

end;


procedure city_building;
begin

w_dialog_items:=0;

for i1:=1 to type_u_max do
	if u[i1,u_i]=1 then
		begin
			w_dialog_items:=w_dialog_items+1;
			w_items[w_dialog_items,1]:=view_unit_1;
			w_items[w_dialog_items,2]:=i1;
		end;

for i1:=1 to type_b_max do
	if b[i1]=1 and b_buffer[i1]=0 then
		begin
			w_dialog_items:=w_dialog_items+1;
			w_items[w_dialog_items,1]:=view_building_1;
			w_items[w_dialog_items,2]:=i1;
		end;

w_dialog_text1:=text16+text1;
w_dialog_text2:='';
w_dialog_center:=1;
w_dialog_color1:=map_window_color1;
w_dialog_color2:=map_window_color2;
w_dialog_w:=2+14;
if w_dialog_items<20 then w_dialog_h:=w_dialog_items+4 else w_dialog_h:=20+4;
w_dialog_cancel:=1;

window_dialog;

if w_dialog_case<>0 then
	begin
		c[city_current,c_b_table]:=w_items[w_dialog_case,1];
		c[city_current,c_b_id]:=w_items[w_dialog_case,2];
		c[city_current,c_b_percent]:=0;
	end;

key1:=66;

end;



procedure city_param_calc;
begin

{---  ---}

bb_com:=0;
asm(BB_FILL);

{---  ---}

c_popul:=(city_building_volume*city_building_volume+1)*10;

{---  ---}

c_defence:=0;

{---  ---}

c_happy:=100/(city_building_volume+1)*c_money[city_current];
if c_happy>100 then c_happy:=100;
if c_happy<happy_min
	then c[city_current,c_riot]:=c[city_current,c_riot]+1
	else c[city_current,c_riot]:=0;

end;



procedure city_window;

begin

repeat

city_param_calc;

color(city_window_color1);
clrscr;

w_dialog_center:=0;

asm(CITY_WINDOW_ARRAY);

color(8*6+2);
gotoxy(2,1);
writeln(c_text[city_current]);

minimap_attr[(c[city_current,c_y]-1)/8+1,(c[city_current,c_x]-1)/8+1]:=8*3+6;
asm(MINIMAP_PUT);
minimap_attr[(c[city_current,c_y]-1)/8+1,(c[city_current,c_x]-1)/8+1]:=8*1+4;

MapSet(map,MAP_SPRITES,dx_scr_city,dy_scr_city,x_scr_city_max,y_scr_city_max);

x_user_map:=c[city_current,c_x]-2;
y_user_map:=c[city_current,c_y]-2;
sprite_x:=dx_scr_city+4;
sprite_y:=dy_scr_city+4;

asm(MAP_PUT);

sprite_number:=cell_city;
sprite_color:=civ[c[city_current,c_civ],civ_color];

asm(sprite2x2_put);

SpritePutOr(POPULATION,6,2,5);
SpritePutOr(DEFENCE,2,2,7);
SpritePutOr(HAPPY,2,2,9);
SpritePutOr(MONEY,6,2,11);

color(8*0+4);

gotoxy(6,5);
write(c_popul,'000');
gotoxy(6,7);
write(c_defence);
gotoxy(6,9);
write(c_happy,'%');
gotoxy(6,11);
write(c_money[city_current]);


color(8*0+6);

for j1:=1 to 3 do
	for i1:=1 to 8 do
		if b_buffer[(j1-1)*8+i1]=1 then
			begin
				SpritePutOr(HOUSE_ICON,8*0+4,3+j1*7,10+i1);
				gotoxy(8+j1*14,10+i1);
				write(b_text[(j1-1)*8+i1]);
			end;

color(8*0+7);
gotoxy(22,21);
write(text22);
color(8*0+4);
gotoxy(22,22);
case c[city_current,c_b_table] of
	view_building_1:
		begin
			write(b_text[c[city_current,c_b_id]]);
			sprite_number:=cell_city;
		end;
	view_unit_1:
		begin
			write(u_text[c[city_current,c_b_id]]);
			sprite_number:=c[city_current,c_b_id]+mapsprite_delta_unit;
		end;
	0:
		begin
			write('-');
			sprite_number:=0;
		end;
end;

if sprite_number<>0 then
	begin
		sprite_color:=civ[civ_user,2];
		sprite_x:=18;
		sprite_y:=21;

		asm(sprite2x2_put);

		gotoxy(42,22);
		write(c[city_current,c_b_percent],'%');
	end;

color(8*7+2);
gotoxy(52,22);
write(' B');
color(8*0+6);
write(text17);

color(8*7+2);
gotoxy(2,21);
write(' G');
color(8*0+6);
write(price_city_from_treasure,text46);

if c[city_current,c_riot]>0 then
	begin
		SpritePutOr(RIOT,8*7+2,2,15);
		color(8*0+2);
		gotoxy(7,15);
		write(text51);
	end;

repeat
	readkey(key1,key2,key3);
	case key1 of
		88: debug_window;
		66: city_building;
		71: city_money_from_treasure;
	end;
until key1=66 or key1=32;

until key1=32;

bb_com:=1;
asm(BB_FILL);

w_dialog_color1:=map_window_color1;
w_dialog_color2:=map_window_color2;
w_dialog_center:=1;

end;


procedure city_case;
begin

w_dialog_items:=0;

for i1:=1 to city_max do
	if c[i1,c_civ]=civ_user then
		begin
			w_dialog_items:=w_dialog_items+1;
			w_items[w_dialog_items,1]:=view_city_1;
			w_items[w_dialog_items,2]:=i1;
		end;

if w_dialog_items>0 then
	begin

		w_dialog_text1:=text15;
		w_dialog_text2:=text1;
		w_dialog_w:=2+11;
		if w_dialog_items<20 then w_dialog_h:=w_dialog_items+4 else w_dialog_h:=20+4;
		w_dialog_cancel:=1;

		window_dialog;

		if w_dialog_case<>0 then
			begin
				city_current:=w_items[w_dialog_case,2];
				city_window;
			end;

	end;


end;


procedure city_create_sub1;
begin

repeat
	city_current:=city_current+1;
until c[city_current,c_civ]=0 or city_current=(ut[unit_current,u_civ]*city_per_civ);

end;


procedure city_create;
begin

city_current:=ut[unit_current,u_civ]*city_per_civ-city_per_civ;
city_create_sub1;

if c[city_current,c_civ]=0 then
	begin
		c[city_current,c_civ]:=ut[unit_current,u_civ];
		c[city_current,c_x]:=ut[unit_current,u_x];
		c[city_current,c_y]:=ut[unit_current,u_y];
		c[city_current,c_b1]:=0;
		c[city_current,c_b2]:=0;
		c[city_current,c_b3]:=0;
		c[city_current,c_b_table]:=view_unit_1;
		c[city_current,c_b_id]:=1;
		c[city_current,c_b_percent]:=0;
		c_money[city_current]:=city_money_min;

		ut[unit_current,u_civ]:=0;
		civ[civ_current,civ_unit]:=civ[civ_current,civ_unit]-1;

		civ[civ_current,civ_city]:=civ[civ_current,civ_city]+1;

		history_civ:=civ_current;
		history_action:=hist_city_create;
		history_element:=city_current;
		ASM(HISTORY_WRITE);

		flag_step_done:=1;

		if civ_current=civ_user then
			begin
				w_dialog_w:=22;
				w_dialog_text1:=text26+text24+c_text[city_current];
				window_message;
				city_window;
			end;

	end;

end;



procedure map_build_user;
begin

if user_money<price_current
	then
		window_treasure_deficit
	else
		begin
			case map_build_current of
				cell_irrig: irrig_create;
				cell_road: road_create;
				cell_rail: rail_create;
				cell_city: city_create;
			end;
			if flag_step_done=1
				then user_money:=user_money-price_current
				else window_error;
		end;

end;



procedure map_search;
begin

map_search_vol:=0;

for map_search_i:=(map_search_y-2) to (map_search_y+2) do
	for map_search_j:=(map_search_x-2) to (map_search_x+2) do
		if map[map_search_i,map_search_j]=map_search_el
			then map_search_vol:=map_search_vol+1;

end;



procedure city_total;
begin

		city_param_calc;


		{---     ---}

		map_search_x:=c[city_current,c_x];
		map_search_y:=c[city_current,c_y];

		for i2:=cell_irrig to cell_power do
			begin
				map_search_el:=i2;
				map_search;
				case i2 of
					cell_irrig: price_current:=price_land_grain_produce;
					cell_power: price_current:=price_land_power_produce;
				end;
				if c_money[city_current]<60000
					then c_money[city_current]:=c_money[city_current]+map_search_vol*price_current;
			end;


		{---    ---}

		if c_money[city_current]<60000 then c_money[city_current]:=c_money[city_current]+city_building_volume*price_b_produce;


		{---  ---}

		civ_current:=c[city_current,c_civ];

		if c[city_current,c_b_id]<>0 and c_money[city_current]>=price_b_consume and c[city_current,c_riot]=0 then
			begin
				c_money[city_current]:=c_money[city_current]-price_b_consume;
				c[city_current,c_b_percent]:=c[city_current,c_b_percent]+build_percent;
			end;

		if c[city_current,c_b_percent]>=100 then
			begin
				if c[city_current,c_b_table]=view_building_1
					then
						begin
							bb_com:=0;
							asm(BB_FILL);
							b_buffer[c[city_current,c_b_id]]:=1;
							bb_com:=1;
							asm(BB_FILL);
							w_dialog_text1:=b_text[c[city_current,c_b_id]];
						end
					else
						begin
							unit_create;
							w_dialog_text1:=u_text[c[city_current,c_b_id]];
						end;

				w_dialog_w:=21;
				w_dialog_text1:=c_text[city_current]+text23+w_dialog_text1;
				window_message;

				c[city_current,c_b_table]:=0;
				c[city_current,c_b_id]:=0;
				c[city_current,c_b_percent]:=0;
				city_window;
			end;



		{---    ---}

		if user_money<60000 and c[city_current,c_riot]=0 then
			begin
				calc_x:=c_money[city_current];
				calc_y:=100;
				calc_z:=tax;
				asm(CALC_DECIMAL);
				user_money:=user_money+calc_result;
				c_money[city_current]:=c_money[city_current]-calc_result;
			end;

end;



procedure civ_unit_move;

begin

ut[unit_current,u_x]:=city_search_x;
ut[unit_current,u_y]:=city_search_y;

end;



procedure key_help;
begin

w_dialog_items:=key_help_max;

for i1:=1 to key_help_max do
	begin
		w_items[i1,1]:=view_help_1;
		w_items[i1,2]:=i1;
	end;

w_dialog_text1:=text34;
w_dialog_text2:=text1;
w_dialog_w:=14;
w_dialog_h:=w_dialog_items+4;
w_dialog_cancel:=1;

window_dialog;

end;



procedure luxury_case;
begin

w_dialog_items:=0;

for i1:=1 to luxury_max do
	if l[i1,l_i]=1 then
		begin
			w_dialog_items:=w_dialog_items+1;
			w_items[w_dialog_items,1]:=view_luxury_1;
			w_items[w_dialog_items,2]:=i1;
		end;

w_dialog_text1:=text36;
w_dialog_text2:=text1;
w_dialog_w:=12;
w_dialog_h:=w_dialog_items+4;
w_dialog_cancel:=1;

window_dialog;

if w_dialog_case<>0 then
	if l[w_items[w_dialog_case,2],l_b]=0
		then
			if user_money>=price_luxury then
				begin
					user_money:=user_money-price_luxury;
					l[w_items[w_dialog_case,2],l_b]:=1;
					w_dialog_w:=16;
					w_dialog_text1:=text37+l_text[w_items[w_dialog_case,2]];
					window_message;
				end
		else
			window_treasure_deficit;

end;



procedure tax_case;
begin

w_dialog_items:=11;

for i1:=1 to 11 do
	begin
		w_items[i1,1]:=view_tax_1;
		w_items[i1,2]:=i1;
	end;

w_dialog_text1:=text21;
w_dialog_text2:=text1;
w_dialog_w:=2+12;
w_dialog_h:=w_dialog_items+4;
w_dialog_cancel:=1;

window_dialog;

if w_dialog_case<>0 then tax:=(w_items[w_dialog_case,2]-1)*10;

end;



procedure wiki_look;
begin

w_dialog_items:=wiki_max;

for i1:=1 to wiki_max do
	begin
		w_items[i1,1]:=view_wiki_1;
		w_items[i1,2]:=i1;
	end;

w_dialog_text1:=menu_text[5];
w_dialog_text2:='';
w_dialog_w:=32;
w_dialog_h:=24;
w_dialog_cancel:=1;

window_dialog;

end;



procedure initialization;
begin

randomize;
border(0);
color(8*1+4);
clrscr;

landscape_color:=1*8+4;
asm(LANDSCAPE_SCREEN);

w_dialog_items:=civ_max;

for i1:=1 to civ_max do
	begin
		w_items[i1,1]:=view_civ_1;
		w_items[i1,2]:=i1;
	end;

w_dialog_text1:=text12;
w_dialog_text2:=text1;
w_dialog_w:=2+9;
w_dialog_h:=w_dialog_items+4;
w_dialog_cancel:=0;

window_dialog;

civ_user:=w_dialog_case;

for i1:=1 to civ_max do
	begin
		ut[unit_user_max+i1*unit_civ_max-2*unit_civ_max+1,u_type]:=unit_colonist;
		ut[unit_user_max+i1*unit_civ_max-2*unit_civ_max+1,u_civ]:=i1;
		ut[unit_user_max+i1*unit_civ_max-2*unit_civ_max+1,u_x]:=init_ut[i1,1];
		ut[unit_user_max+i1*unit_civ_max-2*unit_civ_max+1,u_y]:=init_ut[i1,2];

		civ[i1,civ_level]:=random(1);
	end;

x_user:=ut[unit_user_max+civ_user*unit_civ_max-2*unit_civ_max+1,u_x]-dx_user_scr;
y_user:=ut[unit_user_max+civ_user*unit_civ_max-2*unit_civ_max+1,u_y]-dy_user_scr;

unit_current:=unit_user_max+civ_user*unit_civ_max-2*unit_civ_max+1;
x_current:=ut[unit_current,u_x];
y_current:=ut[unit_current,u_y];
current_unit_type:=ut[unit_current,u_type];
all_put;

end;



procedure case_menu;
begin

case key1 of
	90: key_help;
	76: luxury_case;
	84: tax_case;
	67: city_case;
	87: wiki_look;
	72: history_look;
	88: debug_window;
end;

end;



begin

initialization;

repeat		{--------------------------------------------------------------}

for i_main:=1 to unit_max do

   begin	{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

	{--- AI of civilizations ---}

	if i_main<=civ_max and i_main<>civ_user then
		begin
			{--- AI science ---}

			{--- AI city create or attack ---}
		end;

	{--- cities ---}

	if i_main<=city_max and c[i_main,c_civ]=civ_user then
		begin
			city_current:=i_main;
			city_total;
		end;

	{--- units ---}

	unit_current:=i_main;

	civ_current:=ut[unit_current,u_civ];

	if civ_current<>0 then
	  begin		{==============================================================}
	    x_current:=ut[unit_current,u_x];
	    y_current:=ut[unit_current,u_y];
	    current_unit_type:=ut[unit_current,u_type];
	    current_unit_com:=u[current_unit_type,u_com];
	    current_unit_move:=u[current_unit_type,u_move];
	    step_volume:=0;
	    flag_step_done:=0;

	    if civ_current=civ_user then
		begin

			if civ[civ_user,civ_unit]>1 then all_put;

			repeat

				x_move:=x_current;
				y_move:=y_current;
				cell_current:=map[y_current,x_current];

				readkey(key1,key2,key3);

				case_menu;

				case key1 of
					66: if current_unit_com=com_build
							and cell_current<>cell_sea
							and x_current>2
							and x_current<(x_global-2)
							and y_current>2
							and y_current<(y_global-2)
						then
							begin
								map_build_current:=cell_city;
								price_current:=0;
								map_build_user;
							end;

					82: if current_unit_com=com_build and cell_current<>cell_sea
						then
							begin
								if cell_current=cell_road
									then map_build_current:=cell_rail
									else map_build_current:=cell_road;
								price_current:=price_b_consume;
								map_build_user;
							end;

					73: if current_unit_com=com_build and cell_current<>cell_sea
						then
							begin
								map_build_current:=cell_irrig;
								price_current:=price_b_consume;
								map_build_user;
							end;

					81,55: if y_current>1 then
						begin
							y_move:=y_current-1;
							unit_move;
						end;

					65,54: if y_current<y_global then
						begin
							y_move:=y_current+1;
							unit_move;
						end;

					79,53:
						begin
							if x_current>1
								then x_move:=x_current-1
								else x_move:=x_global;
							unit_move;
						end;

					80,56:
						begin
							if x_current<x_global
								then x_move:=x_current+1
								else x_move:=1;
							unit_move;
						end;

					49: if y_current>1 then
						begin
							y_move:=y_current-1;
							if x_current>1
								then x_move:=x_current-1
								else x_move:=x_global;
							unit_move;
						end;

					51: if y_current<y_global then
						begin
							y_move:=y_current+1;
							if x_current>1
								then x_move:=x_current-1
								else x_move:=x_global;
							unit_move;
						end;


					50: if y_current>1 then
						begin
							y_move:=y_current-1;
							if x_current<x_global
								then x_move:=x_current+1
								else x_move:=1;
							unit_move;
						end;

					52: if y_current<y_global then
						begin
							y_move:=y_current+1;
							if x_current<x_global
								then x_move:=x_current+1
								else x_move:=1;
							unit_move;
						end;

					32: flag_step_done:=1;
				end;

				if current_unit_com=com_trade then
					begin
						is_cell_city;
						if city_search_civ<>0 and city_search_civ<>civ_user then
							case civ[city_search_civ,civ_pact] of
								0,1:
									begin
										if user_money<60000 then user_money:=user_money+price_trade;
										ut[unit_current,u_civ]:=0;

										w_dialog_w:=16;
										w_dialog_text1:=text47;
										window_message;
									end;
								2:
									begin
										w_dialog_w:=23;
										w_dialog_text1:=civ_text[city_search_civ]+text48;
										window_error;
									end;
							end;
					end;

				ut[unit_current,u_x]:=x_current;
				ut[unit_current,u_y]:=y_current;

				if key1<>0 and civ[civ_user,civ_unit]>0 then
					begin
						all_put;
						delay(20);
					end;

			until flag_step_done=1;

			if user_money<price_u_consume and ut[unit_current,u_civ]<>0
				then
					begin
						ut[unit_current,u_civ]:=0;
						civ[civ_user,civ_unit]:=civ[civ_current,civ_unit]-1;

						w_dialog_w:=32;
						w_dialog_text1:=u_text[ut[unit_current,u_type]]+text30+text28+text49;
						window_error;
					end
				else user_money:=user_money-price_u_consume;

		end
	    else
		begin
			case ut[unit_current,u_type] of
				unit_colonist:
					case civ[civ_current,civ_strategy] of
						str_build_city:
							begin
								city_search_par:=0;
								city_search;
								if city_search_id<>0 then
									begin
										civ_unit_move;
										city_create;
									end;
							end;
					end;
			end;
		end;
	  end;		{==============================================================}

   end;			{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

year_word:=year_word+1;

if user_money>=price_science_money_consume
	then
		begin
			user_money:=user_money-price_science_money_consume;
			if science_speed>science_speed_base then science_speed:=science_speed-1;
		end
	else
		begin
			if science_speed<(science_speed_base*2) then science_speed:=science_speed+1;
			if civ[civ_user,civ_unit]>0 then
				begin
					w_dialog_w:=24;
					w_dialog_text1:=text28+text50+text49;
					window_error;
				end;
		end;

if year_word>=(year_science+science_speed) then
	begin
		year_science:=year_word;
		science_complete;
	end;

key1:=0;
if civ[civ_user,civ_unit]=0 then
	begin
		unit_current:=unit_user_max+civ_user*unit_civ_max-2*unit_civ_max+1;
		calc_coord_all_put;
		background_put;
		repeat
			readkey(key1,key2,key3);
			case_menu;
		until key1<>0;
	end;

until 1=2;	{--------------------------------------------------------------}


end.



; --------------------------------------------   --------------------------------------------


;      
; : _MAP - , _LAND_I,LAND_J -   x,y, _LANDSCAPE_COLOR -  
; : 

LANDSCAPE_TILE			ld	a,(_LANDSCAPE_COLOR)
				ld	(attr_sprite),a

				ld	hl,LAND_0000
				ld	de,(_LAND_J1)
				dec	d
				dec	e
				call	put_spr_or

      ld    a,(_LAND_I1)
      ld    l,a
      ld    h,0
      add   hl,hl
      dec   hl
      dec   hl
      add   hl,hl
      add   hl,hl
      add   hl,hl
      add   hl,hl
      add   hl,hl
      add   hl,hl
      ld    de,_MAP
      add   hl,de
      push  hl
      ld    a,(_LAND_J1)
      ld    l,a
      ld    h,0
      add   hl,hl
      dec   hl
      dec   hl
      pop   de
      add   hl,de

				ld	a,(hl)
				and	a
				jr	z,landscape_tile_02
				ld	de,LAND_F000
				call	landscape_tile_01

landscape_tile_02		inc	hl
				ld	a,(hl)
				and	a
				jr	z,landscape_tile_03
				ld	de,LAND_0F00
				call	landscape_tile_01

landscape_tile_03		ld	de,63
				add	hl,de
				ld	a,(hl)
				and	a
				jr	z,landscape_tile_04
				ld	de,LAND_00F0
				call	landscape_tile_01

landscape_tile_04		inc	hl
				ld	a,(hl)
				and	a
				ret	z
				ld	de,LAND_000F
				call	landscape_tile_01

				ret

landscape_tile_01		push	hl
				ld	hl,(_LAND_J1)
				dec	h
				dec	l
				ex	de,hl
				call	put_spr_or
				pop	hl
				ret


;     
; : _MAP - 
; : 

LANDSCAPE_SCREEN		ld	hl,_MAP+48*64-1
				ld	b,24

landscape_screen_01		push	bc
				ld	a,b
				ld	(_LAND_I1),a

				ld	b,32

landscape_screen_02		push	bc
				ld	a,b
				ld	(_LAND_J1),a

				call	LANDSCAPE_TILE

				pop	bc
				djnz	landscape_screen_02
				pop	bc
				djnz	landscape_screen_01

				ret


;       2x2 
; :  
; : 

MAP_PUT
			ld	a,(_Y_USER_MAP)
			dec	a
			ld	(map_x),a
			ld	(map_x_curr),a
			ld	a,(_X_USER_MAP)
			dec	a
			ld	(map_y),a
			ld	(map_y_curr),a

			ld	a,(map_ymax_array)
			ld	c,a
			ld	b,0
			ld	a,(map_x)
			ld	e,a
			ld	d,0
			call	mul

			ld	a,(map_y)
			ld	e,a
			ld	d,0
			add	hl,de

			ld	de,(map_addr_array)
			add	hl,de

			ld	(map_addr_curr),hl

			ld	hl,(map_xscr)
			ld	(map_xscr_curr),hl

			ld	a,(map_height_scr)
			ld	b,a

map_put_01		push	bc

			ld	a,(map_width_scr)
			ld	b,a

map_put_02		push	bc

			xor	a
			ld	(flag_rail),a

			ld	hl,(map_addr_curr)
			ld	a,(hl)
			cp	cell_sea
			jp	z,output_more
			cp	cell_road
			jp	z,output_way
			cp	cell_rail
			jp	z,output_way_rail

map_put_03		ld	(map_cell_curr),a

			ld	l,a
			ld	h,0
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			ld	de,(map_addr_sprites)
			add	hl,de

map_put_04		call	map_put_10

			ld	hl,(map_addr_curr)
			inc	hl
			ld	(map_addr_curr),hl

			ld	hl,map_y_curr
			inc	(hl)

			ld	hl,map_xscr_curr
			inc	(hl)
			inc	(hl)

			pop	bc
			djnz	map_put_02

			ld	hl,(map_addr_curr)
			ld	a,(map_ymax_array)
			ld	e,a
			ld	d,0
			add	hl,de

			ld	a,(map_width_scr)
			ld	e,a
			and	a
			sbc	hl,de

			ld	(map_addr_curr),hl

			ld	hl,map_x_curr
			inc	(hl)

			ld	a,(map_y)
			ld	(map_y_curr),a

			ld	hl,map_yscr_curr
			inc	(hl)
			inc	(hl)

			ld	a,(map_xscr)
			ld	(map_xscr_curr),a

			pop	bc
			djnz	map_put_01

			ret


map_put_10		ex	de,hl				; de =  

; +++++ _attr_map +++++

			ld	a,(map_cell_curr)

			cp	8
			jp	c,map_put_11
			cp	23
			jp	c,map_put_12

			ld	a,(flag_rail)
			and	a
			jp	z,map_put_13
			ld	a,8*4+0
			jp	map_put_14

map_put_12		ld	a,8*1+4
			jp	map_put_14

map_put_13		ld	a,8*4+6
			jp	map_put_14

map_put_11		ld	l,a
			ld	h,0
			ld	bc,(map_addr_attr)
			add	hl,bc
			ld	a,(hl)

map_put_14		ld	(map_color_curr),a
			
map_put_15		ld	bc,(map_xscr_curr)

			LD	A,B
			RRCA
			RRCA
			RRCA
			LD	L,A
			AND	31
			OR	88
			LD	H,A
			LD	A,L
			AND	252
			OR	C
			LD	L,A

			ld	a,(map_color_curr)
			ld	(hl),a

			inc	hl
			ld	(hl),a

			ld	bc,31
			add	hl,bc
			ld	(hl),a

			inc	hl
			ld	(hl),a

; ----- _attr_map -----

			ld	bc,(map_xscr_curr)

			LD      A,B
			LD      H,A
			RRCA
			RRCA
			RRCA
			AND	A,224
			ADD	A,C
			LD	L,A
			LD	A,H
			AND	24
			OR	64
			LD	H,A

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			ld	bc,#6e1
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			ld	bc,#6ff
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a

			ret

map_addr_attr		defw	MAP_ATTR
map_cell_curr		defb	0
map_x_curr		defb	0
map_y_curr		defb	0
map_color_curr		defb	0

cell_sea		equ	0					; 
cell_road		equ	8					; 
cell_rail		equ	9					;  
parameter_okruga	defb	0					;    
flag_rail		defb	0					;    ,    

;       

table_more			defb	0,22,21,8,20,12,11,15,19,13,10,17,9,16,14,18

;        (: -------)

table_way
				defb	21+2		; %00000000
				defb	37+2		; %00000001
				defb	23+2		; %00000010
				defb	23+2		; %00000011
				defb	38+2		; %00000100
				defb	30+2		; %00000101
				defb	23+2		; %00000110
				defb	23+2		; %00000111

				defb	21+2		; %00001000
				defb	37+2		; %00001001
				defb	29+2		; %00001010
				defb	29+2		; %00001011
				defb	21+2		; %00001100
				defb	37+2		; %00001101
				defb	29+2		; %00001110
				defb	29+2		; %00001111

				defb	33+2		; %00010000
				defb	24+2		; %00010001
				defb	36+2		; %00010010
				defb	36+2		; %00010011
				defb	28+2		; %00010100
				defb	47+2		; %00010101
				defb	36+2		; %00010110
				defb	36+2		; %00010111

				defb	21+2		; %00011000
				defb	37+2		; %00011001
				defb	29+2		; %00011010
				defb	29+2		; %00011011
				defb	21+2		; %00011100
				defb	37+2		; %00011101
				defb	29+2		; %00011110
				defb	29+2		; %00011111

				defb	23+2		; %00100000
				defb	40+2		; %00100001
				defb	23+2		; %00100010
				defb	23+2		; %00100011
				defb	35+2		; %00100100
				defb	49+2		; %00100101
				defb	23+2		; %00100110
				defb	23+2		; %00100111

				defb	27+2		; %00101000
				defb	53+2		; %00101001
				defb	46+2		; %00101010
				defb	46+2		; %00101011
				defb	27+2		; %00101100
				defb	53+2		; %00101101
				defb	46+2		; %00101110
				defb	46+2		; %00101111

				defb	23+2		; %00110000
				defb	40+2		; %00110001
				defb	23+2		; %00110010
				defb	23+2		; %00110011
				defb	35+2		; %00110100
				defb	49+2		; %00110101
				defb	23+2		; %00110110
				defb	23+2		; %00110111

				defb	27+2		; %00111000
				defb	53+2		; %00111001
				defb	46+2		; %00111010
				defb	46+2		; %00111011
				defb	27+2		; %00111100
				defb	53+2		; %00111101
				defb	46+2		; %00111110
				defb	46+2		; %00111111




				defb	34+2		; %01000000
				defb	32+2		; %01000001
				defb	39+2		; %01000010
				defb	39+2		; %01000011
				defb	22+2		; %01000100
				defb	43+2		; %01000101
				defb	39+2		; %01000110
				defb	39+2		; %01000111

				defb	34+2		; %01001000
				defb	52+2		; %01001001
				defb	54+2		; %01001010
				defb	54+2		; %01001011
				defb	34+2		; %01001100
				defb	52+2		; %01001101
				defb	54+2		; %01001110
				defb	54+2		; %01001111

				defb	26+2		; %01010000
				defb	48+2		; %01010001
				defb	50+2		; %01010010
				defb	50+2		; %01010011
				defb	44+2		; %01010100
				defb	58+2		; %01010101
				defb	50+2		; %01010110
				defb	50+2		; %01010111

				defb	34+2		; %01011000
				defb	52+2		; %01011001
				defb	54+2		; %01011010
				defb	54+2		; %01011011
				defb	34+2		; %01011100
				defb	52+2		; %01011101
				defb	54+2		; %01011110
				defb	54+2		; %01011111

				defb	23+2		; %01100000
				defb	40+2		; %01100001
				defb	23+2		; %01100010
				defb	23+2		; %01100011
				defb	35+2		; %01100100
				defb	49+2		; %01100101
				defb	23+2		; %01100110
				defb	23+2		; %01100111

				defb	27+2		; %01101000
				defb	53+2		; %01101001
				defb	46+2		; %01101010
				defb	46+2		; %01101011
				defb	27+2		; %01101100
				defb	53+2		; %01101101
				defb	46+2		; %01101110
				defb	46+2		; %01101111

				defb	23+2		; %01110000
				defb	40+2		; %01110001
				defb	23+2		; %01110010
				defb	23+2		; %01110011
				defb	35+2		; %01110100
				defb	49+2		; %01110101
				defb	23+2		; %01110110
				defb	23+2		; %01110111

				defb	27+2		; %01111000
				defb	53+2		; %01111001
				defb	46+2		; %01111010
				defb	46+2		; %01111011
				defb	27+2		; %01111100
				defb	53+2		; %01111101
				defb	46+2		; %01111110
				defb	46+2		; %01111111





				defb	21+2		; %10000000
				defb	21+2		; %10000001
				defb	31+2		; %10000010
				defb	31+2		; %10000011
				defb	38+2		; %10000100
				defb	38+2		; %10000101
				defb	31+2		; %10000110
				defb	31+2		; %10000111

				defb	21+2		; %10001000
				defb	21+2		; %10001001
				defb	42+2		; %10001010
				defb	42+2		; %10001011
				defb	21+2		; %10001100
				defb	21+2		; %10001101
				defb	42+2		; %10001110
				defb	42+2		; %10001111

				defb	33+2		; %10010000
				defb	33+2		; %10010001
				defb	56+2		; %10010010
				defb	56+2		; %10010011
				defb	51+2		; %10010100
				defb	51+2		; %10010101
				defb	56+2		; %10010110
				defb	56+2		; %10010111

				defb	21+2		; %10011000
				defb	21+2		; %10011001
				defb	42+2		; %10011010
				defb	42+2		; %10011011
				defb	21+2		; %10011100
				defb	21+2		; %10011101
				defb	42+2		; %10011110
				defb	42+2		; %10011111

				defb	25+2		; %10100000
				defb	25+2		; %10100001
				defb	45+2		; %10100010
				defb	45+2		; %10100011
				defb	55+2		; %10100100
				defb	55+2		; %10100101
				defb	45+2		; %10100110
				defb	45+2		; %10100111

				defb	41+2		; %10101000
				defb	41+2		; %10101001
				defb	57+2		; %10101010
				defb	57+2		; %10101011
				defb	41+2		; %10101100
				defb	41+2		; %10101101
				defb	57+2		; %10101110
				defb	57+2		; %10101111

				defb	25+2		; %10110000
				defb	25+2		; %10110001
				defb	45+2		; %10110010
				defb	45+2		; %10110011
				defb	55+2		; %10110100
				defb	55+2		; %10110101
				defb	45+2		; %10110110
				defb	45+2		; %10110111

				defb	41+2		; %10111000
				defb	41+2		; %10111001
				defb	57+2		; %10111010
				defb	57+2		; %10111011
				defb	41+2		; %10111100
				defb	41+2		; %10111101
				defb	57+2		; %10111110
				defb	57+2		; %10111111




				defb	21+2		; %11000000
				defb	21+2		; %11000001
				defb	31+2		; %11000010
				defb	31+2		; %11000011
				defb	38+2		; %11000100
				defb	38+2		; %11000101
				defb	31+2		; %11000110
				defb	31+2		; %11000111

				defb	21+2		; %11001000
				defb	21+2		; %11001001
				defb	42+2		; %11001010
				defb	42+2		; %11001011
				defb	21+2		; %11001100
				defb	21+2		; %11001101
				defb	42+2		; %11001110
				defb	42+2		; %11001111

				defb	33+2		; %11010000
				defb	33+2		; %11010001
				defb	56+2		; %11010010
				defb	56+2		; %11010011
				defb	51+2		; %11010100
				defb	51+2		; %11010101
				defb	56+2		; %11010110
				defb	56+2		; %11010111

				defb	21+2		; %11011000
				defb	21+2		; %11011001
				defb	42+2		; %11011010
				defb	42+2		; %11011011
				defb	21+2		; %11011100
				defb	21+2		; %11011101
				defb	42+2		; %11011110
				defb	42+2		; %11011111

				defb	25+2		; %11100000
				defb	25+2		; %11100001
				defb	45+2		; %11100010
				defb	45+2		; %11100011
				defb	55+2		; %11100100
				defb	55+2		; %11100101
				defb	45+2		; %11100110
				defb	45+2		; %11100111

				defb	41+2		; %11101000
				defb	41+2		; %11101001
				defb	57+2		; %11101010
				defb	57+2		; %11101011
				defb	41+2		; %11101100
				defb	41+2		; %11101101
				defb	57+2		; %11101110
				defb	57+2		; %11101111

				defb	25+2		; %11110000
				defb	25+2		; %11110001
				defb	45+2		; %11110010
				defb	45+2		; %11110011
				defb	55+2		; %11110100
				defb	55+2		; %11110101
				defb	45+2		; %11110110
				defb	45+2		; %11110111

				defb	41+2		; %11111000
				defb	41+2		; %11111001
				defb	57+2		; %11111010
				defb	57+2		; %11111011
				defb	41+2		; %11111100
				defb	41+2		; %11111101
				defb	57+2		; %11111110
				defb	57+2		; %11111111


;   
; : bc=   
; : a= 

read_cell			ld	l,c
				ld	h,0
				call	mul_n64
				ld	e,b
				ld	d,0
				add	hl,de
				ld	de,_MAP
				add	hl,de
				ld	a,(hl)
				ret



;           
; : (map_x_curr),(map_y_curr)=   
; : a= 

output_more			xor	a					;  
				ld	(parameter_okruga),a

output_more_0xxx		ld	de,(map_x_curr)
				ld	a,d
				and	a
				jp	z,output_more_x0xx
				dec	a
				ld	b,a
				ld	c,e
				call	read_cell
				cp	cell_sea
				jp	z,output_more_x0xx

				ld	a,8
				ld	(parameter_okruga),a

output_more_x0xx		ld	de,(map_x_curr)
				ld	a,d
				cp	map_ymax_array-1
				jp	z,output_more_xx0x
				inc	a
				ld	b,a
				ld	c,e
				call	read_cell
				cp	cell_sea
				jp	z,output_more_xx0x

				ld	a,(parameter_okruga)
				add	a,4
				ld	(parameter_okruga),a

output_more_xx0x		ld	de,(map_x_curr)
				ld	a,e
				and	a
				jp	z,output_more_xxx0
				dec	a
				ld	b,d
				ld	c,a
				call	read_cell
				cp	cell_sea
				jp	z,output_more_xxx0

				ld	a,(parameter_okruga)
				add	a,2
				ld	(parameter_okruga),a

output_more_xxx0		ld	de,(map_x_curr)
				ld	a,e
				cp	map_xmax_array-1
				jp	z,output_more_01
				inc	a
				ld	b,d
				ld	c,a
				call	read_cell
				cp	cell_sea
				jp	z,output_more_01

				ld	a,(parameter_okruga)
				inc	a
				ld	(parameter_okruga),a

output_more_01			ld	h,0
				ld	a,(parameter_okruga)
				ld	l,a
				ld	bc,table_more
				add	hl,bc
				ld	a,(hl)

				jp	map_put_03


				
;          
; : (map_x_curr),(map_y_curr)=   
; : a= 

output_way_rail			ld	a,1
				ld	(flag_rail),a

output_way			xor	a					;  
				ld	(parameter_okruga),a

output_way_0xxx_xxxx		ld	de,(map_x_curr)				; 
				ld	a,d
				and	a
				jp	z,output_way_x0xx_xxxx
				dec	a
				ld	b,a
				ld	c,e
				call	read_cell
				cp	cell_road
				jp	z,output_way_01
				cp	cell_rail
				jp	nz,output_way_x0xx_xxxx

output_way_01			ld	a,2
				ld	(parameter_okruga),a

output_way_x0xx_xxxx		ld	de,(map_x_curr)				; 
				ld	a,d
				and	a
				jp	z,output_way_xx0x_xxxx
				dec	a
				ld	b,a
				ld	a,e
				cp	map_xmax_array-1
				jp	z,output_way_xx0x_xxxx
				inc	a
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_02
				cp	cell_rail
				jp	nz,output_way_xx0x_xxxx

output_way_02			ld	a,(parameter_okruga)
				add	a,4
				ld	(parameter_okruga),a

output_way_xx0x_xxxx		ld	de,(map_x_curr)				; 
				ld	a,e
				cp	map_xmax_array-1
				jp	z,output_way_xxx0_xxxx
				inc	a
				ld	b,d
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_03
				cp	cell_rail
				jp	nz,output_way_xxx0_xxxx

output_way_03			ld	a,(parameter_okruga)
				add	a,8
				ld	(parameter_okruga),a

output_way_xxx0_xxxx		ld	de,(map_x_curr)				; 
				ld	a,d
				cp	map_ymax_array-1
				jp	z,output_way_xxxx_0xxx
				inc	a
				ld	b,a
				ld	a,e
				cp	map_xmax_array-1
				jp	z,output_way_xxxx_0xxx
				inc	a
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_04
				cp	cell_rail
				jp	nz,output_way_xxxx_0xxx

output_way_04			ld	a,(parameter_okruga)
				add	a,16
				ld	(parameter_okruga),a

output_way_xxxx_0xxx		ld	de,(map_x_curr)				; 
				ld	a,d
				cp	map_ymax_array-1
				jp	z,output_way_xxxx_x0xx
				inc	a
				ld	b,a
				ld	c,e
				call	read_cell
				cp	cell_road
				jp	z,output_way_05
				cp	cell_rail
				jp	nz,output_way_xxxx_x0xx

output_way_05			ld	a,(parameter_okruga)
				add	a,32
				ld	(parameter_okruga),a

output_way_xxxx_x0xx		ld	de,(map_x_curr)				; 
				ld	a,d
				cp	map_ymax_array-1
				jp	z,output_way_xxxx_xx0x
				inc	a
				ld	b,a
				ld	a,e
				and	a
				jp	z,output_way_xxxx_xx0x
				dec	a
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_06
				cp	cell_rail
				jp	nz,output_way_xxxx_xx0x

output_way_06			ld	a,(parameter_okruga)
				add	a,64
				ld	(parameter_okruga),a

output_way_xxxx_xx0x		ld	de,(map_x_curr)				; 
				ld	a,e
				and	a
				jp	z,output_way_xxxx_xxx0
				dec	a
				ld	b,d
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_07
				cp	cell_rail
				jp	nz,output_way_xxxx_xxx0

output_way_07			ld	a,(parameter_okruga)
				add	a,128
				ld	(parameter_okruga),a

output_way_xxxx_xxx0		ld	de,(map_x_curr)				; 
				ld	a,d
				and	a
				jp	z,output_way_01
				dec	a
				ld	b,a
				ld	a,e
				and	a
				jp	z,output_way_01
				dec	a
				ld	c,a
				call	read_cell
				cp	cell_road
				jp	z,output_way_08
				cp	cell_rail
				jp	nz,output_way_10

output_way_08			ld	a,(parameter_okruga)
				inc	a
				ld	(parameter_okruga),a

output_way_10			ld	h,0
				ld	a,(parameter_okruga)
				ld	l,a
				ld	bc,table_way
				add	hl,bc
				ld	a,(hl)

				jp	map_put_03



;     
; : 
; : 

CITY_WINDOW_ARRAY		ld	b,5
				ld	hl,city_window_array_table

city_window_array_01		push	bc

				ld	de,_W_DIALOG_X
				ld	bc,6
				ldir

				push	hl
				call	_WINDOW_CLEAR_PUT
				pop	hl

				pop	bc
				djnz	city_window_array_01

				ret

city_window_array_table		defb	0,0,9,3,5,50
				defb	0,3,9,21,5,0
				defb	22,0,10,10,5,0
				defb	9,10,23,10,5,0
				defb	9,20,23,4,5,0



;   2x2 
; : (_SPRITE_NUMBER)=id , (_SPRITE_X)=.X, (_SPRITE_Y)=.Y, (_SPRITE_COLOR)=
; : 

SPRITE2X2_PUT			ld	a,(_SPRITE_NUMBER)

				ld	l,a
				ld	h,0
				add	hl,hl
				add	hl,hl
				add	hl,hl
				add	hl,hl
				add	hl,hl
				ld	de,MAP_SPRITES
				add	hl,de
				ex	de,hl

				ld	a,(_SPRITE_X)
				ld	(map_xscr_curr),a
				ld	a,(_SPRITE_Y)
				ld	(map_yscr_curr),a
				ld	a,(_SPRITE_COLOR)
				ld	(map_color_curr),a
				call	map_put_15

				ret



;  
; : 
; : 

MINIMAP_PUT			ld	hl,_MINIMAP_ATTR
				ld	de,#5857

				ld	b,6
minimap_put_01			push	bc

				ld	bc,8
				ldir

				ex	de,hl
				ld	bc,24
				add	hl,bc
				ex	de,hl

				pop	bc
				djnz	minimap_put_01

				; -------------

				ld	de,MINIMAP
				ld	hl,#4057

				ld	b,6
minimap_put_02			push	bc
				push	hl

				ld	b,8
minimap_put_03			push	bc

				ex	de,hl
				ld	bc,8
				ldir
				ex	de,hl

				ld	bc,#f8
				add	hl,bc

				pop	bc
				djnz	minimap_put_03

				pop	hl
				ld	bc,#20
				add	hl,bc

				pop	bc
				djnz	minimap_put_02

				ret


;    
; : _CITY_CURRENT= , _BB_COM= (0-  , 1-  )
; : _CITY_BUILDING_VOLUME=    (  )

BB_FILL				ld	hl,_CITY_BUILDING_VOLUME
				ld	(hl),0

				ld	a,(_CITY_CURRENT)
				dec	a
				ld	l,a
				ld	h,0
				add	hl,hl
				ld	e,l
				ld	d,h
				add	hl,hl
				add	hl,hl
				add	hl,de
				ld	de,_C+3
				add	hl,de
				ex	de,hl					; de = c[city_current,c_b1]

				ld	hl,_B_BUFFER				; hl = b_buffer[1]
				ld	b,3

				ld	a,(_BB_COM)
				and	a
				jp	nz,bb_fill_10

bb_fill_01			push	bc

				ld	b,8
				ld	a,(de)

bb_fill_02			ld	(hl),0
				rlca
				jp	nc,bb_fill_03

				ld	(hl),1

				push	hl
				ld	hl,_CITY_BUILDING_VOLUME
				inc	(hl)
				pop	hl

bb_fill_03			inc	hl

				djnz	bb_fill_02

				inc	de

				pop	bc
				djnz	bb_fill_01

				ret

bb_fill_10			ex	de,hl					; hl = c[city_current,c_b1], de = b_buffer[1]

bb_fill_11			push	bc

				ld	b,8
				ld	c,0

bb_fill_12			ld	a,(de)
				and	a
				scf
				jp	nz,bb_fill_13
				ccf

bb_fill_13			rl	c
				inc	de

				djnz	bb_fill_12

				ld	(hl),c
				inc	hl

				pop	bc
				djnz	bb_fill_11

				ret


;  x/y*z      
; : (_CALC_X),(_CALC_Y),(CALC_Z)
; : (_CALC_RESULT)

CALC_DECIMAL			ld	bc,(_CALC_Z)
				call	11563
				ld	bc,(_CALC_X)
				call	11563
				ld	bc,(_CALC_Y)
				call	11563
				rst	40
				defb	5
				defb	4
				defb	56
				call	11682
				ld	(_CALC_RESULT),bc
				ret

;   abs(arg2-arg1)
; : (_ARG1),(_ARG2)
; : (_ABS_ARG)

ABS				ld	bc,(_ARG1)
				ld	a,c
				sub	b
				jr	nc,abs_01
				neg
abs_01				ld	(_ABS_ARG),a
				ret


;   
; : (_HISTORY_LAST),(_YEAR_WORD),(_HISTORY_CIV),(_HISTORY_ACTION),(_HISTORY_ELEMENT)
; : 

;   3   (_HISTORY): %44444443,%33222111,%11111111 (1-, 2-, 3-, 4-)
; , :
;	000 - , 
;	001 - , 
;	002 - , 
;	003 - , 
;	004 - , 
;	005 - , 

HISTORY_WRITE			ld	hl,(_HISTORY_LAST)
				inc	hl
				ld	(_HISTORY_LAST),hl

				ld	e,l
				ld	d,h
				add	hl,hl
				add	hl,de
				ld	de,_HISTORY-3
				add	hl,de

				ld	a,(_HISTORY_ELEMENT)
				and	%01111111
				ld	c,a
				ld	b,0

				ld	a,(_HISTORY_CIV)
				dec	a
				and	%00000111
				rra
				rr	b
				rra
				rr	b
				rra
				rl	c
				ld	(hl),c

				ld	a,(_HISTORY_ACTION)
				and	%00000111
				rlca
				rlca
				rlca
				or	b
				ld	b,a

				ld	de,(_YEAR_WORD)
				ld	a,d
				and	%00000111
				or	b
				inc	hl
				ld	(hl),b
				inc	hl
				ld	(hl),e

				ret

;   
; : (_HISTORY_CURRENT)
; : (_HISTORY_YEAR),(_HISTORY_CIV),(_HISTORY_ACTION),(_HISTORY_ELEMENT)
;   3   (_HISTORY): %44444443,%33222111,%11111111 (1-, 2-, 3-, 4-)

HISTORY_READ			ld	hl,(_HISTORY_CURRENT)
				ld	e,l
				ld	d,h
				add	hl,hl
				add	hl,de
				ld	de,_HISTORY-3
				add	hl,de

				ld	c,(hl)
				inc	hl
				ld	b,(hl)

				srl	c
				ld	a,c
				ld	(_HISTORY_ELEMENT),a
				rr	b
				srl	b
				srl	b
				ld	a,b
				and	%00000111
				ld	(_HISTORY_ACTION),a
				srl	b
				srl	b
				srl	b
				ld	a,b
				inc	a
				ld	(_HISTORY_CIV),a

				ld	a,(hl)
				and	%00000111
				ld	d,a
				inc	hl
				ld	e,(hl)
				ld	(_HISTORY_YEAR),de

				ret
				

; --------------------------------------------  --------------------------------------------

FRAME_LU			defb	1, 0,0, 127,213,159,191,253,182,248,181
FRAME_H				defb	1, 0,0, 255,85,255,255,85,170,0,255
FRAME_RU			defb	1, 0,0, 254,83,249,245,121,181,121,181
FRAME_V				defb	1, 0,0, 249,181,249,181,249,181,249,181
FRAME_RD			defb	1, 0,0, 249,117,249,245,81,169,3,254
FRAME_LD			defb	1, 0,0, 249,189,255,191,213,170,192,127

LAND_0000			defb	1, 0,0, #00,#00,#00,#00,#00,#00,#00,#00
LAND_F000			defb	1, 0,0, #F0,#F0,#F0,#F0,#00,#00,#00,#00
LAND_0F00			defb	1, 0,0, #0F,#0F,#0F,#0F,#00,#00,#00,#00
LAND_00F0			defb	1, 0,0, #00,#00,#00,#00,#F0,#F0,#F0,#F0
LAND_000F			defb	1, 0,0, #00,#00,#00,#00,#0F,#0F,#0F,#0F



MAP_SPRITES									; 0 
				DEFB	0,0,0,10,20,0,0,0
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,0,40,80,0,0,0

										; 1 
				DEFB	0,1,32,0,0,0,4,0
				DEFB	0,0,4,0,0,32,0,0
				DEFB	0,0,32,0,0,4,0,0
				DEFB	2,0,64,0,0,4,0,0

										; 2 
				DEFB	17,111,249,63,12,243,191,15
				DEFB	207,228,190,25,60,126,207,178
				DEFB	102,240,253,59,103,190,153,103
				DEFB	28,127,230,140,59,115,254,28

										; 3 
				DEFB	17,111,249,63,12,243,191,15
				DEFB	207,228,190,25,60,126,207,178
				DEFB	102,240,253,59,103,190,153,103
				DEFB	28,127,230,140,59,115,254,28

										; 4 
				defb	#02,#07,#07,#22,#72,#70,#30,#20
				defb	#02,#07,#07,#22,#72,#70,#30,#20
				defb	#02,#07,#07,#22,#72,#70,#30,#20
				defb	#02,#07,#07,#22,#72,#70,#30,#20

										; 5 
				DEFB	1,2,7,10,13,26,23,42
				DEFB	0,128,64,224,80,176,88,236
				DEFB	53,110,213,186,87,234,64,0
				DEFB	84,170,221,170,119,170,80,0

										; 6 
				DEFB	0,204,51,0,0,204,51,0
				DEFB	0,204,51,0,0,204,51,0
				DEFB	0,204,51,0,0,204,51,0
				DEFB	0,204,51,0,0,204,51,0

										; 7 
				DEFB	0,0,0,1,2,2,1,6
				DEFB	0,0,0,128,192,64,128,96
				DEFB	11,9,6,0,0,0,0,0
				DEFB	176,144,96,0,0,0,0,0


				;  

										; 8
				DEFB 255,63,15,0,0,0,0,0
				DEFB 255,254,56,0,0,0,0,0
				DEFB 0,0,0,0,0,12,127,255
				DEFB 0,0,0,0,0,240,254,255

										; 9
				DEFB 128,192,192,192,224,224,192,192
				DEFB 1,1,3,3,7,7,7,7
				DEFB 224,224,224,224,192,192,192,128
				DEFB 3,3,7,7,7,3,3,1

										; 10
				DEFB 255,255,255,252,248,240,240,224
				DEFB 255,254,248,240,0,0,0,0
				DEFB 224,224,224,192,192,192,128,128
				DEFB 0,0,0,0,0,0,0,0

										; 11
				DEFB 255,127,31,15,0,0,0,0
				DEFB 255,255,255,63,31,15,15,7
				DEFB 0,0,0,0,0,0,0,0
				DEFB 7,7,7,3,3,3,1,1

										; 12
				DEFB 0,0,0,0,0,0,0,0
				DEFB 1,3,3,7,15,15,15,15
				DEFB 0,0,0,0,0,7,63,255
				DEFB 7,7,15,31,127,255,255,255

										; 13
				DEFB 128,128,192,192,192,224,224,224
				DEFB 0,0,0,0,0,0,0,0
				DEFB 224,240,240,248,252,255,255,255
				DEFB 0,0,0,0,240,248,254,255

										; 14
				DEFB 255,255,254,248,240,224,192,192
				DEFB 255,255,63,15,7,3,3,3
				DEFB 128,128,192,224,224,192,192,128
				DEFB 1,1,1,3,3,3,1,1

										; 15
				DEFB 255,124,24,0,0,0,0,0
				DEFB 255,255,63,31,15,7,7,3
				DEFB 0,0,0,0,0,0,56,255
				DEFB 3,3,7,7,15,31,255,255

										; 16
				DEFB 128,128,192,192,192,128,128,128
				DEFB 1,3,3,7,7,3,1,1
				DEFB 192,192,192,224,240,252,255,255
				DEFB 3,3,7,15,31,127,255,255

										; 17
				DEFB 255,255,248,240,224,224,192,192
				DEFB 255,28,0,0,0,0,0,0
				DEFB 192,224,224,240,248,252,255,255
				DEFB 0,0,0,0,0,24,62,255

										; 18
				DEFB 255,248,224,192,192,192,128,128
				DEFB 255,31,3,1,1,3,3,3
				DEFB 128,128,192,224,224,240,254,255
				DEFB 1,1,1,3,3,7,63,255

										; 19
				DEFB 128,192,192,192,224,224,192,192
				DEFB 0,0,0,0,0,0,0,0
				DEFB 224,224,224,224,192,192,192,128
				DEFB 0,0,0,0,0,0,0,0

										; 20
				DEFB 0,0,0,0,0,0,0,0
				DEFB 1,3,3,3,7,7,3,3
				DEFB 0,0,0,0,0,0,0,0
				DEFB 7,7,7,7,3,3,3,1

										; 21
				DEFB 255,127,12,0,0,0,0,0
				DEFB 255,254,240,0,0,0,0,0
				DEFB 0,0,0,0,0,0,0,0
				DEFB 0,0,0,0,0,0,0,0

										; 22
				DEFB 0,0,0,0,0,0,0,0
				DEFB 0,0,0,0,0,0,0,0
				DEFB 0,0,0,0,0,12,127,255
				DEFB 0,0,0,0,0,240,254,255


				;  

										; 23
				DEFB	1,1,3,3,6,6,12,12
				DEFB	128,128,0,0,0,0,0,0
				DEFB	6,3,1,1,0,0,1,1
				DEFB	0,0,128,128,192,192,128,128

										; 24
				DEFB	0,0,0,0,0,0,0,7
				DEFB	3,6,6,12,12,24,24,48
				DEFB	15,24,48,96,96,192,192,128
				DEFB	224,192,0,0,0,0,0,0

										; 25
				DEFB	0,0,0,15,31,49,224,192
				DEFB	0,0,0,0,128,192,96,49
				DEFB	0,0,0,0,0,0,0,0
				DEFB	31,14,0,0,0,0,0,0

										; 26
				DEFB	192,96,96,48,48,24,24,12
				DEFB	0,0,0,0,0,0,0,224
				DEFB	7,3,0,0,0,0,0,0
				DEFB	240,24,12,6,6,3,3,1

										; 27
				DEFB	1,1,0,0,0,8,0,0
				DEFB	128,128,192,192,96,48,28,15
				DEFB	0,0,0,0,16,0,0,0
				DEFB	3,0,0,0,16,0,0,0

										; 28
				DEFB	0,0,0,2,0,0,0,0
				DEFB	3,6,6,12,24,24,48,48
				DEFB	0,0,0,8,0,0,0,0
				DEFB	48,24,24,12,12,6,6,3

										; 29
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,0,0,0,0,0,3
				DEFB	0,0,0,0,0,0,1,1
				DEFB	15,28,48,96,192,192,128,128

										; 30
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,1,7,30,120,224,128
				DEFB	0,0,192,240,56,14,7,1

										; 31
				DEFB	0,0,0,0,0,0,0,192
				DEFB	0,0,0,0,0,0,0,0
				DEFB	240,56,12,6,3,3,1,1
				DEFB	0,0,0,0,0,0,128,128

										; 32
				DEFB	192,96,96,48,48,24,24,12
				DEFB	0,0,0,0,0,0,0,0
				DEFB	12,12,24,24,48,96,96,192
				DEFB	0,0,0,0,0,0,0,0

										; 33
				DEFB	1,1,3,3,6,12,56,240
				DEFB	128,128,0,0,0,0,0,0
				DEFB	192,0,0,0,0,0,0,0
				DEFB	0,0,0,0,0,0,0,0

										; 34
				DEFB	128,224,112,28,15,3,0,0
				DEFB	1,7,30,120,224,128,0,0
				DEFB	0,0,0,0,0,0,0,0
				DEFB	0,0,0,0,0,0,0,0

										; 35
				DEFB	1,1,3,3,3,3,1,1
				DEFB	128,128,0,0,0,0,128,128
				DEFB	1,0,0,0,0,0,0,0
				DEFB	192,224,112,56,28,14,7,3

										; 36
				DEFB	0,0,0,0,0,0,0,1
				DEFB	3,7,14,28,56,112,224,192
				DEFB	1,1,3,3,3,3,1,1
				DEFB	128,128,0,0,0,0,128,128

										; 37
				DEFB	0,0,0,0,0,0,0,1
				DEFB	0,0,0,0,0,0,60,255
				DEFB	3,7,14,28,56,112,224,192
				DEFB	195,0,0,0,0,0,0,0

										; 38
				DEFB	0,0,0,0,0,0,60,255
				DEFB	0,0,0,0,0,0,0,128
				DEFB	195,0,0,0,0,0,0,0
				DEFB	192,224,112,56,28,14,7,3

										; 39
				DEFB	192,224,112,56,28,14,7,3
				DEFB	0,0,0,0,0,0,0,128
				DEFB	1,1,0,0,0,0,1,1
				DEFB	128,128,192,192,192,192,128,128

										; 40
				DEFB	1,1,0,0,0,0,1,1
				DEFB	128,128,192,192,192,192,128,128
				DEFB	3,7,14,28,56,112,224,192
				DEFB	128,0,0,0,0,0,0,0

										; 41
				DEFB	0,0,0,0,0,0,0,195
				DEFB	3,7,14,28,56,112,224,192
				DEFB	255,60,0,0,0,0,0,0
				DEFB	128,0,0,0,0,0,0,0

										; 42
				DEFB	192,224,112,56,28,14,7,3
				DEFB	0,0,0,0,0,0,0,195
				DEFB	1,0,0,0,0,0,0,0
				DEFB	255,60,0,0,0,0,0,0

										; 43
				DEFB	1,1,3,3,6,6,12,12
				DEFB	128,128,0,0,0,0,12,63
				DEFB	6,3,1,1,0,0,1,1
				DEFB	115,192,192,128,192,192,128,128

										; 44
				DEFB	1,1,0,0,0,0,48,252
				DEFB	128,128,192,192,96,96,48,48
				DEFB	206,3,3,1,3,3,1,1
				DEFB	96,192,192,128,0,0,128,128

										; 45
				DEFB	192,112,56,28,12,14,6,7
				DEFB	3,6,6,12,12,24,24,48
				DEFB	15,24,48,96,96,192,192,128
				DEFB	224,192,0,0,0,0,0,0

										; 46
				DEFB	0,0,0,0,0,1,3,3
				DEFB	1,7,30,120,224,128,0,0
				DEFB	1,1,1,3,6,28,120,224
				DEFB	128,224,248,60,14,6,3,1

										; 47
				DEFB	1,1,0,0,1,1,55,254
				DEFB	128,128,192,192,128,128,0,3
				DEFB	206,7,1,0,0,0,0,0
				DEFB	15,60,240,192,0,0,0,0

										; 48
				DEFB	0,0,0,0,0,1,7,206
				DEFB	0,0,0,0,192,240,60,15
				DEFB	254,55,1,1,0,0,1,1
				DEFB	3,0,128,128,192,192,128,128

										; 49
				DEFB	128,224,120,30,7,1,0,0
				DEFB	0,0,0,0,0,128,192,192
				DEFB	1,7,31,60,112,96,192,128
				DEFB	128,128,128,192,96,56,30,7

										; 50
				DEFB	192,96,96,48,48,24,24,12
				DEFB	3,14,28,56,48,112,96,224
				DEFB	7,3,0,0,0,0,0,0
				DEFB	240,24,12,6,6,3,3,1

										; 51
				DEFB	192,240,56,28,14,7,3,3
				DEFB	0,0,0,0,0,0,60,255
				DEFB	3,7,14,28,56,112,224,192
				DEFB	195,0,0,0,0,0,0,0

										; 52
				DEFB	0,0,0,0,0,0,60,255
				DEFB	3,15,28,56,112,224,192,192
				DEFB	195,0,0,0,0,0,0,0
				DEFB	192,224,112,56,28,14,7,3

										; 53
				DEFB	1,1,0,0,0,0,1,1
				DEFB	128,128,192,192,192,192,128,128
				DEFB	3,7,14,28,56,112,224,192
				DEFB	224,240,56,28,14,6,3,3

										; 54
				DEFB	192,224,112,56,28,14,7,3
				DEFB	3,3,6,14,28,56,240,224
				DEFB	1,1,0,0,0,0,1,1
				DEFB	128,128,192,192,192,192,128,128

										; 55
				DEFB	192,224,112,56,28,14,7,3
				DEFB	0,0,0,0,0,0,0,195
				DEFB	3,3,6,6,3,3,1,1
				DEFB	255,60,0,0,0,0,128,128

										; 56
				DEFB	0,0,0,0,0,0,0,195
				DEFB	3,7,14,28,56,112,224,192
				DEFB	255,60,0,0,0,0,1,1
				DEFB	192,192,96,96,192,192,128,128

										; 57
				DEFB	1,1,3,3,6,6,3,3
				DEFB	128,128,0,0,0,0,60,255
				DEFB	3,7,14,28,56,112,224,192
				DEFB	195,0,0,0,0,0,0,0

										; 58
				DEFB	1,1,0,0,0,0,60,255
				DEFB	128,128,192,192,96,96,192,192
				DEFB	195,0,0,0,0,0,0,0
				DEFB	192,224,112,56,28,14,7,3

										; 59
				DEFB	1,1,3,3,6,6,28,252
				DEFB	128,128,0,0,0,0,12,63
				DEFB	230,3,1,1,0,0,1,1
				DEFB	115,192,192,128,192,192,128,128

										; 60
				DEFB	192,112,56,28,12,14,6,7
				DEFB	3,6,6,12,12,24,24,48
				DEFB	15,28,48,96,96,192,192,128
				DEFB	224,224,112,56,28,14,7,3

				;  

				DEFB	203,108,57,109,197,117,159,169		; 61 
				DEFB	209,191,148,61,103,74,233,63
				DEFB	249,143,72,254,37,117,205,187
				DEFB	209,29,178,163,245,29,118,211

				;  

				DEFB	0,0,0,48,44,35,32,16			; 
				DEFB	0,0,0,6,26,226,2,4
				DEFB	11,7,31,55,42,54,28,0
				DEFB	104,240,252,246,42,54,28,0

				DEFB	0,0,0,27,27,18,19,27			; 
				DEFB	0,64,96,176,152,156,150,178
				DEFB	15,7,2,3,2,2,6,0
				DEFB	224,192,128,128,128,128,192,0

				DEFB	0,0,0,1,1,1,1,1				; 
				DEFB	0,0,0,0,0,0,0,0
				DEFB	1,49,31,10,7,42,0,0
				DEFB	14,60,252,168,240,170,0,0

				DEFB	0,2,4,8,23,3,1,27			; 
				DEFB	0,192,232,220,186,254,242,176
				DEFB	63,55,23,7,15,18,27,0
				DEFB	152,56,120,254,50,36,48,0

				DEFB	0,0,17,19,18,16,58,31			; 
				DEFB	0,0,24,148,164,54,226,128
				DEFB	47,47,32,53,47,47,32,0
				DEFB	200,232,8,88,232,232,8,0

				DEFB	0,0,3,7,13,14,2,2			; 
				DEFB	0,8,200,192,136,136,8,136
				DEFB	15,11,7,2,3,2,6,0
				DEFB	216,136,136,136,136,136,200,0

				DEFB	0,0,1,28,117,125,31,15			; 
				DEFB	0,192,224,240,240,224,216,188
				DEFB	15,7,3,1,1,1,3,0
				DEFB	62,254,188,24,8,8,24,0

				DEFB	0,0,1,3,3,6,3,31			; 
				DEFB	0,0,228,228,68,196,4,68
				DEFB	43,55,43,29,1,1,3,0
				DEFB	174,188,228,192,192,64,96,0

				DEFB	0,0,0,0,0,0,0,0				; 
				DEFB	0,0,12,20,28,24,48,112
				DEFB	0,1,3,127,127,22,12,0
				DEFB	200,132,2,254,254,44,24,0

				DEFB	0,0,0,0,0,2,2,6				; 
				DEFB	0,0,64,64,64,200,72,216
				DEFB	14,22,98,63,30,7,42,0
				DEFB	216,216,78,254,174,252,170,0

				DEFB	0,0,48,92,94,24,14,4			; 
				DEFB	0,0,0,0,0,0,20,28
				DEFB	31,63,126,77,127,33,95,0
				DEFB	62,244,254,238,236,96,192,0

				DEFB	0,0,1,7,15,3,3,2			; 
				DEFB	0,0,128,192,224,128,136,176
				DEFB	6,7,30,27,3,2,6,0
				DEFB	224,192,128,128,128,128,192,0

				DEFB	0,0,0,0,0,0,127,127			; 
				DEFB	0,0,0,0,0,16,252,252
				DEFB	15,14,11,5,3,0,0,0
				DEFB	224,240,184,76,134,0,0,0

				DEFB	0,0,0,0,0,0,2,2				; 
				DEFB	0,0,0,0,0,2,22,30
				DEFB	2,2,2,58,31,85,0,0
				DEFB	124,80,80,172,252,212,0,0

				DEFB	0,0,0,14,15,12,30,31			; 
				DEFB	0,0,0,0,0,0,252,64
				DEFB	30,14,14,15,9,9,13,0
				DEFB	0,0,0,0,0,0,128,0

				DEFB	0,0,0,0,1,0,3,7				; 
				DEFB	0,0,0,0,192,128,224,240
				DEFB	31,31,11,28,28,0,0,0
				DEFB	252,252,232,28,28,0,0,0

				DEFB	0,0,0,7,2,0,1,1				; 
				DEFB	0,0,0,240,160,128,192,192
				DEFB	63,63,23,1,1,0,0,0
				DEFB	254,254,244,64,64,128,0,0

				DEFB	0,0,0,0,6,3,1,0				; 
				DEFB	0,0,0,0,0,0,128,224
				DEFB	0,31,21,10,0,0,0,0
				DEFB	240,252,84,168,0,0,0,0

				DEFB	0,0,0,0,1,1,1,1				; .
				DEFB	0,0,0,128,64,64,192,64
				DEFB	1,1,1,3,3,2,0,0
				DEFB	192,64,64,224,96,160,0,0

				DEFB	0,0,0,29,46,62,62,28			; 
				DEFB	0,24,96,132,48,192,0,0
				DEFB	32,4,18,1,8,0,4,0
				DEFB	0,0,0,0,0,64,0,0



MAP_ATTR			defb	8*1+7					; 
				defb	8*4+6					; 
				defb	8*4+6					; 
				defb	8*4+7					; 
				defb	8*4+0					; 
				defb	8*4+0					; 
				defb	8*4+2					; 
				defb	8*4+0					; 


RESOURCE_SPRITES
POPULATION			defb 1,0,0, #18,#18,#3C,#7E,#5A,#18,#24,#24	; 
DEFENCE				defb 1,0,0, 0,24,24,126,126,24,24,0		; 
HAPPY				defb 1,0,0, 0,68,238,254,254,124,56,16		; 
MONEY				defb 1,0,0, 56,124,238,198,238,124,56,0		; 
YEAR				defb 1,0,0, 56,108,238,226,254,124,56,0		; 
TAX				defb 1,0,0, 190,90,182,238,218,180,250,0	; 

HOUSE_ICON			defb 1,0,0, 16,56,124,254,170,254,170,254	; 
RIOT				defb 1,0,0, 127,126,124,126,127,64,64,64	; 

MINIMAP

      defb  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %00000010,  %10000000,  %01000000,  %10000000,  %01000111,  %00000000,  %00000000  
      defb  %00000110,  %00011000,  %01000111,  %11100000,  %00000000,  %10001111,  %11111000,  %00111100  
      defb  %00111111,  %11000100,  %00000011,  %11100000,  %00000000,  %00111111,  %11111111,  %11111110  
      defb  %01111111,  %10010011,  %00000111,  %11000000,  %11110100,  %01111111,  %11111111,  %11111000  
      defb  %01001111,  %11111110,  %00000111,  %10000011,  %00100100,  %11111111,  %11111111,  %11100000  
      defb  %00000111,  %11111000,  %10001100,  %00000110,  %01001110,  %11111111,  %11111111,  %11000000  
      defb  %00001111,  %11110001,  %00001001,  %00001110,  %11011111,  %11111111,  %11111000,  %11000000  

      defb  %00001111,  %11110011,  %10000000,  %00000110,  %01111111,  %11111111,  %11110000,  %01000000  
      defb  %00001111,  %11110111,  %00000000,  %00100100,  %11111111,  %11111101,  %11110000,  %01000000  
      defb  %00011111,  %11111111,  %00000000,  %01100001,  %11111111,  %11111111,  %11111000,  %00000000  
      defb  %00111111,  %11011100,  %00000000,  %01001111,  %11111111,  %11111111,  %11111101,  %00000000  
      defb  %01111111,  %11111000,  %00000000,  %00011111,  %11111111,  %11111111,  %11111101,  %00000000  
      defb  %01111111,  %11100000,  %00000000,  %01111111,  %01010111,  %11111111,  %11000100,  %00000000  
      defb  %01111111,  %11000000,  %00000000,  %01101011,  %00010111,  %11111111,  %11100101,  %00000000  
      defb  %00111101,  %10000000,  %00000000,  %00001010,  %11111111,  %11111111,  %11100001,  %00000000  

      defb  %00111000,  %10000000,  %00000000,  %11100000,  %11111111,  %11111111,  %11110010,  %00000000  
      defb  %00110000,  %00000000,  %00000001,  %11110011,  %01110011,  %11111111,  %11111000,  %00000000  
      defb  %00110000,  %11000000,  %00000001,  %11111111,  %00111001,  %01111111,  %11110000,  %00000000  
      defb  %00011100,  %00000000,  %00000011,  %11111111,  %10011100,  %01111011,  %11000000,  %00000000  
      defb  %00001001,  %10000000,  %00000011,  %11111111,  %11011100,  %01110001,  %11100100,  %00000000  
      defb  %00000101,  %11100000,  %00000011,  %11111111,  %11000000,  %00110000,  %11100000,  %00000000  
      defb  %00000111,  %11110000,  %00000001,  %11111111,  %11111000,  %00100000,  %01100010,  %00000000  
      defb  %00000011,  %11110000,  %00000000,  %11111111,  %11110000,  %00001000,  %01000000,  %00000000  

      defb  %00000011,  %11111000,  %00000000,  %00111111,  %11100000,  %00000000,  %01000100,  %00000000  
      defb  %00000011,  %11111100,  %00000000,  %00001111,  %11100000,  %00000000,  %00001100,  %00000000  
      defb  %00000011,  %11111111,  %00000000,  %00001111,  %01000000,  %00000000,  %00100000,  %11000000  
      defb  %00000001,  %11111111,  %10000000,  %00001111,  %11000000,  %00000000,  %00110100,  %01100000  
      defb  %00000000,  %11111111,  %10000000,  %00001111,  %11000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %11111111,  %00000000,  %00000111,  %11010000,  %00000000,  %00000011,  %01000000  
      defb  %00000000,  %01111111,  %00000000,  %00000111,  %11010000,  %00000000,  %00000111,  %11000000  
      defb  %00000000,  %00111110,  %00000000,  %00000111,  %10010000,  %00000000,  %00001111,  %11000000  

      defb  %00000000,  %00111110,  %00000000,  %00000111,  %10000000,  %00000000,  %00011111,  %11100000  
      defb  %00000000,  %00111110,  %00000000,  %00000011,  %00000000,  %00000000,  %00011111,  %11100000  
      defb  %00000000,  %00011110,  %00000000,  %00000000,  %00000000,  %00000000,  %00010011,  %11000100  
      defb  %00000000,  %00011110,  %00000000,  %00000000,  %00000000,  %00000000,  %00000001,  %10000100  
      defb  %00000000,  %00011100,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %00001100,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %10001000  
      defb  %00000000,  %00001100,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00001000  
      defb  %00000000,  %00000100,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  

      defb  %00000000,  %00000110,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %00000010,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000,  %00000000  
      defb  %00000000,  %00000000,  %01000000,  %00000000,  %00001111,  %11000000,  %00000000,  %00000000  
      defb  %00000000,  %00000000,  %01100000,  %00000011,  %11111111,  %11111111,  %10000000,  %00000000  
      defb  %00000000,  %00000000,  %00110000,  %00011111,  %11111111,  %11111111,  %11100000,  %00000000  
      defb  %00000001,  %11110000,  %01111000,  %01111011,  %11111111,  %11111111,  %11111111,  %11111000  
      defb  %00111111,  %11111111,  %11111111,  %11111111,  %11111111,  %11111111,  %11111111,  %11111100


;  

				org	font64+18					; 
				defb	#00,#88,#CC,#44,#CC,#88				; #
				defb	#00,#33,#66,#44,#66,#33				; $