                ; https://svofski.github.io/pretty-8080-assembler/
                ; i8080 assembler code
                .project pan301a.rk
                .tape rk-bin


                ORIGIN          equ $0000               ; Начало ПЗУ

                ;###############
                ;## КОНСТАНТЫ ##
                ;###############

                KR580VG75       equ $C000
                KR580VT57       equ $E000
                KR580VV55_KBD   equ $8000
                KR580VV55_PPI   equ $A000

                COLS		equ 78
                ROWS		equ 30
                DMA_SIZE        equ COLS * ROWS - 1

                MARGIN_TOP      equ 3
                MARGIN_LEFT     equ 8

                ; Видеорежим
                DISPLAY_78X30   equ (ROWS - 1) << 8 | (COLS - 1)
                GRAPH_78X30     equ $9399
                DMA_SIZE_78X30  equ 78 * 30 - 1

                org ORIGIN

                JMP START

                
                ;################
                ;## ПЕРЕМЕННЫЕ ##
                ;################
                
                CLOCK:          db $00
                CARRIAGE        dw $0000         
                CARRIAGE_ADDR   dw SCREEN
                COORDS:         dw $0000
                CURSOR_ADDR:    dw SCREEN
                TMP             dw $0000         


        SET_DISPLAY: ; Настройка ВГ75
        
                ; DE - строки и столбцы
                ; BC - размер знакоместа и курсор

		; Останов КР580ВГ75
		LXI H, KR580VG75 + 1


		; Скрываем курсор

        	MVI M, $80
		DCR L
		MVI M, $FF
		MVI M, $FF

		; Останов КР580ВГ75

		INR L
		MVI M, 0
		DCR L

        	MOV M, E	; Столбцы
        	MOV M, D	; Строки
        	MOV M, C	; Позиция курсора и кол-во линий в знакоместе
        	MOV M, B	; 0101.0011
        	
 		; Старт КР580ВГ75

		INR L
        	MVI M, $25

		RET

		
        SET_DMA: ; Настройка ПДП

                ; DE - адрес экрана
                ; BC - размер экрана
                
                LXI H, KR580VT57 + 8
		MVI M, $80
		MVI L, $04
		MOV M, E
		MOV M, D

		INR L
		MOV M, C
		MOV M, B
		MVI L, 8
		MVI M, $A4

                RET


        VG75_READY: ; Ждем обратный ход

                LXI H, KR580VG75 + 1
		MOV A, M
		MOV A, M \\ ANI $20 \\ JZ . - 3
                RET            


        VG75_INIT: ; Инициализация видеоконтроллера

                ; Очистка экрана
                LXI D, $0000
                LXI B, COLS * ROWS / 2
                CALL FILL_SCREEN

                ; Настройка знакогенератора
                LXI D, DISPLAY_78X30
                LXI B, GRAPH_78X30
                CALL SET_DISPLAY
                
                CALL VG75_READY
                
                ; Настройка ПДП
                LXI H, SCREEN
                XCHG
		MVI C, DMA_SIZE_78X30 & $00FF
		MVI B, ($4000 + DMA_SIZE_78X30) >> 8
                CALL SET_DMA

                LXI H, $0000
                CALL CARRIAGE_SET

                RET            


        FILL_SCREEN: ; Очистка экрана стеком
        
                ; DE - чем заполнять
                ; BC - сколько заполнять / 2
                
                ; Сохраняем стек                
                LXI H, $0000
                DAD SP
                
                LXI SP, SCREEN + COLS * ROWS
                
                PUSH D \\ DCX B
                MOV A, C \\ ORA B \\ JNZ . - 4

                SPHL

                RET


                ;##################################
                ;## Печать с управляющими кодами ##
                ;##################################


        PRINT_TEXT:

                ; HL - адрес строки

                XCHG

                PRINT_TEXT_LOOP:

		LDAX D

                ; Конец строки ($00)
		CODE_00:
		ANA A \\ RZ

                ; Табуляция ($09)
		CODE_09:
		CPI $09 \\ JNZ CODE_0A
		LHLD CARRIAGE
		MOV A, L
		ORI 00000111B
		INR A
		MOV L, A
		SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                ; Перевод строки ($0A)
		CODE_0A:
		CPI $0A \\ JNZ CODE_0D
		LHLD CARRIAGE \\ INR H \\ SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                ; Возврат каретки ($0D)
		CODE_0D:
		CPI $0D \\ JNZ PRINT_TEXT_CHAR
		LHLD CARRIAGE \\ MVI L, $00 \\ SHLD CARRIAGE
		JMP PRINT_TEXT_SKIP

                PRINT_TEXT_CHAR:

		LHLD CARRIAGE_ADDR
		
		; Экранирование спецсимволов
		ADI 0 \\ JP . + 5 \\ MVI A, '.'

		; Вывод символа
		MOV M, A
		
        	LXI H, CARRIAGE \\ INR M

		PRINT_TEXT_SKIP:
		
		LHLD CARRIAGE
		PUSH D \\ CALL CARRIAGE_SET \\ POP D
		INX D

		JMP PRINT_TEXT_LOOP
		
		RET


        PRINT_BIN:
        
                ; А - ччисло
                ; HL - адрес
                
                MVI C, $08
                
                PRINT_BIN_LOOP:
                
                RAL
                JC . + 5 \\ MVI M, '0'
                JNC . + 5 \\ MVI M, '1'
                
                INX H \\ DCR C
                
                JNZ PRINT_BIN_LOOP

                RET


                ;####################№##
                ;## Установка каретки ##
                ;#######################
                

        CARRIAGE_SET:
        
                ; H - строка
                ; L - позиция в строке
                
                MOV A, L \\ CPI 64 \\ JC . + 06 \\ ANI 00111111B \\ INR H \\ MOV L, A
                MOV A, H \\ ANI 00011111B \\ MOV H, A

                SHLD CARRIAGE

                XCHG
                LXI H, SCREEN \\ LXI B, COLS * MARGIN_TOP + MARGIN_LEFT \\ DAD B
                LXI B, COLS
                
                XRA A
                
                GET_ADDR_LOOP:
                
                CMP D \\ JZ GET_ADDR_SKIP
                DAD B \\ DCR D
                JMP GET_ADDR_LOOP
                
                GET_ADDR_SKIP:
                
                MOV C, E \\ DAD B
                
                SHLD CARRIAGE_ADDR

                RET


        ADNS2610_INIT:
        
                CALL VG75_READY
                
                LXI H, KR580VV55_KBD + 2

		MVI M, 00000010B
		MVI M, 00000000B
		MVI M, 00000010B
		
		; Задержка для достижения таймаута протокола
		
		MVI A, 60
		
		ADNS2610_INIT_LOOP:
		PUSH PSW
                
                CALL VG75_READY
                
                POP PSW
                DCR A \\ JNZ ADNS2610_INIT_LOOP

                RET


        ADNS2610_READ:
        
                ; A - адрес, откуда читать
                ; A - счтанные данные
        
                LXI H, KR580VV55_KBD + 2
                LXI D, $0001
                LXI B, $0008

                ADNS2610_ADDR_LOOP:
                
		MOV M, D

                RAL \\ MOV B, A
                MOV A, E \\ RAL
                MOV M, A
                MOV A, B

		DCR C \\ JNZ ADNS2610_ADDR_LOOP
		
		XRA A
		;DCR A \\ JNZ . - 1

                LXI D, $0301
                LXI B, $0008
                
                ADNS2610_DATA_LOOP:
                
                MOV B, A

		MOV M, E
		MOV M, D
		
		MOV A, M
                ANI 00010000B
                CPI 00010000B

                MOV A, B
                RAL

		DCR C \\ JNZ ADNS2610_DATA_LOOP
		
		CMA
                
                RET
                


        START: 

                ;###########################
                ;## Сброс и инициализация ##
                ;###########################
        

                ; Настройка видеоконтроллера
                CALL VG75_INIT

                ; Вывод названия системы
                LXI H, TXT_TITLE \\ CALL PRINT_TEXT

                CALL ADNS2610_INIT

        MAIN:

		; Ждём обратный ход луча для синхронизации
		
		CALL VG75_READY

		; Счетчик-делитель

		LXI H, CLOCK
		INR M

		; X1
		CALL X1

                ; X2 FLIP
		LDA CLOCK
		ANI 1
		CZ X2
		
                ; X2 FLOP
		LDA CLOCK
		ANI 1
		CNZ X2_

                ; X4
		LDA CLOCK
 		ANI 3
		CZ X4

                JMP MAIN

        X1:

                
                ; Считываем регистр состояния   
                MVI A, $02 \\ CALL ADNS2610_READ
                RAL
                RNC
                
                
                ; Считываем Х   
                
                MVI A, $03 \\ CALL ADNS2610_READ
                
                PUSH PSW
                
                MOV B, A
                LDA COORDS
                SBB B
                MVI C, $7F \\ ANA C
                STA COORDS

                LXI H, $0009
                CALL CARRIAGE_SET
                
                POP PSW
                CALL PRINT_BIN


                ; Считываем У  
                
                MVI A, $04 \\ CALL ADNS2610_READ
                
                PUSH PSW
                
                MOV B, A
                LDA COORDS + 1
                ADD B
                MVI C, $3F \\ ANA C
                STA COORDS + 1

                LXI H, $0109
                CALL CARRIAGE_SET
                
                POP PSW
                CALL PRINT_BIN
                
                
                ; Рисуем указатель мыши
                
                LHLD COORDS
                MOV A, L \\ ORA A \\ RAR \\ MOV L, A
                MOV A, H \\ ORA A \\ RAR \\ MOV H, A
                CALL CARRIAGE_SET

                LHLD CURSOR_ADDR
                MVI M, $00

                LHLD CARRIAGE_ADDR
                SHLD CURSOR_ADDR
                MVI M, $17
                
                RET


        X2:


		RET


        X2_:
                

                RET


        X4:

		RET


TXT_TITLE:      db "MOUSE X: ", $0A, $0D, "MOUSE Y: ", $00
TXT_EOL:        db $0A, $0D, $00		

SCREEN: 
