#!/bin/sh

##
## Config
##

INSTALL_PREFIX="/opt/zemu"

##
## Installer
##

BIN_PATH="$INSTALL_PREFIX/bin"
SHARE_PATH="$INSTALL_PREFIX/share"		# use share/zemu if INSTALL_PREFIX is different from /opt/zemu
ROMS_PATH="$SHARE_PATH/roms"
CONFIG_PATH="$SHARE_PATH/config"
ARC_PATH="$SHARE_PATH/arc"
BOOT_PATH="$SHARE_PATH/boot"

echo "[ Compiling... ]"

./compile.sh $CONFIG_PATH

if [[ -e \!errors.log ]] ; then
	echo "[ There are some compilation errors ]"
else
	echo "[ Installing ... ]"

	install -d $BIN_PATH
	install -d $ROMS_PATH
	install -d $CONFIG_PATH
	install -d $ARC_PATH
	install -d $BOOT_PATH

	install -s ./zemu $BIN_PATH
	install ./roms/* $ROMS_PATH
	install ./config-install.xml $CONFIG_PATH
	install ./keys.config $CONFIG_PATH
	install ./arc/* $ARC_PATH
	install ./boot/* $BOOT_PATH

	mv $CONFIG_PATH/config-install.xml $CONFIG_PATH/config.xml

	echo "[ Complete ]"
fi
