#!/bin/sh

export CFLAGS="-O2 -march=i586 -mcpu=i586 -fomit-frame-pointer"
export CXXFLAGS="${CFLAGS}"

if [ "x$1" != "x" ] ; then
	CONFIG_PATH=$1
else
	CONFIG_PATH="."
fi

g++ \
*.cpp \
-DCONFIG_PATH=\"$CONFIG_PATH\" \
lib_ay/*.cpp \
lib_ym2203/*.cpp \
devices/tsfm/*.cpp \
devices/border/*.cpp \
devices/extport/*.cpp \
devices/keyboard/*.cpp \
devices/mmanager/*.cpp \
devices/trdos/*.cpp \
devices/mouse/*.cpp \
devices/joystick/*.cpp \
renderer/*.cpp \
tape/*.cpp \
-Llib_wd1793 \
-Llib_z80ex \
-lSDLmain \
-lSDL \
-lz80ex \
-lz80ex_dasm \
-lunrealwd1793 \
-o zemu &> \!errors.log

RETVAL=`cat \!errors.log`

if [ "x$RETVAL" != "x" ] ; then
	cat \!errors.log
else
	if [[ -e zemu.exe ]] ; then
		strip --strip-all zemu.exe
	else
		strip --strip-all zemu
	fi

	rm \!errors.log
fi

